/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.importer.actions;

import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.jabref.Globals;
import org.jabref.gui.BasePanel;
import org.jabref.gui.customentrytypes.CustomEntryTypesManager;
import org.jabref.gui.importer.actions.GUIPostOpenAction;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.EntryTypes;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.CustomEntryType;
import org.jabref.model.entry.EntryType;

public class CheckForNewEntryTypesAction
implements GUIPostOpenAction {
    @Override
    public boolean isActionNecessary(ParserResult parserResult) {
        return !this.getListOfUnknownAndUnequalCustomizations(parserResult).isEmpty();
    }

    @Override
    public void performAction(BasePanel panel, ParserResult parserResult) {
        BibDatabaseMode mode = this.getBibDatabaseModeFromParserResult(parserResult);
        List<EntryType> typesToStore = this.determineEntryTypesToSave(panel, this.getListOfUnknownAndUnequalCustomizations(parserResult), mode);
        if (!typesToStore.isEmpty()) {
            typesToStore.forEach(type -> EntryTypes.addOrModifyCustomEntryType((CustomEntryType)type, mode));
            CustomEntryTypesManager.saveCustomEntryTypes(Globals.prefs);
        }
    }

    private List<EntryType> getListOfUnknownAndUnequalCustomizations(ParserResult parserResult) {
        BibDatabaseMode mode = this.getBibDatabaseModeFromParserResult(parserResult);
        return parserResult.getEntryTypes().values().stream().filter(type -> !EntryTypes.getType(type.getName(), mode).isPresent() || !EntryTypes.isEqualNameAndFieldBased(type, EntryTypes.getType(type.getName(), mode).get())).collect(Collectors.toList());
    }

    private List<EntryType> determineEntryTypesToSave(BasePanel panel, List<EntryType> allCustomizedEntryTypes, BibDatabaseMode databaseMode) {
        ArrayList<EntryType> newTypes = new ArrayList<EntryType>();
        ArrayList<EntryType> differentCustomizations = new ArrayList<EntryType>();
        for (EntryType customType : allCustomizedEntryTypes) {
            if (!EntryTypes.getType(customType.getName(), databaseMode).isPresent()) {
                newTypes.add(customType);
                continue;
            }
            EntryType currentlyStoredType = EntryTypes.getType(customType.getName(), databaseMode).get();
            if (EntryTypes.isEqualNameAndFieldBased(customType, currentlyStoredType)) continue;
            differentCustomizations.add(customType);
        }
        HashMap<EntryType, JCheckBox> typeCheckBoxMap = new HashMap<EntryType, JCheckBox>();
        JPanel checkboxPanel = this.createCheckBoxPanel(newTypes, differentCustomizations, typeCheckBoxMap);
        int answer = JOptionPane.showConfirmDialog(panel.frame(), checkboxPanel, Localization.lang("Custom entry types", new String[0]), 2, 3);
        if (answer == 0) {
            return typeCheckBoxMap.entrySet().stream().filter(entry -> ((JCheckBox)entry.getValue()).isSelected()).map(Map.Entry::getKey).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private JPanel createCheckBoxPanel(List<EntryType> newTypes, List<EntryType> differentCustomizations, Map<EntryType, JCheckBox> typeCheckBoxMap) {
        JCheckBox box;
        JPanel checkboxPanel = new JPanel();
        checkboxPanel.setLayout(new BoxLayout(checkboxPanel, 3));
        JLabel customFoundLabel = new JLabel(Localization.lang("Custom entry types found in file", new String[0]) + ".");
        Font boldStandardFont = new Font(customFoundLabel.getFont().getFontName(), 1, customFoundLabel.getFont().getSize());
        customFoundLabel.setFont(boldStandardFont);
        checkboxPanel.add(customFoundLabel);
        JLabel selectLabel = new JLabel(Localization.lang("Select all customized types to be stored in local preferences", new String[0]) + ":");
        selectLabel.setFont(boldStandardFont);
        checkboxPanel.add(selectLabel);
        checkboxPanel.add(new JLabel(" "));
        if (!newTypes.isEmpty()) {
            checkboxPanel.add(new JLabel(Localization.lang("Currently unknown", new String[0]) + ":"));
            for (EntryType type : newTypes) {
                box = new JCheckBox(type.getName(), true);
                checkboxPanel.add(box);
                typeCheckBoxMap.put(type, box);
            }
        }
        if (!differentCustomizations.isEmpty()) {
            checkboxPanel.add(new JLabel(Localization.lang("Different customization, current settings will be overwritten", new String[0]) + ":"));
            for (EntryType type : differentCustomizations) {
                box = new JCheckBox(type.getName(), true);
                checkboxPanel.add(box);
                typeCheckBoxMap.put(type, box);
            }
        }
        return checkboxPanel;
    }

    private BibDatabaseMode getBibDatabaseModeFromParserResult(ParserResult parserResult) {
        return parserResult.getMetaData().getMode().orElse(Globals.prefs.getDefaultBibDatabaseMode());
    }
}

