/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.keyboard;

import org.jabref.gui.keyboard.KeyBindingCategory;
import org.jabref.logic.l10n.Localization;

public enum KeyBinding {
    ABBREVIATE("Abbreviate", Localization.lang("Abbreviate journal names", new String[0]), "ctrl+alt+A", KeyBindingCategory.TOOLS),
    AUTOGENERATE_BIBTEX_KEYS("Autogenerate BibTeX keys", Localization.lang("Autogenerate BibTeX keys", new String[0]), "ctrl+G", KeyBindingCategory.QUALITY),
    ACCEPT("Accept", Localization.lang("Accept", new String[0]), "ctrl+ENTER", KeyBindingCategory.EDIT),
    AUTOMATICALLY_LINK_FILES("Automatically link files", Localization.lang("Automatically set file links", new String[0]), "F7", KeyBindingCategory.QUALITY),
    BACK("Back", Localization.lang("Back", new String[0]), "alt+LEFT", KeyBindingCategory.VIEW),
    CHECK_INTEGRITY("Check integrity", Localization.menuTitle("Check integrity", new String[0]), "ctrl+F8", KeyBindingCategory.QUALITY),
    CLEANUP("Cleanup", Localization.lang("Cleanup entries", new String[0]), "alt+F8", KeyBindingCategory.QUALITY),
    CLEAR_SEARCH("Clear search", Localization.lang("Clear search", new String[0]), "ESCAPE", KeyBindingCategory.SEARCH),
    CLOSE_DATABASE("Close library", Localization.lang("Close library", new String[0]), "ctrl+W", KeyBindingCategory.FILE),
    CLOSE_DIALOG("Close dialog", Localization.lang("Close dialog", new String[0]), "ESCAPE", KeyBindingCategory.FILE),
    CLOSE_ENTRY_EDITOR("Close entry editor", Localization.lang("Close entry editor", new String[0]), "Esc", KeyBindingCategory.VIEW),
    COPY("Copy", Localization.lang("Copy", new String[0]), "ctrl+C", KeyBindingCategory.EDIT),
    COPY_TITLE("Copy title", Localization.lang("Copy title", new String[0]), "ctrl+shift+alt+T", KeyBindingCategory.EDIT),
    COPY_CITE_BIBTEX_KEY("Copy \\cite{BibTeX key}", Localization.lang("Copy \\cite{BibTeX key}", new String[0]), "ctrl+K", KeyBindingCategory.EDIT),
    COPY_BIBTEX_KEY("Copy BibTeX key", Localization.lang("Copy BibTeX key", new String[0]), "ctrl+shift+K", KeyBindingCategory.EDIT),
    COPY_BIBTEX_KEY_AND_TITLE("Copy BibTeX key and title", Localization.lang("Copy BibTeX key and title", new String[0]), "ctrl+shift+alt+K", KeyBindingCategory.EDIT),
    COPY_BIBTEX_KEY_AND_LINK("Copy BibTeX key and link", Localization.lang("Copy BibTeX key and link", new String[0]), "ctrl+alt+K", KeyBindingCategory.EDIT),
    COPY_PREVIEW("Copy preview", Localization.lang("Copy preview", new String[0]), "ctrl+shift+C", KeyBindingCategory.VIEW),
    CUT("Cut", Localization.lang("Cut", new String[0]), "ctrl+X", KeyBindingCategory.EDIT),
    ENTRY_EDITOR_PREVIOUS_PANEL_2("Entry editor, previous panel 2", Localization.lang("Entry editor, previous panel 2", new String[0]), "ctrl+MINUS", KeyBindingCategory.VIEW),
    DECREASE_TABLE_FONT_SIZE("Decrease table font size", Localization.lang("Decrease table font size", new String[0]), "ctrl+MINUS", KeyBindingCategory.VIEW),
    DELETE_ENTRY("Delete entry", Localization.lang("Delete entry", new String[0]), "DELETE", KeyBindingCategory.BIBTEX),
    DOWNLOAD_FULL_TEXT("Look up full text documents", Localization.lang("Look up full text documents", new String[0]), "alt+F7", KeyBindingCategory.QUALITY),
    EDIT_ENTRY("Edit entry", Localization.lang("Edit entry", new String[0]), "ctrl+E", KeyBindingCategory.BIBTEX),
    EDIT_STRINGS("Edit strings", Localization.lang("Edit strings", new String[0]), "ctrl+T", KeyBindingCategory.BIBTEX),
    ENTRY_EDITOR_NEXT_ENTRY("Entry editor, next entry", Localization.lang("Entry editor, next entry", new String[0]), "ctrl+shift+DOWN", KeyBindingCategory.VIEW),
    ENTRY_EDITOR_NEXT_PANEL("Entry editor, next panel", Localization.lang("Entry editor, next panel", new String[0]), "ctrl+TAB", KeyBindingCategory.VIEW),
    ENTRY_EDITOR_NEXT_PANEL_2("Entry editor, next panel 2", Localization.lang("Entry editor, next panel 2", new String[0]), "ctrl+PLUS", KeyBindingCategory.VIEW),
    ENTRY_EDITOR_PREVIOUS_ENTRY("Entry editor, previous entry", Localization.lang("Entry editor, previous entry", new String[0]), "ctrl+shift+UP", KeyBindingCategory.VIEW),
    ENTRY_EDITOR_PREVIOUS_PANEL("Entry editor, previous panel", Localization.lang("Entry editor, previous panel", new String[0]), "ctrl+shift+TAB", KeyBindingCategory.VIEW),
    FILE_LIST_EDITOR_MOVE_ENTRY_DOWN("File list editor, move entry down", Localization.lang("File list editor, move entry down", new String[0]), "ctrl+DOWN", KeyBindingCategory.VIEW),
    FILE_LIST_EDITOR_MOVE_ENTRY_UP("File list editor, move entry up", Localization.lang("File list editor, move entry up", new String[0]), "ctrl+UP", KeyBindingCategory.VIEW),
    FIND_UNLINKED_FILES("Find unlinked files", Localization.lang("Find unlinked files", new String[0]), "shift+F7", KeyBindingCategory.QUALITY),
    FOCUS_ENTRY_TABLE("Focus entry table", Localization.lang("Focus entry table", new String[0]), "alt+1", KeyBindingCategory.VIEW),
    FORWARD("Forward", Localization.lang("Forward", new String[0]), "alt+RIGHT", KeyBindingCategory.VIEW),
    GLOBAL_SEARCH("Search globally", Localization.lang("Search globally", new String[0]), "ctrl+shift+F", KeyBindingCategory.SEARCH),
    HELP("Help", Localization.lang("Help", new String[0]), "F1", KeyBindingCategory.FILE),
    IMPORT_INTO_CURRENT_DATABASE("Import into current library", Localization.lang("Import into current library", new String[0]), "ctrl+I", KeyBindingCategory.FILE),
    IMPORT_INTO_NEW_DATABASE("Import into new library", Localization.lang("Import into new library", new String[0]), "ctrl+alt+I", KeyBindingCategory.FILE),
    INCREASE_TABLE_FONT_SIZE("Increase table font size", Localization.lang("Increase table font size", new String[0]), "ctrl+PLUS", KeyBindingCategory.VIEW),
    DEFAULT_TABLE_FONT_SIZE("Default table font size", Localization.lang("Default table font size", new String[0]), "ctrl+0", KeyBindingCategory.VIEW),
    MARK_ENTRIES("Mark entries", Localization.lang("Mark entries", new String[0]), "ctrl+M", KeyBindingCategory.EDIT),
    NEW_ARTICLE("New article", Localization.lang("New article", new String[0]), "ctrl+shift+A", KeyBindingCategory.BIBTEX),
    NEW_BOOK("New book", Localization.lang("New book", new String[0]), "ctrl+shift+B", KeyBindingCategory.BIBTEX),
    NEW_ENTRY("New entry", Localization.lang("New entry", new String[0]), "ctrl+N", KeyBindingCategory.BIBTEX),
    NEW_FROM_PLAIN_TEXT("New from plain text", Localization.lang("New from plain text", new String[0]), "ctrl+shift+N", KeyBindingCategory.BIBTEX),
    NEW_INBOOK("New inbook", Localization.lang("New inbook", new String[0]), "ctrl+shift+I", KeyBindingCategory.BIBTEX),
    NEW_MASTERSTHESIS("New mastersthesis", Localization.lang("New mastersthesis", new String[0]), "ctrl+shift+M", KeyBindingCategory.BIBTEX),
    NEW_PHDTHESIS("New phdthesis", Localization.lang("New phdthesis", new String[0]), "ctrl+shift+T", KeyBindingCategory.BIBTEX),
    NEW_PROCEEDINGS("New proceedings", Localization.lang("New proceedings", new String[0]), "ctrl+shift+P", KeyBindingCategory.BIBTEX),
    NEW_UNPUBLISHED("New unpublished", Localization.lang("New unpublished", new String[0]), "ctrl+shift+U", KeyBindingCategory.BIBTEX),
    NEW_TECHREPORT("New technical report", Localization.lang("New technical report", new String[0]), "ctrl+shift+R", KeyBindingCategory.BIBTEX),
    NEXT_PREVIEW_LAYOUT("Next preview layout", Localization.lang("Next preview layout", new String[0]), "F9", KeyBindingCategory.VIEW),
    NEXT_TAB("Next tab", Localization.lang("Next tab", new String[0]), "ctrl+PAGE_DOWN", KeyBindingCategory.VIEW),
    OPEN_CONSOLE("Open terminal here", Localization.lang("Open terminal here", new String[0]), "ctrl+shift+L", KeyBindingCategory.TOOLS),
    OPEN_DATABASE("Open library", Localization.lang("Open library", new String[0]), "ctrl+O", KeyBindingCategory.FILE),
    OPEN_FILE("Open file", Localization.lang("Open file", new String[0]), "F4", KeyBindingCategory.TOOLS),
    OPEN_FOLDER("Open folder", Localization.lang("Open folder", new String[0]), "ctrl+shift+O", KeyBindingCategory.TOOLS),
    OPEN_OPEN_OFFICE_LIBRE_OFFICE_CONNECTION("Open OpenOffice/LibreOffice connection", Localization.lang("Open OpenOffice/LibreOffice connection", new String[0]), "alt+0", KeyBindingCategory.TOOLS),
    OPEN_URL_OR_DOI("Open URL or DOI", Localization.lang("Open URL or DOI", new String[0]), "F3", KeyBindingCategory.TOOLS),
    PASTE("Paste", Localization.lang("Paste", new String[0]), "ctrl+V", KeyBindingCategory.EDIT),
    PULL_CHANGES_FROM_SHARED_DATABASE("Pull changes from shared database", Localization.lang("Pull changes from shared database", new String[0]), "ctrl+shift+R", KeyBindingCategory.FILE),
    PREAMBLE_EDITOR_STORE_CHANGES("Preamble editor, store changes", Localization.lang("Preamble editor, store changes", new String[0]), "alt+S", KeyBindingCategory.FILE),
    PREVIOUS_PREVIEW_LAYOUT("Previous preview layout", Localization.lang("Previous preview layout", new String[0]), "shift+F9", KeyBindingCategory.VIEW),
    PREVIOUS_TAB("Previous tab", Localization.lang("Previous tab", new String[0]), "ctrl+PAGE_UP", KeyBindingCategory.VIEW),
    PUSH_TO_APPLICATION("Push to application", Localization.lang("Push to application", new String[0]), "ctrl+L", KeyBindingCategory.TOOLS),
    QUIT_JABREF("Quit JabRef", Localization.lang("Quit JabRef", new String[0]), "ctrl+Q", KeyBindingCategory.FILE),
    REDO("Redo", Localization.lang("Redo", new String[0]), "ctrl+Y", KeyBindingCategory.EDIT),
    REFRESH_OO("Refresh OO", Localization.lang("Refresh OpenOffice/LibreOffice", new String[0]), "ctrl+alt+O", KeyBindingCategory.TOOLS),
    REPLACE_STRING("Replace string", Localization.lang("Replace string", new String[0]), "ctrl+R", KeyBindingCategory.SEARCH),
    RESOLVE_DUPLICATE_BIBTEX_KEYS("Resolve duplicate BibTeX keys", Localization.lang("Resolve duplicate BibTeX keys", new String[0]), "ctrl+shift+D", KeyBindingCategory.BIBTEX),
    SAVE_ALL("Save all", Localization.lang("Save all", new String[0]), "ctrl+alt+S", KeyBindingCategory.FILE),
    SAVE_DATABASE("Save library", Localization.lang("Save library", new String[0]), "ctrl+S", KeyBindingCategory.FILE),
    SAVE_DATABASE_AS("Save library as ...", Localization.lang("Save library as...", new String[0]), "ctrl+shift+S", KeyBindingCategory.FILE),
    SEARCH("Search", Localization.lang("Search", new String[0]), "ctrl+F", KeyBindingCategory.SEARCH),
    SELECT_ALL("Select all", Localization.lang("Select all", new String[0]), "ctrl+A", KeyBindingCategory.EDIT),
    SELECT_FIRST_ENTRY("Select first entry", Localization.lang("Select first entry", new String[0]), "HOME", KeyBindingCategory.EDIT),
    SELECT_LAST_ENTRY("Select last entry", Localization.lang("Select last entry", new String[0]), "END", KeyBindingCategory.EDIT),
    STRING_DIALOG_ADD_STRING("String dialog, add string", Localization.lang("String dialog, add string", new String[0]), "ctrl+N", KeyBindingCategory.FILE),
    STRING_DIALOG_REMOVE_STRING("String dialog, remove string", Localization.lang("String dialog, remove string", new String[0]), "shift+DELETE", KeyBindingCategory.FILE),
    SYNCHRONIZE_FILES("Synchronize files", Localization.lang("Synchronize files", new String[0]), "ctrl+shift+F7", KeyBindingCategory.QUALITY),
    TOGGLE_ENTRY_PREVIEW("Toggle entry preview", Localization.lang("Toggle entry preview", new String[0]), "alt+2", KeyBindingCategory.VIEW),
    TOGGLE_GROUPS_INTERFACE("Toggle groups interface", Localization.lang("Toggle groups interface", new String[0]), "alt+3", KeyBindingCategory.VIEW),
    UNABBREVIATE("Unabbreviate", Localization.lang("Unabbreviate", new String[0]), "ctrl+alt+shift+A", KeyBindingCategory.TOOLS),
    UNDO("Undo", Localization.lang("Undo", new String[0]), "ctrl+Z", KeyBindingCategory.EDIT),
    UNMARK_ENTRIES("Unmark entries", Localization.lang("Unmark entries", new String[0]), "ctrl+shift+M", KeyBindingCategory.EDIT),
    WEB_SEARCH("Web search", Localization.lang("Web search", new String[0]), "alt+4", KeyBindingCategory.SEARCH),
    WRITE_XMP("Write XMP", Localization.lang("Write XMP", new String[0]), "F6", KeyBindingCategory.TOOLS);

    private final String constant;
    private final String localization;
    private final String defaultBinding;
    private final KeyBindingCategory category;

    private KeyBinding(String constantName, String localization, String defaultKeyBinding, KeyBindingCategory category) {
        this.constant = constantName;
        this.localization = localization;
        this.defaultBinding = defaultKeyBinding;
        this.category = category;
    }

    public String getConstant() {
        return this.constant;
    }

    public String getLocalization() {
        return this.localization;
    }

    public String getDefaultKeyBinding() {
        return this.defaultBinding;
    }

    public KeyBindingCategory getCategory() {
        return this.category;
    }
}

