/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.bibtex;

import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.jabref.logic.TypedBibEntry;
import org.jabref.logic.bibtex.InvalidFieldValueException;
import org.jabref.logic.bibtex.LatexFieldFormatter;
import org.jabref.logic.util.OS;
import org.jabref.model.EntryTypes;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.EntryType;
import org.jabref.model.entry.InternalBibtexFields;
import org.jabref.model.strings.StringUtil;

public class BibEntryWriter {
    private final LatexFieldFormatter fieldFormatter;
    private final boolean write;

    public BibEntryWriter(LatexFieldFormatter fieldFormatter, boolean write) {
        this.fieldFormatter = fieldFormatter;
        this.write = write;
    }

    public void write(BibEntry entry, Writer out, BibDatabaseMode bibDatabaseMode) throws IOException {
        this.write(entry, out, bibDatabaseMode, false);
    }

    public void write(BibEntry entry, Writer out, BibDatabaseMode bibDatabaseMode, Boolean reformat) throws IOException {
        if (!reformat.booleanValue() && !entry.hasChanged()) {
            out.write(entry.getParsedSerialization());
            return;
        }
        this.writeUserComments(entry, out);
        out.write(OS.NEWLINE);
        this.writeRequiredFieldsFirstRemainingFieldsSecond(entry, out, bibDatabaseMode);
        out.write(OS.NEWLINE);
    }

    private void writeUserComments(BibEntry entry, Writer out) throws IOException {
        String userComments = entry.getUserComments();
        if (!userComments.isEmpty()) {
            out.write(userComments + OS.NEWLINE);
        }
    }

    public void writeWithoutPrependedNewlines(BibEntry entry, Writer out, BibDatabaseMode bibDatabaseMode) throws IOException {
        if (!entry.hasChanged()) {
            out.write(entry.getParsedSerialization().trim());
            return;
        }
        this.writeRequiredFieldsFirstRemainingFieldsSecond(entry, out, bibDatabaseMode);
    }

    private void writeRequiredFieldsFirstRemainingFieldsSecond(BibEntry entry, Writer out, BibDatabaseMode bibDatabaseMode) throws IOException {
        TypedBibEntry typedEntry = new TypedBibEntry(entry, bibDatabaseMode);
        out.write('@' + typedEntry.getTypeForDisplay() + '{');
        this.writeKeyField(entry, out);
        HashSet<String> written = new HashSet<String>();
        written.add("bibtexkey");
        int indentation = this.getLengthOfLongestFieldName(entry);
        EntryType type = EntryTypes.getTypeOrDefault(entry.getType(), bibDatabaseMode);
        Set<String> fields = type.getRequiredFieldsFlat();
        if (fields != null) {
            for (String value : fields) {
                this.writeField(entry, out, value, indentation);
                written.add(value);
            }
        }
        if ((fields = type.getOptionalFields()) != null) {
            for (String value : fields) {
                if (written.contains(value)) continue;
                this.writeField(entry, out, value, indentation);
                written.add(value);
            }
        }
        TreeSet<String> remainingFields = new TreeSet<String>();
        for (String key : entry.getFieldNames()) {
            boolean writeIt;
            boolean bl = writeIt = this.write ? InternalBibtexFields.isWriteableField(key) : InternalBibtexFields.isDisplayableField(key);
            if (written.contains(key) || !writeIt) continue;
            remainingFields.add(key);
        }
        for (String field2 : remainingFields) {
            this.writeField(entry, out, field2, indentation);
        }
        out.write(125);
    }

    private void writeKeyField(BibEntry entry, Writer out) throws IOException {
        String keyField = StringUtil.shaveString(entry.getCiteKeyOptional().orElse(""));
        out.write(keyField + ',' + OS.NEWLINE);
    }

    private void writeField(BibEntry entry, Writer out, String name, int indentation) throws IOException {
        Optional<String> field2 = entry.getField(name);
        if (field2.isPresent() && !field2.get().trim().isEmpty()) {
            out.write("  " + this.getFieldDisplayName(name, indentation));
            try {
                out.write(this.fieldFormatter.format(field2.get(), name));
                out.write(',' + OS.NEWLINE);
            }
            catch (InvalidFieldValueException ex) {
                throw new IOException("Error in field '" + name + "': " + ex.getMessage(), ex);
            }
        }
    }

    private int getLengthOfLongestFieldName(BibEntry entry) {
        Predicate<String> isNotBibtexKey = field2 -> !"bibtexkey".equals(field2);
        return entry.getFieldNames().stream().filter(isNotBibtexKey).mapToInt(String::length).max().orElse(0);
    }

    private String getFieldDisplayName(String field2, int intendation) {
        String actualField = field2;
        if (actualField.isEmpty()) {
            actualField = "UNKNOWN";
        }
        return actualField.toLowerCase(Locale.ROOT) + StringUtil.repeatSpaces(intendation - actualField.length()) + " = ";
    }
}

