/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.exporter;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.Set;
import org.jabref.logic.exporter.SaveException;
import org.jabref.logic.exporter.SaveSession;
import org.jabref.logic.exporter.VerifyingWriter;
import org.jabref.logic.util.io.FileBasedLock;
import org.jabref.logic.util.io.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSaveSession
extends SaveSession {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSaveSession.class);
    private static final String BACKUP_EXTENSION = ".bak";
    private static final String TEMP_PREFIX = "jabref";
    private static final String TEMP_SUFFIX = "save.bib";
    private final Path temporaryFile;

    public FileSaveSession(Charset encoding, boolean backup) throws SaveException {
        this(encoding, backup, FileSaveSession.createTemporaryFile());
    }

    public FileSaveSession(Charset encoding, boolean backup, Path temporaryFile) throws SaveException {
        super(encoding, backup, FileSaveSession.getWriterForFile(encoding, temporaryFile));
        this.temporaryFile = temporaryFile;
    }

    private static VerifyingWriter getWriterForFile(Charset encoding, Path file) throws SaveException {
        try {
            return new VerifyingWriter(Files.newOutputStream(file, new OpenOption[0]), encoding);
        }
        catch (IOException e) {
            throw new SaveException(e);
        }
    }

    private static Path createTemporaryFile() throws SaveException {
        try {
            return Files.createTempFile(TEMP_PREFIX, TEMP_SUFFIX, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new SaveException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(Path file) throws SaveException {
        block15: {
            if (file == null) {
                return;
            }
            if (this.backup && Files.exists(file, new LinkOption[0])) {
                Path backupFile = FileUtil.addExtension(file, BACKUP_EXTENSION);
                FileUtil.copyFile(file, backupFile, true);
            }
            try {
                try {
                    if (FileBasedLock.createLockFile(file) && !FileBasedLock.waitForFileLock(file)) {
                        throw SaveException.FILE_LOCKED;
                    }
                }
                catch (IOException ex) {
                    LOGGER.error("Error when creating lock file.", ex);
                }
                Set<PosixFilePermission> oldFilePermissions = EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_WRITE, PosixFilePermission.OTHERS_READ);
                if (FileUtil.IS_POSIX_COMPILANT && Files.exists(file, new LinkOption[0])) {
                    try {
                        oldFilePermissions = Files.getPosixFilePermissions(file, new LinkOption[0]);
                    }
                    catch (IOException exception) {
                        LOGGER.warn("Error getting file permissions.", exception);
                    }
                }
                FileUtil.copyFile(this.temporaryFile, file, true);
                if (!FileUtil.IS_POSIX_COMPILANT) break block15;
                try {
                    Files.setPosixFilePermissions(file, oldFilePermissions);
                }
                catch (IOException exception) {
                    throw new SaveException(exception);
                }
            }
            finally {
                FileBasedLock.deleteLockFile(file);
            }
        }
        try {
            Files.deleteIfExists(this.temporaryFile);
        }
        catch (IOException e) {
            LOGGER.warn("Cannot delete temporary file", e);
        }
    }

    @Override
    public void cancel() {
        try {
            Files.deleteIfExists(this.temporaryFile);
        }
        catch (IOException e) {
            LOGGER.warn("Cannot delete temporary file", e);
        }
    }
}

