/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fileformat;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.jabref.logic.importer.Importer;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.util.StandardFileType;
import org.jabref.model.entry.AuthorList;
import org.jabref.model.entry.BibEntry;

public class InspecImporter
extends Importer {
    private static final Pattern INSPEC_PATTERN = Pattern.compile("Record.*INSPEC.*");

    @Override
    public String getName() {
        return "INSPEC";
    }

    @Override
    public StandardFileType getFileType() {
        return StandardFileType.TXT;
    }

    @Override
    public String getDescription() {
        return "INSPEC format importer.";
    }

    @Override
    public boolean isRecognizedFormat(BufferedReader reader) throws IOException {
        String str;
        while ((str = reader.readLine()) != null) {
            if (!INSPEC_PATTERN.matcher(str).find()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ParserResult importDatabase(BufferedReader reader) throws IOException {
        String str;
        ArrayList<BibEntry> bibitems = new ArrayList<BibEntry>();
        StringBuilder sb = new StringBuilder();
        while ((str = reader.readLine()) != null) {
            if (str.length() < 2) continue;
            if (str.indexOf("Record") == 0) {
                sb.append("__::__").append(str);
                continue;
            }
            sb.append("__NEWFIELD__").append(str);
        }
        String[] entries = sb.toString().split("__::__");
        String type = "";
        HashMap<String, String> h2 = new HashMap<String, String>();
        for (String entry : entries) {
            String[] fields;
            if (entry.indexOf("Record") != 0) continue;
            h2.clear();
            for (String s2 : fields = entry.split("__NEWFIELD__")) {
                String f3 = s2.substring(0, 2);
                String frest = s2.substring(5);
                if ("TI".equals(f3)) {
                    h2.put("title", frest);
                    continue;
                }
                if ("PY".equals(f3)) {
                    h2.put("year", frest);
                    continue;
                }
                if ("AU".equals(f3)) {
                    h2.put("author", AuthorList.fixAuthorLastNameFirst(frest.replace(",-", ", ").replace(";", " and ")));
                    continue;
                }
                if ("AB".equals(f3)) {
                    h2.put("abstract", frest);
                    continue;
                }
                if ("ID".equals(f3)) {
                    h2.put("keywords", frest);
                    continue;
                }
                if ("SO".equals(f3)) {
                    int m3 = frest.indexOf(46);
                    if (m3 < 0) continue;
                    String jr = frest.substring(0, m3);
                    h2.put("journal", jr.replace("-", " "));
                    frest = frest.substring(m3);
                    m3 = frest.indexOf(59);
                    if (m3 < 5) continue;
                    String yr = frest.substring(m3 - 5, m3).trim();
                    h2.put("year", yr);
                    frest = frest.substring(m3);
                    m3 = frest.indexOf(58);
                    if (m3 < 0) continue;
                    String pg = frest.substring(m3 + 1).trim();
                    h2.put("pages", pg);
                    String vol = frest.substring(1, m3).trim();
                    h2.put("volume", vol);
                    continue;
                }
                if (!"RT".equals(f3)) continue;
                type = "Journal-Paper".equals(frest = frest.trim()) ? "article" : ("Conference-Paper".equals(frest) || "Conference-Paper; Journal-Paper".equals(frest) ? "inproceedings" : frest.replace(" ", ""));
            }
            BibEntry b = new BibEntry(type);
            b.setField(h2);
            bibitems.add(b);
        }
        return new ParserResult(bibitems);
    }
}

