/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.integrity;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jabref.logic.bibtexkeypattern.BibtexKeyPatternPreferences;
import org.jabref.logic.integrity.ASCIICharacterChecker;
import org.jabref.logic.integrity.BibStringChecker;
import org.jabref.logic.integrity.BibTeXEntryTypeChecker;
import org.jabref.logic.integrity.BibtexKeyChecker;
import org.jabref.logic.integrity.BibtexKeyDuplicationChecker;
import org.jabref.logic.integrity.BibtexkeyDeviationChecker;
import org.jabref.logic.integrity.EntryLinkChecker;
import org.jabref.logic.integrity.FieldChecker;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.logic.integrity.HTMLCharacterChecker;
import org.jabref.logic.integrity.IntegrityMessage;
import org.jabref.logic.integrity.JournalInAbbreviationListChecker;
import org.jabref.logic.integrity.NoBibtexFieldChecker;
import org.jabref.logic.integrity.TypeChecker;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.metadata.FileDirectoryPreferences;

public class IntegrityCheck {
    private final BibDatabaseContext bibDatabaseContext;
    private final FileDirectoryPreferences fileDirectoryPreferences;
    private final BibtexKeyPatternPreferences bibtexKeyPatternPreferences;
    private final JournalAbbreviationRepository journalAbbreviationRepository;
    private final boolean enforceLegalKey;

    public IntegrityCheck(BibDatabaseContext bibDatabaseContext, FileDirectoryPreferences fileDirectoryPreferences, BibtexKeyPatternPreferences bibtexKeyPatternPreferences, JournalAbbreviationRepository journalAbbreviationRepository, boolean enforceLegalKey) {
        this.bibDatabaseContext = Objects.requireNonNull(bibDatabaseContext);
        this.fileDirectoryPreferences = Objects.requireNonNull(fileDirectoryPreferences);
        this.bibtexKeyPatternPreferences = Objects.requireNonNull(bibtexKeyPatternPreferences);
        this.journalAbbreviationRepository = Objects.requireNonNull(journalAbbreviationRepository);
        this.enforceLegalKey = enforceLegalKey;
    }

    public List<IntegrityMessage> checkBibtexDatabase() {
        ArrayList<IntegrityMessage> result = new ArrayList<IntegrityMessage>();
        for (BibEntry entry : this.bibDatabaseContext.getDatabase().getEntries()) {
            result.addAll(this.checkBibtexEntry(entry));
        }
        return result;
    }

    private List<IntegrityMessage> checkBibtexEntry(BibEntry entry) {
        ArrayList<IntegrityMessage> result = new ArrayList<IntegrityMessage>();
        if (entry == null) {
            return result;
        }
        FieldCheckers fieldCheckers = new FieldCheckers(this.bibDatabaseContext, this.fileDirectoryPreferences, this.journalAbbreviationRepository, this.enforceLegalKey);
        for (FieldChecker checker : fieldCheckers.getAll()) {
            result.addAll(checker.check(entry));
        }
        if (!this.bibDatabaseContext.isBiblatexMode()) {
            result.addAll(new ASCIICharacterChecker().check(entry));
            result.addAll(new NoBibtexFieldChecker().check(entry));
            result.addAll(new BibTeXEntryTypeChecker().check(entry));
            result.addAll(new JournalInAbbreviationListChecker("journal", this.journalAbbreviationRepository).check(entry));
        } else {
            result.addAll(new JournalInAbbreviationListChecker("journaltitle", this.journalAbbreviationRepository).check(entry));
        }
        result.addAll(new BibtexKeyChecker().check(entry));
        result.addAll(new TypeChecker().check(entry));
        result.addAll(new BibStringChecker().check(entry));
        result.addAll(new HTMLCharacterChecker().check(entry));
        result.addAll(new EntryLinkChecker(this.bibDatabaseContext.getDatabase()).check(entry));
        result.addAll(new BibtexkeyDeviationChecker(this.bibDatabaseContext, this.bibtexKeyPatternPreferences).check(entry));
        result.addAll(new BibtexKeyDuplicationChecker(this.bibDatabaseContext.getDatabase()).check(entry));
        return result;
    }

    @FunctionalInterface
    public static interface Checker {
        public List<IntegrityMessage> check(BibEntry var1);
    }
}

