/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.util;

import java.util.Arrays;
import java.util.List;
import org.jabref.logic.util.FileType;

public enum StandardFileType implements FileType
{
    BIBTEXML("bibx", "xml"),
    ENDNOTE("ref", "enw"),
    FREECITE("txt", "xml"),
    ISI("isi", "txt"),
    MEDLINE("nbib", "xml"),
    MEDLINE_PLAIN("nbib", "txt"),
    PUBMED("fcgi"),
    SILVER_PLATTER("dat", "txt"),
    AUX("aux"),
    BIBTEX_DB("bib"),
    CITATION_STYLE("csl"),
    CLASS("class"),
    CSV("csv"),
    HTML("html"),
    JAR("jar"),
    JSTYLE("jstyle"),
    LAYOUT("layout"),
    ODS("ods"),
    PDF("pdf"),
    RIS("ris"),
    TERMS("terms"),
    TXT("txt"),
    RDF("rdf"),
    RTF("rtf"),
    SXC("sxc"),
    XML("xml"),
    XMP("xmp"),
    ZIP("zip");

    private final List<String> extensions;

    private StandardFileType(String ... extensions) {
        this.extensions = Arrays.asList(extensions);
    }

    @Override
    public List<String> getExtensions() {
        return this.extensions;
    }

    public static FileType newFileType(String ... extensions) {
        return () -> Arrays.asList(extensions);
    }
}

