/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.util.io;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class FileHistory {
    private static final int HISTORY_SIZE = 8;
    private final LinkedList<String> history;

    public FileHistory(List<String> fileList) {
        this.history = new LinkedList(Objects.requireNonNull(fileList));
    }

    public int size() {
        return this.history.size();
    }

    public boolean isEmpty() {
        return this.history.isEmpty();
    }

    public void newFile(String filename) {
        this.removeItem(filename);
        this.history.addFirst(filename);
        while (this.size() > 8) {
            this.history.removeLast();
        }
    }

    public String getFileName(int i) {
        return this.history.get(i);
    }

    public void removeItem(String filename) {
        this.history.remove(filename);
    }

    public List<String> getHistory() {
        return this.history;
    }
}

