/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.xmp;

import java.io.IOException;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.xmpbox.DateConverter;
import org.apache.xmpbox.schema.DublinCoreSchema;
import org.jabref.logic.TypedBibEntry;
import org.jabref.logic.xmp.XmpPreferences;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.Author;
import org.jabref.model.entry.AuthorList;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.Month;
import org.jabref.model.strings.StringUtil;

public class DublinCoreExtractor {
    private final DublinCoreSchema dcSchema;
    private final XmpPreferences xmpPreferences;
    private final BibEntry bibEntry;

    public DublinCoreExtractor(DublinCoreSchema dcSchema, XmpPreferences xmpPreferences, BibEntry resolvedEntry) {
        this.dcSchema = dcSchema;
        this.xmpPreferences = xmpPreferences;
        this.bibEntry = resolvedEntry;
    }

    private void extractEditor() {
        List<String> contributors = this.dcSchema.getContributors();
        if (contributors != null && !contributors.isEmpty()) {
            this.bibEntry.setField("editor", String.join((CharSequence)" and ", contributors));
        }
    }

    private void extractAuthor() {
        List<String> creators = this.dcSchema.getCreators();
        if (creators != null && !creators.isEmpty()) {
            this.bibEntry.setField("author", String.join((CharSequence)" and ", creators));
        }
    }

    private void extractYearAndMonth() {
        List<String> dates = this.dcSchema.getUnqualifiedSequenceValueList("date");
        if (dates != null && !dates.isEmpty()) {
            String date = dates.get(0).trim();
            Calendar calender = null;
            try {
                calender = DateConverter.toCalendar(date);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (calender != null) {
                Optional<Month> month;
                this.bibEntry.setField("year", String.valueOf(calender.get(1)));
                if ((calender.get(2) != 0 || calender.get(5) != 1) && (month = Month.getMonthByNumber(calender.get(2) + 1)).isPresent()) {
                    this.bibEntry.setField("month", month.get().getShortName());
                }
            }
        }
    }

    private void extractAbstract() {
        String description = this.dcSchema.getDescription();
        if (!StringUtil.isNullOrEmpty(description)) {
            this.bibEntry.setField("abstract", description);
        }
    }

    private void extractDOI() {
        String identifier = this.dcSchema.getIdentifier();
        if (!StringUtil.isNullOrEmpty(identifier)) {
            this.bibEntry.setField("doi", identifier);
        }
    }

    private void extractPublisher() {
        List<String> publishers = this.dcSchema.getPublishers();
        if (publishers != null && !publishers.isEmpty()) {
            this.bibEntry.setField("publisher", String.join((CharSequence)" and ", publishers));
        }
    }

    private void extractBibTexFields() {
        List<String> relationships = this.dcSchema.getRelations();
        Predicate<String> isBibTeXElement = s2 -> s2.startsWith("bibtex/");
        Consumer<String> splitBibTeXElement = s2 -> {
            String temp = s2.substring("bibtex/".length());
            int i = temp.indexOf(47);
            if (i != -1) {
                Optional<Month> parsedMonth;
                String key = temp.substring(0, i);
                String value = temp.substring(i + 1);
                this.bibEntry.setField(key, value);
                if ("month".equals(key) && (parsedMonth = Month.parse(value)).isPresent()) {
                    this.bibEntry.setField(key, parsedMonth.get().getShortName());
                }
            }
        };
        if (relationships != null) {
            relationships.stream().filter(isBibTeXElement).forEach(splitBibTeXElement);
        }
    }

    private void extractRights() {
        String rights = this.dcSchema.getRights();
        if (!StringUtil.isNullOrEmpty(rights)) {
            this.bibEntry.setField("rights", rights);
        }
    }

    private void extractSource() {
        String source = this.dcSchema.getSource();
        if (!StringUtil.isNullOrEmpty(source)) {
            this.bibEntry.setField("source", source);
        }
    }

    private void extractSubject() {
        List<String> subjects = this.dcSchema.getSubjects();
        if (subjects != null && !subjects.isEmpty()) {
            this.bibEntry.addKeywords(subjects, this.xmpPreferences.getKeywordSeparator());
        }
    }

    private void extractTitle() {
        String title = this.dcSchema.getTitle();
        if (!StringUtil.isNullOrEmpty(title)) {
            this.bibEntry.setField("title", title);
        }
    }

    private void extractType() {
        String type;
        List<String> types = this.dcSchema.getTypes();
        if (types != null && !types.isEmpty() && !StringUtil.isNullOrEmpty(type = types.get(0))) {
            this.bibEntry.setType(type);
        }
    }

    public Optional<BibEntry> extractBibtexEntry() {
        this.extractEditor();
        this.extractAuthor();
        this.extractYearAndMonth();
        this.extractAbstract();
        this.extractDOI();
        this.extractPublisher();
        this.extractBibTexFields();
        this.extractRights();
        this.extractSource();
        this.extractSubject();
        this.extractTitle();
        this.extractType();
        if (this.bibEntry.getType() == null) {
            this.bibEntry.setType("misc");
        }
        return Optional.of(this.bibEntry);
    }

    private void fillContributor(String authors) {
        AuthorList list = AuthorList.parse(authors);
        for (Author author : list.getAuthors()) {
            this.dcSchema.addContributor(author.getFirstLast(false));
        }
    }

    private void fillCreator(String creators) {
        AuthorList list = AuthorList.parse(creators);
        for (Author author : list.getAuthors()) {
            this.dcSchema.addCreator(author.getFirstLast(false));
        }
    }

    private void fillDate() {
        this.bibEntry.getFieldOrAlias("date").ifPresent(publicationDate -> this.dcSchema.addUnqualifiedSequenceValue("date", (String)publicationDate));
    }

    private void fillDescription(String description) {
        this.dcSchema.setDescription(description);
    }

    private void fillIdentifier(String identifier) {
        this.dcSchema.setIdentifier(identifier);
    }

    private void fillPublisher(String publisher) {
        this.dcSchema.addPublisher(publisher);
    }

    private void fillKeywords(String value) {
        String[] keywords;
        for (String keyword : keywords = value.split(",")) {
            this.dcSchema.addSubject(keyword.trim());
        }
    }

    private void fillTitle(String title) {
        this.dcSchema.setTitle(title);
    }

    private void fillCustomField(String key, String value) {
        this.dcSchema.addRelation("bibtex/" + key + '/' + value);
    }

    public void fillDublinCoreSchema() {
        boolean useXmpPrivacyFilter = this.xmpPreferences.isUseXMPPrivacyFilter();
        TreeSet<String> filters = new TreeSet<String>(this.xmpPreferences.getXmpPrivacyFilter());
        for (Map.Entry<String, String> field2 : this.bibEntry.getFieldMap().entrySet()) {
            if (useXmpPrivacyFilter && filters.contains(field2.getKey())) continue;
            if ("editor".equals(field2.getKey())) {
                this.fillContributor(field2.getValue());
                continue;
            }
            if ("author".equals(field2.getKey())) {
                this.fillCreator(field2.getValue());
                continue;
            }
            if ("year".equals(field2.getKey())) {
                this.fillDate();
                continue;
            }
            if ("abstract".equals(field2.getKey())) {
                this.fillDescription(field2.getValue());
                continue;
            }
            if ("doi".equals(field2.getKey())) {
                this.fillIdentifier(field2.getValue());
                continue;
            }
            if ("publisher".equals(field2.getKey())) {
                this.fillPublisher(field2.getValue());
                continue;
            }
            if ("keywords".equals(field2.getKey())) {
                this.fillKeywords(field2.getValue());
                continue;
            }
            if ("title".equals(field2.getKey())) {
                this.fillTitle(field2.getValue());
                continue;
            }
            this.fillCustomField(field2.getKey(), field2.getValue());
        }
        this.dcSchema.setFormat("application/pdf");
        TypedBibEntry typedEntry = new TypedBibEntry(this.bibEntry, BibDatabaseMode.BIBTEX);
        String o = typedEntry.getTypeForDisplay();
        if (!o.isEmpty()) {
            this.dcSchema.addType(o);
        }
    }
}

