/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.model;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.ResponseStream;
import com.google.jstestdriver.hooks.ResourcePreProcessor;
import com.google.jstestdriver.model.JstdTestCaseFactory;
import com.google.jstestdriver.model.RunData;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunDataFactory {
    private final Set<FileInfo> fileSet;
    private final Set<ResourcePreProcessor> processors;
    private final List<FileInfo> tests;
    private final JstdTestCaseFactory testCaseFactory;
    private final List<FileInfo> plugins;

    @Inject
    public RunDataFactory(@Named(value="fileSet") Set<FileInfo> fileSet, @Named(value="tests") List<FileInfo> tests, Set<ResourcePreProcessor> processors, @Named(value="plugins") List<FileInfo> plugins, JstdTestCaseFactory testCaseFactory) {
        this.fileSet = fileSet;
        this.tests = tests;
        this.processors = processors;
        this.plugins = plugins;
        this.testCaseFactory = testCaseFactory;
    }

    public RunData get() {
        List<FileInfo> processedDependencies = Lists.newLinkedList(this.fileSet);
        List<FileInfo> processedPlugins = Lists.newLinkedList(this.plugins);
        List<FileInfo> processedTests = Lists.newLinkedList(this.tests);
        for (ResourcePreProcessor processor : this.processors) {
            processedPlugins = processor.processPlugins(processedPlugins);
            processedTests = processor.processTests(processedTests);
            processedDependencies = processor.processDependencies(processedDependencies);
        }
        return new RunData(Collections.<ResponseStream>emptyList(), this.testCaseFactory.createCases(processedPlugins, processedDependencies, processedTests), this.testCaseFactory);
    }
}

