/* lfs.h was originally generated by the autoSql program, which also 
 * generated lfs.c and lfs.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef LFS_H
#define LFS_H

struct lfs
/* Standard linked features series table */
    {
    struct lfs *next;  /* Next in singly linked list. */
    short bin;	/* Bin number for browser speedup */
    char *chrom;	/* Human chromosome or FPC contig */
    unsigned chromStart;	/* Start position of clone in chromosome */
    unsigned chromEnd;	/* End position of clone in chromosome */
    char *name;	/* Name of clone */
    unsigned score;	/* Score = 1000/(# of times clone appears in assembly) */
    char strand[2];	/* Value should be + or - */
    char *pslTable;	/* Table which contains corresponding PSL records for linked features */
    unsigned lfCount;	/* Number of linked features in the series */
    unsigned *lfStarts;	/* Comma separated list of start positions of each linked feature in genomic */
    unsigned *lfSizes;	/* Comma separated list of sizes of each linked feature in genomic */
    char **lfNames;	/* Comma separated list of names of linked features */
    };

struct lfs *lfsLoad(char **row);
/* Load a lfs from row fetched with select * from lfs
 * from database.  Dispose of this with lfsFree(). */

struct lfs *lfsLoadAll(char *fileName);
/* Load all lfs from a tab-separated file.
 * Dispose of this with lfsFreeList(). */

struct lfs *lfsCommaIn(char **pS, struct lfs *ret);
/* Create a lfs out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new lfs */

void lfsFree(struct lfs **pEl);
/* Free a single dynamically allocated lfs such as created
 * with lfsLoad(). */

void lfsFreeList(struct lfs **pList);
/* Free a list of dynamically allocated lfs's */

void lfsOutput(struct lfs *el, FILE *f, char sep, char lastSep);
/* Print out lfs.  Separate fields with sep. Follow last field with lastSep. */

#define lfsTabOut(el,f) lfsOutput(el,f,'\t','\n');
/* Print out lfs as a line in a tab-separated file. */

#define lfsCommaOut(el,f) lfsOutput(el,f,',',',');
/* Print out lfs as a comma separated list including final comma. */

#endif /* LFS_H */

