/* zdobnovSynt.h was originally generated by the autoSql program, which also 
 * generated zdobnovSynt.c and zdobnovSynt.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef ZDOBNOVSYNT_H
#define ZDOBNOVSYNT_H

#define ZDOBNOVSYNT_NUM_COLS 13

struct zdobnovSynt
/* Gene homology-based synteny blocks from Evgeny Zdobnov/Peer Bork et al. */
    {
    struct zdobnovSynt *next;  /* Next in singly linked list. */
    char *chrom;	/* chromosome */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* Name of item:  */
    unsigned score;	/* Score placeholder */
    char strand[2];	/* placeholder */
    unsigned thickStart;	/* Start of where display should be thick (start codon) */
    unsigned thickEnd;	/* End of where display should be thick (stop codon) */
    unsigned reserved;	/* Always zero for now */
    int blockCount;	/* Number of blocks (syntenic genes) */
    int *blockSizes;	/* Comma separated list of block sizes */
    int *chromStarts;	/* Start positions relative to chromStart */
    char **geneNames;	/* Names of genes (from other species) */
    };

struct zdobnovSynt *zdobnovSyntLoad(char **row);
/* Load a zdobnovSynt from row fetched with select * from zdobnovSynt
 * from database.  Dispose of this with zdobnovSyntFree(). */

struct zdobnovSynt *zdobnovSyntLoadAll(char *fileName);
/* Load all zdobnovSynt from whitespace-separated file.
 * Dispose of this with zdobnovSyntFreeList(). */

struct zdobnovSynt *zdobnovSyntLoadAllByChar(char *fileName, char chopper);
/* Load all zdobnovSynt from chopper separated file.
 * Dispose of this with zdobnovSyntFreeList(). */

#define zdobnovSyntLoadAllByTab(a) zdobnovSyntLoadAllByChar(a, '\t');
/* Load all zdobnovSynt from tab separated file.
 * Dispose of this with zdobnovSyntFreeList(). */

struct zdobnovSynt *zdobnovSyntCommaIn(char **pS, struct zdobnovSynt *ret);
/* Create a zdobnovSynt out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new zdobnovSynt */

void zdobnovSyntFree(struct zdobnovSynt **pEl);
/* Free a single dynamically allocated zdobnovSynt such as created
 * with zdobnovSyntLoad(). */

void zdobnovSyntFreeList(struct zdobnovSynt **pList);
/* Free a list of dynamically allocated zdobnovSynt's */

void zdobnovSyntOutput(struct zdobnovSynt *el, FILE *f, char sep, char lastSep);
/* Print out zdobnovSynt.  Separate fields with sep. Follow last field with lastSep. */

#define zdobnovSyntTabOut(el,f) zdobnovSyntOutput(el,f,'\t','\n');
/* Print out zdobnovSynt as a line in a tab-separated file. */

#define zdobnovSyntCommaOut(el,f) zdobnovSyntOutput(el,f,',',',');
/* Print out zdobnovSynt as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* ZDOBNOVSYNT_H */

