/* dless.c was originally generated by the autoSql program, which also 
 * generated dless.h and dless.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "dless.h"


void dlessStaticLoad(char **row, struct dless *ret)
/* Load a row from dless table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->score = atof(row[4]);
strcpy(ret->type, row[5]);
ret->branch = row[6];
ret->pConsSub = atof(row[7]);
ret->pConsSup = atof(row[8]);
ret->pConsSubCond = atof(row[9]);
ret->pConsSupCond = atof(row[10]);
strcpy(ret->condApprox, row[11]);
ret->priorMeanSub = atof(row[12]);
ret->priorVarSub = atof(row[13]);
ret->priorMinSub = sqlUnsigned(row[14]);
ret->priorMaxSub = sqlUnsigned(row[15]);
ret->postMeanSub = atof(row[16]);
ret->postVarSub = atof(row[17]);
ret->priorMeanSup = atof(row[18]);
ret->priorVarSup = atof(row[19]);
ret->priorMinSup = sqlUnsigned(row[20]);
ret->priorMaxSup = sqlUnsigned(row[21]);
ret->postMeanSup = atof(row[22]);
ret->postVarSup = atof(row[23]);
}

struct dless *dlessLoad(char **row)
/* Load a dless from row fetched with select * from dless
 * from database.  Dispose of this with dlessFree(). */
{
struct dless *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->score = atof(row[4]);
strcpy(ret->type, row[5]);
ret->branch = cloneString(row[6]);
ret->pConsSub = atof(row[7]);
ret->pConsSup = atof(row[8]);
ret->pConsSubCond = atof(row[9]);
ret->pConsSupCond = atof(row[10]);
strcpy(ret->condApprox, row[11]);
ret->priorMeanSub = atof(row[12]);
ret->priorVarSub = atof(row[13]);
ret->priorMinSub = sqlUnsigned(row[14]);
ret->priorMaxSub = sqlUnsigned(row[15]);
ret->postMeanSub = atof(row[16]);
ret->postVarSub = atof(row[17]);
ret->priorMeanSup = atof(row[18]);
ret->priorVarSup = atof(row[19]);
ret->priorMinSup = sqlUnsigned(row[20]);
ret->priorMaxSup = sqlUnsigned(row[21]);
ret->postMeanSup = atof(row[22]);
ret->postVarSup = atof(row[23]);
return ret;
}

struct dless *dlessLoadAll(char *fileName) 
/* Load all dless from a whitespace-separated file.
 * Dispose of this with dlessFreeList(). */
{
struct dless *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[24];

while (lineFileRow(lf, row))
    {
    el = dlessLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct dless *dlessLoadAllByChar(char *fileName, char chopper) 
/* Load all dless from a chopper separated file.
 * Dispose of this with dlessFreeList(). */
{
struct dless *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[24];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = dlessLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct dless *dlessCommaIn(char **pS, struct dless *ret)
/* Create a dless out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new dless */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->score = sqlFloatComma(&s);
sqlFixedStringComma(&s, ret->type, sizeof(ret->type));
ret->branch = sqlStringComma(&s);
ret->pConsSub = sqlFloatComma(&s);
ret->pConsSup = sqlFloatComma(&s);
ret->pConsSubCond = sqlFloatComma(&s);
ret->pConsSupCond = sqlFloatComma(&s);
sqlFixedStringComma(&s, ret->condApprox, sizeof(ret->condApprox));
ret->priorMeanSub = sqlFloatComma(&s);
ret->priorVarSub = sqlFloatComma(&s);
ret->priorMinSub = sqlUnsignedComma(&s);
ret->priorMaxSub = sqlUnsignedComma(&s);
ret->postMeanSub = sqlFloatComma(&s);
ret->postVarSub = sqlFloatComma(&s);
ret->priorMeanSup = sqlFloatComma(&s);
ret->priorVarSup = sqlFloatComma(&s);
ret->priorMinSup = sqlUnsignedComma(&s);
ret->priorMaxSup = sqlUnsignedComma(&s);
ret->postMeanSup = sqlFloatComma(&s);
ret->postVarSup = sqlFloatComma(&s);
*pS = s;
return ret;
}

void dlessFree(struct dless **pEl)
/* Free a single dynamically allocated dless such as created
 * with dlessLoad(). */
{
struct dless *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->branch);
freez(pEl);
}

void dlessFreeList(struct dless **pList)
/* Free a list of dynamically allocated dless's */
{
struct dless *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    dlessFree(&el);
    }
*pList = NULL;
}

void dlessOutput(struct dless *el, FILE *f, char sep, char lastSep) 
/* Print out dless.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%g", el->score);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->type);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->branch);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%g", el->pConsSub);
fputc(sep,f);
fprintf(f, "%g", el->pConsSup);
fputc(sep,f);
fprintf(f, "%g", el->pConsSubCond);
fputc(sep,f);
fprintf(f, "%g", el->pConsSupCond);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->condApprox);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%g", el->priorMeanSub);
fputc(sep,f);
fprintf(f, "%g", el->priorVarSub);
fputc(sep,f);
fprintf(f, "%u", el->priorMinSub);
fputc(sep,f);
fprintf(f, "%u", el->priorMaxSub);
fputc(sep,f);
fprintf(f, "%g", el->postMeanSub);
fputc(sep,f);
fprintf(f, "%g", el->postVarSub);
fputc(sep,f);
fprintf(f, "%g", el->priorMeanSup);
fputc(sep,f);
fprintf(f, "%g", el->priorVarSup);
fputc(sep,f);
fprintf(f, "%u", el->priorMinSup);
fputc(sep,f);
fprintf(f, "%u", el->priorMaxSup);
fputc(sep,f);
fprintf(f, "%g", el->postMeanSup);
fputc(sep,f);
fprintf(f, "%g", el->postVarSup);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

