/* jobResult.h was originally generated by the autoSql program, which also 
 * generated jobResult.c and jobResult.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef JOBRESULT_H
#define JOBRESULT_H

struct jobResult
/* Info about the result of one job from parasol */
    {
    struct jobResult *next;  /* Next in singly linked list. */
    int status;	/* Job status - wait() return format. 0 is good. */
    char *host;	/* Machine job ran on. */
    char *jobId;	/* Job queuing system job ID */
    char *exe;	/* Job executable file (no path) */
    int usrTicks;	/* 'User' CPU time in ticks. */
    int sysTicks;	/* 'System' CPU time in ticks. */
    unsigned submitTime;	/* Job submission time in seconds since 1/1/1970 */
    unsigned startTime;	/* Job start time in seconds since 1/1/1970 */
    unsigned endTime;	/* Job end time in seconds since 1/1/1970 */
    char *user;	/* User who ran job */
    char *errFile;	/* Location of stderr file on host */
    };

void jobResultStaticLoad(char **row, struct jobResult *ret);
/* Load a row from jobResult table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct jobResult *jobResultLoad(char **row);
/* Load a jobResult from row fetched with select * from jobResult
 * from database.  Dispose of this with jobResultFree(). */

struct jobResult *jobResultLoadAll(char *fileName, off_t *resultBookMark, off_t resultsSize);
/* Load all jobResult from a tab-separated file, starting from bookMark, ending at resultsSize.
 * Dispose of this with jobResultFreeList(). */

struct jobResult *jobResultCommaIn(char **pS, struct jobResult *ret);
/* Create a jobResult out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new jobResult */

void jobResultFree(struct jobResult **pEl);
/* Free a single dynamically allocated jobResult such as created
 * with jobResultLoad(). */

void jobResultFreeList(struct jobResult **pList);
/* Free a list of dynamically allocated jobResult's */

void jobResultOutput(struct jobResult *el, FILE *f, char sep, char lastSep);
/* Print out jobResult.  Separate fields with sep. Follow last field with lastSep. */

#define jobResultTabOut(el,f) jobResultOutput(el,f,'\t','\n');
/* Print out jobResult as a line in a tab-separated file. */

#define jobResultCommaOut(el,f) jobResultOutput(el,f,',',',');
/* Print out jobResult as a comma separated list including final comma. */

#endif /* JOBRESULT_H */

