/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorators;

import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.graphics.Color;
import org.xmind.gef.draw2d.decoration.ICorneredDecoration;
import org.xmind.gef.draw2d.decoration.IDecoration;
import org.xmind.gef.graphicalpolicy.IStyleSelector;
import org.xmind.gef.part.Decorator;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.decorations.ICalloutTopicDecoration;
import org.xmind.ui.decorations.ITopicDecoration;
import org.xmind.ui.internal.figures.TopicFigure;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.ISheetPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.style.StyleUtils;
import org.xmind.ui.util.MindMapUtils;

public class TopicDecorator
extends Decorator {
    private static final TopicDecorator instance = new TopicDecorator();

    public void decorate(IGraphicalPart part, IFigure figure) {
        super.decorate(part, figure);
        if (figure instanceof TopicFigure) {
            IBranchPart branch = MindMapUtils.findBranch((IPart)part);
            if (branch != null) {
                part = branch;
            }
            this.decorateTopic(part, StyleUtils.getStyleSelector(part), (TopicFigure)figure);
        }
    }

    private void decorateTopic(IGraphicalPart part, IStyleSelector ss, TopicFigure figure) {
        String newShapeId;
        String branchType;
        ITopicDecoration shape = figure.getDecoration();
        String defaultShapeId = "org.xmind.topicShape.roundedRect";
        String shapeKey = "shape-class";
        if (part instanceof IBranchPart && "calloutBranch".equals(branchType = ((IBranchPart)part).getBranchType())) {
            defaultShapeId = "org.xmind.calloutTopicShape.balloon.ellipse";
            shapeKey = "callout-shape-class";
        }
        if (!StyleUtils.isSameDecoration((IDecoration)shape, newShapeId = StyleUtils.getString(part, ss, shapeKey, defaultShapeId))) {
            shape = StyleUtils.createTopicDecoration(part, newShapeId);
            figure.setDecoration(shape);
        }
        if (shape != null) {
            String decorationId = shape.getId();
            shape.setAlpha((IFigure)figure, 255);
            shape.setFillAlpha((IFigure)figure, 255);
            shape.setLineAlpha((IFigure)figure, 255);
            Color fillColor = StyleUtils.getColor(part, ss, "svg:fill", decorationId, "#d0d0d0");
            shape.setFillColor((IFigure)figure, fillColor);
            shape.setGradient((IFigure)figure, this.isGradientColor(part, figure, shape));
            int fontSize = 0;
            if (figure.getTitle() != null) {
                fontSize = StyleUtils.getInteger(part, ss, "fo:font-size", 0);
            }
            fontSize = fontSize < 56 ? fontSize : 56;
            shape.setLeftMargin((IFigure)figure, StyleUtils.getInteger(part, ss, "fo:margin-left", decorationId, 10) + (int)((double)fontSize * 0.5));
            shape.setRightMargin((IFigure)figure, StyleUtils.getInteger(part, ss, "fo:margin-right", decorationId, 10) + (int)((double)fontSize * 0.5));
            shape.setTopMargin((IFigure)figure, StyleUtils.getInteger(part, ss, "fo:margin-top", decorationId, 5) + (int)((double)fontSize * 0.1));
            shape.setBottomMargin((IFigure)figure, StyleUtils.getInteger(part, ss, "fo:margin-bottom", decorationId, 5) + (int)((double)fontSize * 0.1));
            String defaultColor = ColorUtils.toString((Color)StyleUtils.getColor(part, ss, "line-color", decorationId, "#808080"));
            Color borderLineColor = StyleUtils.getColor(part, ss, "border-line-color", decorationId, defaultColor);
            shape.setLineColor((IFigure)figure, borderLineColor);
            int defaultWidth = StyleUtils.getInteger(part, ss, "line-width", decorationId, 1);
            int borderLineWidth = StyleUtils.getInteger(part, ss, "border-line-width", decorationId, defaultWidth);
            shape.setLineWidth((IFigure)figure, borderLineWidth);
            int lineStyle = StyleUtils.getLineStyle(part, ss, decorationId, 1);
            shape.setLineStyle((IFigure)figure, lineStyle);
            shape.setVisible((IFigure)figure, true);
            int cornerSize = StyleUtils.getInteger(part, ss, "shape-corner", decorationId, 10);
            if (shape instanceof ICorneredDecoration) {
                ((ICorneredDecoration)shape).setCornerSize((IFigure)figure, cornerSize);
            }
            if (shape instanceof ICalloutTopicDecoration) {
                ICalloutTopicDecoration calloutDecoration = (ICalloutTopicDecoration)((Object)shape);
                String fromLineClass = MindMapUI.getDecorationManager().getDecorationDescriptor(decorationId).getDefaultValueProvider("callout-line-class").getValue(part, "callout-line-class");
                calloutDecoration.setFromLineClass((IFigure)figure, StyleUtils.getString(part, ss, "callout-line-class", fromLineClass));
                calloutDecoration.setFromLineColor((IFigure)figure, StyleUtils.getColor(part, ss, "callout-line-color", decorationId, ColorUtils.toString((Color)borderLineColor)));
                String defaultFromFillColor = fillColor == null ? "none" : ColorUtils.toString((Color)fillColor);
                calloutDecoration.setFromFillColor((IFigure)figure, StyleUtils.getColor(part, ss, "callout-fill-color", decorationId, defaultFromFillColor));
                calloutDecoration.setFromLineStyle((IFigure)figure, StyleUtils.getInteger(part, ss, "callout-line-pattern", decorationId, lineStyle));
                calloutDecoration.setFromLineWidth((IFigure)figure, StyleUtils.getInteger(part, ss, "callout-line-width", decorationId, borderLineWidth));
                calloutDecoration.setFromLineCorner((IFigure)figure, StyleUtils.getInteger(part, ss, "callout-line-corner", decorationId, cornerSize));
            }
        }
        double angle = StyleUtils.getDouble(part, ss, "rotate-angle", 0.0);
        figure.setRotationDegrees(angle);
    }

    private boolean isGradientColor(IGraphicalPart part, TopicFigure figure, ITopicDecoration shape) {
        boolean isGraidentColor = false;
        IPart parentPart = part.getParent();
        while (parentPart != null && !(parentPart instanceof ISheetPart)) {
            parentPart = parentPart.getParent();
        }
        if (parentPart != null && parentPart instanceof ISheetPart) {
            String gradient = StyleUtils.getStyleSelector((ISheetPart)parentPart).getStyleValue((IGraphicalPart)((ISheetPart)parentPart), "color-gradient");
            if ("none".equals(gradient)) {
                isGraidentColor = false;
            } else if ("gradient".equals(gradient)) {
                isGraidentColor = true;
            }
        }
        return isGraidentColor;
    }

    public static TopicDecorator getInstance() {
        return instance;
    }
}

