/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editpolicies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.xmind.core.IBoundary;
import org.xmind.core.IPositioned;
import org.xmind.core.IRange;
import org.xmind.core.IRelationship;
import org.xmind.core.ISheet;
import org.xmind.core.ISummary;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicRange;
import org.xmind.core.IWorkbook;
import org.xmind.core.marker.IMarkerRef;
import org.xmind.core.util.Point;
import org.xmind.gef.IViewer;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.ICommandStack;
import org.xmind.ui.commands.AddBoundaryCommand;
import org.xmind.ui.commands.AddRelationshipCommand;
import org.xmind.ui.commands.AddSummaryCommand;
import org.xmind.ui.commands.AddTopicCommand;
import org.xmind.ui.commands.ModifyPositionCommand;
import org.xmind.ui.commands.ModifyRangeCommand;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.internal.editpolicies.DeleteCommandBuilder;

public class SortTopicCommandBuilder
extends DeleteCommandBuilder {
    private String type;
    private Map<ITopicRange, Range> cacheRanges = null;
    private List<IRelationship> cacheRelations = null;
    private Map<ISummary, ITopic> cacheSummaryTopics = null;

    public SortTopicCommandBuilder(IViewer viewer, ICommandStack commandStack) {
        super(viewer, commandStack);
    }

    public void setSortType(String type) {
        this.type = type;
    }

    public void sort(ITopic parent) {
        ArrayList<ITopic> children = new ArrayList<ITopic>(parent.getChildren("attached"));
        if (children.isEmpty()) {
            return;
        }
        this.cacheRelationships(parent);
        this.cacheTopicRanges(parent);
        List<ITopic> topics = this.resort(children);
        if (!this.canResort(topics)) {
            MessageDialog.openWarning(null, (String)DialogMessages.SortMessageDialog_Title, (String)DialogMessages.SortMessageDialog_Messages);
            return;
        }
        for (ITopic topic : children) {
            this.deleteTopic(topic, true);
        }
        children.clear();
        int i = 0;
        while (i < topics.size()) {
            ITopic topic = topics.get(i);
            this.addTopic(topic, parent, i);
            this.modifyTopicPosition(topic);
            ++i;
        }
        topics.clear();
        this.addRelationships(parent);
        this.addTopicRanges(parent);
    }

    private void modifyTopicPosition(ITopic topic) {
        Point position = topic.getPosition();
        if (position == null) {
            return;
        }
        ModifyPositionCommand command = new ModifyPositionCommand((IPositioned)topic, null);
        this.add((Command)command, true);
    }

    private boolean canResort(List<ITopic> topics) {
        if (this.cacheRanges == null) {
            return true;
        }
        for (Map.Entry<ITopicRange, Range> entry : this.cacheRanges.entrySet()) {
            ITopicRange topicRange = entry.getKey();
            List enTopics = topicRange.getEnclosingTopics();
            if (enTopics.isEmpty() || enTopics.size() == 1) continue;
            ArrayList<Integer> newIndexList = null;
            for (ITopic topic : enTopics) {
                int index = topics.indexOf(topic);
                if (newIndexList == null) {
                    newIndexList = new ArrayList<Integer>();
                }
                newIndexList.add(index);
            }
            Collections.sort(newIndexList, new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    return o1 - o2;
                }
            });
            int flag = -1;
            Iterator index = newIndexList.iterator();
            while (index.hasNext()) {
                int index2 = (Integer)index.next();
                if (flag == -1) {
                    flag = index2;
                    continue;
                }
                if (Math.abs(flag - index2) > 1) {
                    return false;
                }
                flag = index2;
            }
            int startIndex = (Integer)newIndexList.get(0);
            int endIndex = (Integer)newIndexList.get(newIndexList.size() - 1);
            Range range = entry.getValue();
            range.startIndex = startIndex;
            range.endIndex = endIndex;
            newIndexList.clear();
        }
        return true;
    }

    private void cacheRelationships(ITopic topic) {
        ISheet sheet = topic.getOwnedSheet();
        Set relations = sheet.getRelationships();
        if (relations.isEmpty()) {
            return;
        }
        for (IRelationship next : relations) {
            if (!this.canAddInCache(topic, next)) continue;
            if (this.cacheRelations == null) {
                this.cacheRelations = new ArrayList<IRelationship>();
            }
            this.cacheRelations.add(next);
        }
    }

    private boolean canAddInCache(ITopic topic, IRelationship raltionship) {
        IWorkbook workbook = topic.getOwnedWorkbook();
        String end1Id = raltionship.getEnd1Id();
        String end2Id = raltionship.getEnd2Id();
        Object obj1 = workbook.getElementById(end1Id);
        Object obj2 = workbook.getElementById(end2Id);
        return this.isPosterity(topic, obj1) || this.isPosterity(topic, obj2);
    }

    private boolean isPosterity(ITopic parent, Object obj) {
        if (obj instanceof ITopicRange) {
            return this.isPosterityOfRange(parent, (ITopicRange)obj);
        }
        if (obj instanceof ITopic) {
            return this.isPosterityOfTopic(parent, (ITopic)obj);
        }
        return false;
    }

    private boolean isPosterityOfTopic(ITopic parent, ITopic topic) {
        if (topic.isRoot()) {
            return false;
        }
        ITopic parentTopic = topic.getParent();
        if (parentTopic.equals(parent)) {
            return true;
        }
        if (parentTopic.isRoot()) {
            return false;
        }
        return this.isPosterityOfTopic(parentTopic, topic);
    }

    private boolean isPosterityOfRange(ITopic parent, ITopicRange topicRange) {
        ITopic parentTopic = topicRange.getParent();
        if (parentTopic.equals(parent)) {
            return true;
        }
        if (parentTopic.isRoot()) {
            return false;
        }
        return this.isPosterityOfRange(parentTopic, topicRange);
    }

    private void addRelationships(ITopic parent) {
        if (this.cacheRelations == null || this.cacheRelations.isEmpty()) {
            return;
        }
        for (IRelationship relationship : this.cacheRelations) {
            AddRelationshipCommand command = new AddRelationshipCommand(relationship, parent.getOwnedSheet());
            this.add((Command)command, true);
        }
    }

    private void addTopicRanges(ITopic parent) {
        if (this.cacheRanges == null || this.cacheRanges.isEmpty()) {
            return;
        }
        for (Map.Entry<ITopicRange, Range> entry : this.cacheRanges.entrySet()) {
            ITopicRange topicRange = entry.getKey();
            Range range = entry.getValue();
            if (topicRange instanceof ISummary) {
                ISummary summary = (ISummary)topicRange;
                ITopic summaryTopic = this.cacheSummaryTopics.get(summary);
                AddTopicCommand addTopicCommand = new AddTopicCommand(summaryTopic, parent, -1, "summary");
                this.add((Command)addTopicCommand, false);
                AddSummaryCommand summaryCommand = new AddSummaryCommand(summary, parent);
                this.add((Command)summaryCommand, false);
            } else if (topicRange instanceof IBoundary) {
                IBoundary boundary = (IBoundary)topicRange;
                AddBoundaryCommand boundaryCommand = new AddBoundaryCommand(boundary, parent);
                this.add((Command)boundaryCommand, false);
            }
            ModifyRangeCommand modifyStart = new ModifyRangeCommand((IRange)topicRange, range.startIndex, true);
            this.add((Command)modifyStart, false);
            ModifyRangeCommand modifyend = new ModifyRangeCommand((IRange)topicRange, range.endIndex, false);
            this.add((Command)modifyend, false);
        }
    }

    private void cacheTopicRanges(ITopic parent) {
        Set summaries;
        Set boundaries;
        if (this.cacheRanges == null) {
            this.cacheRanges = new HashMap<ITopicRange, Range>();
        }
        if (this.cacheSummaryTopics == null) {
            this.cacheSummaryTopics = new HashMap<ISummary, ITopic>();
        }
        if (!(boundaries = parent.getBoundaries()).isEmpty()) {
            for (IBoundary next : boundaries) {
                if (next.isMasterBoundary()) continue;
                int startIndex = next.getStartIndex();
                int endIndex = next.getEndIndex();
                if (startIndex < 0 || endIndex < 0) continue;
                this.cacheRanges.put((ITopicRange)next, new Range(startIndex, endIndex));
            }
        }
        if (!(summaries = parent.getSummaries()).isEmpty()) {
            for (ISummary next : summaries) {
                int startIndex = next.getStartIndex();
                int endIndex = next.getEndIndex();
                if (startIndex < 0 || endIndex < 0) continue;
                ITopic summaryTopic = next.getTopic();
                this.cacheRanges.put((ITopicRange)next, new Range(startIndex, endIndex));
                this.cacheSummaryTopics.put(next, summaryTopic);
            }
        }
    }

    private void addTopic(ITopic topic, ITopic parent, int toIndex) {
        AddTopicCommand command = new AddTopicCommand(topic, parent, toIndex, "attached");
        this.add((Command)command, true);
    }

    private List<ITopic> resort(List<ITopic> oldTopics) {
        ArrayList<ITopic> newTopics = new ArrayList<ITopic>(oldTopics.size());
        for (ITopic topic : oldTopics) {
            newTopics.add(topic);
        }
        Collections.sort(newTopics, new Comparator<ITopic>(){

            @Override
            public int compare(ITopic o1, ITopic o2) {
                if ("org.xmind.ui.sort_title".equals(SortTopicCommandBuilder.this.type)) {
                    String text1 = o1.getTitleText();
                    String text2 = o2.getTitleText();
                    return text1.compareToIgnoreCase(text2);
                }
                if ("org.xmind.ui.sort_priority".equals(SortTopicCommandBuilder.this.type)) {
                    int p1 = SortTopicCommandBuilder.this.getPriority(o1);
                    int p2 = SortTopicCommandBuilder.this.getPriority(o2);
                    return p1 - p2;
                }
                if ("org.xmind.ui.sort_modified".equals(SortTopicCommandBuilder.this.type)) {
                    long time1 = o1.getModifiedTime();
                    long time2 = o2.getModifiedTime();
                    long ex = time1 - time2;
                    return (int)ex;
                }
                return 0;
            }
        });
        return newTopics;
    }

    private int getPriority(ITopic topic) {
        for (IMarkerRef next : topic.getMarkerRefs()) {
            String markerId = next.getMarkerId();
            if (!markerId.startsWith("priority")) continue;
            int index = markerId.indexOf(45);
            String number = markerId.substring(index + 1);
            return Integer.parseInt(number);
        }
        return Integer.MAX_VALUE;
    }

    private class Range {
        int startIndex;
        int endIndex;

        public Range(int startIndex, int endIndex) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj != this && !(obj instanceof Range)) {
                return false;
            }
            Range that = (Range)obj;
            return this.startIndex == that.startIndex && this.endIndex == that.endIndex;
        }
    }
}

