/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.outline.resource;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.xmind.core.ITopic;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerRef;
import org.xmind.ui.internal.outline.resource.AbstractIndexResource;
import org.xmind.ui.internal.outline.resource.IMarkerResource;
import org.xmind.ui.mindmap.IWorkbookRef;

public class MarkerResourceForWorkbook
extends AbstractIndexResource
implements IMarkerResource {
    private Set<String> markerIds = new HashSet<String>();
    private Map<String, Set<ITopic>> idToTopics = new HashMap<String, Set<ITopic>>();
    private Map<String, IMarker> idToMarker = new HashMap<String, IMarker>();
    private IWorkbookRef workbookRef;

    public MarkerResourceForWorkbook(IWorkbookRef workbookRef) {
        Assert.isNotNull((Object)workbookRef);
        this.workbookRef = workbookRef;
        this.init(false);
    }

    private void init(boolean update) {
        if (update) {
            this.markerIds.clear();
            this.idToTopics.clear();
            this.idToMarker.clear();
        }
        this.collectResourceForWorkbook(this.workbookRef);
    }

    @Override
    public Set<String> getMarkerIds() {
        return this.markerIds;
    }

    @Override
    public IMarker getMarker(String markerId) {
        return this.idToMarker.get(markerId);
    }

    @Override
    public Set<ITopic> getTopics(String markerId) {
        return this.idToTopics.get(markerId);
    }

    @Override
    public Object getSource() {
        return this.workbookRef;
    }

    @Override
    public void reset(Object source, boolean update) {
        Assert.isNotNull((Object)source);
        this.workbookRef = (IWorkbookRef)source;
        this.init(update);
    }

    @Override
    protected void collectResourceForTopic(ITopic topic) {
        for (IMarkerRef markerRef : topic.getMarkerRefs()) {
            Set<Object> topicsCollected;
            IMarker marker = markerRef.getMarker();
            String markerId = marker.getId();
            this.markerIds.add(markerId);
            Set<String> keySet = this.idToTopics.keySet();
            if (keySet.contains(markerId)) {
                topicsCollected = this.idToTopics.get(markerId);
                if (topicsCollected == null) {
                    topicsCollected = new HashSet();
                }
                topicsCollected.add(topic);
                this.idToTopics.put(markerId, topicsCollected);
                this.idToMarker.put(markerId, marker);
                continue;
            }
            topicsCollected = new HashSet<ITopic>();
            topicsCollected.add(topic);
            this.idToTopics.put(markerId, topicsCollected);
            this.idToMarker.put(markerId, marker);
        }
    }
}

