/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.popover;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.xmind.ui.internal.e4handlers.DirectToolItem;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.util.RegionUtils;

public class PopoverMenuToolItem
extends DirectToolItem {
    private Shell shell;
    private Control contents;
    private ShellAdapter shellDeactivedListener = new ShellAdapter(){

        public void shellDeactivated(ShellEvent e) {
            PopoverMenuToolItem.this.handleShellDeactived();
        }
    };
    private LocalResourceManager localResourceManager;

    protected void showExtensionControl(Rectangle itemBoundsToDisplay) {
        if (this.shell != null && !this.shell.isDisposed()) {
            if (this.shellDeactivedListener != null) {
                this.shell.removeShellListener((ShellListener)this.shellDeactivedListener);
            }
            this.shell.dispose();
        }
        this.shell = this.createShell();
        this.localResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.shell);
        this.configureShell(this.shell);
        this.contents = this.createContents((Composite)this.shell);
        this.initializeBounds(itemBoundsToDisplay);
        this.shell.setActive();
        this.shell.setVisible(true);
        this.shell.forceFocus();
    }

    protected Shell createShell() {
        return new Shell(Display.getCurrent().getActiveShell(), 8);
    }

    protected void configureShell(Shell newShell) {
        newShell.addShellListener((ShellListener)this.shellDeactivedListener);
        Layout layout = this.getLayout();
        if (layout != null) {
            newShell.setLayout(layout);
        }
        newShell.setBackground(this.localResourceManager.createColor(ColorUtils.toRGB((String)"#c2c2c2")));
    }

    protected Layout getLayout() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 1;
        layout.marginWidth = 1;
        return layout;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(this.localResourceManager.createColor(ColorUtils.toRGB((String)"#ffffff")));
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        return composite;
    }

    protected void initializeBounds(Rectangle itemBoundsToDisplay) {
        Point size = this.shell.computeSize(-1, -1);
        Region region = RegionUtils.getRoundedRectangle((Rectangle)new Rectangle(0, 0, size.x, size.y), (int)6);
        this.shell.setRegion(region);
        Region region2 = RegionUtils.getRoundedRectangle((Rectangle)new Rectangle(0, 0, size.x - 2, size.y - 2), (int)6);
        this.contents.setRegion(region2);
        Point location = this.getLocation(itemBoundsToDisplay, size);
        this.shell.setLocation(location);
    }

    private Point getLocation(Rectangle itemBoundsToDisplay, Point size) {
        return new Point(itemBoundsToDisplay.x + itemBoundsToDisplay.width / 2 - size.x / 2, itemBoundsToDisplay.y + itemBoundsToDisplay.height);
    }

    protected void handleShellDeactived() {
        Region region2;
        if (this.shell == null || this.shell.isDisposed()) {
            return;
        }
        this.shell.removeShellListener((ShellListener)this.shellDeactivedListener);
        Region region = this.shell.getRegion();
        if (region != null) {
            region.dispose();
            region = null;
        }
        if ((region2 = this.contents.getRegion()) != null) {
            region2.dispose();
            region2 = null;
        }
        this.shell.dispose();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (LocalResourceManager.class.equals(adapter)) {
            return adapter.cast(this.localResourceManager);
        }
        return (T)super.getAdapter(adapter);
    }
}

