/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.prefs;

import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.prefs.PrefMessages;
import org.xmind.ui.preference.PreferenceFieldEditorPageSection;

public class AuthorInfoPreferenceSection
extends PreferenceFieldEditorPageSection
implements IWorkbenchPreferencePage {
    private Text nameEditor = null;
    private Text emailEditor = null;
    private Text organizationEditor = null;
    private static final String EMPTY = "";

    protected IPreferenceStore doGetPreferenceStore() {
        return MindMapUIPlugin.getDefault().getPreferenceStore();
    }

    public void init(IWorkbench workbench) {
        String name = this.doGetPreferenceStore().getString("org.xmind.ui.mindmap.author.name");
        if (name == null || EMPTY.equals(name)) {
            this.doGetPreferenceStore().setValue("org.xmind.ui.mindmap.author.name", System.getProperty("user.name"));
        }
    }

    protected Control createContents(Composite parent) {
        Label descriptionLabel = new Label(parent, 64);
        descriptionLabel.setLayoutData((Object)new GridData(4, 128, true, false));
        GridData data = (GridData)descriptionLabel.getLayoutData();
        data.widthHint = 450;
        descriptionLabel.setText(PrefMessages.AuthorInfoPage_Message);
        GridLayout layout = (GridLayout)parent.getLayout();
        layout.marginLeft = 25;
        layout.verticalSpacing = 5;
        this.createNameItem(parent);
        this.createEmailItem(parent);
        this.createOrganizationItem(parent);
        return parent;
    }

    private Composite createNameItem(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createLabel(composite, PrefMessages.AuthorInfoPage_Name_label);
        this.nameEditor = this.createEditor(composite, this.doGetPreferenceStore().getString("org.xmind.ui.mindmap.author.name"), false);
        return composite;
    }

    private Composite createEmailItem(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createLabel(composite, PrefMessages.AuthorInfoPage_Email_label);
        this.emailEditor = this.createEditor(composite, this.doGetPreferenceStore().getString("org.xmind.ui.mindmap.author.email"), true);
        return composite;
    }

    private Composite createOrganizationItem(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createLabel(composite, PrefMessages.AuthorInfoPage_Organization_label);
        this.organizationEditor = this.createEditor(composite, this.doGetPreferenceStore().getString("org.xmind.ui.mindmap.author.org"), true);
        return composite;
    }

    private void createLabel(Composite parent, String text) {
        Composite composite = new Composite(parent, 0);
        GridData data = new GridData(131072, 4, false, false);
        data.widthHint = 100;
        composite.setLayoutData((Object)data);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        Label label = new Label(composite, 0);
        label.setText(text);
    }

    private Text createEditor(Composite parent, String content, boolean canBeEmpty) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        final Text editor = new Text(composite, 2052);
        GridData data = new GridData(131072, 4, false, false);
        data.widthHint = 240;
        editor.setLayoutData((Object)data);
        if (content != null && !EMPTY.equals(content)) {
            editor.setText(content);
        }
        if (!canBeEmpty) {
            editor.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    AuthorInfoPreferenceSection.this.validateLibraryName(editor);
                }

                public void focusGained(FocusEvent e) {
                    e.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (editor.isDisposed()) {
                                return;
                            }
                            editor.setSelection(0, editor.getCharCount());
                        }
                    });
                }
            });
            editor.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AuthorInfoPreferenceSection.this.validateLibraryName(editor);
                }
            });
        }
        return editor;
    }

    protected boolean validateLibraryName(Text editor) {
        if (EMPTY.equals(editor.getText())) {
            this.setErrorMessage(PrefMessages.PreferencePage_EmptyName_errorMessage);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public boolean performOk() {
        return this.saveLibraryName();
    }

    protected void performDefaults() {
        System.setProperty("org.xmind.author.name", System.getProperty("user.name"));
        System.setProperty("org.xmind.author.email", EMPTY);
        System.setProperty("org.xmind.author.org", EMPTY);
        if (this.nameEditor != null && !this.nameEditor.isDisposed()) {
            this.nameEditor.setText(System.getProperty("user.name"));
        }
        if (this.emailEditor != null && !this.emailEditor.isDisposed()) {
            this.emailEditor.setText(EMPTY);
        }
        if (this.organizationEditor != null && !this.organizationEditor.isDisposed()) {
            this.organizationEditor.setText(EMPTY);
        }
        this.doGetPreferenceStore().setValue("org.xmind.ui.mindmap.author.name", System.getProperty("user.name"));
        this.doGetPreferenceStore().setValue("org.xmind.ui.mindmap.author.email", EMPTY);
        this.doGetPreferenceStore().setValue("org.xmind.ui.mindmap.author.org", EMPTY);
        super.performDefaults();
    }

    private boolean saveLibraryName() {
        if (this.nameEditor == null || this.nameEditor.isDisposed()) {
            return true;
        }
        if (!this.validateLibraryName(this.nameEditor)) {
            return false;
        }
        System.setProperty("org.xmind.author.name", this.nameEditor.getText());
        System.setProperty("org.xmind.author.email", this.emailEditor.getText());
        System.setProperty("org.xmind.author.org", this.organizationEditor.getText());
        this.doGetPreferenceStore().setValue("org.xmind.ui.mindmap.author.name", this.nameEditor.getText());
        this.doGetPreferenceStore().setValue("org.xmind.ui.mindmap.author.email", this.emailEditor.getText());
        this.doGetPreferenceStore().setValue("org.xmind.ui.mindmap.author.org", this.organizationEditor.getText());
        return true;
    }

    protected void createFieldEditors() {
    }
}

