/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.resourcemanager;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.Section;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.gef.EditDomain;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gallery.FramePart;
import org.xmind.ui.gallery.GallerySelectTool;
import org.xmind.ui.gallery.GalleryViewer;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.resourcemanager.ResourceManagerViewer;
import org.xmind.ui.internal.utils.ResourceUtils;
import org.xmind.ui.mindmap.IResourceManager;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.texteditor.FloatingTextEditor;
import org.xmind.ui.texteditor.IFloatingTextEditorListener;
import org.xmind.ui.texteditor.TextEvent;
import org.xmind.ui.util.MarkerImageDescriptor;
import org.xmind.ui.viewers.IToolTipProvider;

public class MarkerResourceManagerViewer
extends ResourceManagerViewer {
    private static final int FRAME_HEIGHT = 32;
    private static final int FRAME_WIDTH = 32;
    private static final int RENAME_COMPOSITE_HEIGHT = 20;
    private static final int RENAME_COMPOSITE_WIDTH = 80;
    private FloatingTextEditor lastEditor;
    private Section activeSectionForSectionMenu;
    private IMarkerGroup activeMarkerGroupForSectionMenu;

    @Override
    public void createControl(Composite container) {
        super.createControl(container);
        this.setContentProvider((IContentProvider)new MarkerCategorizedContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new MarkerCategorizedLabelProvider());
        EditDomain domain = new EditDomain();
        domain.installTool("select tool", (ITool)new GallerySelectTool());
        this.setEditDomain(domain);
        this.initProperties();
        this.createControl(container, 64);
        this.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.setInput(this.getMarkerGroups());
    }

    @Override
    protected void initNestedGalleryViewer(GalleryViewer galleryViewerer) {
        super.initNestedGalleryViewer(galleryViewerer);
        Properties properties = galleryViewerer.getProperties();
        properties.set("org.xmind.ui.gallery.hideTitle", (Object)Boolean.TRUE);
    }

    @Override
    protected void initProperties() {
        super.initProperties();
        Properties properties = this.getProperties();
        properties.set("org.xmind.ui.gallery.frameContentSize", (Object)new Dimension(32, 32));
    }

    @Override
    protected void configureSection(final Section section, Object category) {
        super.configureSection(section, category);
        if (category instanceof IMarkerGroup) {
            final IMarkerGroup group = (IMarkerGroup)category;
            try {
                Field field = ExpandableComposite.class.getDeclaredField("textLabel");
                field.setAccessible(true);
                Object textLabel = field.get(section);
                if (textLabel instanceof Control) {
                    ((Control)textLabel).addMenuDetectListener(new MenuDetectListener(){

                        public void menuDetected(MenuDetectEvent e) {
                            MarkerResourceManagerViewer.this.activeMarkerGroupForSectionMenu = null;
                            MarkerResourceManagerViewer.this.activeSectionForSectionMenu = null;
                            IStructuredSelection ss = MarkerResourceManagerViewer.this.getStructuredSelection();
                            if (ss != null && ss.isEmpty()) {
                                MarkerResourceManagerViewer.this.activeSectionForSectionMenu = section;
                                MarkerResourceManagerViewer.this.activeMarkerGroupForSectionMenu = group;
                            }
                        }
                    });
                }
            }
            catch (NoSuchFieldException e1) {
                e1.printStackTrace();
            }
            catch (SecurityException e1) {
                e1.printStackTrace();
            }
            catch (IllegalArgumentException e1) {
                e1.printStackTrace();
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
            }
            this.getNestedViewer(category).getControl().addMenuDetectListener(new MenuDetectListener(){

                public void menuDetected(MenuDetectEvent e) {
                    MarkerResourceManagerViewer.this.activeMarkerGroupForSectionMenu = null;
                    MarkerResourceManagerViewer.this.activeSectionForSectionMenu = null;
                }
            });
            section.addMenuDetectListener(new MenuDetectListener(){

                public void menuDetected(MenuDetectEvent e) {
                    MarkerResourceManagerViewer.this.activeMarkerGroupForSectionMenu = null;
                    MarkerResourceManagerViewer.this.activeSectionForSectionMenu = null;
                    IStructuredSelection ss = MarkerResourceManagerViewer.this.getStructuredSelection();
                    if (ss != null && ss.isEmpty()) {
                        MarkerResourceManagerViewer.this.activeSectionForSectionMenu = section;
                        MarkerResourceManagerViewer.this.activeMarkerGroupForSectionMenu = group;
                    }
                }
            });
            IMarkerSheet userSheet = MindMapUI.getResourceManager().getUserMarkerSheet();
            if (!userSheet.getMarkerGroups().contains(group)) {
                return;
            }
            this.createSectionTextClient(section, MindMapMessages.MarkerResourceManagerViewer_AddSection_title, category);
        }
    }

    private List<IMarkerGroup> getMarkerGroups() {
        ArrayList<IMarkerGroup> mgs = new ArrayList<IMarkerGroup>();
        IResourceManager resourceManager = MindMapUI.getResourceManager();
        IMarkerSheet userSheet = resourceManager.getUserMarkerSheet();
        IMarkerSheet sysSheet = resourceManager.getSystemMarkerSheet();
        for (IMarkerGroup group : sysSheet.getMarkerGroups()) {
            if (group.isHidden()) continue;
            mgs.add(group);
        }
        for (IMarkerGroup group : userSheet.getMarkerGroups()) {
            if (group.isHidden()) continue;
            mgs.add(group);
        }
        return mgs;
    }

    public boolean canEditMarkerGroup() {
        if (this.activeMarkerGroupForSectionMenu == null || this.activeSectionForSectionMenu == null || this.activeSectionForSectionMenu.isDisposed()) {
            return false;
        }
        IMarkerSheet userSheet = MindMapUI.getResourceManager().getUserMarkerSheet();
        if (!userSheet.getMarkerGroups().contains(this.activeMarkerGroupForSectionMenu)) {
            return false;
        }
        IStructuredSelection ss = this.getStructuredSelection();
        return ss == null || ss.isEmpty();
    }

    public void renameMarkerGroup() {
        if (this.activeMarkerGroupForSectionMenu == null || this.activeSectionForSectionMenu == null || this.activeSectionForSectionMenu.isDisposed()) {
            this.activeMarkerGroupForSectionMenu = null;
            this.activeSectionForSectionMenu = null;
            return;
        }
        final IMarkerGroup markerGroup = this.activeMarkerGroupForSectionMenu;
        final Section section = this.activeSectionForSectionMenu;
        this.activeMarkerGroupForSectionMenu = null;
        this.activeSectionForSectionMenu = null;
        org.eclipse.swt.graphics.Rectangle textLabelBounds = null;
        final String groupName = markerGroup.getName();
        Control[] controlArray = section.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Label && groupName.equals(((Label)control).getText())) {
                textLabelBounds = control.getBounds();
            }
            ++n2;
        }
        if (this.lastEditor != null) {
            this.lastEditor.close();
            this.lastEditor = null;
        }
        final FloatingTextEditor editor = new FloatingTextEditor((Composite)section);
        if (textLabelBounds != null) {
            section.setText("");
            int x = textLabelBounds.x - 2;
            int y = textLabelBounds.y - 2;
            editor.setInitialLocation(new Point(x, y));
            editor.setInitialSize(new Point(100, 18));
        } else {
            editor.setInitialLocation(new Point(100, 0));
            editor.setInitialSize(new Point(100, 18));
        }
        editor.setInput((Object)new Document(groupName));
        editor.open();
        editor.doOperation(7);
        editor.addFloatingTextEditorListener((IFloatingTextEditorListener)new IFloatingTextEditorListener.Stub(){

            public void editingFinished(TextEvent e) {
                String text = e.text;
                if (text == null || "".equals(text) || text.equals(groupName)) {
                    section.setText(groupName);
                    editor.close();
                } else {
                    markerGroup.setName(text);
                }
                MindMapUI.getResourceManager().saveUserMarkerSheet();
            }

            public void editingCanceled(TextEvent e) {
                MarkerResourceManagerViewer.this.refresh();
            }
        });
        final Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (editor != null && !editor.isClosed() && !editor.getControl().getBounds().contains(event.x, event.y)) {
                    editor.close(true);
                }
            }
        };
        Display.getCurrent().addFilter(3, listener);
        editor.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (listener != null) {
                    Display.getCurrent().removeFilter(3, listener);
                }
            }
        });
        this.lastEditor = editor;
        ITextViewer textViewer = editor.getTextViewer();
        textViewer.getTextWidget().setBackground(this.getResourceManager().createColor(new RGB(255, 255, 255)));
        textViewer.getTextWidget().setForeground(this.getResourceManager().createColor(new RGB(0, 0, 0)));
    }

    @Override
    protected void handleClickSectionTextClient(Object category) {
        if (category instanceof IMarkerGroup) {
            List<IMarker> newMarkers = ResourceUtils.addMarkersFor((IMarkerGroup)category);
            Iterator<IMarker> iterator = newMarkers.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                MindMapUIPlugin.getDefault().getUsageDataCollector().increase("UserMarkerCount");
            }
            this.refresh();
            this.reveal(category);
            this.setSelection((ISelection)new StructuredSelection(newMarkers), true);
            MindMapUI.getResourceManager().saveUserMarkerSheet();
        }
    }

    public void startEditing(IMarker marker) {
        List<IMarkerGroup> markerGroups = this.getMarkerGroups();
        for (IMarkerGroup markerGroup : markerGroups) {
            List styles = markerGroup.getMarkers();
            if (!styles.contains(marker)) continue;
            GalleryViewer galleryViewer = this.getNestedViewer(markerGroup);
            FramePart part = (FramePart)galleryViewer.findGraphicalPart((Object)marker);
            this.renameMarker((Composite)galleryViewer.getControl(), marker, part.getFigure().getBounds());
            break;
        }
    }

    private void renameMarker(Composite composite, final IMarker marker, Rectangle bounds) {
        int x = bounds.x + (bounds.width - 80) / 2;
        int y = bounds.y + (bounds.height - 20) / 2;
        FloatingTextEditor editor = new FloatingTextEditor(composite);
        editor.setInitialLocation(new Point(x, y));
        editor.setInitialSize(new Point(80, 20));
        editor.setInput((Object)new Document(marker.getName()));
        editor.open();
        editor.doOperation(7);
        editor.addFloatingTextEditorListener((IFloatingTextEditorListener)new IFloatingTextEditorListener.Stub(){

            public void editingFinished(TextEvent e) {
                String text = e.text;
                if (text != null && !"".equals(text)) {
                    marker.setName(text);
                }
            }
        });
    }

    public void updateInput() {
        this.setInput(this.getMarkerGroups());
    }

    public void deleteMarkerGroup() {
        IMarkerSheet markerSheet = MindMapUI.getResourceManager().getUserMarkerSheet();
        markerSheet.removeMarkerGroup(this.activeMarkerGroupForSectionMenu);
        try {
            MindMapUI.getResourceManager().saveUserMarkerSheet();
        }
        catch (Exception exception) {}
        this.updateInput();
    }

    public void activateGroup(IMarkerGroup markerGroup) {
        this.activeMarkerGroupForSectionMenu = markerGroup;
        this.activeSectionForSectionMenu = (Section)this.getSection(markerGroup);
    }

    private static class MarkerCategorizedContentProvider
    implements ITreeContentProvider {
        private MarkerCategorizedContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof List) {
                return ((List)parentElement).toArray();
            }
            if (parentElement instanceof IMarkerGroup) {
                ArrayList<IMarker> markers = new ArrayList<IMarker>();
                for (IMarker marker : ((IMarkerGroup)parentElement).getMarkers()) {
                    if (marker.isHidden()) continue;
                    markers.add(marker);
                }
                return markers.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof IMarker) {
                IMarker marker = (IMarker)element;
                return marker.getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof IMarkerGroup || element instanceof List;
        }
    }

    private class MarkerCategorizedLabelProvider
    extends ResourceManagerViewer.CategorizedLabelProvider
    implements IToolTipProvider {
        private MarkerCategorizedLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IMarker) {
                return ((IMarker)element).getName();
            }
            if (element instanceof IMarkerGroup) {
                return ((IMarkerGroup)element).getName();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof IMarker) {
                IMarker marker = (IMarker)element;
                Image image = null;
                Dimension size = (Dimension)MarkerResourceManagerViewer.this.getProperties().get("org.xmind.ui.gallery.frameContentSize");
                if (size == null) {
                    size = new Dimension(64, 64);
                }
                ImageDescriptor imageDescriptor = MarkerImageDescriptor.createFromMarker(marker, size.width, size.height, false);
                image = MarkerResourceManagerViewer.this.getResourceManager().createImage(imageDescriptor);
                if (image != null) {
                    return image;
                }
            }
            return super.getImage(element);
        }

        public String getToolTip(Object element) {
            if (element instanceof IMarker) {
                return this.getText((IMarker)element);
            }
            return "";
        }
    }
}

