/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.views;

import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.xmind.core.IFileEntry;
import org.xmind.core.IManifest;
import org.xmind.core.IMeta;
import org.xmind.core.IPlainNotesContent;
import org.xmind.core.IRevisionManager;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.internal.dom.NumberUtils;
import org.xmind.ui.internal.utils.CommandUtils;
import org.xmind.ui.internal.views.InspectorSection;
import org.xmind.ui.internal.views.Messages;
import org.xmind.ui.util.MindMapUtils;

public class FileInfoInspectorSection
extends InspectorSection
implements ICoreEventListener {
    private ICoreEventRegister register;
    private ICoreEventRegister revisionRegister;
    private ICoreEventRegister modifyTimeRegister;
    private List<ITopic> allTopics;
    private Label estimateSizeLabel;
    private Label topicsCountLabel;
    private Label wordsCountLabel;
    private Hyperlink revisions;
    private Label modifyTimeLabel;
    private Label modifyByLabel;
    private Label createdTimeLabel;

    public FileInfoInspectorSection() {
        this.setTitle(Messages.FileInfoInspectorSection_title);
    }

    @Override
    protected Composite createContent(Composite parent) {
        Composite composite = super.createContent(parent);
        this.createEstimateSizeItem(composite);
        this.createWordsItem(composite);
        this.createTopicsItem(composite);
        this.createRevisionsItem(composite);
        this.createModifiedTimeItem(composite);
        this.createModifiedByItem(composite);
        this.createCreatedTimeItem(composite);
        return composite;
    }

    private Composite createEstimateSizeItem(Composite parent) {
        Composite item = this.createItemComposite(parent);
        Label label = new Label(item, 0);
        label.setText(Messages.FileInfoEstimateSize_label);
        if (this.estimateSizeLabel == null) {
            this.estimateSizeLabel = new Label(item, 0);
        }
        this.estimateSizeLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        this.estimateSizeLabel.setText(this.getSize());
        return item;
    }

    private Composite createWordsItem(Composite parent) {
        Composite item = this.createItemComposite(parent);
        Label label = new Label(item, 0);
        label.setText(Messages.FileInfoWords_label);
        if (this.wordsCountLabel == null) {
            this.wordsCountLabel = new Label(item, 0);
        }
        this.wordsCountLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        this.wordsCountLabel.setText(this.getWordsCount());
        return item;
    }

    private Composite createTopicsItem(Composite parent) {
        Composite item = this.createItemComposite(parent);
        Label label = new Label(item, 0);
        label.setText(Messages.FileInfoTopics_label);
        if (this.topicsCountLabel == null) {
            this.topicsCountLabel = new Label(item, 0);
        }
        this.topicsCountLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        this.topicsCountLabel.setText(this.getTopicsCount());
        return item;
    }

    private Composite createRevisionsItem(Composite parent) {
        Composite item = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        item.setLayout((Layout)layout);
        item.setLayoutData((Object)new GridData(4, 4, true, false));
        Label label = new Label(item, 0);
        label.setText(Messages.FileInfoRevisions_label);
        if (this.revisions == null) {
            this.revisions = new Hyperlink(item, 0);
        }
        this.revisions.setForeground(Display.getCurrent().getSystemColor(9));
        this.revisions.setUnderlined(true);
        this.revisions.setLayoutData((Object)new GridData(4, 4, true, false));
        this.revisions.setText(this.getRevisions());
        this.addRevisionsListener();
        return item;
    }

    private void addRevisionsListener() {
        this.revisions.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IWorkbenchPage page;
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null && (page = window.getActivePage()) != null) {
                    CommandUtils.executeCommand("org.xmind.ui.command.editingHistory", window);
                }
            }
        });
    }

    private Composite createModifiedTimeItem(Composite parent) {
        Composite item = this.createItemComposite(parent);
        Label label = new Label(item, 0);
        label.setText(Messages.FileInfoModifiedTime_label);
        if (this.modifyTimeLabel == null) {
            this.modifyTimeLabel = new Label(item, 0);
        }
        this.modifyTimeLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        this.modifyTimeLabel.setText(this.getModifiedTime());
        return item;
    }

    private Composite createModifiedByItem(Composite parent) {
        Composite item = this.createItemComposite(parent);
        Label label = new Label(item, 0);
        label.setText(Messages.FileInfoModifiedBy_label);
        if (this.modifyByLabel == null) {
            this.modifyByLabel = new Label(item, 0);
        }
        this.modifyByLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        this.modifyByLabel.setText(this.getModifiedBy());
        return item;
    }

    private Composite createCreatedTimeItem(Composite parent) {
        Composite item = this.createItemComposite(parent);
        Label label = new Label(item, 0);
        label.setText(Messages.FileInfoCreatedTime_label);
        if (this.createdTimeLabel == null) {
            this.createdTimeLabel = new Label(item, 0);
        }
        this.createdTimeLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createdTimeLabel.setText(this.getCreatedTime());
        return item;
    }

    private Composite createItemComposite(Composite parent) {
        Composite item = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        item.setLayout((Layout)layout);
        item.setLayoutData((Object)new GridData(4, 4, true, false));
        return item;
    }

    private String getSize() {
        double size_K;
        IWorkbook workbook = this.getCurrentWorkbook();
        if (workbook == null) {
            return "-1";
        }
        IManifest manifest = workbook.getManifest();
        if (manifest == null) {
            return "-1";
        }
        List list = manifest.getFileEntries();
        double size = 0.0;
        for (IFileEntry entry : list) {
            size += (double)entry.getSize();
        }
        if (!this.hasThumbnail(list)) {
            size += 2252.8;
        }
        if ((size_K = (double)Math.round((size += (double)manifest.getFileEntry("META-INF/manifest.xml").getSize()) / 1024.0 * 100.0) / 100.0) < 100.0) {
            return String.valueOf(size_K) + "K";
        }
        return String.valueOf((double)Math.round(size / 1024.0 / 1024.0 * 100.0) / 100.0) + "M";
    }

    private boolean hasThumbnail(List<IFileEntry> list) {
        for (IFileEntry entry : list) {
            if (!"Thumbnails/thumbnail.png".equals(entry.getPath())) continue;
            return true;
        }
        return false;
    }

    private String getWordsCount() {
        List<ITopic> allTopics = this.getAllTopics();
        if (allTopics == null) {
            return "-1";
        }
        String allWords = this.getAllWords(allTopics);
        return String.valueOf(this.countWords(allWords));
    }

    private String getAllWords(List<ITopic> allTopics) {
        StringBuilder sb = new StringBuilder();
        for (ITopic topic : allTopics) {
            IPlainNotesContent planContent;
            if (topic.getTitleText() != null) {
                sb.append(" ").append(topic.getTitleText());
            }
            if (topic.getLabels() != null && !topic.getLabels().isEmpty()) {
                sb.append(" ").append(MindMapUtils.getLabelText(topic.getLabels()));
            }
            if (topic.getNotes() == null || topic.getNotes().isEmpty() || (planContent = (IPlainNotesContent)topic.getNotes().getContent("plain")) == null) continue;
            sb.append(" ").append(planContent.getTextContent());
        }
        return sb.toString().replaceAll("/n", " ");
    }

    private int countWords(String allWords) {
        char[] cs = allWords.toCharArray();
        int wordsCount = 0;
        boolean wordflag = false;
        int i = 0;
        while (i < cs.length) {
            if (!this.isChinese(cs[i]) && cs[i] != ' ') {
                if (!wordflag) {
                    ++wordsCount;
                    wordflag = true;
                }
            } else {
                wordflag = false;
                if (this.isChinese(cs[i])) {
                    ++wordsCount;
                }
            }
            ++i;
        }
        return wordsCount;
    }

    private boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }

    private String getTopicsCount() {
        List<ITopic> allTopics = this.getAllTopics();
        if (allTopics == null) {
            return "-1";
        }
        this.setLabelRef(allTopics);
        return String.valueOf(this.allTopics.size());
    }

    private String getRevisions() {
        ISheet sheet = this.getCurrentSheet();
        if (sheet == null) {
            return "-1";
        }
        IRevisionManager revisionManager = sheet.getOwnedWorkbook().getRevisionRepository().getRevisionManager(sheet.getId(), "application/vnd.xmind.sheet");
        if (this.revisionRegister != null) {
            this.revisionRegister.unregisterAll();
            this.revisionRegister = null;
        }
        this.revisionRegister = new CoreEventRegister((ICoreEventListener)this);
        this.revisionRegister.setNextSourceFrom((Object)revisionManager);
        this.revisionRegister.register("revisionAdd");
        this.revisionRegister.register("revisionRemove");
        if (revisionManager.getRevisions() == null || revisionManager.getRevisions().isEmpty()) {
            return "0";
        }
        return String.valueOf(revisionManager.getRevisions().size());
    }

    private String getModifiedTime() {
        IWorkbook workbook = this.getCurrentWorkbook();
        if (workbook == null) {
            return "-1";
        }
        if (this.modifyTimeRegister != null) {
            this.modifyTimeRegister.unregisterAll();
            this.modifyTimeRegister = null;
        }
        this.modifyTimeRegister = new CoreEventRegister((ICoreEventSource)workbook, (ICoreEventListener)this);
        this.modifyTimeRegister.register("modifyTime");
        this.modifyTimeRegister.register("workbookSave");
        return NumberUtils.formatDate((long)workbook.getModifiedTime());
    }

    private String getModifiedBy() {
        IWorkbook workbook = this.getCurrentWorkbook();
        if (workbook == null) {
            return System.getProperty("user.name");
        }
        String name = workbook.getModifiedBy();
        if (name == null || "".equals(name)) {
            name = System.getProperty("user.name");
        }
        return name;
    }

    private String getCreatedTime() {
        IWorkbook workbook = this.getCurrentWorkbook();
        if (workbook == null) {
            return "-1";
        }
        IMeta meta = workbook.getMeta();
        if (meta == null) {
            return "-1";
        }
        String time = meta.getValue("Create/Time");
        if (time == null) {
            return "-1";
        }
        return time;
    }

    public void handleCoreEvent(final CoreEvent event) {
        Control c = this.getControl();
        if (c == null || c.isDisposed()) {
            return;
        }
        c.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                FileInfoInspectorSection.this.refreshFileInfo(event);
                FileInfoInspectorSection.this.reflow();
            }
        });
    }

    protected void refreshFileInfo(CoreEvent event) {
        String type = event.getType();
        if ("revisionAdd".equals(type) || "revisionRemove".equals(type)) {
            this.refreshRevisions();
        } else if ("modifyTime".equals(type)) {
            this.refreshModifyTime();
            this.refreshModifyBy();
            this.refreshEstimateSize();
        } else if ("workbookSave".equals(type)) {
            this.refreshEstimateSize();
        } else if ("topicAdd".equals(type) || "topicRemove".equals(type)) {
            this.refreshTopicsCount();
            this.refreshWordsCount();
        } else if ("titleText".equals(type) || "topicNotes".equals(type) || "labels".equals(type)) {
            this.refreshWordsCount();
        }
    }

    @Override
    protected void refreshFileInfo() {
        this.refreshEstimateSize();
        this.refreshTopicsCount();
        this.refreshWordsCount();
        this.refreshRevisions();
        this.refreshModifyTime();
        this.refreshModifyBy();
        this.refreshCreatedTime();
        this.reflow();
    }

    private void refreshCreatedTime() {
        if (this.createdTimeLabel != null && !this.createdTimeLabel.isDisposed()) {
            this.createdTimeLabel.setText(this.getCreatedTime());
        }
    }

    private void refreshModifyTime() {
        if (this.modifyTimeLabel != null && !this.modifyTimeLabel.isDisposed()) {
            this.modifyTimeLabel.setText(this.getModifiedTime());
        }
    }

    private void refreshModifyBy() {
        if (this.modifyByLabel != null && !this.modifyByLabel.isDisposed()) {
            this.modifyByLabel.setText(this.getModifiedBy());
        }
    }

    private void refreshRevisions() {
        if (this.revisions != null && !this.revisions.isDisposed()) {
            this.revisions.setText(this.getRevisions());
        }
    }

    private void refreshWordsCount() {
        if (this.wordsCountLabel != null && !this.wordsCountLabel.isDisposed()) {
            this.wordsCountLabel.setText(this.getWordsCount());
        }
    }

    private void refreshTopicsCount() {
        if (this.topicsCountLabel != null && !this.topicsCountLabel.isDisposed()) {
            this.topicsCountLabel.setText(this.getTopicsCount());
        }
    }

    private void refreshEstimateSize() {
        if (this.estimateSizeLabel != null && !this.estimateSizeLabel.isDisposed()) {
            this.estimateSizeLabel.setText(this.getSize());
        }
    }

    private void setLabelRef(List<ITopic> allTopics) {
        if (this.allTopics == allTopics) {
            return;
        }
        if (this.register != null) {
            this.register.unregisterAll();
            this.register = null;
        }
        this.allTopics = allTopics;
        if (allTopics != null) {
            this.register = new CoreEventRegister((ICoreEventListener)this);
            for (ITopic topic : allTopics) {
                this.register.setNextSourceFrom((Object)topic);
                this.register.register("titleText");
                this.register.register("topicNotes");
                this.register.register("labels");
                this.register.register("topicAdd");
                this.register.register("topicRemove");
            }
        }
    }

    @Override
    protected void handleDispose() {
        if (this.register != null) {
            this.register.unregisterAll();
            this.register = null;
        }
        if (this.modifyTimeRegister != null) {
            this.modifyTimeRegister.unregisterAll();
            this.modifyTimeRegister = null;
        }
        if (this.revisionRegister != null) {
            this.revisionRegister.unregisterAll();
            this.revisionRegister = null;
        }
    }
}

