/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.clients;

import com.evernote.auth.EvernoteAuth;
import com.evernote.clients.BusinessNoteStoreClient;
import com.evernote.clients.LinkedNoteStoreClient;
import com.evernote.clients.NoteStoreClient;
import com.evernote.clients.UserStoreClient;
import com.evernote.edam.error.EDAMNotFoundException;
import com.evernote.edam.error.EDAMSystemException;
import com.evernote.edam.error.EDAMUserException;
import com.evernote.edam.type.LinkedNotebook;
import com.evernote.edam.userstore.AuthenticationResult;
import com.evernote.thrift.TException;
import com.evernote.thrift.protocol.TBinaryProtocol;
import com.evernote.thrift.protocol.TProtocol;
import com.evernote.thrift.transport.THttpClient;
import com.evernote.thrift.transport.TTransportException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientFactory {
    private static final String USER_AGENT_KEY = "User-Agent";
    private static final Pattern CONSUMER_KEY_REGEX = Pattern.compile(":A=([^:]+):");
    private EvernoteAuth evernoteAuth;
    private String userAgent;
    private Map<String, String> customHeaders;

    public ClientFactory(EvernoteAuth auth) {
        if (auth == null) {
            throw new IllegalArgumentException("token must not be null");
        }
        this.evernoteAuth = auth;
    }

    public UserStoreClient createUserStoreClient() throws TTransportException {
        String serviceUrl = this.evernoteAuth.getUserStoreUrl();
        return this.createStoreClient(UserStoreClient.class, serviceUrl, this.evernoteAuth.getToken());
    }

    public NoteStoreClient createNoteStoreClient() throws EDAMUserException, EDAMSystemException, TException {
        String noteStoreUrl = this.evernoteAuth.getNoteStoreUrl();
        if (noteStoreUrl == null) {
            noteStoreUrl = this.createUserStoreClient().getNoteStoreUrl();
            this.evernoteAuth.setNoteStoreUrl(noteStoreUrl);
        }
        return this.createStoreClient(NoteStoreClient.class, noteStoreUrl, this.evernoteAuth.getToken());
    }

    public LinkedNoteStoreClient createLinkedNoteStoreClient(LinkedNotebook linkedNotebook) throws EDAMUserException, EDAMSystemException, TException, EDAMNotFoundException {
        NoteStoreClient mainNoteStoreClient = this.createNoteStoreClient();
        AuthenticationResult sharedAuth = mainNoteStoreClient.authenticateToSharedNotebook(linkedNotebook.getShareKey());
        NoteStoreClient linkedNoteStoreClient = this.createStoreClient(NoteStoreClient.class, linkedNotebook.getNoteStoreUrl(), sharedAuth.getAuthenticationToken());
        return new LinkedNoteStoreClient(mainNoteStoreClient, linkedNoteStoreClient, sharedAuth);
    }

    public BusinessNoteStoreClient createBusinessNoteStoreClient() throws TException, EDAMUserException, EDAMSystemException {
        NoteStoreClient mainNoteStoreClient = this.createNoteStoreClient();
        AuthenticationResult businessAuthResult = this.createUserStoreClient().authenticateToBusiness();
        NoteStoreClient linkedNoteStoreClient = this.createStoreClient(NoteStoreClient.class, businessAuthResult.getNoteStoreUrl(), businessAuthResult.getAuthenticationToken());
        return new BusinessNoteStoreClient(mainNoteStoreClient, linkedNoteStoreClient, businessAuthResult);
    }

    <T> T createStoreClient(Class<T> clientClass, String url, String token) throws TTransportException {
        THttpClient transport = new THttpClient(url);
        transport.setCustomHeader(USER_AGENT_KEY, this.generateUserAgent());
        if (this.customHeaders != null) {
            for (Map.Entry<String, String> header : this.customHeaders.entrySet()) {
                transport.setCustomHeader(header.getKey(), header.getValue());
            }
        }
        TBinaryProtocol protocol = new TBinaryProtocol(transport);
        try {
            return clientClass.getDeclaredConstructor(TProtocol.class, TProtocol.class, String.class).newInstance(protocol, protocol, token);
        }
        catch (Throwable e) {
            throw new RuntimeException("Couldn't create " + clientClass.getName() + " due to the error.", e);
        }
    }

    String generateUserAgent() {
        String sdkVersion;
        String id = this.userAgent;
        if (id == null) {
            Matcher matcher = CONSUMER_KEY_REGEX.matcher(this.evernoteAuth.getToken());
            id = matcher.find() && matcher.groupCount() >= 1 && matcher.group(1) != null ? matcher.group(1) : "";
        }
        if ((sdkVersion = this.getClass().getPackage().getImplementationVersion()) == null) {
            sdkVersion = "1.25";
        }
        String javaVersion = System.getProperty("java.version");
        return String.valueOf(id) + " / " + sdkVersion + "; Java / " + javaVersion;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders = customHeaders;
    }
}

