/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.acc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.xmind.gef.acc.AccessibleBase;
import org.xmind.gef.acc.IAccessible;

public class AccessibleRegistry {
    private List<Integer> ids = new ArrayList<Integer>();
    private List<Integer> removedIds = new ArrayList<Integer>();
    private List<IAccessible> accessibles = new ArrayList<IAccessible>();
    private int lastId = 0;

    public void register(IAccessible acc) {
        Integer id;
        if (acc == null) {
            return;
        }
        if (acc instanceof AccessibleBase) {
            this.lastId = this.createId(this.lastId);
            id = this.lastId++;
            ((AccessibleBase)acc).setAccessibleId(id);
        } else {
            id = acc.getAccessibleId();
        }
        this.ids.add(id);
        this.accessibles.add(acc);
    }

    private Integer createId(Integer newId) {
        if (!this.ids.contains(newId)) {
            return newId;
        }
        return this.createId(newId + 1);
    }

    public void unregister(IAccessible acc) {
        if (acc == null) {
            return;
        }
        Integer id = acc.getAccessibleId();
        int index = this.ids.indexOf(id);
        if (index >= 0) {
            if (index < this.ids.size() - 1) {
                this.removedIds.add(id);
            }
            this.ids.remove(index);
            this.accessibles.remove(index);
        }
    }

    public IAccessible getAccessible(int id) {
        int index = this.ids.indexOf(id);
        if (index >= 0) {
            return this.accessibles.get(index);
        }
        return null;
    }

    public Object[] getAllAccessibleIDs() {
        Object[] array = this.ids.toArray();
        Arrays.sort(array);
        return array;
    }

    public int getNumAccessibles() {
        return this.ids.size();
    }
}

