/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.rainbow;

import org.bouncycastle.crypto.CipherParameters;

public class RainbowParameters
implements CipherParameters {
    private final int[] DEFAULT_VI = new int[]{6, 12, 17, 22, 33};
    private int[] vi;

    public RainbowParameters() {
        this.vi = this.DEFAULT_VI;
    }

    public RainbowParameters(int[] vi) {
        this.vi = vi;
        try {
            this.checkParams();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkParams() throws Exception {
        if (this.vi == null) {
            throw new Exception("no layers defined.");
        }
        if (this.vi.length > 1) {
            int i = 0;
            while (i < this.vi.length - 1) {
                if (this.vi[i] >= this.vi[i + 1]) {
                    throw new Exception("v[i] has to be smaller than v[i+1]");
                }
                ++i;
            }
        } else {
            throw new Exception("Rainbow needs at least 1 layer, such that v1 < v2.");
        }
    }

    public int getNumOfLayers() {
        return this.vi.length - 1;
    }

    public int getDocLength() {
        return this.vi[this.vi.length - 1] - this.vi[0];
    }

    public int[] getVi() {
        return this.vi;
    }
}

