/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.gallery;

import java.io.File;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.Section;
import org.xmind.core.internal.gallery.GalleryCore;
import org.xmind.core.internal.gallery.IGalleryGroup;
import org.xmind.core.internal.gallery.IGalleryItem;
import org.xmind.core.internal.gallery.LocalGalleryGroup;
import org.xmind.gef.EditDomain;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gallery.GallerySelectTool;
import org.xmind.ui.gallery.GalleryViewer;
import org.xmind.ui.internal.dialogs.DialogUtils;
import org.xmind.ui.internal.resourcemanager.ResourceManagerViewer;
import org.xmind.ui.texteditor.FloatingTextEditor;
import org.xmind.ui.texteditor.IFloatingTextEditorListener;
import org.xmind.ui.texteditor.TextEvent;
import org.xmind.ui.viewers.IToolTipProvider;

public class ClipArtResourceManagerViewer
extends ResourceManagerViewer {
    private static final int FRAME_HEIGHT = 48;
    private static final int FRAME_WIDTH = 48;
    private Section activeSectionForSectionMenu;
    private IGalleryGroup activeGalleryGroupForSectionMenu;

    public void createControl(Composite container) {
        super.createControl(container);
        this.setContentProvider((IContentProvider)new ClipArtCategorizedContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new ClipArtCategorizedLabelProvider());
        EditDomain domain = new EditDomain();
        domain.installTool("select tool", (ITool)new GallerySelectTool());
        this.setEditDomain(domain);
        this.initProperties();
        this.createControl(container, 64);
        this.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.getControl().setFont(container.getFont());
        this.setInput(ClipArtGalleryCore.getInstance());
    }

    protected void initNestedGalleryViewer(GalleryViewer galleryViewerer) {
        super.initNestedGalleryViewer(galleryViewerer);
        Properties properties = galleryViewerer.getProperties();
        properties.set("org.xmind.ui.gallery.hideTitle", (Object)Boolean.TRUE);
    }

    protected void initProperties() {
        super.initProperties();
        Properties properties = this.getProperties();
        properties.set("org.xmind.ui.gallery.frameContentSize", (Object)new Dimension(48, 48));
    }

    protected void configureSection(final Section section, Object category) {
        super.configureSection(section, category);
        if (category instanceof IGalleryGroup) {
            final IGalleryGroup group = (IGalleryGroup)category;
            this.getNestedViewer(category).getControl().addMenuDetectListener(new MenuDetectListener(){

                public void menuDetected(MenuDetectEvent e) {
                    ClipArtResourceManagerViewer.this.activeGalleryGroupForSectionMenu = null;
                    ClipArtResourceManagerViewer.this.activeSectionForSectionMenu = null;
                }
            });
            try {
                Field field = ExpandableComposite.class.getDeclaredField("textLabel");
                field.setAccessible(true);
                Object textLabel = field.get(section);
                if (textLabel instanceof Control) {
                    ((Control)textLabel).addMenuDetectListener(new MenuDetectListener(){

                        public void menuDetected(MenuDetectEvent e) {
                            ClipArtResourceManagerViewer.this.activeGalleryGroupForSectionMenu = null;
                            ClipArtResourceManagerViewer.this.activeSectionForSectionMenu = null;
                            IStructuredSelection ss = ClipArtResourceManagerViewer.this.getStructuredSelection();
                            if (ss != null && ss.isEmpty()) {
                                ClipArtResourceManagerViewer.this.activeSectionForSectionMenu = section;
                                ClipArtResourceManagerViewer.this.activeGalleryGroupForSectionMenu = group;
                            }
                        }
                    });
                }
            }
            catch (NoSuchFieldException e1) {
                e1.printStackTrace();
            }
            catch (SecurityException e1) {
                e1.printStackTrace();
            }
            catch (IllegalArgumentException e1) {
                e1.printStackTrace();
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
            }
            section.addMenuDetectListener(new MenuDetectListener(){

                public void menuDetected(MenuDetectEvent e) {
                    ClipArtResourceManagerViewer.this.activeGalleryGroupForSectionMenu = null;
                    ClipArtResourceManagerViewer.this.activeSectionForSectionMenu = null;
                    IStructuredSelection ss = ClipArtResourceManagerViewer.this.getStructuredSelection();
                    if (ss != null && ss.isEmpty()) {
                        ClipArtResourceManagerViewer.this.activeSectionForSectionMenu = section;
                        ClipArtResourceManagerViewer.this.activeGalleryGroupForSectionMenu = group;
                    }
                }
            });
            if (GalleryCore.getInstance().getUserGalleryGroups().contains(group)) {
                this.createSectionTextClient(section, "Add [Pro]", category);
                this.createDropTarget((Control)section, (LocalGalleryGroup)category);
            }
        }
    }

    public void renameGalleryGroup() {
        if (this.activeSectionForSectionMenu == null || this.activeSectionForSectionMenu.isDisposed() || !(this.activeGalleryGroupForSectionMenu instanceof LocalGalleryGroup)) {
            return;
        }
        Section section = this.activeSectionForSectionMenu;
        final LocalGalleryGroup localGalleryGroup = (LocalGalleryGroup)this.activeGalleryGroupForSectionMenu;
        this.activeGalleryGroupForSectionMenu = null;
        this.activeSectionForSectionMenu = null;
        Rectangle textLabelBounds = null;
        final String groupName = localGalleryGroup.getName();
        Control[] controlArray = section.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Label && groupName.equals(((Label)control).getText())) {
                textLabelBounds = control.getBounds();
            }
            ++n2;
        }
        final FloatingTextEditor editor = new FloatingTextEditor((Composite)section);
        if (textLabelBounds != null) {
            section.setText("");
            int x = textLabelBounds.x - 2;
            int y = textLabelBounds.y - 2;
            editor.setInitialLocation(new Point(x, y));
            editor.setInitialSize(new Point(100, 18));
        } else {
            editor.setInitialLocation(new Point(100, 0));
            editor.setInitialSize(new Point(100, 18));
        }
        editor.setInput((Object)new Document(groupName));
        editor.open();
        editor.doOperation(7);
        editor.addFloatingTextEditorListener((IFloatingTextEditorListener)new IFloatingTextEditorListener.Stub(){

            public void editingFinished(TextEvent e) {
                String text = e.text;
                if (text != null && !"".equals(text.trim()) && !text.equals(groupName)) {
                    GalleryCore.getInstance().renameUserGroup(localGalleryGroup, text);
                }
                ClipArtResourceManagerViewer.this.refresh();
            }

            public void editingCanceled(TextEvent e) {
                ClipArtResourceManagerViewer.this.refresh();
            }
        });
        final Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (editor != null && !editor.isClosed() && !editor.getControl().getBounds().contains(event.x, event.y)) {
                    editor.close(true);
                }
            }
        };
        Display.getCurrent().addFilter(3, listener);
        editor.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (listener != null) {
                    Display.getCurrent().removeFilter(3, listener);
                }
            }
        });
        ITextViewer textViewer = editor.getTextViewer();
        textViewer.getTextWidget().setBackground(this.getResourceManager().createColor(new RGB(255, 255, 255)));
        textViewer.getTextWidget().setForeground(this.getResourceManager().createColor(new RGB(0, 0, 0)));
    }

    public void deleteGalleryGroup() {
        if (this.activeGalleryGroupForSectionMenu instanceof LocalGalleryGroup) {
            LocalGalleryGroup localGalleryGroup = (LocalGalleryGroup)this.activeGalleryGroupForSectionMenu;
            this.activeGalleryGroupForSectionMenu = null;
            this.activeSectionForSectionMenu = null;
            GalleryCore.getInstance().deleteUserGroup(localGalleryGroup);
        }
    }

    protected void handleClickSectionTextClient(Object category) {
        if (category instanceof IGalleryGroup) {
            this.addClipArts((IGalleryGroup)category);
        }
    }

    private void createDropTarget(Control control, final LocalGalleryGroup galleryGroup) {
        final DropTarget dropTarget = new DropTarget(control, 3);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                dropTarget.dispose();
            }
        });
        dropTarget.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dropTarget.addDropListener(new DropTargetListener(){

            public void drop(DropTargetEvent event) {
                String[] paths = (String[])event.data;
                Object[] addedItems = GalleryCore.getInstance().addImagesToUserGroup(paths, galleryGroup);
                ClipArtResourceManagerViewer.this.refresh();
                ClipArtResourceManagerViewer.this.setSelection((ISelection)new StructuredSelection(addedItems), true);
            }

            public void dragEnter(DropTargetEvent event) {
                this.dropAccept(event);
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
                this.dropAccept(event);
            }

            public void dragOver(DropTargetEvent event) {
                this.dropAccept(event);
            }

            public void dropAccept(DropTargetEvent event) {
                if (!FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    event.detail = 0;
                } else if (event.detail == 16) {
                    if ((event.operations & 1) != 0) {
                        event.detail = 1;
                    } else if ((event.operations & 2) != 0) {
                        event.detail = 2;
                    }
                }
            }
        });
    }

    private void addClipArts(IGalleryGroup targetGroup) {
        String[] sourcePaths = this.selectImageFile();
        if (sourcePaths == null) {
            return;
        }
        Object[] addedItems = GalleryCore.getInstance().addImagesToUserGroup(sourcePaths, targetGroup);
        this.refresh();
        this.reveal(targetGroup);
        this.setSelection((ISelection)new StructuredSelection(addedItems), true);
        GalleryCore.getInstance().fireGalleryChanged();
    }

    private String[] selectImageFile() {
        FileDialog dialog = new FileDialog(this.getControl().getShell(), 4098);
        DialogUtils.makeDefaultImageSelectorDialog((FileDialog)dialog, (boolean)true);
        String open = dialog.open();
        if (open == null) {
            return null;
        }
        String parent = dialog.getFilterPath();
        String[] fileNames = dialog.getFileNames();
        String[] paths = new String[fileNames.length];
        int i = 0;
        while (i < fileNames.length) {
            paths[i] = new File(parent, fileNames[i]).getAbsolutePath();
            ++i;
        }
        return paths;
    }

    public boolean isUserGalleryGroup() {
        if (this.activeGalleryGroupForSectionMenu == null || this.activeSectionForSectionMenu == null || this.activeSectionForSectionMenu.isDisposed()) {
            return false;
        }
        return GalleryCore.getInstance().getUserGalleryGroups().contains(this.activeGalleryGroupForSectionMenu);
    }

    public void activateGroup(IGalleryGroup galleryGroup) {
        this.activeGalleryGroupForSectionMenu = galleryGroup;
        this.activeSectionForSectionMenu = (Section)this.getSection(galleryGroup);
    }

    private static class ClipArtCategorizedContentProvider
    implements ITreeContentProvider {
        private ClipArtCategorizedContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ClipArtGalleryCore) {
                return ((ClipArtGalleryCore)inputElement).getElements().toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ClipArtGalleryCore) {
                return ((ClipArtGalleryCore)parentElement).getElements().toArray();
            }
            if (parentElement instanceof IGalleryGroup) {
                return ((IGalleryGroup)parentElement).getItems().toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            ClipArtGalleryCore clipArtGalleryCore = ClipArtGalleryCore.getInstance();
            if (element instanceof IGalleryItem) {
                IGalleryItem clipArt = (IGalleryItem)element;
                return clipArt.getParent();
            }
            if (element instanceof IGalleryGroup) {
                return clipArtGalleryCore;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof IGalleryGroup || element instanceof ClipArtGalleryCore;
        }
    }

    private class ClipArtCategorizedLabelProvider
    extends ResourceManagerViewer.CategorizedLabelProvider
    implements IToolTipProvider {
        private ClipArtCategorizedLabelProvider() {
            super((ResourceManagerViewer)ClipArtResourceManagerViewer.this);
        }

        public String getText(Object element) {
            if (element instanceof IGalleryItem) {
                int end;
                int begin;
                String absoluteFileName;
                URL url = ((IGalleryItem)element).getURL();
                String text = absoluteFileName = url == null ? null : url.getPath();
                if (absoluteFileName != null && (begin = absoluteFileName.lastIndexOf("/")) < (end = absoluteFileName.lastIndexOf(".")) && begin > 0 && absoluteFileName.length() > end) {
                    text = absoluteFileName.substring(begin + 1, end);
                }
                return text;
            }
            if (element instanceof IGalleryGroup) {
                return ((IGalleryGroup)element).getName();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            if (element == null || !(element instanceof IGalleryItem)) {
                return super.getImage(element);
            }
            IGalleryItem item = (IGalleryItem)element;
            URL url = item.getURL();
            if (url == null) {
                return super.getImage(element);
            }
            ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)url);
            Image image = ClipArtResourceManagerViewer.this.getResourceManager().createImage(imageDescriptor);
            if (image != null) {
                return image;
            }
            return super.getImage(element);
        }

        public String getToolTip(Object element) {
            if (element != null && element instanceof IGalleryItem) {
                IGalleryItem item = (IGalleryItem)element;
                String groupName = this.getText(item.getParent());
                String clipArtName = this.getText(item);
                return String.valueOf(groupName) + "-" + clipArtName;
            }
            return "";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClipArtGalleryCore {
        private static ClipArtGalleryCore instance = new ClipArtGalleryCore();
        List<IGalleryGroup> groups = new ArrayList<IGalleryGroup>();

        public static ClipArtGalleryCore getInstance() {
            return instance;
        }

        private ClipArtGalleryCore() {
        }

        private void load() {
            GalleryCore galleryCore = GalleryCore.getInstance();
            List<IGalleryGroup> userGroups = galleryCore.getUserGalleryGroups();
            List<IGalleryGroup> sysGroups = galleryCore.getGalleryGroups();
            this.groups.clear();
            for (IGalleryGroup group : sysGroups) {
                this.groups.add(group);
            }
            for (IGalleryGroup userGroup : userGroups) {
                if (userGroup == null) continue;
                this.groups.add(userGroup);
            }
        }

        public List<IGalleryGroup> getElements() {
            this.load();
            return this.groups;
        }
    }
}

