/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.fishbone.decorations;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.draw2d.IDecoratedFigure;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.draw2d.decoration.AbstractDecoration;
import org.xmind.gef.draw2d.decoration.IDecoration;
import org.xmind.gef.draw2d.decoration.IShapeDecoration;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.gef.draw2d.geometry.IPrecisionTransformer;
import org.xmind.gef.draw2d.geometry.PrecisionHorizontalFlipper;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.geometry.PrecisionRectangle;
import org.xmind.gef.draw2d.graphics.GradientPattern;
import org.xmind.ui.decorations.ITopicDecoration;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.ITopicPart;

public class MainFishboneBranchDecoration
extends AbstractDecoration {
    private IBranchPart branch;
    private IPrecisionTransformer hf = new PrecisionHorizontalFlipper();
    private PrecisionPoint lineStart = null;
    private PrecisionPoint lineEnd = null;
    private PrecisionPoint tailTop = null;
    private PrecisionPoint tailBottom = null;
    public static final int TailLength = 30;

    public MainFishboneBranchDecoration(IBranchPart branch, String id) {
        super(id);
        this.branch = branch;
    }

    public void validate(IFigure figure) {
        super.validate(figure);
        if (this.branch.isFolded() || this.branch.getSubBranches().isEmpty()) {
            this.setVisible(figure, false);
            return;
        }
        this.setVisible(figure, true);
        PrecisionPoint ref = this.getReference(figure);
        this.hf.setOrigin(ref);
        int orientation = this.branch.getConnections().getSourceOrientation();
        this.hf.setEnabled(orientation == 8);
        PrecisionRectangle r = this.getChildrenBounds(figure);
        PrecisionRectangle b = this.hf.tr(this.getTopicBounds(ref));
        PrecisionPoint source = this.hf.rp(new PrecisionPoint(b.right() - 1.0, ref.y));
        PrecisionPoint target = this.hf.rp(new PrecisionPoint(this.hf.tr(r).right(), ref.y));
        double tailX = target.x + (double)(source.x < target.x ? 30 : -30);
        double tw = Math.max(0.0, Math.min(b.height / 2.0, Math.min(target.y - r.y, r.bottom() - target.y)));
        this.lineStart = source;
        this.lineEnd = target;
        this.tailTop = new PrecisionPoint(tailX, target.y - tw);
        this.tailBottom = new PrecisionPoint(tailX, target.y + tw);
    }

    private PrecisionRectangle getTopicBounds(PrecisionPoint ref) {
        ITopicPart topicPart = this.branch.getTopicPart();
        if (topicPart != null) {
            return new PrecisionRectangle(topicPart.getFigure().getBounds());
        }
        return new PrecisionRectangle(ref.x, ref.y, 0.0, 0.0);
    }

    private PrecisionRectangle getChildrenBounds(IFigure figure) {
        PrecisionRectangle r = null;
        ITopicPart topicPart = this.branch.getTopicPart();
        if (topicPart != null) {
            r = Geometry.union(r, (PrecisionRectangle)new PrecisionRectangle(topicPart.getFigure().getBounds()));
        }
        for (IBranchPart subBranch : this.branch.getSubBranches()) {
            r = Geometry.union((PrecisionRectangle)r, (PrecisionRectangle)new PrecisionRectangle(subBranch.getFigure().getBounds()));
        }
        if (r != null) {
            return r;
        }
        return new PrecisionRectangle(figure.getBounds());
    }

    private PrecisionPoint getReference(IFigure figure) {
        ITopicPart topicPart = this.branch.getTopicPart();
        if (topicPart != null) {
            return new PrecisionPoint(((IReferencedFigure)topicPart.getFigure()).getReference());
        }
        return new PrecisionPoint(figure.getBounds().getCenter());
    }

    public void invalidate() {
        this.lineStart = null;
        this.lineEnd = null;
        this.tailTop = null;
        this.tailBottom = null;
        super.invalidate();
    }

    protected void performPaint(IFigure figure, Graphics graphics) {
        if (this.lineStart == null || this.lineEnd == null || this.tailTop == null || this.tailBottom == null) {
            return;
        }
        ITopicDecoration topicDecoration = this.getTopicDecoration();
        if (topicDecoration == null) {
            return;
        }
        Color lineColor = topicDecoration.getLineColor();
        Color fillColor = topicDecoration.getFillColor();
        if (lineColor == null) {
            return;
        }
        int lineWidth = Math.max(1, topicDecoration.getLineWidth());
        int lineStyle = topicDecoration.getLineStyle();
        graphics.setAlpha(this.getAlpha());
        graphics.setLineStyle(lineStyle);
        graphics.setAntialias(1);
        org.xmind.gef.draw2d.graphics.Path shape = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
        if (this.branch.getConnections().isTapered()) {
            graphics.setLineWidth(lineWidth);
            shape.moveTo((float)this.lineStart.x + (float)(this.lineStart.x < this.lineEnd.x ? -1 : 1), (float)(this.lineStart.y - (double)(lineWidth * 5) - 0.0));
            shape.lineTo((float)this.lineStart.x + (float)(this.lineStart.x < this.lineEnd.x ? -1 : 1), (float)(this.lineStart.y + (double)(lineWidth * 5) + 0.0));
            shape.lineTo((float)this.lineEnd.x, (float)(this.lineEnd.y + (double)lineWidth * 0.5));
            shape.lineTo((float)this.lineEnd.x, (float)(this.lineEnd.y - (double)lineWidth * 0.5));
            shape.close();
            graphics.setBackgroundColor(lineColor);
            graphics.fillPath((Path)shape);
        } else {
            shape.moveTo(this.lineStart);
            shape.lineTo(this.lineEnd);
            graphics.setForegroundColor(lineColor);
            graphics.setLineWidth(lineWidth);
            graphics.drawPath((Path)shape);
        }
        shape.dispose();
        shape = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
        shape.moveTo(this.lineEnd);
        shape.lineTo(this.tailTop);
        shape.lineTo(this.tailBottom);
        shape.lineTo(this.lineEnd);
        shape.close();
        if (fillColor != null) {
            Pattern pattern = null;
            if (this.isGradient()) {
                PrecisionRectangle r = new PrecisionRectangle(this.tailTop, this.tailBottom).union(this.lineEnd);
                pattern = this.createPattern(figure, this.getAlpha(), fillColor, r);
                if (pattern != null) {
                    graphics.pushState();
                    graphics.setBackgroundPattern(pattern);
                }
            } else {
                graphics.setAlpha(this.getAlpha());
                graphics.setBackgroundColor(fillColor);
            }
            graphics.fillPath((Path)shape);
            if (pattern != null) {
                graphics.popState();
                pattern.dispose();
            }
        }
        if (lineColor != null) {
            graphics.setForegroundColor(lineColor);
            graphics.setLineWidth(lineWidth);
            graphics.setLineStyle(lineStyle);
            graphics.setAlpha(this.getAlpha());
            graphics.drawPath((Path)shape);
        }
        shape.dispose();
    }

    private ITopicDecoration getTopicDecoration() {
        IDecoration decoration;
        IFigure topicFigure;
        ITopicPart topicPart = this.branch.getTopicPart();
        if (topicPart != null && (topicFigure = topicPart.getFigure()) instanceof IDecoratedFigure && (decoration = ((IDecoratedFigure)topicFigure).getDecoration()) instanceof ITopicDecoration) {
            return (ITopicDecoration)decoration;
        }
        return null;
    }

    private Pattern createPattern(IFigure figure, int alpha, Color color, PrecisionRectangle r) {
        int delta = (int)(r.height * 0.4);
        GradientPattern p = new GradientPattern((Device)Display.getCurrent(), (float)r.x, (float)(r.y - (double)delta), (float)r.x, (float)(r.y + r.height), ColorConstants.white, alpha, color, alpha);
        return p;
    }

    private boolean isGradient() {
        IDecoration decoration;
        IFigure figure;
        ITopicPart topicPart = this.branch.getTopicPart();
        if (topicPart != null && (figure = topicPart.getFigure()) instanceof IDecoratedFigure && (decoration = ((IDecoratedFigure)figure).getDecoration()) instanceof IShapeDecoration) {
            return ((IShapeDecoration)decoration).isGradient();
        }
        return true;
    }
}

