/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.search.workbooks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.xmind.core.IBoundary;
import org.xmind.core.INotes;
import org.xmind.core.INotesContent;
import org.xmind.core.IPlainNotesContent;
import org.xmind.core.IRelationship;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.ui.internal.search.workbooks.ISearchResultItem;
import org.xmind.ui.internal.search.workbooks.SearchResultItem;
import org.xmind.ui.internal.utils.E4Utils;
import org.xmind.ui.mindmap.MindMapUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MindMapSearchEngine {
    private Collection<IEditorPart> editors;
    private String toFind;
    private List<ISearchResultItem> result = new ArrayList<ISearchResultItem>();
    private ISearchResultItem editorItem;
    private ISearchResultItem rootTopicItem;
    private ISearchResultItem topicItem;
    private IEditorPart editor;
    private ITopic rootTopic;
    private ITopic topic;
    private int parameter;

    public MindMapSearchEngine(String toFind, Collection<IEditorPart> editors) {
        this.toFind = toFind;
        this.editors = editors;
    }

    public void setParameter(int parameter) {
        this.parameter = parameter;
        if (!this.isCaseSensitive()) {
            this.toFind = this.toFind.toLowerCase();
        }
    }

    public void search() {
        if (this.toFind == null || this.editors == null) {
            return;
        }
        Iterator<IEditorPart> iterator = this.editors.iterator();
        while (iterator.hasNext()) {
            IEditorPart e;
            this.editor = e = iterator.next();
            this.editorItem = null;
            if (this.editor == null) {
                this.rootTopicItem = null;
                return;
            }
            IWorkbook workbook = (IWorkbook)this.editor.getAdapter(IWorkbook.class);
            if (workbook == null) continue;
            this.searchWorkbook(workbook);
        }
    }

    private void searchWorkbook(IWorkbook workbook) {
        for (ISheet s : workbook.getSheets()) {
            this.rootTopic = s.getRootTopic();
            this.rootTopicItem = null;
            boolean forceQuery = this.includesTopics() || this.includesRelationships() || this.includesNotes() || this.includesLabels() || this.includesBoundaries();
            boolean bl = forceQuery = !forceQuery;
            if (this.includesTopics() || this.includesBoundaries() || this.includesLabels() || this.includesNotes() || forceQuery) {
                this.topic = this.rootTopic;
                this.searchTopic();
            }
            if (!this.includesRelationships() && !forceQuery) continue;
            this.searchRelationships(s);
        }
    }

    private void searchRelationships(ISheet s) {
        for (IRelationship r : s.getRelationships()) {
            int[] highlights = this.find(r.getTitleText());
            if (highlights == null) continue;
            ISearchResultItem parent = this.ensureRootTopicItem(null);
            parent.addChild(new RelationshipItem(parent, r, highlights));
        }
    }

    private void searchTopic() {
        boolean forceQuery = this.includesTopics() || this.includesRelationships() || this.includesNotes() || this.includesLabels() || this.includesBoundaries();
        forceQuery = !forceQuery;
        ITopic theTopic = this.topic;
        if (this.includesTopics() || forceQuery) {
            this.searchTitle(theTopic);
        }
        if (this.includesBoundaries() || forceQuery) {
            this.searchBoundaries(theTopic);
        }
        if (this.includesLabels() || forceQuery) {
            this.searchLabels(theTopic);
        }
        if (this.includesNotes() || forceQuery) {
            this.searchNotes(theTopic);
        }
        Iterator iterator = theTopic.getAllChildren().iterator();
        while (iterator.hasNext()) {
            ITopic t;
            this.topic = t = (ITopic)iterator.next();
            this.topicItem = null;
            this.searchTopic();
        }
    }

    private void searchTitle(ITopic topic) {
        int[] highlights = this.find(topic.getTitleText());
        if (highlights != null) {
            if (topic == this.rootTopic) {
                this.ensureRootTopicItem(highlights);
            } else {
                this.ensureSubTopicItem(highlights);
            }
        }
    }

    private void searchBoundaries(ITopic topic) {
        for (IBoundary b : topic.getBoundaries()) {
            int[] highlights = this.find(b.getTitleText());
            if (highlights == null) continue;
            ISearchResultItem parent = this.ensureTopicItem(topic);
            parent.addChild(new BoundaryItem(parent, b, highlights));
        }
    }

    private void searchLabels(ITopic topic) {
        for (String label : topic.getLabels()) {
            int[] highlights = this.find(label);
            if (highlights == null) continue;
            ISearchResultItem parent = this.ensureTopicItem(topic);
            parent.addChild(new LabelItem(parent, topic, label, highlights));
        }
    }

    private void searchNotes(ITopic topic) {
        String text;
        int[] highlights;
        INotesContent content;
        INotes notes = topic.getNotes();
        if (!notes.isEmpty() && (content = notes.getContent("plain")) != null && content instanceof IPlainNotesContent && (highlights = this.find(text = ((IPlainNotesContent)content).getTextContent().replaceAll("\\s", " "))) != null) {
            ISearchResultItem parent = this.ensureTopicItem(topic);
            int i = 0;
            while (i < highlights.length) {
                parent.addChild(new NotesItem(parent, topic, text, highlights[i++], highlights[i++]));
            }
        }
    }

    private ISearchResultItem ensureEditorItem() {
        if (this.editorItem == null) {
            this.editorItem = new EditorItem(this.editor);
            this.result.add(this.editorItem);
        }
        return this.editorItem;
    }

    private ISearchResultItem ensureRootTopicItem(int[] highlights) {
        this.ensureEditorItem();
        if (this.rootTopicItem == null) {
            this.rootTopicItem = new TopicItem(this.editorItem, this.rootTopic, highlights);
            this.editorItem.addChild(this.rootTopicItem);
        }
        return this.rootTopicItem;
    }

    private ISearchResultItem ensureSubTopicItem(int[] highlights) {
        this.ensureRootTopicItem(null);
        if (this.topicItem == null) {
            this.topicItem = new TopicItem(this.rootTopicItem, this.topic, highlights);
            this.rootTopicItem.addChild(this.topicItem);
        }
        return this.topicItem;
    }

    private ISearchResultItem ensureTopicItem(ITopic topic) {
        if (topic == this.rootTopic) {
            return this.ensureRootTopicItem(null);
        }
        return this.ensureSubTopicItem(null);
    }

    private int[] find(String text) {
        if (text == null || "".equals(text)) {
            return null;
        }
        if (!this.isCaseSensitive()) {
            text = text.toLowerCase();
        }
        int[] highlights = new int[text.length() * 2];
        int cursor = 0;
        int index = text.indexOf(this.toFind);
        while (index >= 0) {
            highlights[cursor] = index;
            highlights[cursor + 1] = this.toFind.length();
            cursor += 2;
            index = text.indexOf(this.toFind, index + this.toFind.length());
        }
        if (cursor > 0) {
            return cursor < highlights.length ? MindMapSearchEngine.subarray(highlights, cursor) : highlights;
        }
        return null;
    }

    private static int[] subarray(int[] array, int length) {
        int[] newArray = new int[length];
        System.arraycopy(array, 0, newArray, 0, length);
        return newArray;
    }

    public Collection<ISearchResultItem> getResult() {
        return this.result;
    }

    private boolean isCaseSensitive() {
        return (this.getParameter() & 1) != 0;
    }

    private boolean includesTopics() {
        return (this.getParameter() & 4) != 0;
    }

    private boolean includesBoundaries() {
        return (this.getParameter() & 8) != 0;
    }

    private boolean includesRelationships() {
        return (this.getParameter() & 0x10) != 0;
    }

    private boolean includesLabels() {
        return (this.getParameter() & 0x20) != 0;
    }

    private boolean includesNotes() {
        return (this.getParameter() & 0x40) != 0;
    }

    public int getParameter() {
        return this.parameter;
    }

    private static class BoundaryItem
    extends SearchResultItem {
        public BoundaryItem(ISearchResultItem parent, IBoundary b, int[] highlights) {
            super(parent, b);
            this.setTitle(b.getTitleText());
            this.setHighlights(highlights);
            this.setImageDescriptor(MindMapUI.getImages().getElementIcon((Object)b, true));
        }
    }

    private static class EditorItem
    extends SearchResultItem {
        public EditorItem(IEditorPart editor) {
            super(null, editor);
            this.setTitle(editor.getEditorInput().getName());
            this.setImageDescriptor(MindMapUI.getImages().get("icons/xmind.16.png"));
        }

        protected boolean reveal(ISearchResultItem item) {
            ISelectionProvider selectionProvider;
            IEditorPart editor = (IEditorPart)super.getObject();
            editor.getSite().getPage().activate((IWorkbenchPart)editor);
            if (item != null && item != this && (selectionProvider = editor.getSite().getSelectionProvider()) != null) {
                Object object = item.getObject();
                selectionProvider.setSelection((ISelection)new StructuredSelection(object));
                ISelection selection = selectionProvider.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection ss = (IStructuredSelection)selection;
                    return ss.size() == 1 && object.equals(ss.getFirstElement());
                }
            }
            return false;
        }
    }

    private static class LabelItem
    extends SearchResultItem {
        public LabelItem(ISearchResultItem parent, ITopic topic, String label, int[] highlights) {
            super(parent, topic);
            this.setTitle(label);
            this.setHighlights(highlights);
            this.setImageDescriptor(MindMapUI.getImages().get("label.png", true));
        }

        public boolean equals(Object obj) {
            return super.equals(obj) && obj instanceof LabelItem && ((LabelItem)obj).getTitle().equals(this.getTitle());
        }
    }

    private static class NotesItem
    extends SearchResultItem {
        private static final String ELLIPSIS = "...";
        private int offset;
        private int length;

        public NotesItem(ISearchResultItem parent, ITopic topic, String text, int offset, int length) {
            super(parent, topic);
            this.offset = offset;
            this.length = length;
            if (offset <= 15) {
                int start = 0;
                int end = offset + length + 15;
                if (end >= text.length()) {
                    end = text.length();
                    this.setTitle(text.substring(start, end));
                } else {
                    this.setTitle(String.valueOf(text.substring(start, end)) + ELLIPSIS);
                }
                this.setHighlights(new int[]{offset, length});
            } else {
                int start = offset - 15;
                int end = offset + length + 15;
                if (end >= text.length()) {
                    end = text.length();
                    this.setTitle(ELLIPSIS + text.substring(start, end));
                } else {
                    this.setTitle(ELLIPSIS + text.substring(start, end) + ELLIPSIS);
                }
                this.setHighlights(new int[]{18, length});
            }
            this.setImageDescriptor(MindMapUI.getImages().get("notes.png", true));
        }

        public boolean reveal() {
            Object obj;
            boolean selected = super.reveal();
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window == null) {
                return selected;
            }
            IWorkbenchPage workbenchPage = window.getActivePage();
            if (workbenchPage == null) {
                return selected;
            }
            E4Utils.showPart((String)"org.xmind.ui.command.showModelPart", (IWorkbenchWindow)window, (String)"org.xmind.ui.modelPart.notes", null, (String)"org.xmind.ui.stack.right");
            ITextViewer textViewer = null;
            MPart part = E4Utils.findPart((IWorkbenchWindow)window, (String)"org.xmind.ui.modelPart.notes");
            if (part != null && (obj = part.getObject()) instanceof IAdaptable) {
                textViewer = (ITextViewer)((IAdaptable)obj).getAdapter(ITextViewer.class);
            }
            if (textViewer == null) {
                return selected;
            }
            try {
                textViewer.setSelectedRange(this.offset, this.length);
                textViewer.revealRange(this.offset, this.length);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }

        public boolean equals(Object obj) {
            boolean b;
            boolean bl = b = super.equals(obj) && obj instanceof NotesItem;
            if (b) {
                NotesItem that = (NotesItem)obj;
                b &= this.offset == that.offset && this.length == that.length;
            }
            return b;
        }
    }

    private static class RelationshipItem
    extends SearchResultItem {
        public RelationshipItem(ISearchResultItem parent, IRelationship r, int[] highlights) {
            super(parent, r);
            this.setTitle(r.getTitleText());
            this.setHighlights(highlights);
            this.setImageDescriptor(MindMapUI.getImages().getElementIcon((Object)r, true));
        }
    }

    private static class TopicItem
    extends SearchResultItem {
        public TopicItem(ISearchResultItem parent, ITopic topic, int[] highlights) {
            super(parent, topic);
            this.setTitle(topic.getTitleText());
            this.setDescription(this.getTopicPath(topic));
            this.setHighlights(highlights);
            if (topic.isRoot()) {
                this.setImageDescriptor(MindMapUI.getImages().get("sheet.png", true));
            } else {
                this.setImageDescriptor(MindMapUI.getImages().getTopicIcon(topic, true));
            }
        }

        private String getTopicPath(ITopic topic) {
            if (topic.isRoot()) {
                return "(" + topic.getOwnedSheet().getTitleText() + ")";
            }
            ITopic p = topic.getParent();
            if (p == null || p.isRoot()) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(")");
            boolean addSep = false;
            while (p != null && !p.isRoot()) {
                if (addSep) {
                    sb.insert(0, " - ");
                } else {
                    addSep = true;
                }
                sb.insert(0, p.getTitleText());
                p = p.getParent();
            }
            sb.insert(0, "(");
            return sb.toString();
        }
    }
}

