/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.xmindresource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.AbstractHintLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.xmind.core.internal.gallery.GalleryCore;
import org.xmind.core.internal.gallery.IGalleryGroup;
import org.xmind.core.style.IStyle;
import org.xmind.gef.EditDomain;
import org.xmind.gef.draw2d.SizeableImageFigure;
import org.xmind.gef.event.MouseEvent;
import org.xmind.gef.part.GraphicalEditPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IPartFactory;
import org.xmind.gef.policy.IEditPolicy;
import org.xmind.gef.status.StatusEvent;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gallery.ContentPanePart;
import org.xmind.ui.gallery.FramePart;
import org.xmind.ui.gallery.GalleryLayout;
import org.xmind.ui.gallery.GalleryNavigablePolicy;
import org.xmind.ui.gallery.GallerySelectTool;
import org.xmind.ui.gallery.GalleryViewer;
import org.xmind.ui.gallery.IDecorationContext;
import org.xmind.ui.gallery.ILabelDecorator;
import org.xmind.ui.internal.views.ThemeFigure;
import org.xmind.ui.internal.wizards.TemplateLabelProvider;
import org.xmind.ui.mindmap.ITemplate;
import org.xmind.ui.mindmap.MindMapUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceViewer
extends GalleryViewer {
    private List<Object> selectedItems = new LinkedList<Object>();
    private List<FramePart> frameParts = new ArrayList<FramePart>();

    public ResourceViewer(Composite parent) {
        this.init();
        this.createControl(parent);
    }

    protected void init() {
        this.setPartFactory(new ResourcePartFactory());
        this.setContentProvider((IStructuredContentProvider)new ResourceContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new ResourceLabelProvider());
        EditDomain editDomain = new EditDomain();
        editDomain.installTool("select tool", (ITool)new ResourceSelectTool());
        editDomain.installEditPolicy("org.xmind.ui.gallery.editPolicy.navigable", (IEditPolicy)new GalleryNavigablePolicy());
        this.setEditDomain(editDomain);
        Properties properties = this.getProperties();
        properties.set("org.xmind.ui.gallery.horizontal", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.wrap", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.singleClickToOpen", (Object)Boolean.FALSE);
        properties.set("org.xmind.ui.gallery.flatFrames", true);
        properties.set("org.xmind.ui.gallery.layout", (Object)new GalleryLayout(1, 1, 10, 10, 10, 10, 10, 10));
        properties.set("org.xmind.ui.gallery.frameContentSize", (Object)new Dimension(128, 64));
        properties.set("constrained", true);
        properties.set("org.xmind.ui.gallery.titlePlacement", (Object)GalleryViewer.TITLE_BOTTOM);
        properties.set("org.xmind.ui.gallery.solidFrames", true);
        properties.set("org.xmind.ui.gallery.customDecorateContentPane", true);
        this.frameParts.clear();
    }

    public List<Object> getSelectedItems() {
        return this.selectedItems;
    }

    public Map<Object, Image> getSelectedMap() {
        HashMap<Object, Image> map = new HashMap<Object, Image>();
        for (Object item : this.selectedItems) {
            map.put(item, this.getImageByElement(item));
        }
        return map;
    }

    private Image getImageByElement(Object element) {
        if (element instanceof IStyle) {
            ThemeFigure figure = new ThemeFigure();
            return figure.getPreviewImage((IStyle)element);
        }
        IBaseLabelProvider provider = this.getLabelProvider();
        if (provider instanceof ResourceLabelProvider) {
            return ((ResourceLabelProvider)provider).getImage(element);
        }
        return null;
    }

    public void selectAllItems(boolean selected) {
        if (!this.frameParts.isEmpty()) {
            for (FramePart part : this.frameParts) {
                part.getStatus().setStatus(2, selected);
                if (selected) {
                    this.getSelectionSupport().appendSelection((Object)part);
                    continue;
                }
                this.getSelectionSupport().deselect((Object)part);
            }
        }
    }

    private static class Layout
    extends AbstractHintLayout {
        private IDecorationContext properties;

        public Layout(IDecorationContext properties) {
            this.properties = properties;
        }

        public void layout(IFigure container) {
            Rectangle area = container.getClientArea();
            for (Object child : container.getChildren()) {
                IFigure figure = (IFigure)child;
                Dimension childSize = figure.getPreferredSize(-1, -1);
                int childWidth = Math.min(area.width, childSize.width);
                int childHeight = Math.min(area.height, childSize.height);
                figure.setBounds(new Rectangle(area.x, area.y, childWidth, childHeight));
            }
        }

        protected Dimension calculatePreferredSize(IFigure figure, int wHint, int hHint) {
            if (wHint > -1) {
                wHint = Math.max(0, wHint - figure.getInsets().getWidth());
            }
            if (hHint > -1) {
                hHint = Math.max(0, hHint - figure.getInsets().getHeight());
            }
            Insets insets = figure.getInsets();
            Dimension contentSize = (Dimension)this.properties.getProperty("org.xmind.ui.gallery.frameContentSize", null);
            if (contentSize != null) {
                return new Dimension(contentSize.width + insets.getWidth(), contentSize.height + insets.getHeight());
            }
            Dimension d = new Dimension();
            List children = figure.getChildren();
            int i = 0;
            while (i < children.size()) {
                IFigure child = (IFigure)children.get(i);
                if (!this.isObservingVisibility() || child.isVisible()) {
                    d.union(child.getPreferredSize(wHint, hHint));
                }
                ++i;
            }
            d.expand(figure.getInsets().getWidth(), figure.getInsets().getHeight());
            d.union(this.getBorderPreferredSize(figure));
            return d;
        }
    }

    private class ResourceContentProvider
    extends ArrayContentProvider {
        private ResourceContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof GalleryCore) {
                LinkedList items = new LinkedList();
                List groups = ((GalleryCore)inputElement).getGalleryGroups();
                for (IGalleryGroup group : groups) {
                    items.addAll(group.getItems());
                }
                return items.toArray();
            }
            if (inputElement instanceof IGalleryGroup) {
                return ((IGalleryGroup)inputElement).getItems().toArray();
            }
            return super.getElements(inputElement);
        }
    }

    private class ResourceFramePart
    extends FramePart {
        public ResourceFramePart(Object model) {
            super(model);
            ResourceViewer.this.frameParts.add(this);
        }

        protected Object[] getModelChildren(Object model) {
            if (model instanceof IStyle) {
                return new Object[]{model};
            }
            return super.getModelChildren(model);
        }

        protected void handleStatusChanged(StatusEvent event) {
            if ((event.key & 2) != 0) {
                Object model = this.getModel();
                if (event.newValue) {
                    if (!ResourceViewer.this.selectedItems.contains(model)) {
                        ResourceViewer.this.selectedItems.add(model);
                    }
                } else {
                    ResourceViewer.this.selectedItems.remove(model);
                }
            }
            this.refresh();
            super.handleStatusChanged(event);
        }
    }

    private class ResourceLabelProvider
    extends TemplateLabelProvider
    implements ILabelDecorator {
        private Image selectedImage;
        private Image preSelectedImage;

        private ResourceLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IStyle) {
                IStyle style = (IStyle)element;
                return style.getName();
            }
            if (element instanceof ITemplate) {
                return ((ITemplate)element).getName();
            }
            return super.getText(element);
        }

        public IFigure decorateFigure(IFigure figure, Object element, IDecorationContext context) {
            List children = figure.getChildren();
            boolean needInitFigureContent = children.isEmpty();
            if (needInitFigureContent) {
                SizeableImageFigure themeContentFigure = new SizeableImageFigure(this.getImage(element));
                SizeableImageFigure defaultImageFigure = new SizeableImageFigure(this.getSelectedImage(true));
                figure.add((IFigure)themeContentFigure);
                figure.add((IFigure)defaultImageFigure);
                if (context != null) {
                    figure.setLayoutManager((LayoutManager)new Layout(context));
                    boolean imageConstrained = Boolean.TRUE.equals(context.getProperty("constrained", (Object)false));
                    boolean imageStretched = Boolean.TRUE.equals(context.getProperty("stretched", (Object)false));
                    themeContentFigure.setConstrained(imageConstrained);
                    themeContentFigure.setStretched(imageStretched);
                    defaultImageFigure.setConstrained(imageConstrained);
                    defaultImageFigure.setStretched(imageStretched);
                }
            }
            children = figure.getChildren();
            int size = children.size();
            Object ContentFigure = children.get(size - 2);
            Object imageFigure = children.get(size - 1);
            if (ContentFigure instanceof SizeableImageFigure && imageFigure instanceof SizeableImageFigure) {
                ((SizeableImageFigure)ContentFigure).setImage(this.getImage(element));
                ((SizeableImageFigure)imageFigure).setImage(this.getMarkImage(element));
            }
            return figure;
        }

        private Image getMarkImage(Object element) {
            if (ResourceViewer.this.getSelectedItems().contains(element)) {
                return this.getSelectedImage(true);
            }
            return ResourceViewer.this.getPreselected() == null || !element.equals(ResourceViewer.this.getPreselected()) ? null : this.getSelectedImage(false);
        }

        private Image getSelectedImage(boolean selected) {
            ImageDescriptor desc;
            if (selected) {
                ImageDescriptor desc2;
                if (this.selectedImage == null && (desc2 = MindMapUI.getImages().get("select.png", true)) != null) {
                    try {
                        this.selectedImage = desc2.createImage(false);
                    }
                    catch (Throwable throwable) {}
                }
                return this.selectedImage;
            }
            if (this.preSelectedImage == null && (desc = MindMapUI.getImages().get("select.png", false)) != null) {
                try {
                    this.preSelectedImage = desc.createImage(false);
                }
                catch (Throwable throwable) {}
            }
            return this.preSelectedImage;
        }
    }

    private class ResourcePartFactory
    implements IPartFactory {
        private ResourcePartFactory() {
        }

        public IPart createPart(IPart context, Object model) {
            if (context instanceof ContentPanePart) {
                return new ResourceFramePart(model);
            }
            if (model instanceof String) {
                return null;
            }
            if (context instanceof ResourceFramePart && model instanceof IStyle) {
                return new ThemePart((IStyle)model);
            }
            return new ContentPanePart(model);
        }
    }

    private static class ResourceSelectTool
    extends GallerySelectTool {
        private ResourceSelectTool() {
        }

        protected boolean handleMouseDown(MouseEvent me) {
            this.getStatus().setStatus(4, true);
            return super.handleMouseDown(me);
        }

        public boolean handleMouseUp(MouseEvent me) {
            this.getStatus().setStatus(4, true);
            return super.handleMouseUp(me);
        }
    }

    private static class ThemePart
    extends GraphicalEditPart {
        public ThemePart(IStyle style) {
            this.setModel(style);
        }

        public IStyle getStyle() {
            return (IStyle)super.getModel();
        }

        protected IFigure createFigure() {
            return new ThemeFigure();
        }

        protected Object[] getModelChildren(Object model) {
            return new Object[0];
        }

        protected void updateView() {
            super.updateView();
            ((ThemeFigure)this.getFigure()).setTheme(this.getStyle());
            Properties properties = ((GalleryViewer)this.getSite().getViewer()).getProperties();
            Dimension size = (Dimension)properties.get("org.xmind.ui.gallery.frameContentSize");
            if (size != null) {
                this.getFigure().setPreferredSize(size);
            }
        }

        protected void register() {
            this.registerModel(this.getStyle().getId());
            super.register();
        }

        protected void unregister() {
            super.unregister();
            this.unregisterModel(this.getStyle().getId());
        }
    }
}

