/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.taskinfo.commands;

import org.eclipse.core.runtime.Assert;
import org.xmind.core.IExtensionElement;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtension;
import org.xmind.core.ITopicExtensionElement;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.gef.command.SourceCommand;
import org.xmind.ui.internal.taskinfo.Dependency;
import org.xmind.ui.internal.taskinfo.TaskMessages;

public class RemoveDependencyCommand
extends SourceCommand {
    private Dependency predecessor;
    private int index = -1;

    public RemoveDependencyCommand(Dependency predecessor) {
        super((Object)predecessor.getSuccessor());
        Assert.isNotNull((Object)predecessor);
        this.predecessor = predecessor;
        this.setLabel(TaskMessages.Command_RemoveDependency);
    }

    public void redo() {
        ITopicExtensionElement element = this.predecessor.getElement();
        ITopicExtensionElement parent = (ITopicExtensionElement)element.getParent();
        if (parent != null) {
            if (this.index < 0) {
                this.index = parent.getChildren().indexOf(element);
            }
            parent.deleteChild((IExtensionElement)element);
        }
        this.fireCoreEvent(this.predecessor.getSuccessor());
        super.redo();
    }

    public void undo() {
        ITopic topic = this.predecessor.getSuccessor();
        ITopicExtension ext = topic.createExtension("org.xmind.ui.taskInfo");
        ITopicExtensionElement content = ext.getContent();
        ITopicExtensionElement parentElement = (ITopicExtensionElement)content.getCreatedChild("predecessors");
        parentElement.addChild((IExtensionElement)this.predecessor.getElement(), this.index);
        this.fireCoreEvent(topic);
        super.undo();
    }

    private void fireCoreEvent(ITopic topic) {
        if (topic instanceof ICoreEventSource) {
            ((ICoreEventSource)topic).getCoreEventSupport().dispatchTargetChange((ICoreEventSource)topic, "taskInfoChange", (Object)"predecessors");
        }
    }
}

