/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator;

import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.lib.LibFile;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.routing.AutoStitch;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.menus.EditMenu;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;

public class PadGenerator {
    public static void generate(String fileName) {
        if (fileName == null) {
            return;
        }
        PadFrame padFrame = new PadFrame(fileName);
    }

    private static class PadFrame
    extends Job {
        String filename;
        String padframename;
        String corename;
        int lineno;
        Library cellLib;
        boolean copycells;
        List views;
        int angle;
        HashMap alignments;
        HashMap exports;
        List orderedCommands;

        protected PadFrame(String file) {
            super("Pad Frame Generator", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.filename = file;
            this.alignments = new HashMap();
            this.exports = new HashMap();
            this.views = new ArrayList();
            this.angle = 0;
            this.lineno = 1;
            this.orderedCommands = new ArrayList();
            this.startJob();
        }

        public boolean doIt() {
            File inputFile = new File(this.filename);
            if (inputFile == null || !inputFile.canRead()) {
                System.out.println("Error reading file " + this.filename);
                return false;
            }
            try {
                FileReader readFile = new FileReader(inputFile);
                BufferedReader readLine = new BufferedReader(readFile);
                String lineRead = readLine.readLine();
                Object lastni = null;
                while (lineRead != null) {
                    String keyWord;
                    StringTokenizer str = new StringTokenizer(lineRead, " \t");
                    if (str.hasMoreTokens() && (keyWord = str.nextToken()).charAt(0) != ';') {
                        do {
                            if (keyWord.equals("celllibrary")) {
                                if (this.processCellLibrary(str)) continue;
                                return false;
                            }
                            if (keyWord.equals("views")) {
                                if (this.processViews(str)) continue;
                                return false;
                            }
                            if (keyWord.equals("facet")) {
                                if (this.processFacet(str)) continue;
                                return false;
                            }
                            if (keyWord.equals("core")) {
                                if (this.processCore(str)) continue;
                                return false;
                            }
                            if (keyWord.equals("rotate")) {
                                if (this.processRotate(str)) continue;
                                return false;
                            }
                            if (keyWord.equals("align")) {
                                if (this.processAlign(str)) continue;
                                return false;
                            }
                            if (keyWord.equals("export")) {
                                if (this.processExport(str)) continue;
                                return false;
                            }
                            if (keyWord.equals("place")) {
                                if (this.processPlace(str)) continue;
                                return false;
                            }
                            System.out.println("Line " + this.lineno + ": unknown keyword'" + keyWord + "'");
                            break;
                        } while (str.hasMoreTokens());
                    }
                    lineRead = readLine.readLine();
                    ++this.lineno;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.createPadFrames();
            return true;
        }

        private boolean processCellLibrary(StringTokenizer str) {
            String keyWord;
            if (str.hasMoreTokens()) {
                keyWord = str.nextToken();
                URL fileURL = TextUtils.makeURLToFile(keyWord);
                this.cellLib = Library.findLibrary(TextUtils.getFileNameWithoutExtension(fileURL));
                if (this.cellLib == null) {
                    StringBuffer errmsg = new StringBuffer();
                    String fileDir = TextUtils.getFilePath(TextUtils.makeURLToFile(this.filename));
                    fileURL = TextUtils.makeURLToFile(fileDir + keyWord);
                    if (!(TextUtils.URLExists(fileURL, errmsg) || TextUtils.URLExists(fileURL, errmsg) || TextUtils.URLExists(fileURL = LibFile.getLibFile(keyWord), errmsg))) {
                        System.out.println(errmsg.toString());
                        return false;
                    }
                    OpenFile.Type style = OpenFile.Type.ELIB;
                    if (TextUtils.getExtension(fileURL).equals("txt")) {
                        style = OpenFile.Type.READABLEDUMP;
                    }
                    Library saveLib = Library.getCurrent();
                    this.cellLib = Library.newInstance(TextUtils.getFileNameWithoutExtension(fileURL), fileURL);
                    this.cellLib = Input.readLibrary(fileURL, style);
                    if (this.cellLib == null) {
                        this.err("cannot read library " + keyWord);
                        return false;
                    }
                    saveLib.setCurrent();
                }
            }
            if (str.hasMoreTokens() && (keyWord = str.nextToken()).equals("copy")) {
                this.copycells = true;
            }
            return true;
        }

        private boolean processViews(StringTokenizer str) {
            while (str.hasMoreTokens()) {
                String keyWord = str.nextToken();
                View view = View.findView(keyWord);
                if (view != null) {
                    this.views.add(view);
                    continue;
                }
                this.err("Unknown view '" + keyWord + "', ignoring");
            }
            return true;
        }

        private boolean processFacet(StringTokenizer str) {
            if (str.hasMoreTokens()) {
                this.padframename = str.nextToken();
                return true;
            }
            return false;
        }

        private boolean processCore(StringTokenizer str) {
            if (str.hasMoreTokens()) {
                this.corename = str.nextToken();
                return true;
            }
            return false;
        }

        private boolean processRotate(StringTokenizer str) {
            int angle = 0;
            if (str.hasMoreTokens()) {
                String keyWord = str.nextToken();
                if (keyWord.equals("c")) {
                    angle = 2700;
                } else if (keyWord.equals("cc")) {
                    angle = 900;
                } else {
                    System.out.println("Line " + this.lineno + ": incorrect rotation " + keyWord);
                    return false;
                }
                Rotation rot = new Rotation();
                rot.angle = angle;
                this.orderedCommands.add(rot);
                return true;
            }
            return false;
        }

        private boolean processAlign(StringTokenizer str) {
            ArrayAlign aa = new ArrayAlign();
            aa.lineno = this.lineno;
            String keyWord = str.nextToken();
            if (keyWord.equals("")) {
                System.out.println("Line " + this.lineno + ": missing 'cell' name");
                return false;
            }
            aa.cellname = keyWord;
            keyWord = str.nextToken();
            if (keyWord.equals("")) {
                System.out.println("Line " + this.lineno + ": missing 'in port' name");
                return false;
            }
            aa.inport = keyWord;
            keyWord = str.nextToken();
            if (keyWord.equals("")) {
                System.out.println("Line " + this.lineno + ": missing 'out port' name");
                return false;
            }
            aa.outport = keyWord;
            this.alignments.put(aa.cellname, aa);
            return true;
        }

        private boolean processExport(StringTokenizer str) {
            PadExports pe = new PadExports();
            pe.lineno = this.lineno;
            pe.padname = null;
            pe.corename = null;
            String keyWord = str.nextToken();
            if (keyWord.equals("")) {
                System.out.println("Line " + this.lineno + ": missing 'cell' name");
                return false;
            }
            pe.cellname = keyWord;
            if (str.hasMoreTokens()) {
                pe.padname = keyWord = str.nextToken();
                if (str.hasMoreTokens()) {
                    pe.corename = keyWord = str.nextToken();
                }
            }
            this.exports.put(pe.cellname, pe);
            return true;
        }

        private boolean processPlace(StringTokenizer str) {
            PlacePad pad = new PlacePad();
            pad.lineno = this.lineno;
            pad.exportsname = null;
            pad.gap = 0;
            pad.ni = null;
            pad.associations = new ArrayList();
            if (!str.hasMoreTokens()) {
                this.err("Cell name missing");
                return false;
            }
            pad.cellname = str.nextToken();
            while (str.hasMoreTokens()) {
                String keyWord = str.nextToken();
                if (keyWord.equals("export")) {
                    if (!str.hasMoreTokens()) {
                        this.err("Missing export assignment after 'export' keyword");
                        return false;
                    }
                    keyWord = str.nextToken();
                    PortAssociate pa = new PortAssociate();
                    pa.export = true;
                    pa.portname = this.getLHS(keyWord);
                    if (pa.portname == null) {
                        this.err("Bad export assignment after 'export' keyword");
                        return false;
                    }
                    pa.assocname = this.getRHS(keyWord, str);
                    if (pa.assocname == null) {
                        this.err("Bad export assignment after 'export' keyword");
                        return false;
                    }
                    pad.associations.add(pa);
                    continue;
                }
                String lhs = this.getLHS(keyWord);
                String rhs = this.getRHS(keyWord, str);
                if (lhs == null || rhs == null) {
                    this.err("Parse error on assignment of " + keyWord);
                    return false;
                }
                if (lhs.equals("gap")) {
                    try {
                        pad.gap = Integer.parseInt(rhs);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        this.err("Error parsing integer for 'gap' = " + rhs);
                        return false;
                    }
                }
                if (lhs.equals("name")) {
                    pad.exportsname = rhs;
                    continue;
                }
                PortAssociate pa = new PortAssociate();
                pa.export = false;
                pa.portname = lhs;
                pa.assocname = rhs;
                pad.associations.add(pa);
            }
            this.orderedCommands.add(pad);
            return true;
        }

        private String getLHS(String keyword) {
            if (keyword.indexOf("=") != -1) {
                return keyword.substring(0, keyword.indexOf("="));
            }
            return keyword;
        }

        private String getRHS(String keyword, StringTokenizer str) {
            if (keyword.indexOf("=") != -1) {
                if (keyword.substring(keyword.indexOf("=") + 1).equals("")) {
                    if (!str.hasMoreTokens()) {
                        return null;
                    }
                    return str.nextToken();
                }
                return keyword.substring(keyword.indexOf("=") + 1);
            }
            if (!str.hasMoreTokens()) {
                return null;
            }
            keyword = str.nextToken();
            if (keyword.equals("=")) {
                if (!str.hasMoreTokens()) {
                    return null;
                }
                return str.nextToken();
            }
            return keyword.substring(keyword.indexOf("=") + 1);
        }

        private void err(String msg) {
            System.out.println("Line " + this.lineno + ": " + msg);
        }

        private void createPadFrames() {
            if (this.views.size() == 0) {
                this.createPadFrame(this.padframename, null);
            } else {
                Iterator it = this.views.iterator();
                while (it.hasNext()) {
                    View view = (View)it.next();
                    if (view == View.SCHEMATIC) {
                        view = View.ICON;
                    }
                    this.createPadFrame(this.padframename, view);
                }
            }
        }

        private void createPadFrame(String name, View view) {
            Cell framecell;
            this.angle = 0;
            if (view != null) {
                name = view == View.ICON ? name + "{sch}" : name + "{" + view.getAbbreviation() + "}";
            }
            if ((framecell = Cell.makeInstance(Library.getCurrent(), name)) == null) {
                System.out.println("Could not create pad frame Cell: " + name);
                return;
            }
            ArrayList<PortProto> padPorts = new ArrayList<PortProto>();
            ArrayList<PortProto> corePorts = new ArrayList<PortProto>();
            NodeInst lastni = null;
            String lastpadname = null;
            Iterator it = this.orderedCommands.iterator();
            while (it.hasNext()) {
                PadExports pe;
                Point2D.Double pointCenter;
                NodeInst ni;
                Cell cell;
                Object obj = it.next();
                if (obj instanceof Rotation) {
                    this.angle = (this.angle + ((Rotation)obj).angle) % 3600;
                    continue;
                }
                PlacePad pad = (PlacePad)obj;
                this.lineno = pad.lineno;
                String cellname = pad.cellname;
                if (view != null) {
                    cellname = cellname + "{" + view.getAbbreviation() + "}";
                }
                if ((cell = this.cellLib.findNodeProto(cellname)) == null) {
                    this.err("Could not create pad Cell: " + cellname);
                    continue;
                }
                if (this.copycells) {
                    cell = CircuitChanges.copyRecursively(cell, cell.getName(), Library.getCurrent(), cell.getView(), false, false, "", false, false, false);
                }
                if (cell == null) {
                    this.err("Could not copy in pad Cell " + cellname);
                    continue;
                }
                ArrayAlign aa = (ArrayAlign)this.alignments.get(pad.cellname);
                if (aa == null) {
                    this.err("No port alignment for cell " + pad.cellname);
                    continue;
                }
                int gapx = 0;
                int gapy = 0;
                double centerX = 0.0;
                double centerY = 0.0;
                if (lastni != null) {
                    ArrayAlign lastaa = (ArrayAlign)this.alignments.get(lastpadname);
                    PortProto pp = lastni.getProto().findPortProto(lastaa.outport);
                    if (pp == null) {
                        this.err("no port called '" + lastaa.outport + "' on cell" + lastni.describe());
                        continue;
                    }
                    Poly poly = lastni.findPortInstFromProto(pp).getPoly();
                    centerX = poly.getCenterX();
                    centerY = poly.getCenterY();
                }
                if ((ni = NodeInst.makeInstance(cell, pointCenter = new Point2D.Double(centerX, centerY), cell.getDefWidth(), cell.getDefHeight(), this.angle, framecell, null)) == null) {
                    this.err("problem creating" + cell.describe() + " instance");
                    continue;
                }
                if (lastni != null) {
                    switch (this.angle) {
                        case 0: {
                            gapx = pad.gap;
                            gapy = 0;
                            break;
                        }
                        case 900: {
                            gapx = 0;
                            gapy = pad.gap;
                            break;
                        }
                        case 1800: {
                            gapx = -pad.gap;
                            gapy = 0;
                            break;
                        }
                        case 2700: {
                            gapx = 0;
                            gapy = -pad.gap;
                        }
                    }
                    PortProto inport = cell.findPortProto(aa.inport);
                    if (inport == null) {
                        this.err("no port called '" + aa.inport + "' on cell " + cell.describe());
                        continue;
                    }
                    Poly poly = ni.findPortInstFromProto(inport).getPoly();
                    double tempx = centerX - poly.getCenterX() - (double)gapx;
                    double tempy = centerY - poly.getCenterY() - (double)gapy;
                    ni.modifyInstance(tempx, tempy, 0.0, 0.0, 0);
                }
                if (pad.exportsname != null && (pe = (PadExports)this.exports.get(pad.cellname)) != null) {
                    PortProto pppad = cell.findPortProto(pe.padname);
                    if (pppad == null) {
                        this.err("no port called '" + pe.padname + "' on Cell " + cell.noLibDescribe());
                    } else if ((pppad = Export.newInstance(framecell, ni.findPortInstFromProto(pppad), pad.exportsname)) == null) {
                        this.err("Creating export " + pad.exportsname);
                    } else {
                        TextDescriptor td = pppad.getTextDescriptor();
                        td.setAbsSize(14);
                        padPorts.add(pppad);
                    }
                    if (pe.corename != null) {
                        PortProto ppcore = cell.findPortProto(pe.corename);
                        if (ppcore == null) {
                            this.err("no port called '" + pe.corename + "' on Cell " + cell.noLibDescribe());
                        } else if ((ppcore = Export.newInstance(framecell, ni.findPortInstFromProto(ppcore), "core_" + pad.exportsname)) == null) {
                            this.err("Creating export core_" + pad.exportsname);
                        } else {
                            TextDescriptor td = ppcore.getTextDescriptor();
                            td.setAbsSize(14);
                            corePorts.add(ppcore);
                        }
                    } else {
                        corePorts.add(null);
                    }
                }
                lastni = ni;
                lastpadname = pad.cellname;
                pad.ni = ni;
            }
            WindowFrame frame = WindowFrame.createEditWindow(framecell);
            EditMenu.selectAllCommand();
            AutoStitch.autoStitch(true, true);
            if (this.corename != null) {
                Cell corenp;
                String corenameview = this.corename;
                if (view != null) {
                    corenameview = this.corename + "{" + view.getAbbreviation() + "}";
                }
                if ((corenp = (Cell)NodeProto.findNodeProto(corenameview)) == null) {
                    System.out.println("Line " + this.lineno + ": cannot find core cell " + corenameview);
                } else {
                    Rectangle2D bounds = framecell.getBounds();
                    Point2D.Double center = new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
                    EditWindow.gridAlign(center);
                    SizeOffset so = corenp.getProtoSizeOffset();
                    NodeInst ni = NodeInst.makeInstance(corenp, center, corenp.getDefWidth(), corenp.getDefHeight(), 0, framecell, null);
                    Iterator ocit = this.orderedCommands.iterator();
                    while (ocit.hasNext()) {
                        Object obj = ocit.next();
                        if (!(obj instanceof PlacePad)) continue;
                        PlacePad pad = (PlacePad)obj;
                        Iterator it2 = pad.associations.iterator();
                        while (it2.hasNext()) {
                            PortAssociate pa = (PortAssociate)it2.next();
                            if (pad.ni == null) continue;
                            PortProto corepp = corenp.findPortProto(pa.assocname);
                            PortInst pi2 = pad.ni.findPortInst(pa.portname);
                            PortInst pi1 = ni.findPortInstFromProto(corepp);
                            PrimitiveArc ap = Generic.tech.unrouted_arc;
                            ArcInst ai = ArcInst.newInstance(ap, ap.getDefaultWidth(), pi1, pi2, null);
                        }
                    }
                }
            }
            frame.getContent().fillScreen();
            if (view == View.ICON) {
                double yBBPos;
                double xBBPos;
                double yPos;
                double xPos;
                double leadLength = User.getIconGenLeadLength();
                double leadSpacing = User.getIconGenLeadSpacing();
                String iconCellName = framecell.getName() + "{ic}";
                Cell iconCell = Cell.makeInstance(Library.getCurrent(), iconCellName);
                if (iconCell == null) {
                    JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot create Icon cell " + iconCellName, "Icon creation failed", 0);
                    return;
                }
                iconCell.setWantExpanded();
                double ySize = (double)Math.max(Math.max(padPorts.size(), corePorts.size()), 5) * leadSpacing;
                double xSize = 3.0 * leadSpacing;
                NodeInst bbNi = null;
                if (User.isIconGenDrawBody()) {
                    bbNi = NodeInst.newInstance(Artwork.tech.openedThickerPolygonNode, new Point2D.Double(0.0, 0.0), xSize, ySize, 0, iconCell, null);
                    if (bbNi == null) {
                        return;
                    }
                    bbNi.newVar(Artwork.ART_COLOR, (Object)new Integer(10));
                    Point2D.Double[] points = new Point2D.Double[]{new Point2D.Double(-0.5 * xSize, -0.5 * ySize), new Point2D.Double(-0.5 * xSize, 0.5 * ySize), new Point2D.Double(0.5 * xSize, 0.5 * ySize), new Point2D.Double(0.5 * xSize, -0.5 * ySize), new Point2D.Double(-0.5 * xSize, -0.5 * ySize)};
                    bbNi.newVar(NodeInst.TRACE, (Object)points);
                    Variable var = bbNi.newVar(Schematics.SCHEM_FUNCTION, (Object)framecell.getName());
                    if (var != null) {
                        var.setDisplay(true);
                    }
                }
                int total = 0;
                int leftSide = padPorts.size();
                int rightSide = corePorts.size();
                Iterator it3 = padPorts.iterator();
                while (it3.hasNext()) {
                    Export pp = (Export)it3.next();
                    if (pp.isBodyOnly()) continue;
                    double spacing = leadSpacing;
                    xPos = 0.0;
                    yPos = 0.0;
                    xBBPos = 0.0;
                    yBBPos = 0.0;
                    xBBPos = -xSize / 2.0;
                    xPos = xBBPos - leadLength;
                    if (leftSide * 2 < rightSide) {
                        spacing = leadSpacing * 2.0;
                    }
                    if (!CircuitChanges.makeIconExport(pp, 0, xPos, yPos, xBBPos, yBBPos = (yPos = ySize / 2.0 - ((ySize - (double)(leftSide - 1) * spacing) / 2.0 + (double)total * spacing)), iconCell)) continue;
                    ++total;
                }
                total = 0;
                it3 = corePorts.iterator();
                while (it3.hasNext()) {
                    Export pp = (Export)it3.next();
                    if (pp == null) {
                        ++total;
                        continue;
                    }
                    if (pp.isBodyOnly()) continue;
                    double spacing = leadSpacing;
                    xPos = 0.0;
                    yPos = 0.0;
                    xBBPos = 0.0;
                    yBBPos = 0.0;
                    xBBPos = xSize / 2.0;
                    xPos = xBBPos + leadLength;
                    if (rightSide * 2 < leftSide) {
                        spacing = leadSpacing * 2.0;
                    }
                    if (!CircuitChanges.makeIconExport(pp, 1, xPos, yPos, xBBPos, yBBPos = (yPos = ySize / 2.0 - ((ySize - (double)(rightSide - 1) * spacing) / 2.0 + (double)total * spacing)), iconCell)) continue;
                    ++total;
                }
                if (!User.isIconGenDrawBody() && !User.isIconGenDrawLeads() && User.isPlaceCellCenter() && total <= 1) {
                    NodeInst.newInstance(Generic.tech.invisiblePinNode, new Point2D.Double(0.0, 0.0), xSize, ySize, 0, iconCell, null);
                }
                int exampleLocation = User.getIconGenInstanceLocation();
                Point2D.Double iconPos = new Point2D.Double(0.0, 0.0);
                Rectangle2D cellBounds = framecell.getBounds();
                Rectangle2D iconBounds = iconCell.getBounds();
                double halfWidth = iconBounds.getWidth() / 2.0;
                double halfHeight = iconBounds.getHeight() / 2.0;
                switch (exampleLocation) {
                    case 0: {
                        ((Point2D)iconPos).setLocation(cellBounds.getMaxX() + halfWidth, cellBounds.getMaxY() + halfHeight);
                        break;
                    }
                    case 1: {
                        ((Point2D)iconPos).setLocation(cellBounds.getMinX() - halfWidth, cellBounds.getMaxY() + halfHeight);
                        break;
                    }
                    case 2: {
                        ((Point2D)iconPos).setLocation(cellBounds.getMaxX() + halfWidth, cellBounds.getMinY() - halfHeight);
                        break;
                    }
                    case 3: {
                        ((Point2D)iconPos).setLocation(cellBounds.getMinX() - halfWidth, cellBounds.getMinY() - halfHeight);
                    }
                }
                EditWindow.gridAlign(iconPos);
                double px = iconCell.getBounds().getWidth();
                double py = iconCell.getBounds().getHeight();
                NodeInst ni = NodeInst.makeInstance(iconCell, iconPos, px, py, 0, framecell, null);
            }
        }
    }

    public static class PortAssociate {
        boolean export;
        String portname;
        String assocname;
    }

    public static class Rotation {
        int angle;
    }

    public static class PlacePad {
        int lineno;
        String cellname;
        String exportsname;
        int gap;
        NodeInst ni;
        List associations;
    }

    public static class PadExports {
        int lineno;
        String cellname;
        String padname;
        String corename;
    }

    public static class ArrayAlign {
        int lineno;
        String cellname;
        String inport;
        String outport;
    }
}

