/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.geometry.Dimension2D;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.drc.Quick;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.Clipboard;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.MeasureListener;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class Array
extends EDialog {
    private static final int SPACING_EDGE = 1;
    private static final int SPACING_CENTER = 2;
    private static final int SPACING_CHARACTERISTIC = 3;
    private static final int SPACING_MEASURED = 4;
    private static int lastXRepeat = 1;
    private static int lastYRepeat = 1;
    private static double lastXDistance = 0.0;
    private static double lastYDistance = 0.0;
    private static boolean lastXFlip = false;
    private static boolean lastYFlip = false;
    private static boolean lastXStagger = false;
    private static boolean lastYStagger = false;
    private static boolean lastXCenter = false;
    private static boolean lastYCenter = false;
    private static boolean lastLinearDiagonal = false;
    private static boolean lastAddNames = false;
    private static boolean lastDRCGood = false;
    private static boolean lastTranspose = false;
    private static int lastSpacingType = 1;
    private double spacingOverX;
    private double spacingOverY;
    private double spacingCenterlineX;
    private double spacingCenterlineY;
    private double spacingCharacteristicX;
    private double spacingCharacteristicY;
    private double spacingMeasuredX;
    private double spacingMeasuredY;
    private HashMap selected;
    private Rectangle2D bounds;
    private JButton cancel;
    private JCheckBox centerXAboutOriginal;
    private JCheckBox centerYAboutOriginal;
    private JCheckBox flipAlternateColumns;
    private JCheckBox flipAlternateRows;
    private JCheckBox generateArrayIndices;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JSeparator jSeparator1;
    private JCheckBox linearDiagonalArray;
    private JButton ok;
    private JCheckBox onlyDRCCorrect;
    private JRadioButton spaceByCenterlineDistance;
    private JRadioButton spaceByCharacteristicSpacing;
    private JRadioButton spaceByEdgeOverlap;
    private JRadioButton spaceByMeasuredDistance;
    private ButtonGroup spacing;
    private JCheckBox staggerAlternateColumns;
    private JCheckBox staggerAlternateRows;
    private JCheckBox transposePlacement;
    private JLabel xOverlapLabel;
    private JTextField xRepeat;
    private JTextField xSpacing;
    private JLabel yOverlapLabel;
    private JTextField yRepeat;
    private JTextField ySpacing;
    static /* synthetic */ Class class$com$sun$electric$database$topology$NodeInst;
    static /* synthetic */ Class class$com$sun$electric$database$topology$ArcInst;

    public static void showArrayDialog() {
        List highs = Highlight.getHighlighted(true, true);
        if (highs.size() == 0) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Select some objects before arraying them.");
            return;
        }
        Array dialog = new Array((Frame)TopLevel.getCurrentJFrame(), true);
        dialog.setVisible(true);
    }

    private Array(Frame parent, boolean modal) {
        super(parent, modal);
        Dimension2D dim;
        ElectricObject eObj;
        this.initComponents();
        this.getRootPane().setDefaultButton(this.ok);
        this.xRepeat.setText(Integer.toString(lastXRepeat));
        this.flipAlternateColumns.setSelected(lastXFlip);
        this.staggerAlternateColumns.setSelected(lastXStagger);
        this.centerXAboutOriginal.setSelected(lastXCenter);
        this.yRepeat.setText(Integer.toString(lastYRepeat));
        this.flipAlternateRows.setSelected(lastYFlip);
        this.staggerAlternateRows.setSelected(lastYStagger);
        this.centerYAboutOriginal.setSelected(lastYCenter);
        this.onlyDRCCorrect.setEnabled(false);
        List highs = Highlight.getHighlighted(true, true);
        if (highs.size() == 1 && (eObj = (ElectricObject)highs.get(0)) instanceof NodeInst) {
            this.onlyDRCCorrect.setEnabled(true);
        }
        this.linearDiagonalArray.setSelected(lastLinearDiagonal);
        this.generateArrayIndices.setSelected(lastAddNames);
        this.onlyDRCCorrect.setSelected(lastDRCGood);
        this.transposePlacement.setSelected(lastTranspose);
        this.spacingCharacteristicY = 0.0;
        this.spacingCharacteristicX = 0.0;
        boolean haveChar = false;
        Iterator it = highs.iterator();
        while (it.hasNext()) {
            Cell subCell;
            Dimension2D spacing;
            NodeInst ni;
            ElectricObject eObj2 = (ElectricObject)it.next();
            if (!(eObj2 instanceof NodeInst) || !((ni = (NodeInst)eObj2).getProto() instanceof Cell) || (spacing = (subCell = (Cell)ni.getProto()).getCharacteristicSpacing()) == null) continue;
            double thisDistX = spacing.getWidth();
            double thisDistY = spacing.getHeight();
            if (ni.isMirroredAboutXAxis() ^ ni.isMirroredAboutYAxis()) {
                double swap = thisDistX;
                thisDistX = thisDistY;
                thisDistY = swap;
            }
            if (haveChar && (this.spacingCharacteristicX != thisDistX || this.spacingCharacteristicY != thisDistY)) {
                haveChar = false;
                break;
            }
            this.spacingCharacteristicX = thisDistX;
            this.spacingCharacteristicY = thisDistY;
            haveChar = true;
        }
        this.spaceByCharacteristicSpacing.setEnabled(haveChar);
        if (haveChar) {
            if (lastSpacingType == 3) {
                lastXDistance = this.spacingCharacteristicX;
                lastYDistance = this.spacingCharacteristicY;
            }
        } else if (lastSpacingType == 3) {
            lastSpacingType = 1;
            lastYDistance = 0.0;
            lastXDistance = 0.0;
        }
        if ((dim = MeasureListener.getLastMeasuredDistance()).getWidth() > 0.0 || dim.getHeight() > 0.0) {
            this.spaceByMeasuredDistance.setEnabled(true);
            this.spacingMeasuredX = dim.getWidth();
            this.spacingMeasuredY = dim.getHeight();
            if (lastSpacingType == 4) {
                lastXDistance = this.spacingMeasuredX;
                lastYDistance = this.spacingMeasuredY;
            }
        } else {
            this.spaceByMeasuredDistance.setEnabled(false);
            if (lastSpacingType == 4) {
                lastSpacingType = 1;
                lastYDistance = 0.0;
                lastXDistance = 0.0;
            }
        }
        this.xSpacing.setText(Double.toString(lastXDistance));
        this.ySpacing.setText(Double.toString(lastYDistance));
        switch (lastSpacingType) {
            case 1: {
                this.spaceByEdgeOverlap.setSelected(true);
                break;
            }
            case 2: {
                this.spaceByCenterlineDistance.setSelected(true);
                break;
            }
            case 3: {
                this.spaceByCharacteristicSpacing.setSelected(true);
                break;
            }
            case 4: {
                this.spaceByMeasuredDistance.setSelected(true);
            }
        }
        if (lastSpacingType == 1) {
            this.xOverlapLabel.setText("X edge overlap:");
            this.yOverlapLabel.setText("Y edge overlap:");
        } else {
            this.xOverlapLabel.setText("X centerline distance:");
            this.yOverlapLabel.setText("Y centerline distance:");
        }
        this.selected = new HashMap();
        Iterator it2 = highs.iterator();
        while (it2.hasNext()) {
            ElectricObject eObj3 = (ElectricObject)it2.next();
            if (eObj3 instanceof NodeInst) {
                this.selected.put(eObj3, eObj3);
                continue;
            }
            if (!(eObj3 instanceof ArcInst)) continue;
            ArcInst ai = (ArcInst)eObj3;
            NodeInst niHead = ai.getHead().getPortInst().getNodeInst();
            this.selected.put(niHead, niHead);
            NodeInst niTail = ai.getTail().getPortInst().getNodeInst();
            this.selected.put(niTail, niTail);
            this.selected.put(ai, ai);
        }
        boolean first = true;
        this.bounds = new Rectangle2D.Double();
        Iterator it3 = this.selected.keySet().iterator();
        while (it3.hasNext()) {
            Geometric geom = (Geometric)it3.next();
            if (first) {
                this.bounds.setRect(geom.getBounds());
                first = false;
                continue;
            }
            Rectangle2D.union(this.bounds, geom.getBounds(), this.bounds);
        }
        this.spacingCenterlineX = this.bounds.getWidth();
        this.spacingCenterlineY = this.bounds.getHeight();
        this.spacingOverY = 0.0;
        this.spacingOverX = 0.0;
        this.spaceByEdgeOverlap.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Array.this.newSpacingSelected();
            }
        });
        this.spaceByCenterlineDistance.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Array.this.newSpacingSelected();
            }
        });
        this.spaceByCharacteristicSpacing.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Array.this.newSpacingSelected();
            }
        });
        this.spaceByMeasuredDistance.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Array.this.newSpacingSelected();
            }
        });
    }

    protected void escapePressed() {
        this.cancel(null);
    }

    private void newSpacingSelected() {
        double x = TextUtils.atof(this.xSpacing.getText());
        double y = TextUtils.atof(this.ySpacing.getText());
        switch (lastSpacingType) {
            case 1: {
                this.spacingOverX = x;
                this.spacingOverY = y;
                break;
            }
            case 2: {
                this.spacingCenterlineX = x;
                this.spacingCenterlineY = y;
            }
        }
        if (this.spaceByEdgeOverlap.isSelected()) {
            lastSpacingType = 1;
        } else if (this.spaceByCenterlineDistance.isSelected()) {
            lastSpacingType = 2;
        } else if (this.spaceByCharacteristicSpacing.isSelected()) {
            lastSpacingType = 3;
        } else if (this.spaceByMeasuredDistance.isSelected()) {
            lastSpacingType = 4;
        }
        if (lastSpacingType == 1) {
            this.xOverlapLabel.setText("X edge overlap:");
            this.yOverlapLabel.setText("Y edge overlap:");
        } else {
            this.xOverlapLabel.setText("X centerline distance:");
            this.yOverlapLabel.setText("Y centerline distance:");
        }
        switch (lastSpacingType) {
            case 1: {
                x = this.spacingOverX;
                y = this.spacingOverY;
                break;
            }
            case 2: {
                x = this.spacingCenterlineX;
                y = this.spacingCenterlineY;
                break;
            }
            case 3: {
                x = this.spacingCharacteristicX;
                y = this.spacingCharacteristicY;
                break;
            }
            case 4: {
                x = this.spacingMeasuredX;
                y = this.spacingMeasuredY;
            }
        }
        this.xSpacing.setText(Double.toString(x));
        this.ySpacing.setText(Double.toString(y));
    }

    private void rememberFields() {
        lastXRepeat = TextUtils.atoi(this.xRepeat.getText());
        lastXFlip = this.flipAlternateColumns.isSelected();
        lastXStagger = this.staggerAlternateColumns.isSelected();
        lastXCenter = this.centerXAboutOriginal.isSelected();
        lastYRepeat = TextUtils.atoi(this.yRepeat.getText());
        lastYFlip = this.flipAlternateRows.isSelected();
        lastYStagger = this.staggerAlternateRows.isSelected();
        lastYCenter = this.centerYAboutOriginal.isSelected();
        lastXDistance = TextUtils.atof(this.xSpacing.getText());
        lastYDistance = TextUtils.atof(this.ySpacing.getText());
        lastLinearDiagonal = this.linearDiagonalArray.isSelected();
        lastAddNames = this.generateArrayIndices.isSelected();
        lastDRCGood = this.onlyDRCCorrect.isSelected();
        lastTranspose = this.transposePlacement.isSelected();
    }

    private void makeArray() {
        ArrayStuff job = new ArrayStuff(this);
    }

    private void initComponents() {
        this.spacing = new ButtonGroup();
        this.cancel = new JButton();
        this.ok = new JButton();
        this.jLabel1 = new JLabel();
        this.xRepeat = new JTextField();
        this.flipAlternateColumns = new JCheckBox();
        this.staggerAlternateColumns = new JCheckBox();
        this.centerXAboutOriginal = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.yRepeat = new JTextField();
        this.flipAlternateRows = new JCheckBox();
        this.staggerAlternateRows = new JCheckBox();
        this.centerYAboutOriginal = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.xOverlapLabel = new JLabel();
        this.xSpacing = new JTextField();
        this.spaceByEdgeOverlap = new JRadioButton();
        this.spaceByCenterlineDistance = new JRadioButton();
        this.yOverlapLabel = new JLabel();
        this.ySpacing = new JTextField();
        this.spaceByCharacteristicSpacing = new JRadioButton();
        this.spaceByMeasuredDistance = new JRadioButton();
        this.linearDiagonalArray = new JCheckBox();
        this.generateArrayIndices = new JCheckBox();
        this.onlyDRCCorrect = new JCheckBox();
        this.transposePlacement = new JCheckBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Array");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Array.this.closeDialog(evt);
            }
        });
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Array.this.cancel(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.cancel, gridBagConstraints);
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Array.this.ok(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        this.jLabel1.setText("X repeat factor:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.xRepeat.setColumns(6);
        this.xRepeat.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.xRepeat, gridBagConstraints);
        this.flipAlternateColumns.setText("Flip alternate columns");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.getContentPane().add((Component)this.flipAlternateColumns, gridBagConstraints);
        this.staggerAlternateColumns.setText("Stagger alternate columns");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.staggerAlternateColumns, gridBagConstraints);
        this.centerXAboutOriginal.setText("Center about original");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.getContentPane().add((Component)this.centerXAboutOriginal, gridBagConstraints);
        this.jLabel2.setText("Y repeat factor:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.yRepeat.setColumns(6);
        this.yRepeat.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.yRepeat, gridBagConstraints);
        this.flipAlternateRows.setText("Flip alternate rows");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.getContentPane().add((Component)this.flipAlternateRows, gridBagConstraints);
        this.staggerAlternateRows.setText("Stagger alternate rows");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.staggerAlternateRows, gridBagConstraints);
        this.centerYAboutOriginal.setText("Center about original");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.getContentPane().add((Component)this.centerYAboutOriginal, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.xOverlapLabel.setText("X edge overlap:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.xOverlapLabel, gridBagConstraints);
        this.xSpacing.setColumns(6);
        this.xSpacing.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.xSpacing, gridBagConstraints);
        this.spaceByEdgeOverlap.setText("Space by edge overlap");
        this.spacing.add(this.spaceByEdgeOverlap);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.spaceByEdgeOverlap, gridBagConstraints);
        this.spaceByCenterlineDistance.setText("Space by centerline distance");
        this.spacing.add(this.spaceByCenterlineDistance);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.spaceByCenterlineDistance, gridBagConstraints);
        this.yOverlapLabel.setText("Y edge overlap:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.yOverlapLabel, gridBagConstraints);
        this.ySpacing.setColumns(6);
        this.ySpacing.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ySpacing, gridBagConstraints);
        this.spaceByCharacteristicSpacing.setText("Space by characteristic spacing");
        this.spacing.add(this.spaceByCharacteristicSpacing);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.spaceByCharacteristicSpacing, gridBagConstraints);
        this.spaceByMeasuredDistance.setText("Space by last measured distance");
        this.spacing.add(this.spaceByMeasuredDistance);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.spaceByMeasuredDistance, gridBagConstraints);
        this.linearDiagonalArray.setText("Linear diagonal array");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.getContentPane().add((Component)this.linearDiagonalArray, gridBagConstraints);
        this.generateArrayIndices.setText("Generate array indices");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.getContentPane().add((Component)this.generateArrayIndices, gridBagConstraints);
        this.onlyDRCCorrect.setText("Only place entries that are DRC correct");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.onlyDRCCorrect, gridBagConstraints);
        this.transposePlacement.setText("Transpose placement ordering");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.transposePlacement, gridBagConstraints);
        this.pack();
    }

    private void cancel(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void ok(ActionEvent evt) {
        this.rememberFields();
        this.makeArray();
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.rememberFields();
        this.setVisible(false);
        this.dispose();
    }

    private static class ArrayStuff
    extends Job {
        Array dialog;

        protected ArrayStuff(Array dialog) {
            super("Make Array", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.dialog = dialog;
            this.startJob();
        }

        public boolean doIt() {
            Cell cell = null;
            Iterator it = this.dialog.selected.keySet().iterator();
            while (it.hasNext()) {
                Geometric geom = (Geometric)it.next();
                cell = geom.getParent();
                if (!(geom instanceof NodeInst ? CircuitChanges.cantEdit(cell, (NodeInst)geom, true) : CircuitChanges.cantEdit(cell, null, true))) continue;
                return false;
            }
            if (lastXRepeat <= 1 && lastYRepeat <= 1) {
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "One dimension of the array must be greater than 1");
                return false;
            }
            if (lastLinearDiagonal && lastXRepeat != 1 && lastYRepeat != 1) {
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Diagonal arrays need one dimension to be 1");
                return false;
            }
            ArrayList<Geometric> nodeList = new ArrayList<Geometric>();
            ArrayList<Geometric> arcList = new ArrayList<Geometric>();
            Iterator it2 = this.dialog.selected.keySet().iterator();
            while (it2.hasNext()) {
                Geometric geom = (Geometric)it2.next();
                cell = geom.getParent();
                if (geom instanceof NodeInst) {
                    nodeList.add(geom);
                    continue;
                }
                arcList.add(geom);
            }
            Collections.sort(nodeList, new GeometricsByName());
            Collections.sort(arcList, new GeometricsByName());
            double xOverlap = lastXDistance;
            double yOverlap = lastYDistance;
            if (lastSpacingType == 1) {
                xOverlap = this.dialog.bounds.getWidth() - lastXDistance;
                yOverlap = this.dialog.bounds.getHeight() - lastYDistance;
            }
            double cX = this.dialog.bounds.getCenterX();
            double cY = this.dialog.bounds.getCenterY();
            Geometric[] geomsToCheck = null;
            boolean[] validity = null;
            int checkNodeCount = 0;
            if (lastDRCGood) {
                geomsToCheck = new NodeInst[lastXRepeat * lastYRepeat];
                validity = new boolean[lastXRepeat * lastYRepeat];
                if (nodeList.size() == 1) {
                    geomsToCheck[checkNodeCount++] = (NodeInst)nodeList.get(0);
                }
            }
            int originalX = 0;
            int originalY = 0;
            int total = lastYRepeat * lastXRepeat;
            for (int index = 0; index < total; ++index) {
                Geometric geom;
                int x = index % lastXRepeat;
                int y = index / lastXRepeat;
                if (lastTranspose) {
                    y = index % lastYRepeat;
                    x = index / lastYRepeat;
                }
                int xIndex = x;
                int yIndex = y;
                if (lastXCenter) {
                    xIndex = x - (lastXRepeat - 1) / 2;
                }
                if (lastYCenter) {
                    yIndex = y - (lastYRepeat - 1) / 2;
                }
                if (xIndex == 0 && yIndex == 0) {
                    originalX = x;
                    originalY = y;
                    continue;
                }
                ArrayList<Export> queuedExports = new ArrayList<Export>();
                boolean firstNode = true;
                Iterator it3 = this.dialog.selected.keySet().iterator();
                while (it3.hasNext()) {
                    NodeInst newNi;
                    geom = (Geometric)it3.next();
                    if (!(geom instanceof NodeInst)) continue;
                    NodeInst ni = (NodeInst)geom;
                    double xPos = cX + xOverlap * (double)xIndex;
                    if (lastLinearDiagonal && lastXRepeat == 1) {
                        xPos = cX + xOverlap * (double)yIndex;
                    }
                    double yPos = cY + yOverlap * (double)yIndex;
                    if (lastLinearDiagonal && lastYRepeat == 1) {
                        yPos = cY + yOverlap * (double)xIndex;
                    }
                    double xOff = ni.getAnchorCenterX() - cX;
                    double yOff = ni.getAnchorCenterY() - cY;
                    if ((xIndex & 1) != 0 && lastXStagger) {
                        yPos += yOverlap / 2.0;
                    }
                    if ((yIndex & 1) != 0 && lastYStagger) {
                        xPos += xOverlap / 2.0;
                    }
                    int ro = ni.getAngle();
                    double sx = ni.getXSizeWithMirror();
                    double sy = ni.getYSizeWithMirror();
                    if ((xIndex & 1) != 0 && lastXFlip) {
                        sx = -sx;
                        xOff = -xOff;
                    }
                    if ((yIndex & 1) != 0 && lastYFlip) {
                        sy = -sy;
                        yOff = -yOff;
                    }
                    if ((newNi = NodeInst.makeInstance(ni.getProto(), new Point2D.Double(xPos += xOff, yPos += yOff), sx, sy, ro, cell, null)) == null) {
                        return false;
                    }
                    newNi.setProtoTextDescriptor(ni.getProtoTextDescriptor());
                    newNi.setNameTextDescriptor(ni.getNameTextDescriptor());
                    if (ni.isExpanded()) {
                        newNi.setExpanded();
                    } else {
                        newNi.clearExpanded();
                    }
                    if (ni.isHardSelect()) {
                        newNi.setHardSelect();
                    } else {
                        newNi.clearHardSelect();
                    }
                    newNi.setTechSpecific(ni.getTechSpecific());
                    newNi.copyVars(ni);
                    if (lastAddNames) {
                        this.setNewName(newNi, x, y);
                    } else {
                        String nodeName = ni.getName();
                        if (nodeName != null) {
                            newNi.setName(ElectricObject.uniqueObjectName(nodeName, cell, class$com$sun$electric$database$topology$NodeInst == null ? Array.class$("com.sun.electric.database.topology.NodeInst") : class$com$sun$electric$database$topology$NodeInst));
                        }
                    }
                    if (User.isDupCopiesExports()) {
                        Iterator eit = ni.getExports();
                        while (eit.hasNext()) {
                            Export pp = (Export)eit.next();
                            queuedExports.add(pp);
                        }
                    }
                    ni.setTempObj(newNi);
                    if (!lastDRCGood || !firstNode) continue;
                    geomsToCheck[checkNodeCount++] = newNi;
                    firstNode = false;
                }
                Clipboard.createQueuedExports(queuedExports);
                it3 = this.dialog.selected.keySet().iterator();
                while (it3.hasNext()) {
                    geom = (Geometric)it3.next();
                    if (!(geom instanceof ArcInst)) continue;
                    ArcInst ai = (ArcInst)geom;
                    double cX0 = ai.getHead().getPortInst().getNodeInst().getAnchorCenterX();
                    double cY0 = ai.getHead().getPortInst().getNodeInst().getAnchorCenterY();
                    double xOff0 = ai.getHead().getLocation().getX() - cX0;
                    double yOff0 = ai.getHead().getLocation().getY() - cY0;
                    double cX1 = ai.getTail().getPortInst().getNodeInst().getAnchorCenterX();
                    double cY1 = ai.getTail().getPortInst().getNodeInst().getAnchorCenterY();
                    double xOff1 = ai.getTail().getLocation().getX() - cX1;
                    double yOff1 = ai.getTail().getLocation().getY() - cY1;
                    if ((xIndex & 1) != 0 && lastXFlip) {
                        xOff0 = -xOff0;
                        xOff1 = -xOff1;
                    }
                    if ((yIndex & 1) != 0 && lastYFlip) {
                        yOff0 = -yOff0;
                        yOff1 = -yOff1;
                    }
                    NodeInst ni0 = (NodeInst)ai.getHead().getPortInst().getNodeInst().getTempObj();
                    NodeInst ni1 = (NodeInst)ai.getTail().getPortInst().getNodeInst().getTempObj();
                    cX0 = ni0.getAnchorCenterX();
                    cY0 = ni0.getAnchorCenterY();
                    cX1 = ni1.getAnchorCenterX();
                    cY1 = ni1.getAnchorCenterY();
                    PortInst pi0 = ni0.findPortInstFromProto(ai.getHead().getPortInst().getPortProto());
                    PortInst pi1 = ni1.findPortInstFromProto(ai.getTail().getPortInst().getPortProto());
                    ArcInst newAi = ArcInst.makeInstance(ai.getProto(), ai.getWidth(), pi0, new Point2D.Double(cX0 + xOff0, cY0 + yOff0), pi1, new Point2D.Double(cX1 + xOff1, cY1 + yOff1), null);
                    if (newAi == null) {
                        return false;
                    }
                    newAi.copyVars(ai);
                    if (lastAddNames) {
                        this.setNewName(newAi, x, y);
                        continue;
                    }
                    String arcName = ai.getName();
                    if (arcName == null) continue;
                    newAi.setName(ElectricObject.uniqueObjectName(arcName, cell, class$com$sun$electric$database$topology$ArcInst == null ? Array.class$("com.sun.electric.database.topology.ArcInst") : class$com$sun$electric$database$topology$ArcInst));
                }
            }
            if (lastAddNames) {
                Iterator it4 = this.dialog.selected.keySet().iterator();
                while (it4.hasNext()) {
                    Geometric geom = (Geometric)it4.next();
                    this.setNewName(geom, originalX, originalY);
                }
            }
            if (lastDRCGood) {
                Quick.checkDesignRules(cell, checkNodeCount, geomsToCheck, validity, false);
                for (int i = 1; i < checkNodeCount; ++i) {
                    if (validity[i]) continue;
                    ((NodeInst)geomsToCheck[i]).kill();
                }
            }
            return true;
        }

        private void setNewName(Geometric geom, int x, int y) {
            String objName = "";
            String geomName = geom.getName();
            if (geomName != null && !geomName.equals("0") && !geomName.equals("0-0")) {
                objName = geomName.toString();
            }
            String totalName = objName + x + "-" + y;
            if (lastXRepeat <= 1 || lastYRepeat <= 1) {
                totalName = objName + (x + y);
            }
            geom.setName(totalName);
            if (geom instanceof NodeInst && ((NodeInst)geom).getProto() instanceof Cell) {
                NodeInst ni = (NodeInst)geom;
                TextDescriptor td = ni.getNameTextDescriptor();
                td.setOff(0.0, ni.getYSize() / 4.0);
            }
        }

        static class GeometricsByName
        implements Comparator {
            GeometricsByName() {
            }

            public int compare(Object o1, Object o2) {
                Geometric g1 = (Geometric)o1;
                Geometric g2 = (Geometric)o2;
                String name1 = g1.getName();
                String name2 = g2.getName();
                if (name1 == null || name2 == null) {
                    return 0;
                }
                return name1.compareToIgnoreCase(name2);
            }
        }
    }
}

