/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellContents;
import com.sun.electric.database.DatabaseChangeThread;
import com.sun.electric.database.DatabaseThread;
import com.sun.electric.database.ImmutableCell;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.NodeInst_;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.text.Name;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.Iterator;

public class Cell_ {
    final int id;
    final DatabaseThread thread;
    String name;
    ImmutableNodeInst[] nodes;
    SoftReference contentsRef;
    static final /* synthetic */ boolean $assertionsDisabled;

    Cell_(int id, ImmutableCell d) {
        if (!($assertionsDisabled || id >= 0 && d != null)) {
            throw new AssertionError();
        }
        DatabaseThread thread = (DatabaseThread)Thread.currentThread();
        this.id = id;
        this.thread = thread;
        if (!$assertionsDisabled && thread.cells[id] != null) {
            throw new AssertionError();
        }
        thread.cells[id] = this;
        this.name = d.name;
        this.nodes = (ImmutableNodeInst[])d.nodes.clone();
    }

    void unlink() {
        this.nodes = null;
        if (this.contentsRef != null) {
            CellContents contents = (CellContents)this.contentsRef.get();
            if (contents != null) {
                contents.unlink();
            }
            this.contentsRef.clear();
            this.contentsRef = null;
        }
        this.name = null;
        this.thread.cells[this.id] = null;
    }

    public String getName() {
        this.checkAlive();
        return this.name;
    }

    public int getNumNodes() {
        this.checkAlive();
        CellContents contents = this.getContents();
        return contents.orderedNodes.size();
    }

    public Iterator getNodes() {
        this.checkAlive();
        CellContents contents = this.getContents();
        return Collections.unmodifiableCollection(contents.orderedNodes.values()).iterator();
    }

    public static Cell_ newInstance(String name) {
        if (!(Thread.currentThread() instanceof DatabaseChangeThread)) {
            throw new IllegalStateException("Not in DatabaseChangeThread");
        }
        if (name == null) {
            throw new IllegalArgumentException("Cell name is null");
        }
        DatabaseChangeThread thread = (DatabaseChangeThread)Thread.currentThread();
        if (thread.orderedCells.get(name) != null) {
            throw new IllegalArgumentException("Cell " + name + " exists");
        }
        thread.checkChanging();
        int cellId = thread.allocCellId();
        ImmutableCell icell = ImmutableCell.newInstance(name, null);
        if (thread.cells.length <= cellId) {
            Cell_[] newCells = new Cell_[cellId + 1];
            System.arraycopy(thread.cells, 0, newCells, 0, thread.cells.length);
            thread.cells = newCells;
        }
        Cell_ cell = new Cell_(cellId, icell);
        thread.orderedCells.put(name, cell);
        thread.endChanging();
        return cell;
    }

    public static Cell_ findCell(String name) {
        if (!(Thread.currentThread() instanceof DatabaseThread)) {
            throw new IllegalStateException("Not in DatabaseThread");
        }
        DatabaseThread thread = (DatabaseThread)Thread.currentThread();
        if (!thread.valid) {
            throw new IllegalStateException("database invalid");
        }
        if (name == null) {
            return null;
        }
        return (Cell_)thread.orderedCells.get(name);
    }

    public void kill() {
        DatabaseChangeThread thread = this.thread.checkChanging();
        this.unlink();
        thread.endChanging();
    }

    public void setName(String name) {
        DatabaseChangeThread thread = this.thread.checkChanging();
        if (name == null) {
            throw new IllegalArgumentException("Cell name is null");
        }
        if (!this.name.equals(name) && thread.orderedCells.get(name) != null) {
            throw new IllegalArgumentException("Cell " + name + " exists");
        }
        thread.orderedCells.remove(this.name);
        thread.orderedCells.put(name, this);
        this.name = name;
        thread.endChanging();
    }

    public NodeInst_ newNode(Cell_ proto, Name name, EPoint anchor) {
        DatabaseChangeThread thread = this.thread.checkChanging();
        if (name == null) {
            throw new NullPointerException("node name");
        }
        if (proto == null) {
            throw new NullPointerException("proto");
        }
        if (anchor == null) {
            throw new NullPointerException("anchor");
        }
        if (proto.thread != thread || proto.nodes == null) {
            throw new IllegalArgumentException("proto not alive");
        }
        ImmutableNodeInst inode = new ImmutableNodeInst(proto.id, name, 0, null, Orientation.IDENT, anchor, 0.0, 0.0, 0, null);
        int nodeId = thread.allocNodeId(this.id);
        CellContents contents = this.getContents();
        if (!$assertionsDisabled && this.nodes.length != contents.nodes.length) {
            throw new AssertionError();
        }
        if (nodeId >= this.nodes.length) {
            ImmutableNodeInst[] newINodes = new ImmutableNodeInst[nodeId + 1];
            NodeInst_[] newNodes = new NodeInst_[nodeId + 1];
            System.arraycopy(this.nodes, 0, newINodes, 0, this.nodes.length);
            System.arraycopy(contents.nodes, 0, newNodes, 0, contents.nodes.length);
            this.nodes = newINodes;
            contents.nodes = newNodes;
        }
        NodeInst_ node = new NodeInst_(nodeId, contents, inode);
        this.nodes[nodeId] = inode;
        thread.endChanging();
        return null;
    }

    ImmutableCell backup(ImmutableCell oldS) {
        if (oldS == null) {
            return ImmutableCell.newInstance(this.name, this.nodes);
        }
        return oldS.withName(this.name).withNodes(this.nodes);
    }

    void restore(ImmutableCell icell) {
    }

    void recover(ImmutableCell icell) {
        this.name = icell.name;
        this.nodes = (ImmutableNodeInst[])icell.nodes.clone();
    }

    private CellContents getContents() {
        CellContents contents;
        if (this.contentsRef != null && (contents = (CellContents)this.contentsRef.get()) != null) {
            return contents;
        }
        return new CellContents(this);
    }

    public boolean isAlive() {
        return this.nodes != null && this.thread == Thread.currentThread() && this.thread.valid;
    }

    private void checkAlive() {
        this.thread.checkRunning();
        if (this.nodes == null) {
            throw new IllegalStateException("Killed cell");
        }
    }

    private DatabaseChangeThread checkChanging() {
        DatabaseChangeThread thread = this.thread.checkChanging();
        if (this.nodes == null) {
            throw new IllegalStateException("Killed cell");
        }
        return thread;
    }

    void check() {
        CellContents contents;
        if (!$assertionsDisabled && this.nodes == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.name == null) {
            throw new AssertionError();
        }
        if (this.contentsRef != null && (contents = (CellContents)this.contentsRef.get()) != null) {
            contents.check();
            if (!$assertionsDisabled && contents.nodes.length != this.nodes.length) {
                throw new AssertionError();
            }
            for (int i = 0; i < this.nodes.length; ++i) {
                NodeInst_ node = contents.nodes[i];
                if (!$assertionsDisabled && this.nodes[i] != (node != null ? node.d : null)) {
                    throw new AssertionError();
                }
            }
        }
    }

    void checkLinked() {
        if (!$assertionsDisabled && this.thread.cells[this.id] != this) {
            throw new AssertionError();
        }
        this.thread.checkLinked();
    }

    static {
        $assertionsDisabled = !Cell_.class.desiredAssertionStatus();
    }
}

