/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.basic;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.ncc.basic.CellContext;
import com.sun.electric.tool.ncc.basic.CellUsage;
import com.sun.electric.tool.ncc.basic.CompareList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class CompareLists {
    private boolean alreadyCompared(Set compared, CompareList compareList) {
        int num = 0;
        int numComp = 0;
        Iterator it = compareList.iterator();
        while (it.hasNext()) {
            CellContext cc = (CellContext)it.next();
            if (compared.contains(cc)) {
                ++numComp;
            }
            ++num;
        }
        LayoutLib.error(numComp != 0 && numComp != num, "cell group partially processed");
        return numComp > 0;
    }

    private List getCompareLists(CellUsage use1, CellUsage use2) {
        HashSet compared = new HashSet();
        ArrayList<CompareList> compareLists = new ArrayList<CompareList>();
        Iterator it = use1.cellsInReverseTopologicalOrder();
        while (it.hasNext()) {
            Cell cell = (Cell)it.next();
            CompareList compareList = new CompareList(cell, use1, use2);
            if (this.alreadyCompared(compared, compareList) || compareList.empty()) continue;
            Iterator it2 = compareList.iterator();
            while (it2.hasNext()) {
                compared.add(it2.next());
            }
            compareLists.add(compareList);
        }
        return compareLists;
    }

    private List getCompareLists1(CellContext cc1, CellContext cc2) {
        CellUsage use1 = CellUsage.getCellUsage(cc1);
        CellUsage use2 = CellUsage.getCellUsage(cc2);
        return this.getCompareLists(use1, use2);
    }

    public static List getCompareLists(CellContext cc1, CellContext cc2) {
        return new CompareLists().getCompareLists1(cc1, cc2);
    }
}

