/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

class EpicSignal {
    String name;
    int type;
    int lastT;
    int lastV;
    int minV = Integer.MAX_VALUE;
    int maxV = Integer.MIN_VALUE;
    byte[] waveform = new byte[512];
    int len;
    static final int VOLTAGE_TYPE = 1;
    static final int CURRENT_TYPE = 2;
    static final /* synthetic */ boolean $assertionsDisabled;

    EpicSignal() {
    }

    void putEvent(int t, int v) {
        this.putUnsigned(t - this.lastT);
        this.putSigned(v - this.lastV);
        this.lastT = t;
        this.lastV = v;
        this.minV = Math.min(this.minV, v);
        this.maxV = Math.max(this.maxV, v);
    }

    void putUnsigned(int value) {
        if (value < 192) {
            this.ensureCapacity(1);
            this.putByte(value);
        } else if (value < 16128) {
            this.ensureCapacity(2);
            this.putByte(value + 49152 >> 8);
            this.putByte(value);
        } else {
            this.ensureCapacity(5);
            this.putByte(255);
            this.putByte(value >> 24);
            this.putByte(value >> 16);
            this.putByte(value >> 8);
            this.putByte(value);
        }
    }

    void putSigned(int value) {
        if (-96 <= value && value < 96) {
            this.ensureCapacity(1);
            this.putByte(value + 96);
        } else if (-7936 <= value && value < 8192) {
            this.ensureCapacity(2);
            this.putByte(value + 57088 >> 8);
            this.putByte(value);
        } else {
            this.ensureCapacity(5);
            this.putByte(255);
            this.putByte(value >> 24);
            this.putByte(value >> 16);
            this.putByte(value >> 8);
            this.putByte(value);
        }
    }

    int[] getWaveform() {
        int count = 0;
        int i = 0;
        while (i < this.len) {
            int b;
            int l = (b = this.waveform[i++] & 0xFF) < 192 ? 0 : (b < 255 ? 1 : 4);
            i += l;
            b = this.waveform[i++] & 0xFF;
            l = b < 192 ? 0 : (b < 255 ? 1 : 4);
            i += l;
            ++count;
        }
        int[] w = new int[count * 2];
        count = 0;
        int t = 0;
        int v = 0;
        int i2 = 0;
        while (i2 < this.len) {
            int l;
            int b;
            if ((b = this.waveform[i2++] & 0xFF) < 192) {
                l = 0;
            } else if (b < 255) {
                l = 1;
                b -= 192;
            } else {
                l = 4;
            }
            while (l > 0) {
                b = b << 8 | this.waveform[i2++] & 0xFF;
                --l;
            }
            w[count * 2] = t += b;
            if ((b = this.waveform[i2++] & 0xFF) < 192) {
                l = 0;
                b -= 96;
            } else if (b < 255) {
                l = 1;
                b -= 223;
            } else {
                l = 4;
            }
            while (l > 0) {
                b = b << 8 | this.waveform[i2++] & 0xFF;
                --l;
            }
            w[count * 2 + 1] = v += b;
            ++count;
        }
        if (!$assertionsDisabled && count * 2 != w.length) {
            throw new AssertionError();
        }
        return w;
    }

    void putByte(int value) {
        this.waveform[this.len++] = (byte)value;
    }

    void ensureCapacity(int l) {
        if (this.len + l <= this.waveform.length) {
            return;
        }
        byte[] newWaveform = new byte[this.waveform.length * 3 / 2];
        System.arraycopy(this.waveform, 0, newWaveform, 0, this.waveform.length);
        this.waveform = newWaveform;
        if (!$assertionsDisabled && this.len + l > this.waveform.length) {
            throw new AssertionError();
        }
    }

    static {
        $assertionsDisabled = !EpicSignal.class.desiredAssertionStatus();
    }
}

