/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.TransistorSize;
import com.sun.electric.tool.io.output.Output;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class L
extends Output {
    private static final int TRUEPIN = 1;
    private static final int TRANSISTOR = 2;
    private static final int INSTANCE = 3;
    private static final int OTHERNODE = 4;
    private Set cellsSeen;
    private PortInst gateLeft;
    private PortInst gateRight;
    private PortInst activeTop;
    private PortInst activeBottom;

    public static void writeLFile(Output.OutputCellInfo cellJob) {
        L out = new L();
        if (out.openTextOutputStream(cellJob.filePath)) {
            return;
        }
        out.writeLCells(cellJob.cell);
        if (out.closeTextOutputStream()) {
            return;
        }
        System.out.println(cellJob.filePath + " written");
    }

    L() {
    }

    private void writeLCells(Cell cell) {
        this.printWriter.println("L:: TECH ANY");
        this.cellsSeen = new HashSet();
        this.writeLCell(cell);
    }

    private void writeLCell(Cell cell) {
        Iterator it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            if (!(ni.getProto() instanceof Cell) || ni.isIconOfParent()) continue;
            Cell np = (Cell)ni.getProto();
            Cell oNp = np.contentsView();
            if (oNp != null) {
                np = oNp;
            }
            if (this.cellsSeen.contains(np)) continue;
            this.writeLCell(np);
        }
        this.cellsSeen.add(cell);
        this.printWriter.println("");
        if (cell.getView() == View.LAYOUT) {
            this.printWriter.print("LAYOUT ");
        }
        if (cell.isSchematic()) {
            this.printWriter.print("SCHEMATIC ");
        }
        if (cell.isIcon()) {
            this.printWriter.print("ICON ");
        }
        if (cell.getView() == View.LAYOUTSKEL) {
            this.printWriter.print("BBOX ");
        }
        this.printWriter.println("CELL " + this.getLegalName(cell.getName()) + " ( )\n{");
        Rectangle2D bounds = cell.getBounds();
        this.printWriter.println("#bbox: ll= (" + TextUtils.formatDouble(bounds.getMinX()) + "," + TextUtils.formatDouble(bounds.getMinY()) + ") ur= (" + TextUtils.formatDouble(bounds.getMaxX()) + "," + TextUtils.formatDouble(bounds.getMaxY()) + ")");
        Iterator it2 = cell.getPorts();
        while (it2.hasNext()) {
            Export e = (Export)it2.next();
            Poly poly = e.getOriginalPort().getPoly();
            double xPos = poly.getCenterX();
            double yPos = poly.getCenterY();
            String type = "";
            if (e.getCharacteristic() == PortCharacteristic.GND) {
                type = "GND";
            } else if (e.getCharacteristic() == PortCharacteristic.PWR) {
                type = "VDD";
            } else if (e.getCharacteristic() == PortCharacteristic.IN) {
                type = "IN";
            } else if (e.getCharacteristic() == PortCharacteristic.OUT) {
                type = "OUT";
            } else if (e.getCharacteristic() == PortCharacteristic.BIDIR) {
                type = "INOUT";
            }
            ArcProto ap = e.getBasePort().getConnections()[0];
            String lay = this.getArcFunctionName(ap, ap.getName());
            this.printWriter.println("\t" + type + " " + lay + " " + this.getLegalName(e.getName()) + " (" + TextUtils.formatDouble(xPos) + "," + TextUtils.formatDouble(yPos) + ") ;");
        }
        this.printWriter.println("");
        it2 = cell.getNodes();
        while (it2.hasNext()) {
            boolean oldTranspose;
            NodeInst ni = (NodeInst)it2.next();
            if (this.getNodeType(ni) == 1) continue;
            NodeProto np = ni.getProto();
            PrimitiveNode.Function fun = ni.getFunction();
            String type = np.getName();
            if (np instanceof Cell) {
                if (ni.isIconOfParent()) continue;
                Cell oNp = ((Cell)np).contentsView();
                if (oNp != null) {
                    np = oNp;
                }
                type = np.getName();
                this.printWriter.print("\tINST " + type + " " + this.getLegalName(ni.getName()));
            } else {
                PrimitiveNode npPrim = (PrimitiveNode)np;
                if (fun == PrimitiveNode.Function.PIN) {
                    if (ni.getNumExports() > 0) continue;
                    PrimitivePort primPp = (PrimitivePort)npPrim.getPort(0);
                    ArcProto ap = primPp.getConnections()[0];
                    type = "NODE " + this.getArcFunctionName(ap, "???");
                }
                if (fun == PrimitiveNode.Function.WELL) {
                    type = "MNSUB";
                }
                if (fun == PrimitiveNode.Function.SUBSTRATE) {
                    type = "MPSUB";
                }
                if (fun == PrimitiveNode.Function.CONTACT || fun == PrimitiveNode.Function.CONNECT) {
                    boolean conMetal1 = false;
                    boolean conMetal2 = false;
                    boolean conPActive = false;
                    boolean conNActive = false;
                    boolean conPoly = false;
                    for (int j = 0; j < npPrim.getNumPorts(); ++j) {
                        PrimitivePort primPp = (PrimitivePort)npPrim.getPort(j);
                        ArcProto[] arcs = primPp.getConnections();
                        for (int k = 0; k < arcs.length; ++k) {
                            ArcProto ap = arcs[k];
                            ArcProto.Function aFun = ap.getFunction();
                            if (aFun == ArcProto.Function.METAL1) {
                                conMetal1 = true;
                            }
                            if (aFun == ArcProto.Function.METAL2) {
                                conMetal2 = true;
                            }
                            if (aFun == ArcProto.Function.POLY1) {
                                conPoly = true;
                            }
                            if (aFun == ArcProto.Function.DIFFP) {
                                conPActive = true;
                            }
                            if (aFun != ArcProto.Function.DIFFN) continue;
                            conNActive = true;
                        }
                    }
                    if (conMetal1) {
                        if (conMetal2) {
                            type = "M1M2";
                        } else if (conPoly) {
                            type = "MPOLY";
                        } else if (conPActive) {
                            type = "MPDIFF";
                        } else if (conNActive) {
                            type = "MNDIFF";
                        }
                    }
                }
                if (fun == PrimitiveNode.Function.TRANMOS) {
                    type = "TN";
                }
                if (fun == PrimitiveNode.Function.TRADMOS) {
                    type = "TD";
                }
                if (fun == PrimitiveNode.Function.TRAPMOS) {
                    type = "TP";
                }
                this.printWriter.print("\t" + type + " " + this.getLegalName(ni.getName()));
            }
            Orientation or = ni.getOrient();
            int oldRotation = or.getCAngle();
            boolean bl = oldTranspose = or.isCTranspose();
            if (oldRotation != 0 || oldTranspose) {
                if (oldTranspose) {
                    this.printWriter.print(" RX");
                    oldRotation = (oldRotation + 2700) % 3600;
                }
                this.printWriter.print(" R" + TextUtils.formatDouble(oldRotation / 10));
            }
            if (ni.getXSize() != np.getDefWidth() || ni.getYSize() != np.getDefHeight()) {
                SizeOffset so = ni.getSizeOffset();
                double wid = ni.getXSize() - so.getLowXOffset() - so.getHighXOffset();
                double len = ni.getYSize() - so.getLowYOffset() - so.getHighYOffset();
                if (fun == PrimitiveNode.Function.TRANMOS || fun == PrimitiveNode.Function.TRADMOS || fun == PrimitiveNode.Function.TRAPMOS) {
                    TransistorSize ts = ni.getTransistorSize(null);
                    len = ts.getDoubleLength();
                    wid = ts.getDoubleWidth();
                }
                this.printWriter.print(" W=" + TextUtils.formatDouble(wid) + " L=" + TextUtils.formatDouble(len));
            }
            if (np instanceof Cell) {
                Rectangle2D cellBounds = ((Cell)ni.getProto()).getBounds();
                this.printWriter.println(" AT (" + TextUtils.formatDouble(ni.getTrueCenterX() - cellBounds.getCenterX()) + "," + TextUtils.formatDouble(ni.getTrueCenterY() - cellBounds.getCenterY()) + ") ;");
                continue;
            }
            this.printWriter.println(" AT (" + TextUtils.formatDouble(ni.getTrueCenterX()) + "," + TextUtils.formatDouble(ni.getTrueCenterY()) + ") ;");
        }
        this.printWriter.println("");
        HashSet<ArcInst> arcsSeen = new HashSet<ArcInst>();
        Iterator it3 = cell.getNodes();
        while (it3.hasNext()) {
            NodeInst ni = (NodeInst)it3.next();
            int nature = this.getNodeType(ni);
            if (nature == 1) continue;
            Iterator cIt = ni.getConnections();
            while (cIt.hasNext()) {
                Connection con = (Connection)cIt.next();
                ArcInst ai = con.getArc();
                if (arcsSeen.contains(ai)) continue;
                this.printWriter.print("\tWIRE");
                String alt = this.getArcFunctionName(ai.getProto(), null);
                if (alt != null) {
                    this.printWriter.print(" " + alt);
                }
                if (ai.getWidth() != ai.getProto().getDefaultWidth()) {
                    this.printWriter.print(" W=" + TextUtils.formatDouble(ai.getWidth() - ai.getProto().getWidthOffset()));
                }
                if (ni.getNumExports() > 0 && ni.getFunction() == PrimitiveNode.Function.PIN) {
                    Export e = (Export)ni.getExports().next();
                    this.printWriter.print(" " + this.getLegalName(e.getName()));
                } else {
                    this.printWriter.print(" " + this.getLegalName(ni.getName()));
                }
                PortInst pi = con.getPortInst();
                if (nature == 2) {
                    this.transistorPorts(ni);
                    if (pi == this.gateLeft) {
                        this.printWriter.print(".gl");
                    }
                    if (pi == this.activeTop) {
                        this.printWriter.print(".d");
                    }
                    if (pi == this.gateRight) {
                        this.printWriter.print(".gr");
                    }
                    if (pi == this.activeBottom) {
                        this.printWriter.print(".s");
                    }
                } else if (nature == 3) {
                    this.printWriter.print("." + this.getLegalName(pi.getPortProto().getName()));
                }
                int thatEnd = 1 - con.getEndIndex();
                String lastDir = "";
                double segDist = -1.0;
                int segCount = 0;
                int eNature = 0;
                NodeInst oNi = null;
                while (true) {
                    arcsSeen.add(ai);
                    int thisEnd = 1 - thatEnd;
                    String dir = lastDir;
                    if (ai.getLocation(thatEnd).getX() == ai.getLocation(thisEnd).getX()) {
                        if (ai.getLocation(thatEnd).getY() > ai.getLocation(thisEnd).getY()) {
                            dir = "UP";
                        } else if (ai.getLocation(thatEnd).getY() < ai.getLocation(thisEnd).getY()) {
                            dir = "DOWN";
                        }
                    } else if (ai.getLocation(thatEnd).getY() == ai.getLocation(thisEnd).getY()) {
                        if (ai.getLocation(thatEnd).getX() > ai.getLocation(thisEnd).getX()) {
                            dir = "RIGHT";
                        } else if (ai.getLocation(thatEnd).getX() < ai.getLocation(thisEnd).getX()) {
                            dir = "LEFT";
                        }
                    }
                    if (!dir.equals(lastDir) && lastDir.length() > 0) {
                        this.printWriter.print(" " + lastDir);
                        if (segDist >= 0.0) {
                            this.printWriter.print("=" + TextUtils.formatDouble(segDist));
                        }
                        segDist = -1.0;
                        ++segCount;
                    }
                    lastDir = dir;
                    oNi = ai.getPortInst(thatEnd).getNodeInst();
                    eNature = this.getNodeType(oNi);
                    if ((nature != 2 || segCount > 0) && eNature != 2) {
                        if (segDist < 0.0) {
                            segDist = 0.0;
                        }
                        segDist += ai.getLength();
                    }
                    if (eNature != 1) break;
                    int tot = 0;
                    int ot = 0;
                    ArcInst oAi = null;
                    Iterator oCIt = oNi.getConnections();
                    while (oCIt.hasNext()) {
                        Connection oCon = (Connection)oCIt.next();
                        if (arcsSeen.contains(oCon.getArc())) continue;
                        oAi = oCon.getArc();
                        ++tot;
                        ot = 1 - oCon.getEndIndex();
                    }
                    if (tot != 1) break;
                    ai = oAi;
                    thatEnd = ot;
                }
                if (lastDir.length() > 0) {
                    this.printWriter.print(" " + lastDir);
                    if (segDist >= 0.0) {
                        this.printWriter.print("=" + TextUtils.formatDouble(segDist));
                    }
                } else {
                    this.printWriter.print(" TO");
                }
                if (oNi.getNumExports() > 0 && oNi.getFunction() == PrimitiveNode.Function.PIN) {
                    Export e = (Export)oNi.getExports().next();
                    this.printWriter.print(" " + this.getLegalName(e.getName()));
                } else {
                    this.printWriter.print(" " + this.getLegalName(oNi.getName()));
                }
                PortInst oPi = ai.getPortInst(thatEnd);
                if (eNature == 2) {
                    this.transistorPorts(oNi);
                    if (oPi == this.gateLeft) {
                        this.printWriter.print(".gl");
                    }
                    if (oPi == this.activeTop) {
                        this.printWriter.print(".d");
                    }
                    if (oPi == this.gateRight) {
                        this.printWriter.print(".gr");
                    }
                    if (oPi == this.activeBottom) {
                        this.printWriter.print(".s");
                    }
                } else if (eNature == 3) {
                    this.printWriter.print("." + this.getLegalName(oPi.getPortProto().getName()));
                }
                this.printWriter.println(" ;");
            }
        }
        it3 = cell.getArcs();
        while (it3.hasNext()) {
            ArcInst ai = (ArcInst)it3.next();
            if (arcsSeen.contains(ai)) continue;
            this.printWriter.println("# WIRE " + ai.describe(true) + " not described!!");
        }
        this.printWriter.println("}");
    }

    private void transistorPorts(NodeInst ni) {
        PrimitiveNode.Function fun = ni.getFunction();
        this.activeBottom = null;
        this.gateRight = null;
        this.activeTop = null;
        this.gateLeft = null;
        if (ni.getNumPortInsts() < 3) {
            return;
        }
        this.gateLeft = ni.getPortInst(0);
        this.activeTop = ni.getPortInst(1);
        this.gateRight = ni.getPortInst(2);
        if (ni.getNumPortInsts() == 3 || fun == PrimitiveNode.Function.TRANPN || fun == PrimitiveNode.Function.TRAPNP || fun == PrimitiveNode.Function.TRA4NMOS || fun == PrimitiveNode.Function.TRA4DMOS || fun == PrimitiveNode.Function.TRA4PMOS || fun == PrimitiveNode.Function.TRA4NPN || fun == PrimitiveNode.Function.TRA4PNP || fun == PrimitiveNode.Function.TRA4NJFET || fun == PrimitiveNode.Function.TRA4PJFET || fun == PrimitiveNode.Function.TRA4DMES || fun == PrimitiveNode.Function.TRA4EMES) {
            this.activeBottom = this.gateRight;
            this.gateRight = null;
        } else {
            this.activeBottom = ni.getPortInst(3);
        }
    }

    private String getLegalName(String name) {
        if (name.equals("VDD")) {
            return "VDDXXX";
        }
        if (name.equals("GND")) {
            return "GNDXXX";
        }
        boolean badChars = false;
        for (int i = 0; i < name.length(); ++i) {
            if (TextUtils.isLetterOrDigit(name.charAt(i))) continue;
            badChars = true;
        }
        if (!badChars) {
            return name;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < name.length(); ++i) {
            if (!TextUtils.isLetterOrDigit(name.charAt(i))) continue;
            sb.append(name.charAt(i));
        }
        return sb.toString();
    }

    private int getNodeType(NodeInst ni) {
        if (ni.getProto() instanceof Cell) {
            return 3;
        }
        PrimitiveNode.Function fun = ni.getFunction();
        if (fun == PrimitiveNode.Function.TRANMOS || fun == PrimitiveNode.Function.TRADMOS || fun == PrimitiveNode.Function.TRAPMOS) {
            return 2;
        }
        if (fun != PrimitiveNode.Function.PIN) {
            return 4;
        }
        if (ni.getNumConnections() != 2) {
            return 4;
        }
        return 1;
    }

    private String getArcFunctionName(ArcProto ap, String def) {
        ArcProto.Function fun = ap.getFunction();
        if (fun.isMetal()) {
            return "MET" + fun.getLevel();
        }
        if (fun.isPoly()) {
            return "POLY";
        }
        if (fun == ArcProto.Function.DIFFP) {
            return "PDIFF";
        }
        if (fun == ArcProto.Function.DIFFN) {
            return "NDIFF";
        }
        if (fun == ArcProto.Function.DIFFS) {
            return "NWELL";
        }
        if (fun == ArcProto.Function.DIFFW) {
            return "PWELL";
        }
        return def;
    }
}

