/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.Tech;
import com.sun.electric.tool.generator.layout.gates.MoCMOSGenerator;
import com.sun.electric.tool.logicaleffort.LEInst;
import java.lang.reflect.Method;

class GenerateLayoutForGatesInSchematic
extends HierarchyEnumerator.Visitor {
    private final StdCellParams stdCell;
    private final boolean DEBUG = false;

    private void trace(String s) {
    }

    private void traceln(String s) {
        this.trace(s);
        this.trace("\n");
    }

    public GenerateLayoutForGatesInSchematic(StdCellParams stdCell) {
        this.stdCell = stdCell;
    }

    private static double getStrength(Nodable no, VarContext context) {
        Variable var = no.getVar(Tech.ATTR_X);
        if (var == null) {
            return -1.0;
        }
        Object val = context.evalVar(var, no);
        if (val == null) {
            return -2.0;
        }
        LayoutLib.error(!(val instanceof Number), "strength not number?");
        return ((Number)val).doubleValue();
    }

    private void generateCell(Nodable iconInst, HierarchyEnumerator.CellInfo info) {
        VarContext context = info.getContext();
        String pNm = iconInst.getProto().getName();
        double x = GenerateLayoutForGatesInSchematic.getStrength(iconInst, context);
        if (x == -2.0) {
            System.out.println("no value for strength attribute for Cell: " + pNm + " instance: " + info.getUniqueNodableName(iconInst, "/"));
        }
        if (x < 0.0) {
            return;
        }
        int pwr = pNm.indexOf("_pwr");
        if (pwr != -1) {
            pNm = pNm.substring(0, pwr);
        }
        Cell c = null;
        if (Tech.isTSMC90()) {
            try {
                Class<?> tsmc90GeneratorClass = Class.forName("com.sun.electric.plugins.tsmc.gates90nm.TSMC90Generator");
                Class[] parameterTypes = new Class[]{String.class, Double.class, StdCellParams.class};
                Method makeGateMethod = tsmc90GeneratorClass.getDeclaredMethod("makeGate", parameterTypes);
                c = (Cell)makeGateMethod.invoke(null, pNm, new Double(x), this.stdCell);
            }
            catch (Exception e) {
                System.out.println("ERROR invoking the TSMC90 gate generator");
            }
        } else {
            c = MoCMOSGenerator.makeGate(pNm, x, this.stdCell);
        }
        if (c != null) {
            Variable var;
            if (LEInst.getType(iconInst, context) == LEInst.Type.LEGATE) {
                var = c.newVar(LEInst.ATTR_LEGATE, (Object)c.libDescribe());
            }
            if (LEInst.getType(iconInst, context) == LEInst.Type.LEKEEPER) {
                var = c.newVar(LEInst.ATTR_LEKEEPER, (Object)c.libDescribe());
            }
            System.out.println("Use: " + pNm + " X=" + x + " for instance: " + info.getUniqueNodableName(iconInst, "/"));
        }
    }

    public boolean enterCell(HierarchyEnumerator.CellInfo info) {
        VarContext ctxt = info.getContext();
        this.traceln("Entering Cell instance: " + ctxt.getInstPath("/"));
        return true;
    }

    public void exitCell(HierarchyEnumerator.CellInfo info) {
        VarContext ctxt = info.getContext();
        this.traceln("Leaving Cell instance: " + ctxt.getInstPath("/"));
    }

    public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
        if (no instanceof NodeInst) {
            return false;
        }
        this.trace("considering instance: " + info.getUniqueNodableName(no, "/") + " ... ");
        Cell cell = (Cell)no.getProto();
        Library lib = cell.getLibrary();
        String libNm = lib.getName();
        if (libNm.equals("redFour") || libNm.equals("purpleFour") || libNm.equals("power2_gates")) {
            this.traceln("generate");
            this.generateCell(no, info);
            return false;
        }
        this.traceln("descend");
        return true;
    }
}

