/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class DRCTab
extends PreferencePanel {
    private boolean requestedDRCClearDates;
    private JPanel BothPanel;
    private JPanel HierPanel;
    private JPanel IncrPanel;
    private JComboBox areaAlgoCombo;
    private JLabel areaAlgoLabel;
    private JPanel drc;
    private JButton drcClearValidDates;
    private JCheckBox drcDateOnCells;
    private JRadioButton drcErrorCell;
    private JRadioButton drcErrorDefault;
    private JRadioButton drcErrorExaustive;
    private JCheckBox drcIgnoreArea;
    private JCheckBox drcIgnoreCenterCuts;
    private JCheckBox drcIgnoreExtensionRules;
    private JCheckBox drcIncrementalOn;
    private JCheckBox drcInteractive;
    private JCheckBox drcInteractiveDrag;
    private ButtonGroup errorTypeGroup;
    private JPanel jPanel1;
    private JComboBox loggingCombo;
    private JLabel loggingLabel;

    public DRCTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.drc;
    }

    public String getName() {
        return "DRC";
    }

    public void init() {
        this.drcIncrementalOn.setSelected(DRC.isIncrementalDRCOn());
        this.drcInteractiveDrag.setSelected(DRC.isInteractiveDRCDragOn());
        switch (DRC.getErrorType()) {
            case ERROR_CHECK_DEFAULT: {
                this.drcErrorDefault.setSelected(true);
                break;
            }
            case ERROR_CHECK_CELL: {
                this.drcErrorCell.setSelected(true);
                break;
            }
            case ERROR_CHECK_EXHAUSTIVE: {
                this.drcErrorExaustive.setSelected(true);
            }
        }
        this.loggingCombo.removeAllItems();
        for (DRC.DRCCheckLogging dRCCheckLogging : DRC.DRCCheckLogging.values()) {
            this.loggingCombo.addItem(dRCCheckLogging);
        }
        this.loggingCombo.setSelectedItem((Object)DRC.getErrorLoggingType());
        this.areaAlgoCombo.removeAllItems();
        for (Enum enum_ : DRC.DRCCheckMinArea.values()) {
            this.areaAlgoCombo.addItem(enum_);
        }
        this.areaAlgoCombo.setSelectedItem((Object)DRC.getMinAreaAlgoOption());
        this.drcIgnoreCenterCuts.setSelected(DRC.isIgnoreCenterCuts());
        this.drcIgnoreArea.setSelected(DRC.isIgnoreAreaChecking());
        this.drcIgnoreExtensionRules.setSelected(DRC.isIgnoreExtensionRuleChecking());
        this.drcDateOnCells.setSelected(!DRC.isDatesStoredInMemory());
        this.drcInteractive.setSelected(DRC.isInteractiveLoggingOn());
        this.requestedDRCClearDates = false;
        this.drcClearValidDates.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DRCTab.this.drcClearValidDates.setEnabled(false);
                DRCTab.this.requestedDRCClearDates = true;
            }
        });
    }

    public void term() {
        boolean currentValue = this.drcIncrementalOn.isSelected();
        if (currentValue != DRC.isIncrementalDRCOn()) {
            DRC.setIncrementalDRCOn(currentValue);
        }
        if ((currentValue = this.drcInteractiveDrag.isSelected()) != DRC.isInteractiveDRCDragOn()) {
            DRC.setInteractiveDRCDragOn(currentValue);
        }
        if (this.drcErrorDefault.isSelected()) {
            DRC.setErrorType(DRC.DRCCheckMode.ERROR_CHECK_DEFAULT);
        } else if (this.drcErrorCell.isSelected()) {
            DRC.setErrorType(DRC.DRCCheckMode.ERROR_CHECK_CELL);
        } else if (this.drcErrorExaustive.isSelected()) {
            DRC.setErrorType(DRC.DRCCheckMode.ERROR_CHECK_EXHAUSTIVE);
        }
        if (this.loggingCombo.getSelectedItem() != DRC.getErrorLoggingType()) {
            DRC.setErrorLoggingType((DRC.DRCCheckLogging)((Object)this.loggingCombo.getSelectedItem()));
        }
        if (this.areaAlgoCombo.getSelectedItem() != DRC.getMinAreaAlgoOption()) {
            DRC.setMinAreaAlgoOption((DRC.DRCCheckMinArea)((Object)this.areaAlgoCombo.getSelectedItem()));
        }
        if ((currentValue = this.drcIgnoreCenterCuts.isSelected()) != DRC.isIgnoreCenterCuts()) {
            DRC.setIgnoreCenterCuts(currentValue);
        }
        if ((currentValue = this.drcIgnoreArea.isSelected()) != DRC.isIgnoreAreaChecking()) {
            DRC.setIgnoreAreaChecking(currentValue);
        }
        if ((currentValue = this.drcIgnoreExtensionRules.isSelected()) != DRC.isIgnoreExtensionRuleChecking()) {
            DRC.setIgnoreExtensionRuleChecking(currentValue);
        }
        boolean bl = currentValue = !this.drcDateOnCells.isSelected();
        if (currentValue != DRC.isDatesStoredInMemory()) {
            DRC.setDatesStoredInMemory(currentValue);
        }
        if ((currentValue = this.drcInteractive.isSelected()) != DRC.isInteractiveLoggingOn()) {
            DRC.setInteractiveLogging(currentValue);
        }
        if (this.requestedDRCClearDates) {
            DRC.resetDRCDates(true);
        }
    }

    private void initComponents() {
        this.errorTypeGroup = new ButtonGroup();
        this.drc = new JPanel();
        this.IncrPanel = new JPanel();
        this.drcIncrementalOn = new JCheckBox();
        this.drcInteractiveDrag = new JCheckBox();
        this.HierPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.drcErrorExaustive = new JRadioButton();
        this.drcErrorDefault = new JRadioButton();
        this.drcErrorCell = new JRadioButton();
        this.loggingLabel = new JLabel();
        this.loggingCombo = new JComboBox();
        this.BothPanel = new JPanel();
        this.drcIgnoreCenterCuts = new JCheckBox();
        this.drcIgnoreExtensionRules = new JCheckBox();
        this.drcIgnoreArea = new JCheckBox();
        this.drcDateOnCells = new JCheckBox();
        this.drcInteractive = new JCheckBox();
        this.drcClearValidDates = new JButton();
        this.areaAlgoLabel = new JLabel();
        this.areaAlgoCombo = new JComboBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Tool Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                DRCTab.this.closeDialog(evt);
            }
        });
        this.drc.setLayout(new GridBagLayout());
        this.IncrPanel.setLayout(new GridBagLayout());
        this.IncrPanel.setBorder(BorderFactory.createTitledBorder("Incremental DRC"));
        this.drcIncrementalOn.setText("On");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.IncrPanel.add((Component)this.drcIncrementalOn, gridBagConstraints);
        this.drcInteractiveDrag.setText("Show worst violation while moving nodes and arcs");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.IncrPanel.add((Component)this.drcInteractiveDrag, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.drc.add((Component)this.IncrPanel, gridBagConstraints);
        this.HierPanel.setLayout(new GridBagLayout());
        this.HierPanel.setBorder(BorderFactory.createTitledBorder("Hierarchical DRC"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Report Type"));
        this.errorTypeGroup.add(this.drcErrorExaustive);
        this.drcErrorExaustive.setText("Report all errors");
        this.drcErrorExaustive.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 4, 4);
        this.jPanel1.add((Component)this.drcErrorExaustive, gridBagConstraints);
        this.errorTypeGroup.add(this.drcErrorDefault);
        this.drcErrorDefault.setSelected(true);
        this.drcErrorDefault.setText("Report just 1 error per pair of geometries");
        this.drcErrorDefault.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.jPanel1.add((Component)this.drcErrorDefault, gridBagConstraints);
        this.errorTypeGroup.add(this.drcErrorCell);
        this.drcErrorCell.setText("Report just 1 error per cell");
        this.drcErrorCell.setAutoscrolls(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 1, 4);
        this.jPanel1.add((Component)this.drcErrorCell, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        this.HierPanel.add((Component)this.jPanel1, gridBagConstraints);
        this.loggingLabel.setHorizontalAlignment(4);
        this.loggingLabel.setText("Report Errors: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.HierPanel.add((Component)this.loggingLabel, gridBagConstraints);
        this.loggingCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.loggingCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DRCTab.this.loggingComboActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.HierPanel.add((Component)this.loggingCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.drc.add((Component)this.HierPanel, gridBagConstraints);
        this.BothPanel.setLayout(new GridBagLayout());
        this.BothPanel.setBorder(BorderFactory.createTitledBorder("Incremental and Hierarchical"));
        this.drcIgnoreCenterCuts.setText("Ignore center cuts in large contacts");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 1, 4);
        this.BothPanel.add((Component)this.drcIgnoreCenterCuts, gridBagConstraints);
        this.drcIgnoreExtensionRules.setText("Ignore extension rules");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.BothPanel.add((Component)this.drcIgnoreExtensionRules, gridBagConstraints);
        this.drcIgnoreArea.setText("Ignore area checking");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.BothPanel.add((Component)this.drcIgnoreArea, gridBagConstraints);
        this.drcDateOnCells.setText("Save valid DRC dates with cells");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 1, 4);
        this.BothPanel.add((Component)this.drcDateOnCells, gridBagConstraints);
        this.drcInteractive.setText("Interactive Logging");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 4, 4);
        this.BothPanel.add((Component)this.drcInteractive, gridBagConstraints);
        this.drcClearValidDates.setText("Clear valid DRC dates");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 30, 4, 4);
        this.BothPanel.add((Component)this.drcClearValidDates, gridBagConstraints);
        this.areaAlgoLabel.setHorizontalAlignment(2);
        this.areaAlgoLabel.setText("MinArea Algorithm: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.BothPanel.add((Component)this.areaAlgoLabel, gridBagConstraints);
        this.areaAlgoCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.areaAlgoCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DRCTab.this.areaAlgoComboActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        this.BothPanel.add((Component)this.areaAlgoCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.drc.add((Component)this.BothPanel, gridBagConstraints);
        this.getContentPane().add((Component)this.drc, new GridBagConstraints());
        this.pack();
    }

    private void areaAlgoComboActionPerformed(ActionEvent evt) {
    }

    private void loggingComboActionPerformed(ActionEvent evt) {
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

