/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.flag.router;

import com.sun.electric.database.topology.PortInst;
import com.sun.electric.tool.generator.flag.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToConnect {
    private List<PortInst> ports = new ArrayList<PortInst>();
    private List<String> exportNames = new ArrayList<String>();

    public ToConnect() {
    }

    public ToConnect(List<String> expNms) {
        for (String expNm : expNms) {
            this.exportNames.add(expNm);
        }
    }

    public void addPortInst(PortInst pi) {
        this.ports.add(pi);
    }

    public List<PortInst> getPortInsts() {
        return this.ports;
    }

    public int numPortInsts() {
        return this.ports.size();
    }

    public boolean isExported() {
        return this.exportNames.size() != 0;
    }

    public Collection<String> getExportName() {
        return this.exportNames;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ToConnect: ");
        if (this.isExported()) {
            sb.append("Exports:");
            for (String expNm : this.exportNames) {
                sb.append(" " + expNm);
            }
            sb.append(", ");
        }
        sb.append("Ports: ");
        for (PortInst pi : this.ports) {
            sb.append(pi.toString() + " ");
        }
        return sb.toString();
    }

    public boolean isPowerOrGround() {
        for (PortInst pi : this.getPortInsts()) {
            if (!Utils.isPwrGnd(pi)) continue;
            return true;
        }
        return false;
    }
}

