/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tecEditWizard;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.Foundry;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Xml;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.tecEditWizard.WizardField;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TechEditWizardData {
    private String tech_name;
    private String tech_description;
    private int num_metal_layers = 2;
    private int stepsize = 100;
    private boolean pWellFlag = true;
    private boolean horizontalFlag = true;
    private WizardField diff_width = new WizardField();
    private WizardField diff_poly_overhang = new WizardField();
    private WizardField diff_contact_overhang = new WizardField();
    private WizardField diff_spacing = new WizardField();
    private WizardField poly_width = new WizardField();
    private WizardField poly_endcap = new WizardField();
    private WizardField poly_spacing = new WizardField();
    private WizardField poly_diff_spacing = new WizardField();
    private WizardField gate_length = new WizardField();
    private WizardField gate_width = new WizardField();
    private WizardField gate_spacing = new WizardField();
    private WizardField gate_contact_spacing = new WizardField();
    private WizardField contact_size = new WizardField();
    private WizardField contact_spacing = new WizardField();
    private WizardField contact_array_spacing = new WizardField();
    private WizardField contact_metal_overhang_inline_only = new WizardField();
    private WizardField contact_metal_overhang_all_sides = new WizardField();
    private WizardField contact_poly_overhang = new WizardField();
    private WizardField polycon_diff_spacing = new WizardField();
    private WizardField nplus_width = new WizardField();
    private WizardField nplus_overhang_diff = new WizardField();
    private WizardField nplus_overhang_poly = new WizardField();
    private WizardField nplus_spacing = new WizardField();
    private WizardField pplus_width = new WizardField();
    private WizardField pplus_overhang_diff = new WizardField();
    private WizardField pplus_overhang_poly = new WizardField();
    private WizardField pplus_spacing = new WizardField();
    private WizardField nwell_width = new WizardField();
    private WizardField nwell_overhang_diff_p = new WizardField();
    private WizardField nwell_overhang_diff_n = new WizardField();
    private WizardField nwell_spacing = new WizardField();
    private WizardField[] metal_width = new WizardField[this.num_metal_layers];
    private WizardField[] metal_spacing = new WizardField[this.num_metal_layers];
    private WizardField[] via_size = new WizardField[this.num_metal_layers - 1];
    private WizardField[] via_spacing = new WizardField[this.num_metal_layers - 1];
    private WizardField[] via_array_spacing = new WizardField[this.num_metal_layers - 1];
    private WizardField[] via_overhang_inline = new WizardField[this.num_metal_layers - 1];
    private double poly_antenna_ratio;
    private double[] metal_antenna_ratio = new double[this.num_metal_layers];
    private int gds_diff_layer;
    private int gds_poly_layer;
    private int gds_nplus_layer;
    private int gds_pplus_layer;
    private int gds_nwell_layer;
    private int gds_contact_layer;
    private int[] gds_metal_layer = new int[this.num_metal_layers];
    private int[] gds_via_layer = new int[this.num_metal_layers - 1];
    private int gds_marking_layer;

    public TechEditWizardData() {
        int i;
        for (i = 0; i < this.num_metal_layers; ++i) {
            this.metal_width[i] = new WizardField();
            this.metal_spacing[i] = new WizardField();
        }
        for (i = 0; i < this.num_metal_layers - 1; ++i) {
            this.via_size[i] = new WizardField();
            this.via_spacing[i] = new WizardField();
            this.via_array_spacing[i] = new WizardField();
            this.via_overhang_inline[i] = new WizardField();
        }
    }

    public String getTechName() {
        return this.tech_name;
    }

    public void setTechName(String s) {
        this.tech_name = s;
    }

    public String getTechDescription() {
        return this.tech_description;
    }

    public void setTechDescription(String s) {
        this.tech_description = s;
    }

    public int getStepSize() {
        return this.stepsize;
    }

    public void setStepSize(int n) {
        this.stepsize = n;
    }

    public int getNumMetalLayers() {
        return this.num_metal_layers;
    }

    public void setNumMetalLayers(int n) {
        int i;
        int i2;
        int i3;
        int i4;
        int i5;
        int i6;
        int smallest = Math.min(n, this.num_metal_layers);
        WizardField[] new_metal_width = new WizardField[n];
        for (i6 = 0; i6 < smallest; ++i6) {
            new_metal_width[i6] = this.metal_width[i6];
        }
        for (i6 = smallest; i6 < n; ++i6) {
            new_metal_width[i6] = new WizardField();
        }
        this.metal_width = new_metal_width;
        WizardField[] new_metal_spacing = new WizardField[n];
        for (i5 = 0; i5 < smallest; ++i5) {
            new_metal_spacing[i5] = this.metal_spacing[i5];
        }
        for (i5 = smallest; i5 < n; ++i5) {
            new_metal_spacing[i5] = new WizardField();
        }
        this.metal_spacing = new_metal_spacing;
        WizardField[] new_via_size = new WizardField[n - 1];
        for (i4 = 0; i4 < smallest - 1; ++i4) {
            new_via_size[i4] = this.via_size[i4];
        }
        for (i4 = smallest - 1; i4 < n - 1; ++i4) {
            new_via_size[i4] = new WizardField();
        }
        this.via_size = new_via_size;
        WizardField[] new_via_spacing = new WizardField[n - 1];
        for (i3 = 0; i3 < smallest - 1; ++i3) {
            new_via_spacing[i3] = this.via_spacing[i3];
        }
        for (i3 = smallest - 1; i3 < n - 1; ++i3) {
            new_via_spacing[i3] = new WizardField();
        }
        this.via_spacing = new_via_spacing;
        WizardField[] new_via_array_spacing = new WizardField[n - 1];
        for (i2 = 0; i2 < smallest - 1; ++i2) {
            new_via_array_spacing[i2] = this.via_array_spacing[i2];
        }
        for (i2 = smallest - 1; i2 < n - 1; ++i2) {
            new_via_array_spacing[i2] = new WizardField();
        }
        this.via_array_spacing = new_via_array_spacing;
        WizardField[] new_via_overhang_inline = new WizardField[n - 1];
        for (i = 0; i < smallest - 1; ++i) {
            new_via_overhang_inline[i] = this.via_overhang_inline[i];
        }
        for (i = smallest - 1; i < n - 1; ++i) {
            new_via_overhang_inline[i] = new WizardField();
        }
        this.via_overhang_inline = new_via_overhang_inline;
        double[] new_metal_antenna_ratio = new double[n];
        for (int i7 = 0; i7 < smallest; ++i7) {
            new_metal_antenna_ratio[i7] = this.metal_antenna_ratio[i7];
        }
        this.metal_antenna_ratio = new_metal_antenna_ratio;
        int[] new_gds_metal_layer = new int[n];
        for (int i8 = 0; i8 < smallest; ++i8) {
            new_gds_metal_layer[i8] = this.gds_metal_layer[i8];
        }
        this.gds_metal_layer = new_gds_metal_layer;
        int[] new_gds_via_layer = new int[n - 1];
        for (int i9 = 0; i9 < smallest - 1; ++i9) {
            new_gds_via_layer[i9] = this.gds_via_layer[i9];
        }
        this.gds_via_layer = new_gds_via_layer;
        this.num_metal_layers = n;
    }

    boolean getPWellProcess() {
        return this.pWellFlag;
    }

    void setPWellProcess(boolean b) {
        this.pWellFlag = b;
    }

    boolean getHorizontalTransistors() {
        return this.horizontalFlag;
    }

    void setHorizontalTransistors(boolean b) {
        this.horizontalFlag = b;
    }

    WizardField getDiffWidth() {
        return this.diff_width;
    }

    void setDiffWidth(WizardField v) {
        this.diff_width = v;
    }

    WizardField getDiffPolyOverhang() {
        return this.diff_poly_overhang;
    }

    void setDiffPolyOverhang(WizardField v) {
        this.diff_poly_overhang = v;
    }

    WizardField getDiffContactOverhang() {
        return this.diff_contact_overhang;
    }

    void setDiffContactOverhang(WizardField v) {
        this.diff_contact_overhang = v;
    }

    WizardField getDiffSpacing() {
        return this.diff_spacing;
    }

    void setDiffSpacing(WizardField v) {
        this.diff_spacing = v;
    }

    WizardField getPolyWidth() {
        return this.poly_width;
    }

    void setPolyWidth(WizardField v) {
        this.poly_width = v;
    }

    WizardField getPolyEndcap() {
        return this.poly_endcap;
    }

    void setPolyEndcap(WizardField v) {
        this.poly_endcap = v;
    }

    WizardField getPolySpacing() {
        return this.poly_spacing;
    }

    void setPolySpacing(WizardField v) {
        this.poly_spacing = v;
    }

    WizardField getPolyDiffSpacing() {
        return this.poly_diff_spacing;
    }

    void setPolyDiffSpacing(WizardField v) {
        this.poly_diff_spacing = v;
    }

    WizardField getGateLength() {
        return this.gate_length;
    }

    void setGateLength(WizardField v) {
        this.gate_length = v;
    }

    WizardField getGateWidth() {
        return this.gate_width;
    }

    void setGateWidth(WizardField v) {
        this.gate_width = v;
    }

    WizardField getGateSpacing() {
        return this.gate_spacing;
    }

    void setGateSpacing(WizardField v) {
        this.gate_spacing = v;
    }

    WizardField getGateContactSpacing() {
        return this.gate_contact_spacing;
    }

    void setGateContactSpacing(WizardField v) {
        this.gate_contact_spacing = v;
    }

    WizardField getContactSize() {
        return this.contact_size;
    }

    void setContactSize(WizardField v) {
        this.contact_size = v;
    }

    WizardField getContactSpacing() {
        return this.contact_spacing;
    }

    void setContactSpacing(WizardField v) {
        this.contact_spacing = v;
    }

    WizardField getContactArraySpacing() {
        return this.contact_array_spacing;
    }

    void setContactArraySpacing(WizardField v) {
        this.contact_array_spacing = v;
    }

    WizardField getContactMetalOverhangInlineOnly() {
        return this.contact_metal_overhang_inline_only;
    }

    void setContactMetalOverhangInlineOnly(WizardField v) {
        this.contact_metal_overhang_inline_only = v;
    }

    WizardField getContactMetalOverhangAllSides() {
        return this.contact_metal_overhang_all_sides;
    }

    void setContactMetalOverhangAllSides(WizardField v) {
        this.contact_metal_overhang_all_sides = v;
    }

    WizardField getContactPolyOverhang() {
        return this.contact_poly_overhang;
    }

    void setContactPolyOverhang(WizardField v) {
        this.contact_poly_overhang = v;
    }

    WizardField getPolyconDiffSpacing() {
        return this.polycon_diff_spacing;
    }

    void setPolyconDiffSpacing(WizardField v) {
        this.polycon_diff_spacing = v;
    }

    WizardField getNPlusWidth() {
        return this.nplus_width;
    }

    void setNPlusWidth(WizardField v) {
        this.nplus_width = v;
    }

    WizardField getNPlusOverhangDiff() {
        return this.nplus_overhang_diff;
    }

    void setNPlusOverhangDiff(WizardField v) {
        this.nplus_overhang_diff = v;
    }

    WizardField getNPlusOverhangPoly() {
        return this.nplus_overhang_poly;
    }

    void setNPlusOverhangPoly(WizardField v) {
        this.nplus_overhang_poly = v;
    }

    WizardField getNPlusSpacing() {
        return this.nplus_spacing;
    }

    void setNPlusSpacing(WizardField v) {
        this.nplus_spacing = v;
    }

    WizardField getPPlusWidth() {
        return this.pplus_width;
    }

    void setPPlusWidth(WizardField v) {
        this.pplus_width = v;
    }

    WizardField getPPlusOverhangDiff() {
        return this.pplus_overhang_diff;
    }

    void setPPlusOverhangDiff(WizardField v) {
        this.pplus_overhang_diff = v;
    }

    WizardField getPPlusOverhangPoly() {
        return this.pplus_overhang_poly;
    }

    void setPPlusOverhangPoly(WizardField v) {
        this.pplus_overhang_poly = v;
    }

    WizardField getPPlusSpacing() {
        return this.pplus_spacing;
    }

    void setPPlusSpacing(WizardField v) {
        this.pplus_spacing = v;
    }

    WizardField getNWellWidth() {
        return this.nwell_width;
    }

    void setNWellWidth(WizardField v) {
        this.nwell_width = v;
    }

    WizardField getNWellOverhangDiffP() {
        return this.nwell_overhang_diff_p;
    }

    void setNWellOverhangDiffP(WizardField v) {
        this.nwell_overhang_diff_p = v;
    }

    WizardField getNWellOverhangDiffN() {
        return this.nwell_overhang_diff_n;
    }

    void setNWellOverhangDiffN(WizardField v) {
        this.nwell_overhang_diff_n = v;
    }

    WizardField getNWellSpacing() {
        return this.nwell_spacing;
    }

    void setNWellSpacing(WizardField v) {
        this.nwell_spacing = v;
    }

    WizardField[] getMetalWidth() {
        return this.metal_width;
    }

    void setMetalWidth(int met, WizardField value) {
        this.metal_width[met] = value;
    }

    WizardField[] getMetalSpacing() {
        return this.metal_spacing;
    }

    void setMetalSpacing(int met, WizardField value) {
        this.metal_spacing[met] = value;
    }

    WizardField[] getViaSize() {
        return this.via_size;
    }

    void setViaSize(int via, WizardField value) {
        this.via_size[via] = value;
    }

    WizardField[] getViaSpacing() {
        return this.via_spacing;
    }

    void setViaSpacing(int via, WizardField value) {
        this.via_spacing[via] = value;
    }

    WizardField[] getViaArraySpacing() {
        return this.via_array_spacing;
    }

    void setViaArraySpacing(int via, WizardField value) {
        this.via_array_spacing[via] = value;
    }

    WizardField[] getViaOverhangInline() {
        return this.via_overhang_inline;
    }

    void setViaOverhangInline(int via, WizardField value) {
        this.via_overhang_inline[via] = value;
    }

    public double getPolyAntennaRatio() {
        return this.poly_antenna_ratio;
    }

    void setPolyAntennaRatio(double v) {
        this.poly_antenna_ratio = v;
    }

    public double[] getMetalAntennaRatio() {
        return this.metal_antenna_ratio;
    }

    void setMetalAntennaRatio(int met, double value) {
        this.metal_antenna_ratio[met] = value;
    }

    int getGDSDiff() {
        return this.gds_diff_layer;
    }

    void setGDSDiff(int l) {
        this.gds_diff_layer = l;
    }

    int getGDSPoly() {
        return this.gds_poly_layer;
    }

    void setGDSPoly(int l) {
        this.gds_poly_layer = l;
    }

    int getGDSNPlus() {
        return this.gds_nplus_layer;
    }

    void setGDSNPlus(int l) {
        this.gds_nplus_layer = l;
    }

    int getGDSPPlus() {
        return this.gds_pplus_layer;
    }

    void setGDSPPlus(int l) {
        this.gds_pplus_layer = l;
    }

    int getGDSNWell() {
        return this.gds_nwell_layer;
    }

    void setGDSNWell(int l) {
        this.gds_nwell_layer = l;
    }

    int getGDSContact() {
        return this.gds_contact_layer;
    }

    void setGDSContact(int l) {
        this.gds_contact_layer = l;
    }

    int[] getGDSMetal() {
        return this.gds_metal_layer;
    }

    void setGDSMetal(int met, int l) {
        this.gds_metal_layer[met] = l;
    }

    int[] getGDSVia() {
        return this.gds_via_layer;
    }

    void setGDSVia(int via, int l) {
        this.gds_via_layer[via] = l;
    }

    int getGDSMarking() {
        return this.gds_marking_layer;
    }

    void setGDSMarking(int l) {
        this.gds_marking_layer = l;
    }

    private String errorInData() {
        int i;
        if (this.tech_name == null || this.tech_name.length() == 0) {
            return "General panel: No technology name";
        }
        if (this.stepsize == 0) {
            return "General panel: Invalid unit size";
        }
        if (this.diff_width.v == 0.0) {
            return "Active panel: Invalid width";
        }
        if (this.poly_width.v == 0.0) {
            return "Poly panel: Invalid width";
        }
        if (this.gate_width.v == 0.0) {
            return "Gate panel: Invalid width";
        }
        if (this.gate_length.v == 0.0) {
            return "Gate panel: Invalid length";
        }
        if (this.contact_size.v == 0.0) {
            return "Contact panel: Invalid size";
        }
        if (this.nplus_width.v == 0.0) {
            return "Well/Implant panel: Invalid NPlus width";
        }
        if (this.pplus_width.v == 0.0) {
            return "Well/Implant panel: Invalid PPlus width";
        }
        if (this.nwell_width.v == 0.0) {
            return "Well/Implant panel: Invalid NWell width";
        }
        for (i = 0; i < this.num_metal_layers; ++i) {
            if (this.metal_width[i].v != 0.0) continue;
            return "Metal panel: Invalid Metal-" + (i + 1) + " width";
        }
        for (i = 0; i < this.num_metal_layers - 1; ++i) {
            if (this.via_size[i].v != 0.0) continue;
            return "Via panel: Invalid Via-" + (i + 1) + " size";
        }
        return null;
    }

    boolean importData() {
        String fileName = OpenFile.chooseInputFile(FileType.ANY, "Technology Wizard File");
        if (fileName == null) {
            return false;
        }
        return this.importData(fileName);
    }

    public boolean importData(String fileName) {
        URL url = TextUtils.makeURLToFile(fileName);
        try {
            String buf;
            URLConnection urlCon = url.openConnection();
            InputStreamReader is = new InputStreamReader(urlCon.getInputStream());
            LineNumberReader lineReader = new LineNumberReader(is);
            while ((buf = lineReader.readLine()) != null) {
                if ((buf = buf.trim()).length() == 0 || buf.startsWith("#") || !buf.startsWith("$") && !buf.startsWith("@")) continue;
                int spacePos = buf.indexOf(32);
                int equalsPos = buf.indexOf(61);
                if (equalsPos < 0) {
                    Job.getUserInterface().showErrorMessage("Missing '=' on line " + lineReader.getLineNumber(), "Syntax Error In Technology File");
                    break;
                }
                spacePos = spacePos < 0 ? equalsPos : Math.min(spacePos, equalsPos);
                String varName = buf.substring(1, spacePos);
                int semiPos = buf.indexOf(59);
                if (semiPos < 0) {
                    Job.getUserInterface().showErrorMessage("Missing ';' on line " + lineReader.getLineNumber(), "Syntax Error In Technology File");
                    break;
                }
                ++equalsPos;
                while (equalsPos < semiPos && buf.charAt(equalsPos) == ' ') {
                    ++equalsPos;
                }
                String varValue = buf.substring(equalsPos, semiPos);
                if (varName.equalsIgnoreCase("tech_libname")) continue;
                if (varName.equalsIgnoreCase("tech_name")) {
                    this.setTechName(this.stripQuotes(varValue));
                    continue;
                }
                if (varName.equalsIgnoreCase("tech_description")) {
                    this.setTechDescription(this.stripQuotes(varValue));
                    continue;
                }
                if (varName.equalsIgnoreCase("num_metal_layers")) {
                    this.setNumMetalLayers(TextUtils.atoi(varValue));
                    continue;
                }
                if (varName.equalsIgnoreCase("pwell_process")) {
                    this.setPWellProcess(Boolean.valueOf(varValue));
                    continue;
                }
                if (varName.equalsIgnoreCase("horizontal_transistors")) {
                    this.setHorizontalTransistors(Boolean.valueOf(varValue));
                    continue;
                }
                if (varName.equalsIgnoreCase("stepsize")) {
                    this.setStepSize(TextUtils.atoi(varValue));
                    continue;
                }
                if (varName.equalsIgnoreCase("diff_width")) {
                    this.diff_width.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("diff_width_rule")) {
                    this.diff_width.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("diff_poly_overhang")) {
                    this.diff_poly_overhang.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("diff_poly_overhang_rule")) {
                    this.diff_poly_overhang.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("diff_contact_overhang")) {
                    this.diff_contact_overhang.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("diff_contact_overhang_rule")) {
                    this.diff_contact_overhang.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("diff_spacing")) {
                    this.diff_spacing.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("diff_spacing_rule")) {
                    this.diff_spacing.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("poly_width")) {
                    this.poly_width.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("poly_width_rule")) {
                    this.poly_width.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("poly_endcap")) {
                    this.poly_endcap.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("poly_endcap_rule")) {
                    this.poly_endcap.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("poly_spacing")) {
                    this.poly_spacing.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("poly_spacing_rule")) {
                    this.poly_spacing.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("poly_diff_spacing")) {
                    this.poly_diff_spacing.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("poly_diff_spacing_rule")) {
                    this.poly_diff_spacing.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("gate_length")) {
                    this.gate_length.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("gate_length_rule")) {
                    this.gate_length.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("gate_width")) {
                    this.gate_width.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("gate_width_rule")) {
                    this.gate_width.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("gate_spacing")) {
                    this.gate_spacing.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("gate_spacing_rule")) {
                    this.gate_spacing.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("gate_contact_spacing")) {
                    this.gate_contact_spacing.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("gate_contact_spacing_rule")) {
                    this.gate_contact_spacing.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("contact_size")) {
                    this.contact_size.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("contact_size_rule")) {
                    this.contact_size.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("contact_spacing")) {
                    this.contact_spacing.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("contact_spacing_rule")) {
                    this.contact_spacing.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("contact_array_spacing")) {
                    this.contact_array_spacing.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("contact_array_spacing_rule")) {
                    this.contact_array_spacing.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("contact_metal_overhang_inline_only")) {
                    this.contact_metal_overhang_inline_only.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("contact_metal_overhang_inline_only_rule")) {
                    this.contact_metal_overhang_inline_only.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("contact_metal_overhang_all_sides")) {
                    this.contact_metal_overhang_all_sides.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("contact_metal_overhang_all_sides_rule")) {
                    this.contact_metal_overhang_all_sides.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("contact_poly_overhang")) {
                    this.contact_poly_overhang.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("contact_poly_overhang_rule")) {
                    this.contact_poly_overhang.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("polycon_diff_spacing")) {
                    this.polycon_diff_spacing.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("polycon_diff_spacing_rule")) {
                    this.polycon_diff_spacing.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nplus_width")) {
                    this.nplus_width.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nplus_width_rule")) {
                    this.nplus_width.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nplus_overhang_diff")) {
                    this.nplus_overhang_diff.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nplus_overhang_diff_rule")) {
                    this.nplus_overhang_diff.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nplus_overhang_poly")) {
                    this.nplus_overhang_poly.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nplus_overhang_poly_rule")) {
                    this.nplus_overhang_poly.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nplus_spacing")) {
                    this.nplus_spacing.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nplus_spacing_rule")) {
                    this.nplus_spacing.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("pplus_width")) {
                    this.pplus_width.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("pplus_width_rule")) {
                    this.pplus_width.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("pplus_overhang_diff")) {
                    this.pplus_overhang_diff.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("pplus_overhang_diff_rule")) {
                    this.pplus_overhang_diff.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("pplus_overhang_poly")) {
                    this.pplus_overhang_poly.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("pplus_overhang_poly_rule")) {
                    this.pplus_overhang_poly.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("pplus_spacing")) {
                    this.pplus_spacing.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("pplus_spacing_rule")) {
                    this.pplus_spacing.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nwell_width")) {
                    this.nwell_width.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nwell_width_rule")) {
                    this.nwell_width.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nwell_overhang_diff_p")) {
                    this.nwell_overhang_diff_p.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nwell_overhang_diff_rule_p")) {
                    this.nwell_overhang_diff_p.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nwell_overhang_diff_n")) {
                    this.nwell_overhang_diff_n.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nwell_overhang_diff_rule_n")) {
                    this.nwell_overhang_diff_n.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nwell_spacing")) {
                    this.nwell_spacing.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nwell_spacing_rule")) {
                    this.nwell_spacing.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("metal_width")) {
                    this.fillWizardArray(varValue, this.metal_width, this.num_metal_layers, false);
                    continue;
                }
                if (varName.equalsIgnoreCase("metal_width_rule")) {
                    this.fillWizardArray(varValue, this.metal_width, this.num_metal_layers, true);
                    continue;
                }
                if (varName.equalsIgnoreCase("metal_spacing")) {
                    this.fillWizardArray(varValue, this.metal_spacing, this.num_metal_layers, false);
                    continue;
                }
                if (varName.equalsIgnoreCase("metal_spacing_rule")) {
                    this.fillWizardArray(varValue, this.metal_spacing, this.num_metal_layers, true);
                    continue;
                }
                if (varName.equalsIgnoreCase("via_size")) {
                    this.fillWizardArray(varValue, this.via_size, this.num_metal_layers - 1, false);
                    continue;
                }
                if (varName.equalsIgnoreCase("via_size_rule")) {
                    this.fillWizardArray(varValue, this.via_size, this.num_metal_layers - 1, true);
                    continue;
                }
                if (varName.equalsIgnoreCase("via_spacing")) {
                    this.fillWizardArray(varValue, this.via_spacing, this.num_metal_layers - 1, false);
                    continue;
                }
                if (varName.equalsIgnoreCase("via_spacing_rule")) {
                    this.fillWizardArray(varValue, this.via_spacing, this.num_metal_layers - 1, true);
                    continue;
                }
                if (varName.equalsIgnoreCase("via_array_spacing")) {
                    this.fillWizardArray(varValue, this.via_array_spacing, this.num_metal_layers - 1, false);
                    continue;
                }
                if (varName.equalsIgnoreCase("via_array_spacing_rule")) {
                    this.fillWizardArray(varValue, this.via_array_spacing, this.num_metal_layers - 1, true);
                    continue;
                }
                if (varName.equalsIgnoreCase("via_overhang_inline")) {
                    this.fillWizardArray(varValue, this.via_overhang_inline, this.num_metal_layers - 1, false);
                    continue;
                }
                if (varName.equalsIgnoreCase("via_overhang_inline_rule")) {
                    this.fillWizardArray(varValue, this.via_overhang_inline, this.num_metal_layers - 1, true);
                    continue;
                }
                if (varName.equalsIgnoreCase("poly_antenna_ratio")) {
                    this.setPolyAntennaRatio(TextUtils.atof(varValue));
                    continue;
                }
                if (varName.equalsIgnoreCase("metal_antenna_ratio")) {
                    this.metal_antenna_ratio = this.makeDoubleArray(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("gds_diff_layer")) {
                    this.setGDSDiff(TextUtils.atoi(varValue));
                    continue;
                }
                if (varName.equalsIgnoreCase("gds_poly_layer")) {
                    this.setGDSPoly(TextUtils.atoi(varValue));
                    continue;
                }
                if (varName.equalsIgnoreCase("gds_nplus_layer")) {
                    this.setGDSNPlus(TextUtils.atoi(varValue));
                    continue;
                }
                if (varName.equalsIgnoreCase("gds_pplus_layer")) {
                    this.setGDSPPlus(TextUtils.atoi(varValue));
                    continue;
                }
                if (varName.equalsIgnoreCase("gds_nwell_layer")) {
                    this.setGDSNWell(TextUtils.atoi(varValue));
                    continue;
                }
                if (varName.equalsIgnoreCase("gds_contact_layer")) {
                    this.setGDSContact(TextUtils.atoi(varValue));
                    continue;
                }
                if (varName.equalsIgnoreCase("gds_metal_layer")) {
                    this.gds_metal_layer = this.makeIntArray(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("gds_via_layer")) {
                    this.gds_via_layer = this.makeIntArray(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("gds_marking_layer")) {
                    this.setGDSMarking(TextUtils.atoi(varValue));
                    continue;
                }
                Job.getUserInterface().showErrorMessage("Unknown keyword '" + varName + "' on line " + lineReader.getLineNumber(), "Syntax Error In Technology File");
                break;
            }
            lineReader.close();
        }
        catch (IOException e) {
            System.out.println("Error reading " + fileName);
            return false;
        }
        return true;
    }

    private String stripQuotes(String str) {
        if (str.startsWith("\"") && str.endsWith("\"")) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    private int[] makeIntArray(String str) {
        WizardField[] foundArray = new WizardField[this.num_metal_layers];
        for (int i = 0; i < this.num_metal_layers; ++i) {
            foundArray[i] = new WizardField();
        }
        this.fillWizardArray(str, foundArray, this.num_metal_layers, false);
        int[] retArray = new int[foundArray.length];
        for (int i = 0; i < foundArray.length; ++i) {
            retArray[i] = (int)foundArray[i].v;
        }
        return retArray;
    }

    private double[] makeDoubleArray(String str) {
        WizardField[] foundArray = new WizardField[this.num_metal_layers];
        for (int i = 0; i < this.num_metal_layers; ++i) {
            foundArray[i] = new WizardField();
        }
        this.fillWizardArray(str, foundArray, this.num_metal_layers, false);
        double[] retArray = new double[foundArray.length];
        for (int i = 0; i < foundArray.length; ++i) {
            retArray[i] = foundArray[i].v;
        }
        return retArray;
    }

    private void fillWizardArray(String str, WizardField[] fieldArray, int expectedLength, boolean getRule) {
        if (!str.startsWith("(")) {
            Job.getUserInterface().showErrorMessage("Array does not start with '(' on " + str, "Syntax Error In Technology File");
            return;
        }
        int pos = 1;
        int index = 0;
        while (true) {
            if (pos < str.length() && str.charAt(pos) == ' ') {
                ++pos;
                continue;
            }
            if (index >= fieldArray.length) {
                Job.getUserInterface().showErrorMessage("Invalid metal index: " + index, "Syntax Error In Technology File");
                return;
            }
            if (getRule) {
                int end;
                if (str.charAt(pos) != '\"') {
                    Job.getUserInterface().showErrorMessage("Rule element does not start with quote on " + str, "Syntax Error In Technology File");
                    return;
                }
                for (end = ++pos; end < str.length() && str.charAt(end) != '\"'; ++end) {
                }
                if (str.charAt(end) != '\"') {
                    Job.getUserInterface().showErrorMessage("Rule element does not end with quote on " + str, "Syntax Error In Technology File");
                    return;
                }
                fieldArray[index++].rule = str.substring(pos, end);
                pos = end + 1;
            } else {
                double v = TextUtils.atof(str.substring(pos));
                fieldArray[index++].v = v;
            }
            while (pos < str.length() && str.charAt(pos) != ',' && str.charAt(pos) != ')') {
                ++pos;
            }
            if (str.charAt(pos) != ',') break;
            ++pos;
        }
    }

    void exportData() {
        String fileName = OpenFile.chooseOutputFile(FileType.TEXT, "Technology Wizard File", "Technology.txt");
        if (fileName == null) {
            return;
        }
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            this.dumpNumbers(printWriter);
            printWriter.close();
        }
        catch (IOException e) {
            System.out.println("Error writing XML file");
            return;
        }
    }

    private void dumpNumbers(PrintWriter pw) {
        int i;
        pw.println("#### Technology wizard data file");
        pw.println("####");
        pw.println("#### All dimensions in nanometers.");
        pw.println();
        pw.println("$tech_name = \"" + this.tech_name + "\";");
        pw.println("$tech_description = \"" + this.tech_description + "\";");
        pw.println("$num_metal_layers = " + this.num_metal_layers + ";");
        pw.println("$num_metal_layers = " + this.num_metal_layers + ";");
        pw.println("$pwell_process = " + this.pWellFlag + ";");
        pw.println("$horizontal_transistors = " + this.horizontalFlag + ";");
        pw.println();
        pw.println("## stepsize is minimum granularity that will be used as movement grid");
        pw.println("## set to manufacturing grid or lowest common denominator with design rules");
        pw.println("$stepsize = " + this.stepsize + ";");
        pw.println();
        pw.println("######  DIFFUSION RULES  #####");
        pw.println("$diff_width = " + TextUtils.formatDouble(this.diff_width.v) + ";");
        pw.println("$diff_width_rule = \"" + this.diff_width.rule + "\";");
        pw.println("$diff_poly_overhang = " + TextUtils.formatDouble(this.diff_poly_overhang.v) + ";        # min. diff overhang from gate edge");
        pw.println("$diff_poly_overhang_rule = \"" + this.diff_poly_overhang.rule + "\";        # min. diff overhang from gate edge");
        pw.println("$diff_contact_overhang = " + TextUtils.formatDouble(this.diff_contact_overhang.v) + ";     # min. diff overhang contact");
        pw.println("$diff_contact_overhang_rule = \"" + this.diff_contact_overhang.rule + "\";     # min. diff overhang contact");
        pw.println("$diff_spacing = " + TextUtils.formatDouble(this.diff_spacing.v) + ";");
        pw.println("$diff_spacing_rule = \"" + this.diff_spacing.rule + "\";");
        pw.println();
        pw.println("######  POLY RULES  #####");
        pw.println("$poly_width = " + TextUtils.formatDouble(this.poly_width.v) + ";");
        pw.println("$poly_width_rule = \"" + this.poly_width.rule + "\";");
        pw.println("$poly_endcap = " + TextUtils.formatDouble(this.poly_endcap.v) + ";               # min. poly gate extension from edge of diffusion");
        pw.println("$poly_endcap_rule = \"" + this.poly_endcap.rule + "\";               # min. poly gate extension from edge of diffusion");
        pw.println("$poly_spacing = " + TextUtils.formatDouble(this.poly_spacing.v) + ";");
        pw.println("$poly_spacing_rule = \"" + this.poly_spacing.rule + "\";");
        pw.println("$poly_diff_spacing = " + TextUtils.formatDouble(this.poly_diff_spacing.v) + ";         # min. spacing between poly and diffusion");
        pw.println("$poly_diff_spacing_rule = \"" + this.poly_diff_spacing.rule + "\";         # min. spacing between poly and diffusion");
        pw.println();
        pw.println("######  GATE RULES  #####");
        pw.println("$gate_length = " + TextUtils.formatDouble(this.gate_length.v) + ";               # min. transistor gate length");
        pw.println("$gate_length_rule = \"" + this.gate_length.rule + "\";               # min. transistor gate length");
        pw.println("$gate_width = " + TextUtils.formatDouble(this.gate_width.v) + ";                # min. transistor gate width");
        pw.println("$gate_width_rule = \"" + this.gate_width.rule + "\";                # min. transistor gate width");
        pw.println("$gate_spacing = " + TextUtils.formatDouble(this.gate_spacing.v) + ";             # min. gate to gate spacing on diffusion");
        pw.println("$gate_spacing_rule = \"" + this.gate_spacing.rule + "\";             # min. gate to gate spacing on diffusion");
        pw.println("$gate_contact_spacing = " + TextUtils.formatDouble(this.gate_contact_spacing.v) + ";      # min. spacing from gate edge to contact inside diffusion");
        pw.println("$gate_contact_spacing_rule = \"" + this.gate_contact_spacing.rule + "\";      # min. spacing from gate edge to contact inside diffusion");
        pw.println();
        pw.println("######  CONTACT RULES  #####");
        pw.println("$contact_size = " + TextUtils.formatDouble(this.contact_size.v) + ";");
        pw.println("$contact_size_rule = \"" + this.contact_size.rule + "\";");
        pw.println("$contact_spacing = " + TextUtils.formatDouble(this.contact_spacing.v) + ";");
        pw.println("$contact_spacing_rule = \"" + this.contact_spacing.rule + "\";");
        pw.println("$contact_array_spacing = " + TextUtils.formatDouble(this.contact_array_spacing.v) + ";");
        pw.println("$contact_array_spacing_rule = \"" + this.contact_array_spacing.rule + "\";");
        pw.println("$contact_metal_overhang_inline_only = " + TextUtils.formatDouble(this.contact_metal_overhang_inline_only.v) + ";      # metal overhang when overhanging contact from two sides only");
        pw.println("$contact_metal_overhang_inline_only_rule = \"" + this.contact_metal_overhang_inline_only.rule + "\";      # metal overhang when overhanging contact from two sides only");
        pw.println("$contact_metal_overhang_all_sides = " + TextUtils.formatDouble(this.contact_metal_overhang_all_sides.v) + ";         # metal overhang when surrounding contact");
        pw.println("$contact_metal_overhang_all_sides_rule = \"" + this.contact_metal_overhang_all_sides.rule + "\";         # metal overhang when surrounding contact");
        pw.println("$contact_poly_overhang = " + TextUtils.formatDouble(this.contact_poly_overhang.v) + ";                    # poly overhang contact");
        pw.println("$contact_poly_overhang_rule = \"" + this.contact_poly_overhang.rule + "\";                    # poly overhang contact");
        pw.println("$polycon_diff_spacing = " + TextUtils.formatDouble(this.polycon_diff_spacing.v) + ";                    # spacing between poly-metal contact edge and diffusion");
        pw.println("$polycon_diff_spacing_rule = \"" + this.polycon_diff_spacing.rule + "\";                    # spacing between poly-metal contact edge and diffusion");
        pw.println();
        pw.println("######  WELL AND IMPLANT RULES  #####");
        pw.println("$nplus_width = " + TextUtils.formatDouble(this.nplus_width.v) + ";");
        pw.println("$nplus_width_rule = \"" + this.nplus_width.rule + "\";");
        pw.println("$nplus_overhang_diff = " + TextUtils.formatDouble(this.nplus_overhang_diff.v) + ";");
        pw.println("$nplus_overhang_diff_rule = \"" + this.nplus_overhang_diff.rule + "\";");
        pw.println("$nplus_overhang_poly = " + TextUtils.formatDouble(this.nplus_overhang_poly.v) + ";");
        pw.println("$nplus_overhang_poly_rule = \"" + this.nplus_overhang_poly.rule + "\";");
        pw.println("$nplus_spacing = " + TextUtils.formatDouble(this.nplus_spacing.v) + ";");
        pw.println("$nplus_spacing_rule = \"" + this.nplus_spacing.rule + "\";");
        pw.println();
        pw.println("$pplus_width = " + TextUtils.formatDouble(this.pplus_width.v) + ";");
        pw.println("$pplus_width_rule = \"" + this.pplus_width.rule + "\";");
        pw.println("$pplus_overhang_diff = " + TextUtils.formatDouble(this.pplus_overhang_diff.v) + ";");
        pw.println("$pplus_overhang_diff_rule = \"" + this.pplus_overhang_diff.rule + "\";");
        pw.println("$pplus_overhang_poly = " + TextUtils.formatDouble(this.pplus_overhang_poly.v) + ";");
        pw.println("$pplus_overhang_poly_rule = \"" + this.pplus_overhang_poly.rule + "\";");
        pw.println("$pplus_spacing = " + TextUtils.formatDouble(this.pplus_spacing.v) + ";");
        pw.println("$pplus_spacing_rule = \"" + this.pplus_spacing.rule + "\";");
        pw.println();
        pw.println("$nwell_width = " + TextUtils.formatDouble(this.nwell_width.v) + ";");
        pw.println("$nwell_width_rule = \"" + this.nwell_width.rule + "\";");
        pw.println("$nwell_overhang_diff_p = " + TextUtils.formatDouble(this.nwell_overhang_diff_p.v) + ";");
        pw.println("$nwell_overhang_diff_rule_p = \"" + this.nwell_overhang_diff_p.rule + "\";");
        pw.println("$nwell_overhang_diff_n = " + TextUtils.formatDouble(this.nwell_overhang_diff_n.v) + ";");
        pw.println("$nwell_overhang_diff_rule_n = \"" + this.nwell_overhang_diff_n.rule + "\";");
        pw.println("$nwell_spacing = " + TextUtils.formatDouble(this.nwell_spacing.v) + ";");
        pw.println("$nwell_spacing_rule = \"" + this.nwell_spacing.rule + "\";");
        pw.println();
        pw.println("######  METAL RULES  #####");
        pw.print("@metal_width = (");
        for (i = 0; i < this.num_metal_layers; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print(TextUtils.formatDouble(this.metal_width[i].v));
        }
        pw.println(");");
        pw.print("@metal_width_rule = (");
        for (i = 0; i < this.num_metal_layers; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print("\"" + this.metal_width[i].rule + "\"");
        }
        pw.println(");");
        pw.print("@metal_spacing = (");
        for (i = 0; i < this.num_metal_layers; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print(TextUtils.formatDouble(this.metal_spacing[i].v));
        }
        pw.println(");");
        pw.print("@metal_spacing_rule = (");
        for (i = 0; i < this.num_metal_layers; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print("\"" + this.metal_spacing[i].rule + "\"");
        }
        pw.println(");");
        pw.println();
        pw.println("######  VIA RULES  #####");
        pw.print("@via_size = (");
        for (i = 0; i < this.num_metal_layers - 1; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print(TextUtils.formatDouble(this.via_size[i].v));
        }
        pw.println(");");
        pw.print("@via_size_rule = (");
        for (i = 0; i < this.num_metal_layers - 1; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print("\"" + this.via_size[i].rule + "\"");
        }
        pw.println(");");
        pw.print("@via_spacing = (");
        for (i = 0; i < this.num_metal_layers - 1; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print(TextUtils.formatDouble(this.via_spacing[i].v));
        }
        pw.println(");");
        pw.print("@via_spacing_rule = (");
        for (i = 0; i < this.num_metal_layers - 1; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print("\"" + this.via_spacing[i].rule + "\"");
        }
        pw.println(");");
        pw.println();
        pw.println("## \"sep2d\" spacing, close proximity via array spacing");
        pw.print("@via_array_spacing = (");
        for (i = 0; i < this.num_metal_layers - 1; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print(TextUtils.formatDouble(this.via_array_spacing[i].v));
        }
        pw.println(");");
        pw.print("@via_array_spacing_rule = (");
        for (i = 0; i < this.num_metal_layers - 1; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print("\"" + this.via_array_spacing[i].rule + "\"");
        }
        pw.println(");");
        pw.print("@via_overhang_inline = (");
        for (i = 0; i < this.num_metal_layers - 1; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print(TextUtils.formatDouble(this.via_overhang_inline[i].v));
        }
        pw.println(");");
        pw.print("@via_overhang_inline_rule = (");
        for (i = 0; i < this.num_metal_layers - 1; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print("\"" + this.via_overhang_inline[i].rule + "\"");
        }
        pw.println(");");
        pw.println();
        pw.println("######  ANTENNA RULES  #####");
        pw.println("$poly_antenna_ratio = " + TextUtils.formatDouble(this.poly_antenna_ratio) + ";");
        pw.print("@metal_antenna_ratio = (");
        for (i = 0; i < this.num_metal_layers; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print(TextUtils.formatDouble(this.metal_antenna_ratio[i]));
        }
        pw.println(");");
        pw.println();
        pw.println("######  GDS-II LAYERS  #####");
        pw.println("$gds_diff_layer = " + this.gds_diff_layer + ";");
        pw.println("$gds_poly_layer = " + this.gds_poly_layer + ";");
        pw.println("$gds_nplus_layer = " + this.gds_nplus_layer + ";");
        pw.println("$gds_pplus_layer = " + this.gds_pplus_layer + ";");
        pw.println("$gds_nwell_layer = " + this.gds_nwell_layer + ";");
        pw.println("$gds_contact_layer = " + this.gds_contact_layer + ";");
        pw.print("@gds_metal_layer = (");
        for (i = 0; i < this.num_metal_layers; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print(this.gds_metal_layer[i]);
        }
        pw.println(");");
        pw.print("@gds_via_layer = (");
        for (i = 0; i < this.num_metal_layers - 1; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print(this.gds_via_layer[i]);
        }
        pw.println(");");
        pw.println();
        pw.println("## Device marking layer");
        pw.println("$gds_marking_layer = " + this.gds_marking_layer + ";");
        pw.println();
        pw.println("# End of techfile");
    }

    void writeXML() {
        String errorMessage = this.errorInData();
        if (errorMessage != null) {
            Job.getUserInterface().showErrorMessage("ERROR: " + errorMessage, "Missing Technology Data");
            return;
        }
        String fileName = OpenFile.chooseOutputFile(FileType.XML, "Technology XML File", "Technology.xml");
        if (fileName == null) {
            return;
        }
        try {
            this.dumpXMLFile(fileName);
        }
        catch (IOException e) {
            System.out.println("Error writing XML file");
            return;
        }
    }

    private Xml.PrimitiveNode makeXmlPrimitivePin(List<Xml.PrimitiveNode> nodes, String name, double size, SizeOffset so, Xml.NodeLayer ... list) {
        ArrayList<Xml.NodeLayer> nodesList = new ArrayList<Xml.NodeLayer>(list.length);
        ArrayList<Xml.PrimitivePort> nodePorts = new ArrayList<Xml.PrimitivePort>();
        ArrayList<String> portNames = new ArrayList<String>();
        for (Xml.NodeLayer lb : list) {
            if (lb == null) continue;
            nodesList.add(lb);
        }
        portNames.add(name);
        nodePorts.add(this.makeXmlPrimitivePort(name.toLowerCase(), 0, 180, 0, null, 0.0, 0.0, 0.0, 0.0, portNames));
        return this.makeXmlPrimitive(nodes, name + "-Pin", PrimitiveNode.Function.PIN, size, size, 0.0, 0.0, so, nodesList, nodePorts, null, true);
    }

    private Xml.PrimitiveNode makeXmlPrimitiveCon(List<Xml.PrimitiveNode> nodes, String name, double size, SizeOffset so, List<String> portNames, Xml.NodeLayer ... list) {
        ArrayList<Xml.NodeLayer> nodesList = new ArrayList<Xml.NodeLayer>(list.length);
        ArrayList<Xml.PrimitivePort> nodePorts = new ArrayList<Xml.PrimitivePort>();
        for (Xml.NodeLayer lb : list) {
            if (lb == null) continue;
            nodesList.add(lb);
        }
        nodePorts.add(this.makeXmlPrimitivePort(name.toLowerCase(), 0, 180, 0, null, 0.0, 0.0, 0.0, 0.0, portNames));
        return this.makeXmlPrimitive(nodes, name + "-Con", PrimitiveNode.Function.CONTACT, size, size, 0.0, 0.0, so, nodesList, nodePorts, null, false);
    }

    private Xml.PrimitiveNode makeXmlPrimitive(List<Xml.PrimitiveNode> nodes, String name, PrimitiveNode.Function function, double width, double height, double ppLeft, double ppBottom, SizeOffset so, List<Xml.NodeLayer> nodeLayers, List<Xml.PrimitivePort> nodePorts, PrimitiveNode.NodeSizeRule nodeSizeRule, boolean isArcsShrink) {
        Xml.PrimitiveNode n = new Xml.PrimitiveNode();
        n.name = name;
        n.function = function;
        n.shrinkArcs = isArcsShrink;
        EPoint minFullSize = EPoint.fromLambda(0.5 * width, 0.5 * height);
        EPoint topLeft = EPoint.fromLambda(ppLeft, ppBottom + height);
        EPoint size = EPoint.fromLambda(width, height);
        double getDefWidth = width;
        double getDefHeight = height;
        if (function == PrimitiveNode.Function.PIN && isArcsShrink) {
            minFullSize = EPoint.fromLambda(ppLeft, ppBottom);
        }
        if (so != null && so.getLowXOffset() == 0.0 && so.getHighXOffset() == 0.0 && so.getLowYOffset() == 0.0 && so.getHighYOffset() == 0.0) {
            so = null;
        }
        n.sizeOffset = so;
        ERectangle baseRectangle = ERectangle.fromGrid(topLeft.getGridX(), topLeft.getGridY(), size.getGridX(), size.getGridY());
        boolean isSerp = false;
        if (nodeLayers != null) {
            n.nodeLayers.addAll(nodeLayers);
        }
        n.specialType = 0;
        if (nodeSizeRule != null) {
            n.nodeSizeRule = new Xml.NodeSizeRule();
            n.nodeSizeRule.width = nodeSizeRule.getWidth();
            n.nodeSizeRule.height = nodeSizeRule.getHeight();
            n.nodeSizeRule.rule = nodeSizeRule.getRuleName();
        }
        n.ports.addAll(nodePorts);
        nodes.add(n);
        return n;
    }

    private Xml.ArcProto makeXmlArc(List<Xml.ArcProto> arcs, String name, ArcProto.Function function, double ant, Xml.ArcLayer ... arcLayers) {
        Xml.ArcProto a = new Xml.ArcProto();
        a.name = name;
        a.function = function;
        a.wipable = true;
        a.extended = true;
        a.fixedAngle = true;
        a.angleIncrement = 90;
        a.antennaRatio = DBMath.round(ant);
        for (Xml.ArcLayer al : arcLayers) {
            if (al == null) continue;
            a.arcLayers.add(al);
        }
        arcs.add(a);
        return a;
    }

    private Xml.Layer makeXmlLayer(List<Xml.Layer> layers, Map<Xml.Layer, WizardField> layer_width, String name, Layer.Function function, int extraf, EGraphics graph, char cifLetter, WizardField width, boolean pureLayerNode, boolean pureLayerPortArc) {
        Xml.Layer l = new Xml.Layer();
        l.name = name;
        l.function = function;
        l.extraFunction = extraf;
        l.desc = graph;
        l.thick3D = 1.0;
        l.height3D = 1.0;
        l.mode3D = "NONE";
        l.factor3D = 1.0;
        l.cif = "C" + cifLetter + cifLetter;
        l.skill = name;
        l.resistance = 1.0;
        l.capacitance = 0.0;
        l.edgeCapacitance = 0.0;
        assert (pureLayerNode || !pureLayerPortArc);
        if (pureLayerNode) {
            l.pureLayerNode = new Xml.PureLayerNode();
            l.pureLayerNode.name = name + "-Node";
            l.pureLayerNode.style = Poly.Type.FILLED;
            l.pureLayerNode.size.addLambda(this.scaledValue(width.v));
            l.pureLayerNode.port = "Port_" + name;
            if (pureLayerPortArc) {
                l.pureLayerNode.portArcs.add(name);
            }
        }
        layers.add(l);
        layer_width.put(l, width);
        return l;
    }

    private Xml.NodeLayer makeXmlNodeLayer(double lx, double hx, double ly, double hy, Xml.Layer lb, Poly.Type style, boolean electricalLayers) {
        Xml.NodeLayer nl = new Xml.NodeLayer();
        nl.layer = lb.name;
        nl.style = style;
        nl.inLayers = true;
        nl.inElectricalLayers = electricalLayers;
        nl.representation = 1;
        nl.lx.k = -1.0;
        nl.hx.k = 1.0;
        nl.ly.k = -1.0;
        nl.hy.k = 1.0;
        nl.lx.addLambda(-lx);
        nl.hx.addLambda(hx);
        nl.ly.addLambda(-ly);
        nl.hy.addLambda(hy);
        return nl;
    }

    private Xml.NodeLayer makeXmlMulticut(Xml.Layer lb, double sizeRule, double sepRule, double sepRule2D) {
        Xml.NodeLayer nl = new Xml.NodeLayer();
        nl.layer = lb.name;
        nl.style = Poly.Type.FILLED;
        nl.inElectricalLayers = true;
        nl.inLayers = true;
        nl.representation = 3;
        nl.lx.k = -1.0;
        nl.hx.k = 1.0;
        nl.ly.k = -1.0;
        nl.hy.k = 1.0;
        nl.sizex = sizeRule;
        nl.sizey = sizeRule;
        nl.sep1d = sepRule;
        nl.sep2d = sepRule2D;
        return nl;
    }

    private Xml.PrimitivePort makeXmlPrimitivePort(String name, int portAngle, int portRange, int portTopology, EPoint minFullSize, double lx, double hx, double ly, double hy, List<String> portArcs) {
        Xml.PrimitivePort ppd = new Xml.PrimitivePort();
        double lambdaX = minFullSize != null ? minFullSize.getLambdaX() : 0.0;
        double lambdaY = minFullSize != null ? minFullSize.getLambdaY() : 0.0;
        ppd.name = name;
        ppd.portAngle = portAngle;
        ppd.portRange = portRange;
        ppd.portTopology = portTopology;
        ppd.lx.k = -1.0;
        ppd.lx.addLambda(DBMath.round(lx + lambdaX * ppd.lx.k));
        ppd.hx.k = 1.0;
        ppd.hx.addLambda(DBMath.round(hx + lambdaX * ppd.hx.k));
        ppd.ly.k = -1.0;
        ppd.ly.addLambda(DBMath.round(ly + lambdaY * ppd.ly.k));
        ppd.hy.k = 1.0;
        ppd.hy.addLambda(DBMath.round(hy + lambdaY * ppd.hy.k));
        if (portArcs != null) {
            for (String s : portArcs) {
                ppd.portArcs.add(s);
            }
        }
        return ppd;
    }

    public void dumpXMLFile(String fileName) throws IOException {
        int i;
        int metalNum;
        int i2;
        Xml.Technology t = new Xml.Technology();
        t.techName = this.getTechName();
        t.shortTechName = this.getTechName();
        t.description = this.getTechDescription();
        t.maxNumMetals = t.defaultNumMetals = this.getNumMetalLayers();
        t.minNumMetals = t.defaultNumMetals;
        t.scaleValue = this.getStepSize();
        t.scaleRelevant = true;
        t.defaultFoundry = "NONE";
        t.minResistance = 1.0;
        t.minCapacitance = 0.1;
        Color[] metal_colour = new Color[]{new Color(0, 150, 255), new Color(148, 0, 211), new Color(255, 215, 0), new Color(132, 112, 255), new Color(255, 160, 122), new Color(34, 139, 34), new Color(178, 34, 34), new Color(34, 34, 178), new Color(153, 153, 153), new Color(102, 102, 102)};
        Color poly_colour = new Color(255, 155, 192);
        Color diff_colour = new Color(107, 226, 96);
        Color via_colour = new Color(205, 205, 205);
        Color contact_colour = new Color(40, 40, 40);
        Color nplus_colour = new Color(224, 238, 224);
        Color pplus_colour = new Color(224, 224, 120);
        Color nwell_colour = new Color(140, 140, 140);
        Color[] colorMap = new Color[]{poly_colour, diff_colour, metal_colour[0], metal_colour[1], metal_colour[2]};
        for (int i3 = 0; i3 < colorMap.length; ++i3) {
            Color transparentColor = colorMap[i3];
            t.transparentLayers.add(transparentColor);
        }
        ArrayList<Xml.Layer> metalLayers = new ArrayList<Xml.Layer>();
        ArrayList<Xml.Layer> viaLayers = new ArrayList<Xml.Layer>();
        LinkedHashMap<Xml.Layer, WizardField> layer_width = new LinkedHashMap<Xml.Layer, WizardField>();
        int[] nullPattern = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        int cifNumber = 0;
        for (i2 = 0; i2 < this.num_metal_layers; ++i2) {
            metalNum = i2 + 1;
            double opacity = (double)(75 - metalNum * 5) / 100.0;
            int metLayHigh = i2 / 10;
            int metLayDig = i2 % 10;
            int r = metal_colour[metLayDig].getRed() * (10 - metLayHigh) / 10;
            int g = metal_colour[metLayDig].getGreen() * (10 - metLayHigh) / 10;
            int b = metal_colour[metLayDig].getBlue() * (10 - metLayHigh) / 10;
            int tcol = 0;
            int[] pattern = null;
            switch (metLayDig) {
                case 0: {
                    tcol = 3;
                    break;
                }
                case 1: {
                    tcol = 4;
                    break;
                }
                case 2: {
                    tcol = 5;
                    break;
                }
                case 3: {
                    pattern = new int[]{65535, 0, 65535, 0, 65535, 0, 65535, 0, 65535, 0, 65535, 0, 65535, 0, 65535, 0};
                    break;
                }
                case 4: {
                    pattern = new int[]{34952, 4369, 8738, 17476, 34952, 4369, 8738, 17476, 34952, 4369, 8738, 17476, 34952, 4369, 8738, 17476};
                    break;
                }
                case 5: {
                    pattern = new int[]{4369, 65535, 4369, 21845, 4369, 65535, 4369, 21845, 4369, 65535, 4369, 21845, 4369, 65535, 4369, 21845};
                    break;
                }
                case 6: {
                    pattern = new int[]{34952, 17476, 8738, 4369, 34952, 17476, 8738, 4369, 34952, 17476, 8738, 4369, 34952, 17476, 8738, 4369};
                    break;
                }
                case 7: {
                    pattern = new int[]{8738, 0, 34952, 0, 8738, 0, 34952, 0, 8738, 0, 34952, 0, 8738, 0, 34952, 0};
                    break;
                }
                case 8: {
                    pattern = new int[]{0, 8738, 0, 34952, 0, 8738, 0, 34952, 0, 8738, 0, 34952, 0, 8738, 0, 34952};
                    break;
                }
                case 9: {
                    pattern = new int[]{21845, 21845, 21845, 21845, 21845, 21845, 21845, 21845, 21845, 21845, 21845, 21845, 21845, 21845, 21845, 21845};
                }
            }
            boolean onDisplay = true;
            boolean onPrinter = true;
            if (pattern == null) {
                pattern = nullPattern;
                onDisplay = false;
                onPrinter = false;
            }
            EGraphics graph = new EGraphics(onDisplay, onPrinter, null, tcol, r, g, b, opacity, true, pattern);
            Layer.Function fun = Layer.Function.getMetal(metalNum);
            if (fun == null) {
                throw new IOException("invalid number of metals");
            }
            Xml.Layer layer = this.makeXmlLayer(t.layers, layer_width, "Metal-" + metalNum, fun, 0, graph, (char)(65 + cifNumber++), this.metal_width[i2], true, true);
            metalLayers.add(layer);
        }
        for (i2 = 0; i2 < this.num_metal_layers - 1; ++i2) {
            metalNum = i2 + 1;
            int r = via_colour.getRed();
            int g = via_colour.getGreen();
            int b = via_colour.getBlue();
            double opacity = 0.7;
            EGraphics graph = new EGraphics(false, false, null, 0, r, g, b, opacity, true, nullPattern);
            Layer.Function fun = Layer.Function.getContact(metalNum);
            if (fun == null) {
                throw new IOException("invalid number of vias");
            }
            viaLayers.add(this.makeXmlLayer(t.layers, layer_width, "Via-" + metalNum, fun, 16384, graph, (char)(65 + cifNumber++), this.via_size[i2], true, false));
        }
        EGraphics graph = new EGraphics(false, false, null, 1, 0, 0, 0, 1.0, true, nullPattern);
        Xml.Layer polyLayer = this.makeXmlLayer(t.layers, layer_width, "Poly", Layer.Function.POLY1, 0, graph, (char)(65 + cifNumber++), this.poly_width, true, true);
        Xml.Layer polyGateLayer = this.makeXmlLayer(t.layers, layer_width, "PolyGate", Layer.Function.GATE, 0, graph, (char)(65 + cifNumber++), this.poly_width, false, false);
        graph = new EGraphics(false, false, null, 0, contact_colour.getRed(), contact_colour.getGreen(), contact_colour.getBlue(), 1.0, true, nullPattern);
        Xml.Layer polyConLayer = this.makeXmlLayer(t.layers, layer_width, "PolyCon", Layer.Function.CONTACT1, 32768, graph, (char)(65 + cifNumber++), this.contact_size, true, false);
        Xml.Layer diffConLayer = this.makeXmlLayer(t.layers, layer_width, "DiffCon", Layer.Function.CONTACT1, 65536, graph, (char)(65 + cifNumber++), this.contact_size, true, false);
        graph = new EGraphics(false, false, null, 2, 0, 0, 0, 1.0, true, nullPattern);
        Xml.Layer diffNLayer = this.makeXmlLayer(t.layers, layer_width, "N-Diff", Layer.Function.DIFFN, 0, graph, (char)(65 + cifNumber++), this.diff_width, true, true);
        Xml.Layer diffPLayer = this.makeXmlLayer(t.layers, layer_width, "P-Diff", Layer.Function.DIFFP, 0, graph, (char)(65 + cifNumber++), this.diff_width, true, true);
        int[] pattern = new int[]{4112, 8224, 16448, 32896, 257, 514, 1028, 2056, 4112, 8224, 16448, 32896, 257, 514, 1028, 2056};
        graph = new EGraphics(true, true, null, 0, nplus_colour.getRed(), nplus_colour.getGreen(), nplus_colour.getBlue(), 1.0, true, pattern);
        Xml.Layer nplusLayer = this.makeXmlLayer(t.layers, layer_width, "NPlus", Layer.Function.IMPLANTN, 0, graph, (char)(65 + cifNumber++), this.nplus_width, true, false);
        graph = new EGraphics(true, true, null, 0, pplus_colour.getRed(), pplus_colour.getGreen(), pplus_colour.getBlue(), 1.0, true, pattern);
        Xml.Layer pplusLayer = this.makeXmlLayer(t.layers, layer_width, "PPlus", Layer.Function.IMPLANTP, 0, graph, (char)(65 + cifNumber++), this.pplus_width, true, false);
        pattern = new int[]{514, 257, 32896, 16448, 8224, 4112, 2056, 1028, 514, 257, 32896, 16448, 8224, 4112, 2056, 1028};
        graph = new EGraphics(true, true, null, 0, nwell_colour.getRed(), nwell_colour.getGreen(), nwell_colour.getBlue(), 1.0, true, pattern);
        Xml.Layer nwellLayer = this.makeXmlLayer(t.layers, layer_width, "N-Well", Layer.Function.WELLN, 0, graph, (char)(65 + cifNumber++), this.nwell_width, true, false);
        Xml.Layer pwellLayer = this.makeXmlLayer(t.layers, layer_width, "P-Well", Layer.Function.WELLP, 0, graph, (char)(65 + cifNumber++), this.nwell_width, true, false);
        graph = new EGraphics(false, false, null, 0, 255, 0, 0, 0.4, true, nullPattern);
        Xml.Layer deviceMarkLayer = this.makeXmlLayer(t.layers, layer_width, "DeviceMark", Layer.Function.CONTROL, 0, graph, (char)(65 + cifNumber++), this.nplus_width, true, false);
        for (int i4 = 1; i4 <= this.num_metal_layers; ++i4) {
            double ant = (int)Math.round(this.metal_antenna_ratio[i4 - 1]) | 0xC8;
            this.makeXmlArc(t.arcs, "Metal-" + i4, ArcProto.Function.getContact(i4), ant, this.makeXmlArcLayer((Xml.Layer)metalLayers.get(i4 - 1), this.metal_width[i4 - 1]));
        }
        ArrayList<String> portNames = new ArrayList<String>();
        double ant = (int)Math.round(this.poly_antenna_ratio) | 0xC8;
        this.makeXmlArc(t.arcs, "Poly", ArcProto.Function.getPoly(1), ant, this.makeXmlArcLayer(polyLayer, this.poly_width));
        double hla = this.scaledValue(this.poly_width.v / 2.0);
        this.makeXmlPrimitivePin(t.nodes, polyLayer.name, hla, null, this.makeXmlNodeLayer(hla, hla, hla, hla, polyLayer, Poly.Type.CROSSED, true));
        portNames.clear();
        portNames.add(polyLayer.name);
        portNames.add(((Xml.Layer)metalLayers.get((int)0)).name);
        hla = this.scaledValue(this.contact_size.v / 2.0 + this.contact_poly_overhang.v);
        Xml.Layer m1Layer = (Xml.Layer)metalLayers.get(0);
        double contSize = this.scaledValue(this.contact_size.v);
        double contSpacing = this.scaledValue(this.contact_spacing.v);
        double contArraySpacing = this.scaledValue(this.contact_array_spacing.v);
        double metal1Over = this.scaledValue(this.contact_size.v / 2.0 + this.contact_metal_overhang_all_sides.v);
        this.makeXmlPrimitiveCon(t.nodes, polyLayer.name, hla, null, portNames, this.makeXmlNodeLayer(metal1Over, metal1Over, metal1Over, metal1Over, m1Layer, Poly.Type.FILLED, true), this.makeXmlNodeLayer(hla, hla, hla, hla, polyLayer, Poly.Type.FILLED, true), this.makeXmlMulticut(diffConLayer, contSize, contSpacing, contArraySpacing));
        this.makeXmlArc(t.arcs, "N-Diff", ArcProto.Function.DIFFN, 0.0, this.makeXmlArcLayer(diffNLayer, this.diff_width), this.makeXmlArcLayer(nplusLayer, this.diff_width, this.nplus_overhang_diff), !this.pWellFlag ? this.makeXmlArcLayer(pwellLayer, this.diff_width, this.nwell_overhang_diff_p) : null);
        this.makeXmlArc(t.arcs, "P-Diff", ArcProto.Function.DIFFP, 0.0, this.makeXmlArcLayer(diffPLayer, this.diff_width), this.makeXmlArcLayer(pplusLayer, this.diff_width, this.pplus_overhang_diff), this.makeXmlArcLayer(nwellLayer, this.diff_width, this.nwell_overhang_diff_p));
        hla = this.scaledValue(this.contact_size.v / 2.0 + this.diff_contact_overhang.v);
        double nsel = this.scaledValue(this.contact_size.v / 2.0 + this.diff_contact_overhang.v + this.nplus_overhang_diff.v);
        double psel = this.scaledValue(this.contact_size.v / 2.0 + this.diff_contact_overhang.v + this.pplus_overhang_diff.v);
        double nwell = this.scaledValue(this.contact_size.v / 2.0 + this.diff_contact_overhang.v + this.nwell_overhang_diff_p.v);
        double nso = this.scaledValue(this.nwell_overhang_diff_p.v);
        double pso = !this.pWellFlag ? nso : this.scaledValue(this.nplus_overhang_diff.v);
        this.makeXmlPrimitivePin(t.nodes, "N-Diff", hla, new SizeOffset(pso, pso, pso, pso), this.makeXmlNodeLayer(hla, hla, hla, hla, diffNLayer, Poly.Type.CROSSED, true), this.makeXmlNodeLayer(nsel, nsel, nsel, nsel, nplusLayer, Poly.Type.CROSSED, true), !this.pWellFlag ? this.makeXmlNodeLayer(nwell, nwell, nwell, nwell, pwellLayer, Poly.Type.CROSSED, true) : null);
        this.makeXmlPrimitivePin(t.nodes, "P-Diff", hla, new SizeOffset(nso, nso, nso, nso), this.makeXmlNodeLayer(hla, hla, hla, hla, diffPLayer, Poly.Type.CROSSED, true), this.makeXmlNodeLayer(psel, psel, psel, psel, pplusLayer, Poly.Type.CROSSED, true), this.makeXmlNodeLayer(nwell, nwell, nwell, nwell, nwellLayer, Poly.Type.CROSSED, true));
        hla = this.scaledValue(this.contact_size.v / 2.0 + this.diff_contact_overhang.v);
        portNames.clear();
        portNames.add(diffNLayer.name);
        portNames.add(m1Layer.name);
        this.makeXmlPrimitiveCon(t.nodes, "N-Diff", hla, new SizeOffset(pso, pso, pso, pso), portNames, this.makeXmlNodeLayer(metal1Over, metal1Over, metal1Over, metal1Over, m1Layer, Poly.Type.FILLED, true), this.makeXmlNodeLayer(hla, hla, hla, hla, diffNLayer, Poly.Type.FILLED, true), this.makeXmlNodeLayer(nsel, nsel, nsel, nsel, nplusLayer, Poly.Type.FILLED, true), !this.pWellFlag ? this.makeXmlNodeLayer(nwell, nwell, nwell, nwell, pwellLayer, Poly.Type.FILLED, true) : null, this.makeXmlMulticut(diffConLayer, contSize, contSpacing, contArraySpacing));
        portNames.clear();
        portNames.add(diffPLayer.name);
        portNames.add(m1Layer.name);
        this.makeXmlPrimitiveCon(t.nodes, "P-Diff", hla, new SizeOffset(nso, nso, nso, nso), portNames, this.makeXmlNodeLayer(metal1Over, metal1Over, metal1Over, metal1Over, m1Layer, Poly.Type.FILLED, true), this.makeXmlNodeLayer(hla, hla, hla, hla, diffPLayer, Poly.Type.FILLED, true), this.makeXmlNodeLayer(psel, psel, psel, psel, pplusLayer, Poly.Type.FILLED, true), this.makeXmlNodeLayer(nwell, nwell, nwell, nwell, nwellLayer, Poly.Type.FILLED, true), this.makeXmlMulticut(diffConLayer, contSize, contSpacing, contArraySpacing));
        nwell = this.scaledValue(this.contact_size.v / 2.0 + this.diff_contact_overhang.v + this.nwell_overhang_diff_n.v);
        nso = this.scaledValue(this.nwell_overhang_diff_n.v);
        if (!this.pWellFlag) {
            this.makeXmlArc(t.arcs, "P-Well", ArcProto.Function.WELL, 0.0, this.makeXmlArcLayer(pwellLayer, this.diff_width, this.nwell_overhang_diff_p));
        }
        this.makeXmlArc(t.arcs, "N-Well", ArcProto.Function.WELL, 0.0, this.makeXmlArcLayer(nwellLayer, this.diff_width, this.nwell_overhang_diff_p));
        portNames.clear();
        if (!this.pWellFlag) {
            portNames.add(pwellLayer.name);
        }
        portNames.add(m1Layer.name);
        this.makeXmlPrimitiveCon(t.nodes, "P-Well", hla, new SizeOffset(pso, pso, pso, pso), portNames, this.makeXmlNodeLayer(metal1Over, metal1Over, metal1Over, metal1Over, m1Layer, Poly.Type.FILLED, true), this.makeXmlNodeLayer(hla, hla, hla, hla, diffPLayer, Poly.Type.FILLED, true), this.makeXmlNodeLayer(nsel, psel, psel, psel, pplusLayer, Poly.Type.FILLED, true), !this.pWellFlag ? this.makeXmlNodeLayer(nwell, nwell, nwell, nwell, pwellLayer, Poly.Type.FILLED, true) : null, this.makeXmlMulticut(diffConLayer, contSize, contSpacing, contArraySpacing));
        portNames.clear();
        portNames.add(nwellLayer.name);
        portNames.add(m1Layer.name);
        this.makeXmlPrimitiveCon(t.nodes, "N-Well", hla, new SizeOffset(nso, nso, nso, nso), portNames, this.makeXmlNodeLayer(metal1Over, metal1Over, metal1Over, metal1Over, m1Layer, Poly.Type.FILLED, true), this.makeXmlNodeLayer(hla, hla, hla, hla, diffNLayer, Poly.Type.FILLED, true), this.makeXmlNodeLayer(nsel, nsel, nsel, nsel, nplusLayer, Poly.Type.FILLED, true), this.makeXmlNodeLayer(nwell, nwell, nwell, nwell, nwellLayer, Poly.Type.FILLED, true), this.makeXmlMulticut(diffConLayer, contSize, contSpacing, contArraySpacing));
        for (int i5 = 1; i5 < this.num_metal_layers; ++i5) {
            hla = this.scaledValue(this.metal_width[i5 - 1].v / 2.0);
            Xml.Layer lb = (Xml.Layer)metalLayers.get(i5 - 1);
            this.makeXmlPrimitivePin(t.nodes, lb.name, hla, null, this.makeXmlNodeLayer(hla, hla, hla, hla, lb, Poly.Type.CROSSED, true));
            double metalW = this.via_size[i5 - 1].v / 2.0 + this.contact_metal_overhang_all_sides.v;
            hla = this.scaledValue(metalW);
            Xml.Layer lt = (Xml.Layer)metalLayers.get(i5);
            Xml.Layer via = (Xml.Layer)viaLayers.get(i5 - 1);
            double viaSize = this.scaledValue(this.via_size[i5 - 1].v);
            double viaSpacing = this.scaledValue(this.via_spacing[i5 - 1].v);
            double viaArraySpacing = this.scaledValue(this.via_array_spacing[i5 - 1].v);
            String name = lb.name + "-" + lt.name;
            portNames.clear();
            portNames.add(lt.name);
            portNames.add(lb.name);
            this.makeXmlPrimitiveCon(t.nodes, name, hla, null, portNames, this.makeXmlNodeLayer(hla, hla, hla, hla, lb, Poly.Type.FILLED, true), this.makeXmlNodeLayer(hla, hla, hla, hla, lt, Poly.Type.FILLED, true), this.makeXmlMulticut(via, viaSize, viaSpacing, viaArraySpacing));
        }
        ArrayList<Xml.NodeLayer> nodesList = new ArrayList<Xml.NodeLayer>();
        ArrayList<Xml.PrimitivePort> nodePorts = new ArrayList<Xml.PrimitivePort>();
        EPoint minFullSize = null;
        for (int i6 = 0; i6 < 2; ++i6) {
            Xml.Layer selectLayer;
            Xml.Layer activeLayer;
            String name;
            double selecty = 0.0;
            double selectx = 0.0;
            Xml.Layer wellLayer = null;
            double sox = 0.0;
            double soy = 0.0;
            double impx = this.scaledValue(this.gate_width.v / 2.0);
            double impy = this.scaledValue((this.gate_length.v + this.diff_poly_overhang.v * 2.0) / 2.0);
            double wellx = this.scaledValue(this.gate_width.v / 2.0 + this.nwell_overhang_diff_p.v);
            double welly = this.scaledValue(this.gate_length.v / 2.0 + this.diff_poly_overhang.v + this.nwell_overhang_diff_p.v);
            if (i6 == 0) {
                name = "P";
                wellLayer = nwellLayer;
                activeLayer = diffPLayer;
                selectLayer = pplusLayer;
                sox = this.scaledValue(this.nwell_overhang_diff_p.v);
                soy = this.scaledValue(this.diff_poly_overhang.v + this.nwell_overhang_diff_p.v);
                selectx = this.scaledValue(this.gate_width.v / 2.0 + (this.poly_endcap.v + this.pplus_overhang_poly.v));
                selecty = this.scaledValue(this.gate_length.v / 2.0 + this.diff_poly_overhang.v + this.pplus_overhang_diff.v);
            } else {
                name = "N";
                if (!this.pWellFlag) {
                    wellLayer = pwellLayer;
                }
                activeLayer = diffNLayer;
                selectLayer = nplusLayer;
                sox = this.scaledValue(this.poly_endcap.v + this.pplus_overhang_poly.v);
                soy = this.scaledValue(this.diff_poly_overhang.v + this.pplus_overhang_diff.v);
                selectx = this.scaledValue(this.gate_width.v / 2.0 + (this.poly_endcap.v + this.nplus_overhang_poly.v));
                selecty = this.scaledValue(this.gate_length.v / 2.0 + this.diff_poly_overhang.v + this.nplus_overhang_diff.v);
            }
            nodesList.clear();
            nodePorts.clear();
            portNames.clear();
            double gatey = this.scaledValue(this.gate_length.v / 2.0);
            double gatex = impx;
            double endPolyx = this.scaledValue((this.gate_width.v + this.poly_endcap.v * 2.0) / 2.0);
            double endPolyy = gatey;
            double endLeftOrRight = -impx;
            double endTopOrBotton = endPolyy;
            double diffX = 0.0;
            double diffY = impy;
            double xSign = 1.0;
            double ySign = -1.0;
            double polyX = endPolyx;
            double polyY = 0.0;
            if (!this.horizontalFlag) {
                double tmp = impx;
                impx = impy;
                impy = tmp;
                tmp = wellx;
                wellx = welly;
                welly = tmp;
                tmp = sox;
                sox = soy;
                soy = tmp;
                tmp = selectx;
                selectx = selecty;
                selecty = tmp;
                tmp = gatex;
                gatex = gatey;
                gatey = tmp;
                tmp = endPolyx;
                endPolyx = endPolyy;
                endPolyy = tmp;
                tmp = diffX;
                diffX = diffY;
                diffY = tmp;
                tmp = polyX;
                polyX = polyY;
                polyY = tmp;
                tmp = xSign;
                xSign = ySign;
                ySign = tmp;
                endLeftOrRight = endPolyx;
                endTopOrBotton = -impx;
            }
            if (wellLayer != null) {
                nodesList.add(this.makeXmlNodeLayer(wellx, wellx, welly, welly, wellLayer, Poly.Type.FILLED, true));
            }
            nodesList.add(this.makeXmlNodeLayer(impx, impx, impy, impy, activeLayer, Poly.Type.FILLED, true));
            portNames.clear();
            portNames.add(activeLayer.name);
            nodePorts.add(this.makeXmlPrimitivePort("trans-diff-top", 90, 90, 0, minFullSize, diffX, diffX, diffY, diffY, portNames));
            nodePorts.add(this.makeXmlPrimitivePort("trans-diff-bottom", 270, 90, 0, minFullSize, xSign * diffX, xSign * diffX, ySign * diffY, ySign * diffY, portNames));
            nodesList.add(this.makeXmlNodeLayer(gatex, gatex, gatey, gatey, polyGateLayer, Poly.Type.FILLED, true));
            nodesList.add(this.makeXmlNodeLayer(endPolyx, endLeftOrRight, endPolyy, endTopOrBotton, polyLayer, Poly.Type.FILLED, true));
            nodesList.add(this.makeXmlNodeLayer(endLeftOrRight, endPolyx, endTopOrBotton, endPolyy, polyLayer, Poly.Type.FILLED, true));
            nodesList.add(this.makeXmlNodeLayer(endPolyx, endPolyx, endPolyy, endPolyy, polyLayer, Poly.Type.FILLED, false));
            portNames.clear();
            portNames.add(polyLayer.name);
            nodePorts.add(this.makeXmlPrimitivePort("trans-poly-left", 180, 90, 0, minFullSize, ySign * polyX, ySign * polyX, xSign * polyY, xSign * polyY, portNames));
            nodePorts.add(this.makeXmlPrimitivePort("trans-poly-right", 0, 180, 0, minFullSize, polyX, polyX, polyY, polyY, portNames));
            nodesList.add(this.makeXmlNodeLayer(selectx, selectx, selecty, selecty, selectLayer, Poly.Type.FILLED, true));
            this.makeXmlPrimitive(t.nodes, name + "-Transistor", PrimitiveNode.Function.TRANMOS, 0.0, 0.0, 0.0, 0.0, new SizeOffset(sox, sox, soy, soy), nodesList, nodePorts, null, false);
        }
        Xml.Foundry f = new Xml.Foundry();
        f.name = Foundry.Type.NONE.getName();
        t.foundries.add(f);
        this.makeLayerGDS(t, diffPLayer, String.valueOf(this.gds_diff_layer));
        this.makeLayerGDS(t, diffNLayer, String.valueOf(this.gds_diff_layer));
        this.makeLayerGDS(t, pplusLayer, String.valueOf(this.gds_pplus_layer));
        this.makeLayerGDS(t, nplusLayer, String.valueOf(this.gds_nplus_layer));
        this.makeLayerGDS(t, nwellLayer, String.valueOf(this.gds_nwell_layer));
        this.makeLayerGDS(t, deviceMarkLayer, String.valueOf(this.gds_marking_layer));
        this.makeLayerGDS(t, polyConLayer, String.valueOf(this.gds_contact_layer));
        this.makeLayerGDS(t, diffConLayer, String.valueOf(this.gds_contact_layer));
        this.makeLayerGDS(t, polyLayer, String.valueOf(this.gds_poly_layer));
        this.makeLayerGDS(t, polyGateLayer, String.valueOf(this.gds_poly_layer));
        for (i = 0; i < this.num_metal_layers; ++i) {
            Xml.Layer met = (Xml.Layer)metalLayers.get(i);
            this.makeLayerGDS(t, met, String.valueOf(this.gds_metal_layer[i]));
            if (i > this.num_metal_layers - 2) continue;
            Xml.Layer via = (Xml.Layer)viaLayers.get(i);
            this.makeLayerGDS(t, via, String.valueOf(this.gds_via_layer[i]));
        }
        this.makeLayerRuleMinWid(t, diffPLayer, this.diff_width);
        this.makeLayerRuleMinWid(t, diffNLayer, this.diff_width);
        this.makeLayerRuleMinWid(t, pplusLayer, this.pplus_width);
        this.makeLayersRuleSurround(t, pplusLayer, diffPLayer, this.pplus_overhang_diff);
        this.makeLayerRuleMinWid(t, nplusLayer, this.nplus_width);
        this.makeLayersRuleSurround(t, nplusLayer, diffNLayer, this.nplus_overhang_diff);
        this.makeLayerRuleMinWid(t, nwellLayer, this.nwell_width);
        this.makeLayersRuleSurround(t, nwellLayer, diffPLayer, this.nwell_overhang_diff_p);
        this.makeLayersRuleSurround(t, nwellLayer, diffNLayer, this.nwell_overhang_diff_n);
        this.makeLayerRuleMinWid(t, polyLayer, this.poly_width);
        for (i = 0; i < this.num_metal_layers; ++i) {
            Xml.Layer met = (Xml.Layer)metalLayers.get(i);
            this.makeLayerRuleMinWid(t, met, this.metal_width[i]);
            if (i >= this.num_metal_layers - 1) continue;
            Xml.Layer via = (Xml.Layer)viaLayers.get(i);
            this.makeLayerRuleMinWid(t, via, this.via_size[i]);
            this.makeLayersRule(t, via, DRCTemplate.DRCRuleType.CONSPA, this.via_spacing[i]);
            this.makeLayersRule(t, via, DRCTemplate.DRCRuleType.UCONSPA2D, this.via_array_spacing[i]);
        }
        t.writeXml(fileName);
    }

    private Xml.ArcLayer makeXmlArcLayer(Xml.Layer layer, WizardField ... flds) {
        Xml.ArcLayer al = new Xml.ArcLayer();
        al.layer = layer.name;
        al.style = Poly.Type.FILLED;
        for (int i = 0; i < flds.length; ++i) {
            al.extend.addLambda(this.scaledValue(flds[i].v / 2.0));
        }
        return al;
    }

    private void makeLayerGDS(Xml.Technology t, Xml.Layer l, String gdsVal) {
        for (Xml.Foundry f : t.foundries) {
            f.layerGds.put(l.name, gdsVal);
        }
    }

    private void makeLayerRuleMinWid(Xml.Technology t, Xml.Layer l, WizardField fld) {
        for (Xml.Foundry f : t.foundries) {
            f.rules.add(new DRCTemplate(fld.rule, DRCTemplate.DRCMode.ALL.mode(), DRCTemplate.DRCRuleType.MINWID, l.name, null, new double[]{this.scaledValue(fld.v)}, null, null));
        }
    }

    private void makeLayersRule(Xml.Technology t, Xml.Layer l, DRCTemplate.DRCRuleType ruleType, WizardField fld) {
        for (Xml.Foundry f : t.foundries) {
            f.rules.add(new DRCTemplate(fld.rule, DRCTemplate.DRCMode.ALL.mode(), ruleType, l.name, l.name, new double[]{this.scaledValue(fld.v)}, null, null));
        }
    }

    private void makeLayersRuleSurround(Xml.Technology t, Xml.Layer l1, Xml.Layer l2, WizardField fld) {
        double value = this.scaledValue(fld.v);
        for (Xml.Foundry f : t.foundries) {
            f.rules.add(new DRCTemplate(fld.rule, DRCTemplate.DRCMode.ALL.mode(), DRCTemplate.DRCRuleType.SURROUND, l1.name, l2.name, new double[]{value, value}, null, null));
        }
    }

    private double scaledValue(double val) {
        return DBMath.round(val / (double)this.stepsize);
    }
}

