/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.simulation.Analysis;
import com.sun.electric.tool.simulation.Engine;
import com.sun.electric.tool.simulation.Signal;
import com.sun.electric.tool.simulation.Simulation;
import com.sun.electric.tool.user.waveform.WaveformWindow;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stimuli {
    public static final int LOGIC = 3;
    public static final int LOGIC_LOW = 0;
    public static final int LOGIC_X = 1;
    public static final int LOGIC_HIGH = 2;
    public static final int LOGIC_Z = 3;
    public static final int STRENGTH = 12;
    public static final int OFF_STRENGTH = 0;
    public static final int NODE_STRENGTH = 4;
    public static final int GATE_STRENGTH = 8;
    public static final int VDD_STRENGTH = 12;
    private WaveformWindow ww;
    private Engine engine;
    private Cell cell;
    private FileType type;
    private URL fileURL;
    private char separatorChar;
    private HashMap<Analysis.AnalysisType, Analysis> analyses;
    private List<Analysis> analysisList;
    private HashMap<Signal, Double[]> controlPointMap;
    private String delim = Simulation.getSpiceExtractedNetDelimiter();
    private boolean legacy = Simulation.isUseLegacySimulationCode();

    public Stimuli() {
        this.separatorChar = (char)46;
        this.analyses = new HashMap();
        this.analysisList = new ArrayList<Analysis>();
        this.controlPointMap = new HashMap();
    }

    public void finished() {
        for (Analysis an : this.analysisList) {
            an.finished();
        }
        this.controlPointMap.clear();
        for (Analysis an : this.analyses.values()) {
            an.finished();
        }
        this.analyses.clear();
    }

    public void addAnalysis(Analysis an) {
        this.analyses.put(an.getAnalysisType(), an);
        this.analysisList.add(an);
    }

    public Analysis findAnalysis(Analysis.AnalysisType type) {
        Analysis an = this.analyses.get(type);
        return an;
    }

    public String getNetDelimiter() {
        return this.delim;
    }

    public boolean isUseLegacySimulationCode() {
        return this.legacy;
    }

    public int getNumAnalyses() {
        return this.analysisList.size();
    }

    public Iterator<Analysis> getAnalyses() {
        return this.analysisList.iterator();
    }

    public void setCell(Cell cell) {
        this.cell = cell;
    }

    public Cell getCell() {
        return this.cell;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public void setWaveformWindow(WaveformWindow ww) {
        this.ww = ww;
    }

    public char getSeparatorChar() {
        return this.separatorChar;
    }

    public void setSeparatorChar(char sep) {
        this.separatorChar = sep;
    }

    public void setDataType(FileType type) {
        this.type = type;
    }

    public FileType getDataType() {
        return this.type;
    }

    public void setFileURL(URL fileURL) {
        this.fileURL = fileURL;
    }

    public URL getFileURL() {
        return this.fileURL;
    }

    public WaveformWindow getWaveformWindow() {
        return this.ww;
    }

    public Double[] getControlPoints(Signal sig) {
        return this.controlPointMap.get(sig);
    }

    public void clearControlPoints(Signal sig) {
        this.controlPointMap.remove(sig);
    }

    public void addControlPoint(Signal sig, double time) {
        Double[] controlPoints = this.controlPointMap.get(sig);
        if (controlPoints == null) {
            controlPoints = new Double[]{new Double(time)};
            this.controlPointMap.put(sig, controlPoints);
        } else {
            for (int i = 0; i < controlPoints.length; ++i) {
                if (controlPoints[i] != time) continue;
                return;
            }
            Double[] newCP = new Double[controlPoints.length + 1];
            for (int i = 0; i < controlPoints.length; ++i) {
                newCP[i] = controlPoints[i];
            }
            newCP[controlPoints.length] = new Double(time);
            this.controlPointMap.put(sig, newCP);
        }
    }

    public void removeControlPoint(Signal sig, double time) {
        Double[] controlPoints = this.controlPointMap.get(sig);
        if (controlPoints == null) {
            return;
        }
        boolean found = false;
        for (int i = 0; i < controlPoints.length; ++i) {
            if (controlPoints[i] != time) continue;
            found = true;
            break;
        }
        if (!found) {
            return;
        }
        Double[] newCP = new Double[controlPoints.length - 1];
        int j = 0;
        for (int i = 0; i < controlPoints.length; ++i) {
            if (controlPoints[i] == time) continue;
            newCP[j++] = controlPoints[i];
        }
        this.controlPointMap.put(sig, newCP);
    }

    public Rectangle2D getBounds() {
        Rectangle2D.Double bounds = null;
        for (Analysis an : this.analysisList) {
            Rectangle2D anBounds = an.getBounds();
            if (anBounds == null) continue;
            if (bounds == null) {
                bounds = new Rectangle2D.Double(anBounds.getMinX(), anBounds.getMinY(), anBounds.getWidth(), anBounds.getHeight());
                continue;
            }
            Rectangle2D.union(bounds, anBounds, bounds);
        }
        return bounds;
    }

    public double getLeftEdge() {
        double leftEdge = 0.0;
        double rightEdge = 0.0;
        for (Analysis an : this.analysisList) {
            if (leftEdge == rightEdge) {
                leftEdge = an.getLeftEdge();
                rightEdge = an.getRightEdge();
                continue;
            }
            if (leftEdge < rightEdge) {
                leftEdge = Math.min(leftEdge, an.getLeftEdge());
                rightEdge = Math.max(rightEdge, an.getRightEdge());
                continue;
            }
            leftEdge = Math.max(leftEdge, an.getLeftEdge());
            rightEdge = Math.min(rightEdge, an.getRightEdge());
        }
        return leftEdge;
    }

    public double getRightEdge() {
        double leftEdge = 0.0;
        double rightEdge = 0.0;
        for (Analysis an : this.analysisList) {
            if (leftEdge == rightEdge) {
                leftEdge = an.getLeftEdge();
                rightEdge = an.getRightEdge();
                continue;
            }
            if (leftEdge < rightEdge) {
                leftEdge = Math.min(leftEdge, an.getLeftEdge());
                rightEdge = Math.max(rightEdge, an.getRightEdge());
                continue;
            }
            leftEdge = Math.max(leftEdge, an.getLeftEdge());
            rightEdge = Math.min(rightEdge, an.getRightEdge());
        }
        return rightEdge;
    }

    public boolean isAnalog() {
        for (Analysis an : this.analysisList) {
            if (!an.isAnalog()) continue;
            return true;
        }
        return false;
    }

    public static int strengthToIndex(int strength) {
        return strength / 4;
    }

    public static int indexToStrength(int index) {
        return index * 4;
    }

    public static String describeLevel(int state) {
        switch (state & 3) {
            case 0: {
                return "low";
            }
            case 2: {
                return "high";
            }
            case 1: {
                return "undefined";
            }
            case 3: {
                return "floating";
            }
        }
        return "?";
    }

    public static String describeLevelBriefly(int state) {
        switch (state & 3) {
            case 0: {
                return "L";
            }
            case 2: {
                return "H";
            }
            case 1: {
                return "X";
            }
            case 3: {
                return "Z";
            }
        }
        return "?";
    }

    public static int parseLevel(String s1) {
        if (s1.length() > 0) {
            switch (s1.charAt(0)) {
                case 'L': 
                case 'l': {
                    return 0;
                }
                case 'X': 
                case 'x': {
                    return 1;
                }
                case 'H': 
                case 'h': {
                    return 2;
                }
                case 'Z': 
                case 'z': {
                    return 3;
                }
            }
        }
        return 1;
    }

    public static String describeStrength(int strength) {
        switch (strength & 0xC) {
            case 0: {
                return "off";
            }
            case 4: {
                return "node";
            }
            case 8: {
                return "gate";
            }
            case 12: {
                return "power";
            }
        }
        return "?";
    }
}

