/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.genetic1.g1;

import com.sun.electric.tool.placement.genetic1.Chromosome;
import com.sun.electric.tool.placement.genetic1.ChromosomeMutation;
import com.sun.electric.tool.placement.genetic1.g1.GeneticPlacement;
import java.util.Random;

public class ChromosomeMutationPadding
implements ChromosomeMutation {
    static int nbrOfPlaceHoldersToMutate = -1;
    static short maxChangePerStep;

    public ChromosomeMutationPadding(short maxChangePerStep) {
        ChromosomeMutationPadding.maxChangePerStep = maxChangePerStep;
    }

    public void mutate(Chromosome c, Random r) {
        assert (nbrOfPlaceHoldersToMutate > -1) : "set nbr of placeholders before using mutation";
        for (int i = 0; i < nbrOfPlaceHoldersToMutate; ++i) {
            int indexOfPlaceholder = r.nextInt(c.GeneXPadding.length);
            if (r.nextBoolean()) {
                int n = indexOfPlaceholder;
                c.GeneXPadding[n] = (short)(c.GeneXPadding[n] + r.nextInt(maxChangePerStep));
                if (c.GeneXPadding[indexOfPlaceholder] >= 0) continue;
                c.GeneXPadding[indexOfPlaceholder] = 0;
                continue;
            }
            int n = indexOfPlaceholder;
            c.GeneYPadding[n] = (short)(c.GeneYPadding[n] + r.nextInt(maxChangePerStep));
            if (c.GeneYPadding[indexOfPlaceholder] >= 0) continue;
            c.GeneYPadding[indexOfPlaceholder] = 0;
        }
    }

    public void setMutationRate(double mutationRate) {
        nbrOfPlaceHoldersToMutate = (int)((double)GeneticPlacement.nodeProxies.length * mutationRate);
        if (nbrOfPlaceHoldersToMutate < 1) {
            nbrOfPlaceHoldersToMutate = 1;
        }
    }
}

