/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.lib.LibFile;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.Xml;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.LibraryFiles;
import com.sun.electric.tool.simulation.SimulationTool;
import com.sun.electric.tool.user.GraphicsPreferences;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.dialogs.AnnularRing;
import com.sun.electric.tool.user.dialogs.CellBrowser;
import com.sun.electric.tool.user.dialogs.ComponentMenu;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.LayoutImage;
import com.sun.electric.tool.user.dialogs.LayoutText;
import com.sun.electric.tool.user.menus.CellMenu;
import com.sun.electric.tool.user.redisplay.AbstractDrawing;
import com.sun.electric.tool.user.redisplay.PixelDrawing;
import com.sun.electric.tool.user.redisplay.VectorCache;
import com.sun.electric.tool.user.tecEdit.Info;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.PaletteFrame;
import com.sun.electric.tool.user.ui.StatusBar;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.Orientation;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.VolatileImage;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;

public class TechPalette
extends JPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener,
PaletteFrame.PlaceNodeEventListener,
ComponentListener,
DragGestureListener,
DragSourceListener {
    private static final Variable.Key TECH_TMPVAR = Variable.newKey("TECH_TMPVAR");
    private int menuX = -1;
    private int menuY = -1;
    private int entrySize;
    private List<Object> inPalette = new ArrayList<Object>();
    private Object highlightedNode;
    private Map<Object, Object> elementsMap = new HashMap<Object, Object>();
    private VolatileImage paletteImage;
    private boolean paletteImageStale;
    private Rectangle entryRect;
    private DragSource dragSource = null;
    private PixelDrawing offscreen;
    private Technology curTech;
    private static final double menuArcLength = 8.0;

    TechPalette() {
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addComponentListener(this);
        this.paletteImage = null;
        this.paletteImageStale = true;
        this.dragSource = DragSource.getDefaultDragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 3, this);
    }

    public Dimension loadForTechnology(Technology tech, Cell curCell) {
        this.curTech = tech;
        this.inPalette.clear();
        this.elementsMap.clear();
        Object[][] paletteMatrix = this.getNodesGrouped(tech, curCell);
        if (paletteMatrix == null) {
            System.out.println("Error: no palette information found for " + tech.getTechName());
        } else {
            this.menuX = paletteMatrix[0].length;
            this.menuY = paletteMatrix.length;
            this.inPalette.clear();
            for (int i = 0; i < this.menuX; ++i) {
                for (int j = 0; j < this.menuY; ++j) {
                    Object item;
                    Object object = item = paletteMatrix[j] == null ? null : paletteMatrix[j][i];
                    if (item instanceof NodeInst) {
                        item = this.rotateTransistor((NodeInst)item);
                    } else if (item instanceof List) {
                        List nodes = (List)item;
                        for (int k = 0; k < nodes.size(); ++k) {
                            Object o = nodes.get(k);
                            User.getUserTool().setEquivalentPortProto(o);
                            if (!(o instanceof NodeInst)) continue;
                            NodeInst ni = (NodeInst)o;
                            nodes.set(k, this.rotateTransistor(ni));
                        }
                    }
                    item = TechPalette.getInUse(item);
                    this.inPalette.add(item);
                }
            }
        }
        Dimension size2 = TopLevel.getScreenSize();
        this.entrySize = (int)size2.getWidth() / this.menuX;
        int ysize = (int)(size2.getHeight() * 0.9) / this.menuY;
        if (ysize < this.entrySize) {
            this.entrySize = ysize;
        }
        size2.setSize(this.entrySize * this.menuX + 1, this.entrySize * this.menuY + 1);
        this.paletteImageStale = true;
        return size2;
    }

    private NodeInst rotateTransistor(NodeInst ni) {
        if (!ni.getProto().getTechnology().isLayout()) {
            return ni;
        }
        int rot = 0;
        if (User.isRotateLayoutTransistors()) {
            rot = 900;
        }
        rot = (rot + ni.getAngle()) % 3600;
        PrimitiveNode.Function fun = ni.getFunction();
        if (fun.isTransistor()) {
            NodeInst newNi = TechPalette.makeNodeInst(ni.getProto(), fun, rot, false, null);
            newNi.copyVarsFrom(ni);
            ni = newNi;
        }
        return ni;
    }

    private static Object getInUse(Object item) {
        if (item != null) {
            PrimitiveNode p = null;
            if (item instanceof NodeInst && ((NodeInst)item).getProto() instanceof PrimitiveNode) {
                p = (PrimitiveNode)((NodeInst)item).getProto();
            } else if (item instanceof PrimitiveNode) {
                p = (PrimitiveNode)item;
            }
            if (p != null && p.isNotUsed()) {
                item = null;
            }
        }
        return item;
    }

    public static String getItemName(Technology tech, Object item, boolean getVarName) {
        if (item instanceof PrimitiveNode) {
            PrimitiveNode np = (PrimitiveNode)item;
            return np.getName();
        }
        if (item instanceof NodeInst) {
            NodeInst ni = (NodeInst)item;
            if (tech == Schematics.tech()) {
                Variable var = ni.getVar(TECH_TMPVAR);
                if (getVarName && var != null) {
                    return var.getObject().toString();
                }
            }
            return ni.getProto().getName();
        }
        if (item instanceof ArcProto) {
            ArcProto ap = (ArcProto)item;
            return ap.getName();
        }
        if (item instanceof Xml.PrimitiveNode) {
            Xml.PrimitiveNode np = (Xml.PrimitiveNode)item;
            return np.name;
        }
        if (item instanceof Xml.MenuNodeInst) {
            Xml.MenuNodeInst ni = (Xml.MenuNodeInst)item;
            return ni.protoName;
        }
        return "";
    }

    private Object[][] getNodesGrouped(Technology tech, Cell curCell) {
        if (tech instanceof Artwork && curCell != null && curCell.isInTechnologyLibrary()) {
            Artwork artwork = (Artwork)tech;
            Object[][] techEditSet = new Object[16][1];
            techEditSet[0][0] = "Text";
            NodeInst arc = NodeInst.makeDummyInstance(artwork.circleNode);
            arc.setArcDegrees(0.0, 0.7853981633974483);
            techEditSet[1][0] = arc;
            NodeInst half = NodeInst.makeDummyInstance(artwork.circleNode);
            half.setArcDegrees(0.0, Math.PI);
            techEditSet[2][0] = half;
            techEditSet[3][0] = artwork.filledCircleNode;
            techEditSet[4][0] = artwork.circleNode;
            techEditSet[5][0] = artwork.openedThickerPolygonNode;
            techEditSet[6][0] = artwork.openedDashedPolygonNode;
            techEditSet[7][0] = artwork.openedDottedPolygonNode;
            techEditSet[8][0] = artwork.openedPolygonNode;
            techEditSet[9][0] = TechPalette.makeNodeInst(artwork.closedPolygonNode, PrimitiveNode.Function.ART, 0, false, null);
            techEditSet[10][0] = TechPalette.makeNodeInst(artwork.filledPolygonNode, PrimitiveNode.Function.ART, 0, false, null);
            techEditSet[11][0] = artwork.boxNode;
            techEditSet[12][0] = artwork.crossedBoxNode;
            techEditSet[13][0] = artwork.filledBoxNode;
            techEditSet[14][0] = "High";
            techEditSet[15][0] = "Port";
            return techEditSet;
        }
        return TechPalette.convertMenuPalette(tech, ComponentMenu.getMenuPalette(tech));
    }

    private static Object[][] convertMenuPalette(Technology tech, Xml.MenuPalette menuPalette) {
        if (menuPalette == null) {
            return null;
        }
        User.getUserTool().uploadCurrentData(tech, menuPalette);
        int numColumns = menuPalette.numColumns;
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        Object[] row = null;
        for (int i = 0; i < menuPalette.menuBoxes.size(); ++i) {
            List<?> menuBoxList;
            int column = i % numColumns;
            if (column == 0) {
                row = new Object[numColumns];
                rows.add(row);
            }
            if ((menuBoxList = menuPalette.menuBoxes.get(i)) == null || menuBoxList.isEmpty()) continue;
            if (menuBoxList.size() == 1) {
                row[column] = TechPalette.convertMenuItem(tech, menuBoxList.get(0));
                continue;
            }
            ArrayList<Object> list2 = new ArrayList<Object>();
            for (Object o : menuBoxList) {
                if (o == null) continue;
                list2.add(TechPalette.convertMenuItem(tech, o));
            }
            row[column] = list2;
        }
        return (Object[][])rows.toArray((T[])new Object[rows.size()][]);
    }

    private static Object convertMenuItem(Technology tech, Object menuItem) {
        if (menuItem instanceof Xml.ArcProto) {
            return tech.findArcProto(((Xml.ArcProto)menuItem).name);
        }
        if (menuItem instanceof Xml.PrimitiveNode) {
            return tech.findNodeProto(((Xml.PrimitiveNode)menuItem).name);
        }
        if (menuItem instanceof Xml.MenuNodeInst) {
            Xml.MenuNodeInst n = (Xml.MenuNodeInst)menuItem;
            boolean display = n.text != null;
            PrimitiveNode pn = tech.findNodeProto(n.protoName);
            if (pn != null) {
                return TechPalette.makeNodeInst(pn, n.function, n.techBits, n.rotation, display, n.text);
            }
        }
        return menuItem.toString();
    }

    private static NodeInst makeNodeInst(NodeProto np, PrimitiveNode.Function func, int angle, boolean display, String varName) {
        return TechPalette.makeNodeInst(np, func, 0, angle, display, varName);
    }

    private static NodeInst makeNodeInst(NodeProto np, PrimitiveNode.Function func, int techBits, int angle, boolean display, String varName) {
        SizeOffset so = np.getProtoSizeOffset();
        Point2D.Double pt = new Point2D.Double((so.getHighXOffset() - so.getLowXOffset()) / 2.0, (so.getHighYOffset() - so.getLowYOffset()) / 2.0);
        Orientation orient = Orientation.fromAngle(angle);
        AffineTransform trans = orient.pureRotate();
        trans.transform(pt, pt);
        NodeInst ni = NodeInst.makeDummyInstance(np, techBits, new EPoint(((Point2D)pt).getX(), ((Point2D)pt).getY()), np.getDefWidth(), np.getDefHeight(), orient);
        np.getTechnology().setPrimitiveFunction(ni, func);
        np.getTechnology().setDefaultOutline(ni);
        if (varName != null) {
            TextDescriptor td = TextDescriptor.getNodeTextDescriptor().withDisplay(display);
            td = td.withOff(0.0, -Math.max(ni.getXSize(), ni.getYSize()) / 2.0 - 2.0).withPos(AbstractTextDescriptor.Position.UP);
            if (angle != 0) {
                td = td.withRotation(AbstractTextDescriptor.Rotation.getRotation(360 - angle / 10));
            }
            ni.newVar(TECH_TMPVAR, (Object)varName, td);
        }
        return ni;
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        TechPalette panel = (TechPalette)e.getSource();
        panel.requestFocus();
        Object obj = this.getObjectUnderCursor(e.getX(), e.getY());
        if (obj == null) {
            return;
        }
        if (obj instanceof NodeProto || obj instanceof NodeInst || obj instanceof ArcProto || obj instanceof List) {
            if (obj instanceof List) {
                List list2 = (List)obj;
                if ((obj = list2.get(0)) instanceof List) {
                    obj = ((List)obj).get(0);
                }
                if (list2.size() > 1 && this.isCursorOnCorner(e)) {
                    String popupName = TechPalette.getItemName(this.curTech, obj, false);
                    JPopupMenu menu = new JPopupMenu(popupName);
                    for (Object item : list2) {
                        JMenuItem menuItem;
                        if (item.equals("-")) {
                            menu.add(new JSeparator());
                            continue;
                        }
                        if (item instanceof List) {
                            List subList = (List)item;
                            for (Object subItem : subList) {
                                if ((subItem = TechPalette.getInUse(subItem)) == null) continue;
                                menuItem = new JMenuItem(TechPalette.getItemName(this.curTech, subItem, true));
                                menu.add(menuItem);
                                menuItem.addActionListener(new PlacePopupListListener(panel, popupName, subItem, list2, subList));
                            }
                            continue;
                        }
                        if ((item = TechPalette.getInUse(item)) == null) continue;
                        menuItem = new JMenuItem(TechPalette.getItemName(this.curTech, item, true));
                        menu.add(menuItem);
                        menuItem.addActionListener(new PlacePopupListListener(panel, popupName, item, list2, null));
                    }
                    menu.show(panel, e.getX(), e.getY());
                    return;
                }
                String curEntry = User.getUserTool().getCurrentContactNodeProto(this.curTech, TechPalette.getItemName(this.curTech, obj, false));
                for (Object o : list2) {
                    String thisOne = TechPalette.getItemName(this.curTech, o, true);
                    if (!thisOne.equals(curEntry)) continue;
                    obj = o;
                }
            }
            if (obj instanceof ArcProto) {
                User.getUserTool().setCurrentArcProto((ArcProto)obj);
            } else {
                PaletteFrame.placeInstance(obj, panel, false);
            }
        } else if (obj instanceof String) {
            JMenuItem menuItem;
            JPopupMenu specialMenu;
            String msg = (String)obj;
            if (msg.startsWith("LOADCELL ")) {
                String cellName = msg.substring(9);
                Cell cell = (Cell)Cell.findNodeProto(cellName);
                if (cell == null) {
                    Job.getUserInterface().showErrorMessage("Cannot find cell " + cellName, "Unknown Cell");
                    return;
                }
                PaletteFrame.placeInstance(cell, panel, false);
            } else if (msg.equals("Cell")) {
                new LongListPopup(panel, e.getX(), e.getY(), false);
            } else if (msg.equals("Pure")) {
                new LongListPopup(panel, e.getX(), e.getY(), true);
            } else if (msg.equals("Misc.")) {
                specialMenu = new JPopupMenu("Miscellaneous");
                menuItem = new JMenuItem("Cell Instance...");
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        CellMenu.cellBrowserCommand(CellBrowser.DoAction.newInstance);
                    }
                });
                specialMenu.add(menuItem);
                specialMenu.addSeparator();
                menuItem = new JMenuItem("Annotation Text");
                menuItem.addActionListener(new PlacePopupListener(panel, "ART_message"));
                specialMenu.add(menuItem);
                menuItem = new JMenuItem("Layout Text...");
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        TechPalette.this.makeLayoutTextCommand();
                    }
                });
                specialMenu.add(menuItem);
                menuItem = new JMenuItem("Layout Image...");
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        TechPalette.this.makeLayoutImageCommand();
                    }
                });
                specialMenu.add(menuItem);
                menuItem = new JMenuItem("Annular Ring...");
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        AnnularRing.showAnnularRingDialog();
                    }
                });
                specialMenu.add(menuItem);
                specialMenu.addSeparator();
                menuItem = new JMenuItem("Cell Center");
                menuItem.addActionListener(new PlacePopupListener(panel, Generic.tech().cellCenterNode));
                specialMenu.add(menuItem);
                menuItem = new JMenuItem("Essential Bounds");
                menuItem.addActionListener(new PlacePopupListener(panel, Generic.tech().essentialBoundsNode));
                specialMenu.add(menuItem);
                specialMenu.addSeparator();
                menuItem = new JMenuItem("Spice Code");
                menuItem.addActionListener(new PlacePopupListener(panel, "SIM_spice_card"));
                specialMenu.add(menuItem);
                menuItem = new JMenuItem("Spice Declaration");
                menuItem.addActionListener(new PlacePopupListener(panel, "SIM_spice_declaration"));
                specialMenu.add(menuItem);
                menuItem = new JMenuItem("Verilog Code");
                menuItem.addActionListener(new PlacePopupListener(panel, "VERILOG_code"));
                specialMenu.add(menuItem);
                menuItem = new JMenuItem("Verilog Declaration");
                menuItem.addActionListener(new PlacePopupListener(panel, "VERILOG_declaration"));
                specialMenu.add(menuItem);
                menuItem = new JMenuItem("Verilog Parameter");
                menuItem.addActionListener(new PlacePopupListener(panel, "VERILOG_parameter"));
                specialMenu.add(menuItem);
                menuItem = new JMenuItem("Verilog External Code");
                menuItem.addActionListener(new PlacePopupListener(panel, "VERILOG_external_code"));
                specialMenu.add(menuItem);
                menuItem = new JMenuItem("Simulation Probe");
                menuItem.addActionListener(new PlacePopupListener(panel, Generic.tech().simProbeNode));
                specialMenu.add(menuItem);
                menuItem = new JMenuItem("DRC Exclusion");
                menuItem.addActionListener(new PlacePopupListener(panel, Generic.tech().drcNode));
                specialMenu.add(menuItem);
                menuItem = new JMenuItem("AFG Exclusion");
                menuItem.addActionListener(new PlacePopupListener(panel, Generic.tech().afgNode));
                specialMenu.add(menuItem);
                specialMenu.addSeparator();
                menuItem = new JMenuItem("Invisible Pin");
                menuItem.addActionListener(new PlacePopupListener(panel, Generic.tech().invisiblePinNode));
                specialMenu.add(menuItem);
                menuItem = new JMenuItem("Universal Pin");
                menuItem.addActionListener(new PlacePopupListener(panel, Generic.tech().universalPinNode));
                specialMenu.add(menuItem);
                menuItem = new JMenuItem("Unrouted Pin");
                menuItem.addActionListener(new PlacePopupListener(panel, Generic.tech().unroutedPinNode));
                specialMenu.add(menuItem);
                specialMenu.show(panel, e.getX(), e.getY());
            }
            if (msg.equals("Spice")) {
                JPopupMenu cellMenu = new JPopupMenu("Spice");
                String currentSpiceLib = SimulationTool.getSpicePartsLibrary();
                Library spiceLib = Library.findLibrary(currentSpiceLib);
                if (spiceLib == null) {
                    URL fileURL = LibFile.getLibFile(currentSpiceLib + ".jelib");
                    new ReadSpiceLibrary(fileURL, cellMenu, panel, e.getX(), e.getY());
                } else {
                    ReadSpiceLibrary.loadSpiceCells(spiceLib, panel, cellMenu);
                    cellMenu.show(panel, e.getX(), e.getY());
                }
            }
            if (msg.equals("Export")) {
                specialMenu = new JPopupMenu("Export");
                menuItem = new JMenuItem("Wire");
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        TechPalette.this.makeExport("wire");
                    }
                });
                specialMenu.add(menuItem);
                menuItem = new JMenuItem("Bus");
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        TechPalette.this.makeExport("bus");
                    }
                });
                specialMenu.add(menuItem);
                menuItem = new JMenuItem("Universal");
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        TechPalette.this.makeExport("universal");
                    }
                });
                specialMenu.add(menuItem);
                specialMenu.show(panel, e.getX(), e.getY());
            }
            if (msg.equals("Text")) {
                PaletteFrame.placeInstance("ART_message", panel, false);
            }
            if (msg.equals("High")) {
                NodeInst ni = NodeInst.makeDummyInstance(Artwork.tech().boxNode);
                ni.newVar(Info.OPTION_KEY, (Object)new Integer(19));
                PaletteFrame.placeInstance(ni, panel, false);
            }
            if (msg.equals("Port")) {
                PaletteFrame.placeInstance(Generic.tech().portNode, panel, false);
            }
        }
        this.repaint();
    }

    private void makeExport(String type) {
        if (type.equals("wire")) {
            PaletteFrame.placeInstance(Schematics.tech().wirePinNode, this, true);
        } else if (type.equals("bus")) {
            PaletteFrame.placeInstance(Schematics.tech().busPinNode, this, true);
        } else if (type.equals("universal")) {
            PaletteFrame.placeInstance(Generic.tech().invisiblePinNode, this, true);
        }
    }

    public void makeLayoutTextCommand() {
        LayoutText dialog = new LayoutText(TopLevel.getCurrentJFrame());
        dialog.setVisible(true);
    }

    public void makeLayoutImageCommand() {
        LayoutImage dialog = new LayoutImage(TopLevel.getCurrentJFrame());
        dialog.setVisible(true);
    }

    public void placeNodeStarted(Object nodeToBePlaced) {
        this.highlightedNode = nodeToBePlaced;
    }

    public void placeNodeFinished(boolean cancelled) {
        this.highlightedNode = null;
        this.repaint();
    }

    public void dragGestureRecognized(DragGestureEvent e) {
        Object obj = this.getObjectUnderCursor(e.getDragOrigin().x, e.getDragOrigin().y);
        EditWindow.NodeProtoTransferable transferable = new EditWindow.NodeProtoTransferable(obj, null);
        this.dragSource.startDrag(e, DragSource.DefaultLinkDrop, transferable, this);
    }

    public void dragEnter(DragSourceDragEvent e) {
    }

    public void dragOver(DragSourceDragEvent e) {
    }

    public void dragExit(DragSourceEvent e) {
    }

    public void dragDropEnd(DragSourceDropEvent e) {
    }

    public void dropActionChanged(DragSourceDragEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    private Object getObjectUnderCursor(int xp, int yp) {
        int index2;
        int x = xp / (this.entrySize + 1);
        int y = this.menuY - yp / (this.entrySize + 1) - 1;
        if (y < 0) {
            y = 0;
        }
        if ((index2 = x * this.menuY + y) < 0 || index2 >= this.inPalette.size()) {
            return null;
        }
        Object obj = this.inPalette.get(index2);
        return obj;
    }

    private boolean isCursorOnCorner(MouseEvent e) {
        int entryS = this.entrySize + 1;
        int x = e.getX() / entryS;
        int y = this.menuY - e.getY() / entryS - 1;
        if (y < 0) {
            y = 0;
        }
        double deltaX = (double)(e.getX() - x * entryS) / (double)entryS;
        double deltaY = (double)(e.getY() - (this.menuY - y - 1) * entryS) / (double)entryS;
        return deltaX > 0.75 && deltaY > 0.65;
    }

    public void mouseMoved(MouseEvent e) {
        Object obj = this.getObjectUnderCursor(e.getX(), e.getY());
        if (obj instanceof List && (obj = ((List)obj).get(0)) instanceof List) {
            obj = ((List)obj).get(0);
        }
        if (obj instanceof PrimitiveNode) {
            StatusBar.setSelectionOverride("CREATE NODE: " + ((PrimitiveNode)obj).describe(false));
        } else if (obj instanceof NodeInst) {
            StatusBar.setSelectionOverride("CREATE NODE: " + ((NodeInst)obj).describe(false));
        } else if (obj instanceof NodeProto) {
            StatusBar.setSelectionOverride("CREATE NODE: " + ((NodeProto)obj).describe(false));
        } else if (obj instanceof ArcProto) {
            ArcProto ap = (ArcProto)obj;
            StatusBar.setSelectionOverride("USE ARC: " + ap.describe());
        } else if (obj instanceof String) {
            String str = (String)obj;
            if (str.startsWith("LOADCELL ")) {
                StatusBar.setSelectionOverride("CREATE CELL: " + str.substring(9));
            } else {
                StatusBar.setSelectionOverride(null);
            }
        }
    }

    public void mouseExited(MouseEvent e) {
        StatusBar.setSelectionOverride(null);
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        this.paletteImageStale = true;
    }

    public void paint(Graphics g) {
        int index2;
        if (this.menuX < 0 || this.menuY < 0) {
            return;
        }
        Dimension size2 = this.getSize();
        int wid = (int)size2.getWidth();
        int hei = (int)size2.getHeight();
        this.entrySize = Math.min(wid / this.menuX - 1, hei / this.menuY - 1);
        if (wid <= 0 || hei <= 0) {
            return;
        }
        do {
            int returnCode;
            if (this.paletteImage == null) {
                this.paletteImage = this.createVolatileImage(this.getWidth(), this.getHeight());
                returnCode = 1;
            } else {
                returnCode = this.paletteImage.validate(this.getGraphicsConfiguration());
                if (returnCode == 2 || this.paletteImage.getWidth() != wid || this.paletteImage.getHeight() != hei) {
                    returnCode = 2;
                    this.paletteImage.flush();
                    this.paletteImage = this.createVolatileImage(this.getWidth(), this.getHeight());
                }
            }
            if (returnCode != 0 || this.paletteImageStale) {
                this.renderPaletteImage();
            }
            g.drawImage(this.paletteImage, 0, 0, this);
        } while (this.paletteImage.contentsLost());
        this.paletteImageStale = false;
        if (this.highlightedNode != null && (index2 = this.inPalette.indexOf(this.highlightedNode)) >= 0) {
            int x = index2 / this.menuY;
            int y = index2 % this.menuY;
            int imgX = x * (this.entrySize + 1) + 1;
            int imgY = (this.menuY - y - 1) * (this.entrySize + 1) + 1;
            g.setColor(Color.BLUE);
            g.drawRect(imgX + 1, imgY + 1, this.entrySize - 3, this.entrySize - 3);
            g.drawRect(imgX + 2, imgY + 2, this.entrySize - 5, this.entrySize - 5);
        }
        ArcProto arcObj = User.getUserTool().getCurrentArcProto();
        int index3 = -1;
        for (int i = 0; i < this.inPalette.size(); ++i) {
            Object obj = this.inPalette.get(i);
            if (obj == null) continue;
            if (obj instanceof List) {
                obj = ((List)obj).get(0);
            }
            if (obj != arcObj) continue;
            index3 = i;
            break;
        }
        if (index3 >= 0) {
            int x = index3 / this.menuY;
            int y = index3 % this.menuY;
            int imgX = x * (this.entrySize + 1) + 1;
            int imgY = (this.menuY - y - 1) * (this.entrySize + 1) + 1;
            g.setColor(Color.RED);
            g.drawRect(imgX + 1, imgY + 1, this.entrySize - 3, this.entrySize - 3);
            g.drawRect(imgX + 2, imgY + 2, this.entrySize - 5, this.entrySize - 5);
        }
    }

    private void renderPaletteImage() {
        int i;
        if (this.entrySize < 2) {
            return;
        }
        this.entryRect = new Rectangle(new Dimension(this.entrySize - 2, this.entrySize - 2));
        this.offscreen = new PixelDrawing(new Dimension(this.entrySize, this.entrySize));
        Graphics2D g = (Graphics2D)this.paletteImage.getGraphics();
        g.setBackground(new Color(User.getColor(User.ColorPrefType.BACKGROUND)));
        g.clearRect(0, 0, this.getWidth(), this.getHeight());
        GraphicsPreferences gp = UserInterfaceMain.getGraphicsPreferences();
        for (int x = 0; x < this.menuX; ++x) {
            for (int y = 0; y < this.menuY; ++y) {
                int index2 = x * this.menuY + y;
                if (index2 >= this.inPalette.size()) continue;
                Object toDraw = this.inPalette.get(index2);
                boolean drawArrow = false;
                if (toDraw instanceof List) {
                    List list2 = (List)toDraw;
                    if ((toDraw = list2.get(0)) instanceof List) {
                        toDraw = ((List)toDraw).get(0);
                    }
                    String curEntry = User.getUserTool().getCurrentContactNodeProto(this.curTech, TechPalette.getItemName(this.curTech, toDraw, false));
                    for (Object obj : list2) {
                        String thisOne = TechPalette.getItemName(this.curTech, obj, true);
                        if (!thisOne.equals(curEntry)) continue;
                        toDraw = obj;
                    }
                    drawArrow = list2.size() > 1;
                }
                int imgX = x * (this.entrySize + 1) + 1;
                int imgY = (this.menuY - y - 1) * (this.entrySize + 1) + 1;
                if (toDraw instanceof ArcProto) {
                    double wid;
                    ArcProto ap = (ArcProto)toDraw;
                    double largest = 0.0;
                    Iterator<ArcProto> it = ap.getTechnology().getArcs();
                    while (it.hasNext()) {
                        ArcProto otherAp = it.next();
                        if (otherAp.isSpecialArc() || otherAp.isSkipSizeInPalette() || !((wid = DBMath.gridToLambda(2L * (otherAp.getFactoryDefaultInst().getGridExtendOverMin() + (long)otherAp.getMaxLayerGridExtend()))) + 8.0 > largest)) continue;
                        largest = wid + 8.0;
                    }
                    double arcLength = 8.0;
                    wid = DBMath.gridToLambda(2L * (ap.getFactoryDefaultInst().getGridExtendOverMin() + (long)ap.getMaxLayerGridExtend()));
                    if (wid + arcLength < largest) {
                        arcLength = largest - wid;
                    }
                    double scalex = (double)this.entrySize / largest * 0.8;
                    double scaley = (double)this.entrySize / largest * 0.8;
                    double scale = Math.min(scalex, scaley);
                    ImmutableArcInst a = ap.getDefaultInst(EditingPreferences.getThreadEditingPreferences());
                    long l2 = DBMath.lambdaToGrid(arcLength / 2.0);
                    a = a.withLocations(EPoint.fromGrid(-l2, 0L), EPoint.fromGrid(l2, 0L));
                    VectorCache.VectorBase[] shapes = VectorCache.drawPolys(a, ap.getShapeOfDummyArc(arcLength));
                    this.drawShapes(g, gp, imgX, imgY, scale, shapes);
                    g.setColor(Color.RED);
                    g.drawRect(imgX, imgY, this.entrySize - 1, this.entrySize - 1);
                }
                if (toDraw instanceof NodeProto || toDraw instanceof NodeInst) {
                    NodeInst ni;
                    if (toDraw instanceof NodeInst) {
                        ni = (NodeInst)toDraw;
                        if (ni.getFunction() == PrimitiveNode.Function.TRAPNP || ni.getFunction() == PrimitiveNode.Function.TRA4PNP) {
                            drawArrow = true;
                        }
                    } else {
                        NodeProto np = (NodeProto)toDraw;
                        ni = NodeInst.makeDummyInstance(np);
                        if (np == Schematics.tech().diodeNode || np == Schematics.tech().capacitorNode || np == Schematics.tech().flipflopNode) {
                            drawArrow = true;
                        }
                    }
                    if (ni.isCellInstance()) {
                        String str = ni.getProto().getName();
                        int defSize = 12;
                        Font f = new Font(User.getDefaultFont(), 1, defSize);
                        FontMetrics fm = g.getFontMetrics(f);
                        float width = fm.stringWidth(str);
                        if (width > (float)this.entryRect.width) {
                            defSize = (int)((float)(defSize * this.entryRect.width) / width);
                            f = new Font(User.getDefaultFont(), 1, defSize);
                            fm = g.getFontMetrics(f);
                            width = fm.stringWidth(str);
                        }
                        g.setFont(f);
                        g.setColor(new Color(User.getColor(User.ColorPrefType.TEXT)));
                        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                        g.drawString(str, (float)imgX + ((float)this.entryRect.width - width) / 2.0f, (float)imgY + ((float)this.entryRect.height + (float)fm.getAscent()) / 2.0f);
                    } else {
                        PrimitiveNode np = (PrimitiveNode)ni.getProto();
                        double largest = this.getLargestDimension(np);
                        double scalex = (double)this.entrySize / largest * 0.8;
                        double scaley = (double)this.entrySize / largest * 0.8;
                        double scale = Math.min(scalex, scaley);
                        Variable var = ni.getVar(TECH_TMPVAR);
                        if (var != null) {
                            int size2;
                            int msgLen = var.describe(-1).length();
                            if (msgLen < 4) {
                                msgLen = 4;
                            }
                            if ((size2 = (int)Math.round((double)(this.entrySize / msgLen) / 0.8)) < 6) {
                                size2 = 6;
                            }
                            double xOff = 0.0;
                            double yOff = largest / 2.0 * 0.4;
                            if (ni.getOrient() == Orientation.R) {
                                xOff = largest / 2.0 * 0.8;
                                yOff = -largest / 2.0;
                            }
                            TextDescriptor td = var.getTextDescriptor().withOff(xOff, yOff).withAbsSize(size2);
                            ni.setTextDescriptor(TECH_TMPVAR, td);
                        }
                        VectorCache.VectorBase[] shapes = VectorCache.drawNode(ni);
                        this.drawShapes(g, gp, imgX, imgY, scale, shapes);
                    }
                    g.setColor(Color.BLUE);
                    g.drawRect(imgX, imgY, this.entrySize - 1, this.entrySize - 1);
                }
                if (toDraw instanceof String) {
                    String str = (String)toDraw;
                    if (str.equals("Cell") || str.equals("Spice") || str.equals("Misc.") || str.equals("Pure")) {
                        drawArrow = true;
                    }
                    if (str.startsWith("LOADCELL ")) {
                        int colonPos = str.indexOf(58);
                        str = colonPos < 0 ? str.substring(9) : str.substring(colonPos + 1);
                        g.setColor(Color.BLUE);
                        g.drawRect(imgX, imgY, this.entrySize - 1, this.entrySize - 1);
                    }
                    int defSize = 18;
                    Font f = new Font(User.getDefaultFont(), 1, defSize);
                    FontMetrics fm = g.getFontMetrics(f);
                    float width = fm.stringWidth(str);
                    if (width > (float)this.entryRect.width) {
                        defSize = (int)((float)(defSize * this.entryRect.width) / width);
                        f = new Font(User.getDefaultFont(), 1, defSize);
                        fm = g.getFontMetrics(f);
                        width = fm.stringWidth(str);
                    }
                    g.setFont(f);
                    g.setColor(new Color(User.getColor(User.ColorPrefType.TEXT)));
                    g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    g.drawString(str, (float)imgX + ((float)this.entryRect.width - width) / 2.0f, (float)imgY + ((float)this.entryRect.height + (float)fm.getAscent()) / 2.0f);
                }
                if (!drawArrow) continue;
                this.drawArrow(g, x, y);
            }
        }
        this.offscreen = null;
        g.setColor(new Color(User.getColor(User.ColorPrefType.GRID)));
        for (i = 0; i <= this.menuX; ++i) {
            int xPos = (this.entrySize + 1) * i;
            g.drawLine(xPos, 0, xPos, this.menuY * (this.entrySize + 1));
        }
        for (i = 0; i <= this.menuY; ++i) {
            int yPos = (this.entrySize + 1) * i;
            g.drawLine(0, yPos, this.menuX * (this.entrySize + 1), yPos);
        }
        g.dispose();
    }

    private double getLargestDimension(PrimitiveNode np) {
        double largest = 0.0;
        if (np.getGroupFunction().isPin()) {
            Iterator<ArcProto> it = np.getTechnology().getArcs();
            while (it.hasNext()) {
                double wid;
                ArcProto otherAp = it.next();
                if (otherAp.isSpecialArc() || otherAp.isSkipSizeInPalette() || !((wid = DBMath.gridToLambda(2L * (otherAp.getFactoryDefaultInst().getGridExtendOverMin() + (long)otherAp.getMaxLayerGridExtend()))) + 8.0 > largest)) continue;
                largest = wid + 8.0;
            }
        } else {
            if (np.getDefHeight() > largest) {
                largest = np.getDefHeight();
            }
            if (np.getDefWidth() > largest) {
                largest = np.getDefWidth();
            }
        }
        if (largest == 0.0) {
            largest = 1.0;
        }
        return largest;
    }

    private void drawArrow(Graphics g, int x, int y) {
        int imgX = x * (this.entrySize + 1) + 1;
        int imgY = (this.menuY - y - 1) * (this.entrySize + 1) + 1;
        int[] arrowX = new int[3];
        int[] arrowY = new int[3];
        arrowX[0] = imgX - 2 + this.entrySize * 7 / 8;
        arrowY[0] = imgY - 2 + this.entrySize;
        arrowX[1] = imgX - 2 + this.entrySize;
        arrowY[1] = imgY - 2 + this.entrySize * 7 / 8;
        arrowX[2] = imgX - 2 + this.entrySize * 7 / 8;
        arrowY[2] = imgY - 2 + this.entrySize * 3 / 4;
        g.setColor(new Color(User.getColor(User.ColorPrefType.GRID)));
        g.fillPolygon(arrowX, arrowY, 3);
    }

    private void drawShapes(Graphics2D g, GraphicsPreferences gp, int imgX, int imgY, double scale, VectorCache.VectorBase[] shapes) {
        AbstractDrawing.drawShapes(g, gp, imgX, imgY, scale, shapes, this.offscreen, this.entryRect);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PlacePopupListListener
    extends PlacePopupListener
    implements ActionListener {
        List<?> list;
        List<?> subList;
        private String popupName;

        PlacePopupListListener(TechPalette panel, String popupName, Object obj, List<?> list2, List<?> subList) {
            super(panel, obj);
            this.popupName = popupName;
            this.list = list2;
            this.subList = subList;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (this.obj instanceof ArcProto) {
                assert (this.subList == null);
                Collections.swap(this.list, 0, this.list.indexOf(this.obj));
                User.getUserTool().setCurrentArcProto((ArcProto)this.obj);
            } else {
                PaletteFrame.placeInstance(this.obj, this.panel, false);
                User.getUserTool().setCurrentContactNodeProto(TechPalette.this.curTech, this.popupName, this.obj);
                Iterator<WindowFrame> it = WindowFrame.getWindows();
                while (it.hasNext()) {
                    WindowFrame wf = it.next();
                    PaletteFrame pf = wf.getPaletteTab();
                    TechPalette tp = pf.getTechPalette();
                    tp.paletteImageStale = true;
                    tp.repaint();
                }
            }
        }
    }

    static class PlacePopupListener
    implements ActionListener {
        TechPalette panel;
        Object obj;

        PlacePopupListener(TechPalette panel, Object obj) {
            this.panel = panel;
            this.obj = obj;
        }

        public void actionPerformed(ActionEvent evt) {
            PaletteFrame.placeInstance(this.obj, this.panel, false);
        }
    }

    private static class ReadSpiceLibrary
    extends Job {
        private URL fileURL;
        private transient JPopupMenu cellMenu;
        private transient TechPalette panel;
        private transient int x;
        private transient int y;
        private Library lib;

        protected ReadSpiceLibrary(URL fileURL, JPopupMenu cellMenu, TechPalette panel, int x, int y) {
            super("Read Spice Library", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.fileURL = fileURL;
            this.cellMenu = cellMenu;
            this.panel = panel;
            this.x = x;
            this.y = y;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            this.lib = LibraryFiles.readLibrary(this.fileURL, null, FileType.JELIB, false);
            if (this.lib == null) {
                return false;
            }
            this.fieldVariableChanged("lib");
            return true;
        }

        public void terminateOK() {
            if (this.lib == null) {
                return;
            }
            ReadSpiceLibrary.loadSpiceCells(this.lib, this.panel, this.cellMenu);
            this.cellMenu.show(this.panel, this.x, this.y);
        }

        public static void loadSpiceCells(Library lib, TechPalette panel, JPopupMenu cellMenu) {
            Iterator<Cell> it = lib.getCells();
            while (it.hasNext()) {
                Cell cell = it.next();
                if (!cell.isIcon()) continue;
                JMenuItem menuItem = new JMenuItem(cell.getName());
                menuItem.addActionListener(new PlacePopupListener(panel, cell));
                cellMenu.add(menuItem);
            }
        }
    }

    private static class LongListPopup
    extends EDialog {
        private JList pureList;
        private TechPalette panel;
        private List<NodeProto> popupPures;

        private LongListPopup(TechPalette panel, int x, int y, boolean pures) {
            super((Frame)TopLevel.getCurrentJFrame(), false);
            this.panel = panel;
            Point los = TopLevel.getCurrentJFrame().getLocationOnScreen();
            this.setLocation(los.x + x, los.y + y);
            this.setUndecorated(true);
            this.getContentPane().setLayout(new GridBagLayout());
            DefaultListModel<String> pureModel = new DefaultListModel<String>();
            this.pureList = new JList(pureModel);
            this.pureList.setSelectionMode(0);
            JScrollPane pureScrollPane = new JScrollPane();
            pureScrollPane.setMinimumSize(new Dimension(200, 200));
            pureScrollPane.setPreferredSize(new Dimension(200, 200));
            pureScrollPane.setViewportView(this.pureList);
            JPanel purePanel = new JPanel();
            purePanel.setBorder(BorderFactory.createBevelBorder(0));
            purePanel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            purePanel.add((Component)pureScrollPane, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            this.getContentPane().add((Component)purePanel, gbc);
            this.pureList.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent evt) {
                    LongListPopup.this.entryClicked();
                }
            });
            this.pureList.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent ke) {
                    if (ke.getKeyCode() == 10) {
                        LongListPopup.this.entryClicked();
                        ke.consume();
                    }
                }
            });
            this.addWindowFocusListener(new DialogFocusHandler());
            this.popupPures = new ArrayList<NodeProto>();
            if (pures) {
                for (PrimitiveNode primitiveNode : Technology.getCurrent().getNodesSortedByName()) {
                    Technology.NodeLayer layer;
                    Layer.Function lf;
                    if (primitiveNode.isNotUsed() || primitiveNode.getFunction() != PrimitiveNode.Function.NODE || (lf = (layer = primitiveNode.getNodeLayers()[0]).getLayer().getFunction()).isContact()) continue;
                    this.popupPures.add(primitiveNode);
                }
                Collections.sort(this.popupPures, new LayersByImportance());
            } else {
                View view = null;
                Cell cell = WindowFrame.getCurrentCell();
                if (cell != null) {
                    if (cell.getTechnology().isLayout()) {
                        view = View.LAYOUT;
                    } else if (cell.getTechnology().isSchematics()) {
                        view = View.ICON;
                    }
                }
                Iterator<Cell> it = Library.getCurrent().getCells();
                while (it.hasNext()) {
                    Cell cell2 = it.next();
                    if (cell2 == cell || view != null && cell2.getView() != view) continue;
                    this.popupPures.add(cell2);
                }
            }
            for (NodeProto nodeProto : this.popupPures) {
                pureModel.addElement(nodeProto.describe(false));
            }
            this.pureList.setSelectedIndex(0);
            this.pack();
            this.setVisible(true);
        }

        protected void escapePressed() {
            this.setVisible(false);
        }

        private void entryClicked() {
            String selected = (String)this.pureList.getSelectedValue();
            for (int i = 0; i < this.popupPures.size(); ++i) {
                NodeProto np = this.popupPures.get(i);
                if (!np.describe(false).equals(selected)) continue;
                PaletteFrame.placeInstance(np, this.panel, false);
            }
            this.setVisible(false);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class LayersByImportance
        implements Comparator<NodeProto> {
            @Override
            public int compare(NodeProto np1, NodeProto np2) {
                Technology.NodeLayer layer1 = ((PrimitiveNode)np1).getNodeLayers()[0];
                Technology.NodeLayer layer2 = ((PrimitiveNode)np2).getNodeLayers()[0];
                int imp1 = this.getCode(layer1.getLayer());
                int imp2 = this.getCode(layer2.getLayer());
                if (imp1 == 3 && imp2 == 3) {
                    String en1 = Layer.Function.getExtraName(layer1.getLayer().getFunctionExtras());
                    String en2 = Layer.Function.getExtraName(layer2.getLayer().getFunctionExtras());
                    return en1.compareTo(en2);
                }
                return imp1 - imp2;
            }

            private int getCode(Layer layer) {
                Layer.Function lf = layer.getFunction();
                if (lf.isWell()) {
                    return 1;
                }
                if (lf.isImplant()) {
                    if (layer.getFunctionExtras() == 0) {
                        return 2;
                    }
                    return 3;
                }
                if (lf == Layer.Function.ART) {
                    return 4;
                }
                return 5;
            }
        }

        private class DialogFocusHandler
        implements WindowFocusListener {
            private DialogFocusHandler() {
            }

            public void windowGainedFocus(WindowEvent e) {
            }

            public void windowLostFocus(WindowEvent e) {
                LongListPopup.this.setVisible(false);
            }
        }
    }
}

