/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.api.minarea.geometry;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.List;

public class Shapes {
    public static Shape fromTiles(List<int[]> tiles) {
        Area area = new Area();
        for (int[] tile : tiles) {
            int x2 = tile[0];
            int y = tile[1];
            int w = tile[2] - x2;
            int h = tile[3] - y;
            area.add(new Area(new Rectangle(x2, y, w, h)));
        }
        return area;
    }

    public static Shape fromTiles(int[] tiles) {
        Area area = new Area();
        int i = 0;
        while (i * 4 < tiles.length) {
            int x2 = tiles[i * 4 + 0];
            int y = tiles[i * 4 + 1];
            int w = tiles[i * 4 + 2] - x2;
            int h = tiles[i * 4 + 3] - y;
            area.add(new Area(new Rectangle(x2, y, w, h)));
            ++i;
        }
        return area;
    }

    public static Point2D maxVertex(Shape shape) {
        double xm = Double.NEGATIVE_INFINITY;
        double ym = Double.NEGATIVE_INFINITY;
        double[] coords = new double[6];
        PathIterator pit = shape.getPathIterator(null);
        while (!pit.isDone()) {
            switch (pit.currentSegment(coords)) {
                case 0: 
                case 1: {
                    double xs = coords[0];
                    double ys = coords[1];
                    if (!(xs > xm) && (xs != xm || !(ys > ym))) break;
                    xm = xs;
                    ym = ys;
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            pit.next();
        }
        return new Point2D.Double(xm, ym);
    }
}

