/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableNetSchem;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.text.ImmutableArrayList;
import com.sun.electric.database.text.Name;
import java.util.Arrays;
import java.util.IdentityHashMap;

public class EquivalentSchematicExports {
    public final CellId cellId;
    public final EquivalentSchematicExports implementation;
    public final Global.Set globals;
    public final int numExports;
    public final int[] portOffsets;
    public final int numExpandedExports;
    final ImmutableArrayList<ImmutableExport> exports;
    public final IdentityHashMap<Name, Global.Set> globalPartitions;
    private IdentityHashMap<Name, Integer> exportNameMapOffsets;
    final int[] equivPortsN;
    final int[] equivPortsP;
    final int[] equivPortsA;

    EquivalentSchematicExports(ImmutableNetSchem netSchem) {
        this.cellId = netSchem.cellTree.top.cellRevision.d.cellId;
        this.implementation = this.cellId == netSchem.implementationCellId ? this : netSchem.snapshot.equivSchemExports[netSchem.implementationCellId.cellIndex];
        this.exports = netSchem.cellTree.top.cellRevision.exports;
        this.numExports = this.exports.size();
        this.numExpandedExports = netSchem.equivPortsN.length;
        this.portOffsets = netSchem.portOffsets;
        this.globals = netSchem.globals;
        this.globalPartitions = netSchem.globalPartitions;
        this.equivPortsN = netSchem.equivPortsN;
        this.equivPortsP = netSchem.equivPortsP;
        this.equivPortsA = netSchem.equivPortsA;
    }

    public static EquivalentSchematicExports computeEquivExports(Snapshot snapshot, CellId top) {
        ImmutableNetSchem netSchem = new ImmutableNetSchem(snapshot, top);
        return new EquivalentSchematicExports(netSchem);
    }

    public CellId getCellId() {
        return this.cellId;
    }

    public Global.Set getGlobals() {
        return this.globals;
    }

    public int getNumExports() {
        return this.numExports;
    }

    public Name getExportName(int exportIndex) {
        return ((ImmutableExport)this.exports.get((int)exportIndex)).name;
    }

    public int getExportNameMapOffset(Name exportName) {
        Integer objResult;
        assert (!exportName.isBus());
        if (this.exportNameMapOffsets == null) {
            this.buildExportNameMapOffsets();
        }
        return (objResult = this.exportNameMapOffsets.get(exportName)) != null ? objResult : -1;
    }

    public int getNumExpandedExports() {
        return this.numExports;
    }

    public int[] getEquivPortsN() {
        return (int[])this.equivPortsN.clone();
    }

    public int[] getEquivPortsP() {
        return (int[])this.equivPortsP.clone();
    }

    public int[] getEquivPortsA() {
        return (int[])this.equivPortsA.clone();
    }

    public int hashCode() {
        return Arrays.hashCode(this.equivPortsN);
    }

    public boolean equals(Object o) {
        if (!(o instanceof EquivalentSchematicExports)) {
            return false;
        }
        EquivalentSchematicExports that = (EquivalentSchematicExports)o;
        if (this.cellId != that.cellId || this.implementation.cellId != that.implementation.cellId) {
            return false;
        }
        if (this.cellId != this.implementation.cellId && !this.implementation.equals(that.implementation)) {
            return false;
        }
        if (this.globals != that.globals) {
            return false;
        }
        if (this.exports != that.exports) {
            if (this.exports.size() != that.exports.size()) {
                return false;
            }
            for (int exportIndex = 0; exportIndex < this.exports.size(); ++exportIndex) {
                ImmutableExport e1 = (ImmutableExport)this.exports.get(exportIndex);
                ImmutableExport e2 = (ImmutableExport)that.exports.get(exportIndex);
                if (e1.exportId == e2.exportId && e1.name == e2.name) continue;
                return false;
            }
        }
        assert (this.numExpandedExports == that.numExpandedExports);
        assert (Arrays.equals(this.portOffsets, that.portOffsets));
        if (this.globalPartitions == null || that.globalPartitions == null ? this.globalPartitions != null || that.globalPartitions != null : !this.globalPartitions.equals(that.globalPartitions)) {
            return false;
        }
        return Arrays.equals(this.equivPortsN, that.equivPortsN) && Arrays.equals(this.equivPortsP, that.equivPortsP) && Arrays.equals(this.equivPortsA, that.equivPortsA);
    }

    private void buildExportNameMapOffsets() {
        IdentityHashMap<Name, Integer> map2 = new IdentityHashMap<Name, Integer>();
        for (int exportIndex = 0; exportIndex < this.exports.size(); ++exportIndex) {
            ImmutableExport e = (ImmutableExport)this.exports.get(exportIndex);
            for (int busIndex = 0; busIndex < e.name.busWidth(); ++busIndex) {
                Integer mapOffset;
                Name exportName = e.name.subname(busIndex);
                if (map2.containsKey(exportName)) continue;
                if (this.implementation == this) {
                    mapOffset = this.portOffsets[exportIndex] + busIndex;
                } else {
                    mapOffset = this.implementation.getExportNameMapOffset(exportName);
                    if (mapOffset == null) continue;
                }
                map2.put(exportName, mapOffset);
            }
        }
        this.exportNameMapOffsets = map2;
    }
}

