/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellRevision;
import com.sun.electric.database.CellTree;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.id.NodeProtoId;
import com.sun.electric.database.id.PrimitiveNodeId;
import com.sun.electric.database.id.PrimitivePortId;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.GenMath;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Iterator;

public abstract class AbstractShapeBuilder {
    private Layer.Function.Set onlyTheseLayers;
    private boolean reasonable;
    private boolean wipePins;
    private boolean electrical;
    private final boolean rotateNodes;
    private Orientation orient;
    private AffineTransform pureRotate;
    protected double[] doubleCoords = new double[8];
    protected int pointCount;
    protected int[] intCoords = new int[4];
    private CellBackup.Memoization m;
    private Shrinkage shrinkage;
    private TechPool techPool;
    private ImmutableNodeInst curNode;
    private static final int MAXARCPIECES = 16;

    public AbstractShapeBuilder() {
        this(true);
    }

    public AbstractShapeBuilder(boolean rotateNodes) {
        this.rotateNodes = rotateNodes;
    }

    public void setup(Cell cell) {
        this.setup(cell.backupUnsafe(), null, false, true, false, null);
    }

    public void setup(CellTree cellTree, Orientation orient, boolean electrical, boolean wipePins, boolean reasonable, Layer.Function.Set onlyTheseLayers) {
        this.setup(cellTree.top, orient, electrical, wipePins, reasonable, onlyTheseLayers);
        this.techPool = cellTree.techPool;
    }

    public void setup(CellBackup cellBackup, Orientation orient, boolean electrical, boolean wipePins, boolean reasonable, Layer.Function.Set onlyTheseLayers) {
        this.m = cellBackup.getMemoization();
        this.shrinkage = cellBackup.getShrinkage();
        this.techPool = cellBackup.techPool;
        if (orient == null || orient.canonic() == Orientation.IDENT) {
            this.orient = null;
            this.pureRotate = null;
        } else {
            this.orient = orient.canonic();
            this.pureRotate = this.orient.pureRotate();
        }
        this.electrical = electrical;
        this.wipePins = wipePins;
        this.reasonable = reasonable;
        this.onlyTheseLayers = onlyTheseLayers;
        this.pointCount = 0;
        this.curNode = null;
    }

    public boolean isElectrical() {
        return this.electrical;
    }

    public boolean isReasonable() {
        return this.reasonable;
    }

    public boolean skipLayer(Layer layer) {
        return this.onlyTheseLayers != null && !this.onlyTheseLayers.contains(layer.getFunction(), layer.getFunctionExtras());
    }

    public CellBackup.Memoization getMemoization() {
        return this.m;
    }

    public CellBackup getCellBackup() {
        return this.m.getCellBackup();
    }

    public Shrinkage getShrinkage() {
        return this.shrinkage;
    }

    public TechPool getTechPool() {
        return this.techPool;
    }

    public void genShapeOfArc(ImmutableArcInst a) {
        if (this.genShapeEasy(a)) {
            return;
        }
        this.pointCount = 0;
        this.curNode = null;
        this.techPool.getTech(a.protoId.techId).getShapeOfArc(this, a);
    }

    public void genShapeOfNode(ImmutableNodeInst n) {
        Technology.NodeLayer[] eLayers;
        PrimitiveNode pn = this.techPool.getPrimitiveNode((PrimitiveNodeId)n.protoId);
        if (this.wipePins) {
            if (this.m.isWiped(n)) {
                return;
            }
            if (pn.isWipeOn1or2() && this.m.pinUseCount(n)) {
                return;
            }
        }
        Technology.NodeLayer[] primLayers = pn.getNodeLayers();
        if (this.electrical && (eLayers = pn.getElectricalLayers()) != null) {
            primLayers = eLayers;
        }
        this.pointCount = 0;
        this.curNode = n;
        pn.getTechnology().genShapeOfNode(this, n, pn, primLayers);
    }

    public void genShapeOfNode(ImmutableNodeInst n, PrimitiveNode np, Technology.NodeLayer[] primLayers, EGraphics graphicsOverride) {
        this.pointCount = 0;
        if (np.isHoldsOutline()) {
            int specialType = np.getSpecialType();
            if (specialType == 1) {
                SerpentineTrans std = new SerpentineTrans(n, np, primLayers);
                if (std.layersTotal > 0) {
                    std.initTransPolyFilling();
                    for (int i = 0; i < std.layersTotal; ++i) {
                        std.fillTransPoly();
                    }
                    return;
                }
            } else {
                EPoint[] outline = n.getTrace();
                if (outline != null) {
                    assert (primLayers.length == 1);
                    Technology.NodeLayer primLayer = primLayers[0];
                    Layer layer = primLayer.getLayer();
                    if (this.skipLayer(layer)) {
                        return;
                    }
                    Poly.Type style = primLayer.getStyle();
                    PrimitivePort pp = primLayer.getPort(np);
                    int startPoint = 0;
                    for (int i = 1; i < outline.length; ++i) {
                        boolean breakPoint;
                        boolean bl = breakPoint = i == outline.length - 1 || outline[i] == null;
                        if (!breakPoint) continue;
                        if (i == outline.length - 1) {
                            ++i;
                        }
                        for (int j = startPoint; j < i; ++j) {
                            this.pushPoint(outline[j]);
                        }
                        this.pushPoly(style, layer, graphicsOverride, pp);
                        startPoint = i + 1;
                    }
                    return;
                }
            }
        }
        double xSize = n.size.getGridX();
        double ySize = n.size.getGridY();
        for (int i = 0; i < primLayers.length; ++i) {
            Technology.NodeLayer primLayer = primLayers[i];
            Layer layer = primLayer.getLayerOrPseudoLayer();
            if (this.skipLayer(layer)) continue;
            Poly.Type style = primLayer.getStyle();
            PrimitivePort pp = primLayer.getPort(np);
            if (layer.isCarbonNanotubeLayer() && (np.getFunction() == PrimitiveNode.Function.TRANMOSCN || np.getFunction() == PrimitiveNode.Function.TRAPMOSCN)) {
                CarbonNanotube cnd = new CarbonNanotube(n, primLayer);
                for (int j = 0; j < cnd.numTubes; ++j) {
                    cnd.fillCutPoly(j, style, layer, pp);
                }
                assert (graphicsOverride == null);
                continue;
            }
            int representation = primLayer.getRepresentation();
            if (representation == 1) {
                EdgeH leftEdge = primLayer.getLeftEdge();
                EdgeH rightEdge = primLayer.getRightEdge();
                EdgeV topEdge = primLayer.getTopEdge();
                EdgeV bottomEdge = primLayer.getBottomEdge();
                double portLowX = leftEdge.getMultiplier() * xSize + (double)leftEdge.getGridAdder();
                double portHighX = rightEdge.getMultiplier() * xSize + (double)rightEdge.getGridAdder();
                double portLowY = bottomEdge.getMultiplier() * ySize + (double)bottomEdge.getGridAdder();
                double portHighY = topEdge.getMultiplier() * ySize + (double)topEdge.getGridAdder();
                this.pushPoint(portLowX, portLowY);
                this.pushPoint(portHighX, portLowY);
                this.pushPoint(portHighX, portHighY);
                this.pushPoint(portLowX, portHighY);
            } else if (representation == 0) {
                Technology.TechPoint[] points = primLayer.getPoints();
                for (int j = 0; j < points.length; ++j) {
                    EdgeH xFactor = points[j].getX();
                    EdgeV yFactor = points[j].getY();
                    double x2 = 0.0;
                    double y = 0.0;
                    if (xFactor != null && yFactor != null) {
                        x2 = xFactor.getMultiplier() * xSize + (double)xFactor.getGridAdder();
                        y = yFactor.getMultiplier() * ySize + (double)yFactor.getGridAdder();
                    }
                    this.pushPoint(x2, y);
                }
            } else if (representation == 3) {
                MultiCutData mcd = new MultiCutData(n, primLayer);
                int numExtraLayers = this.reasonable ? mcd.cutsReasonable : mcd.cutsTotal;
                for (int j = 0; j < numExtraLayers; ++j) {
                    mcd.fillCutPoly(j, style, layer, pp);
                }
                assert (graphicsOverride == null);
                continue;
            }
            if (style.isText()) {
                assert (graphicsOverride == null);
                this.pushTextPoly(style, layer, pp, primLayer.getMessage(), primLayer.getDescriptor());
                continue;
            }
            this.pushPoly(style, layer, graphicsOverride, pp);
        }
    }

    public void genShapeOfPort(ImmutableNodeInst n, PrimitivePortId portId, Point2D selectPt) {
        PrimitiveNode pn = this.techPool.getPrimitiveNode((PrimitiveNodeId)n.protoId);
        PrimitivePort pp = pn.getPort(portId);
        this.pointCount = 0;
        this.curNode = n;
        pn.getTechnology().genShapeOfPort(this, n, pn, pp, selectPt);
    }

    public void genShapeOfPort(ImmutableNodeInst n, PrimitiveNode pn, PrimitivePort pp) {
        EPoint[] outline;
        SerpentineTrans std;
        if (pn.getSpecialType() == 1 && (std = new SerpentineTrans(n, pn, pn.getNodeLayers())).hasValidData()) {
            std.fillTransPort(pp);
            return;
        }
        if (pn.isHoldsOutline() && (outline = n.getTrace()) != null) {
            int i;
            int endPortPoly = outline.length;
            for (i = 1; i < outline.length; ++i) {
                if (outline[i] != null) continue;
                endPortPoly = i;
                break;
            }
            for (i = 0; i < endPortPoly; ++i) {
                this.pushPoint(outline[i].getGridX(), outline[i].getGridY());
            }
            Poly.Type style = pn.getTechnology().getPrimitiveFunction(pn, n.techBits) == PrimitiveNode.Function.NODE ? Poly.Type.FILLED : Poly.Type.OPENED;
            this.pushPoly(style, null, null, null);
            return;
        }
        double sizeX = n.size.getGridX();
        double sizeY = n.size.getGridY();
        double portLowX = pp.getLeft().getMultiplier() * sizeX + (double)pp.getLeft().getGridAdder();
        double portHighX = pp.getRight().getMultiplier() * sizeX + (double)pp.getRight().getGridAdder();
        double portLowY = pp.getBottom().getMultiplier() * sizeY + (double)pp.getBottom().getGridAdder();
        double portHighY = pp.getTop().getMultiplier() * sizeY + (double)pp.getTop().getGridAdder();
        this.pushPoint(portLowX, portLowY);
        this.pushPoint(portHighX, portLowY);
        this.pushPoint(portHighX, portHighY);
        this.pushPoint(portLowX, portHighY);
        this.pushPoly(Poly.Type.FILLED, null, null, null);
    }

    public void makeGridPoly(ImmutableArcInst a, long gridWidth, Poly.Type style, Layer layer, EGraphics graphicsOverride) {
        Double radiusDouble;
        if (this.techPool.getArcProto(a.protoId).isCurvable() && (radiusDouble = a.getRadius()) != null && this.curvedArcGridOutline(a, gridWidth, DBMath.lambdaToGrid(radiusDouble))) {
            this.pushPoly(style, layer, graphicsOverride, null);
            return;
        }
        if (gridWidth <= 0L) {
            this.pushPoint(a.tailLocation);
            this.pushPoint(a.headLocation);
            if (style == Poly.Type.FILLED) {
                style = Poly.Type.OPENED;
            }
            this.pushPoly(style, layer, graphicsOverride, null);
            return;
        }
        int w2 = (int)gridWidth >>> 1;
        short shrinkT = a.isTailExtended() ? this.shrinkage.get(a.tailNodeId) : (short)1;
        short shrinkH = a.isHeadExtended() ? this.shrinkage.get(a.headNodeId) : (short)1;
        int angle = a.getDefinedAngle();
        double w2x = DBMath.roundShapeCoord((double)w2 * GenMath.cos(angle));
        double w2y = DBMath.roundShapeCoord((double)w2 * GenMath.sin(angle));
        double tx = 0.0;
        double ty = 0.0;
        if (shrinkT == 0) {
            tx = -w2x;
            ty = -w2y;
        } else if (shrinkT != 1) {
            int oppAngle = a.getOppositeAngle();
            if (oppAngle == -1) {
                oppAngle = 0;
            }
            Point2D e = AbstractShapeBuilder.computeExtension(w2, -w2x, -w2y, oppAngle, shrinkT);
            tx = e.getX();
            ty = e.getY();
        }
        double hx = 0.0;
        double hy = 0.0;
        if (shrinkH == 0) {
            hx = w2x;
            hy = w2y;
        } else if (shrinkH != 1) {
            Point2D e = AbstractShapeBuilder.computeExtension(w2, w2x, w2y, angle, shrinkH);
            hx = e.getX();
            hy = e.getY();
        }
        this.pushPoint(a.tailLocation, tx - w2y, ty + w2x);
        this.pushPoint(a.tailLocation, tx + w2y, ty - w2x);
        this.pushPoint(a.headLocation, hx + w2y, hy - w2x);
        this.pushPoint(a.headLocation, hx - w2y, hy + w2x);
        if (gridWidth != 0L && style.isOpened()) {
            this.pushPoint(a.tailLocation, tx - w2y, ty + w2x);
        }
        this.pushPoly(style, layer, graphicsOverride, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Point2D computeExtension(int w2, double ix1, double iy1, int angle, short shrink) {
        double s2;
        double s1;
        if (shrink == 0) {
            return new Point2D.Double(ix1, iy1);
        }
        if (shrink == 1) {
            return new Point2D.Double(0.0, 0.0);
        }
        assert (shrink >= 2);
        int angle2 = shrink - 2 - angle;
        if (angle2 < 0) {
            angle2 += 3600;
        }
        double x1 = ix1;
        double y1 = iy1;
        if (y1 == 0.0) {
            if (x1 > 0.0) {
                s1 = x1;
                x1 = 1.0;
            } else {
                if (!(x1 < 0.0)) return new Point2D.Double(0.0, 0.0);
                s1 = -x1;
                x1 = -1.0;
            }
        } else if (x1 == 0.0) {
            if (y1 > 0.0) {
                s1 = y1;
                y1 = 1.0;
            } else {
                s1 = -y1;
                y1 = -1.0;
            }
        } else {
            s1 = x1 * x1 + y1 * y1;
        }
        double x2 = DBMath.roundShapeCoord((double)w2 * GenMath.cos(angle2));
        double y2 = DBMath.roundShapeCoord((double)w2 * GenMath.sin(angle2));
        if (y2 == 0.0) {
            if (x2 > 0.0) {
                s2 = x2;
                x2 = 1.0;
            } else {
                if (!(x2 < 0.0)) return new Point2D.Double(0.0, 0.0);
                s2 = -x2;
                x2 = -1.0;
            }
        } else if (x2 == 0.0) {
            if (y2 > 0.0) {
                s2 = y2;
                y2 = 1.0;
            } else {
                s2 = -y2;
                y2 = -1.0;
            }
        } else {
            s2 = x2 * x2 + y2 * y2;
        }
        double det = x1 * y2 - y1 * x2;
        if (det == 0.0) {
            return new Point2D.Double(0.0, 0.0);
        }
        double x3 = (x2 * s1 + x1 * s2) / det;
        double y = (y2 * s1 + y1 * s2) / det;
        x3 = DBMath.roundShapeCoord(x3);
        y = DBMath.roundShapeCoord(y);
        if (!(det < 0.0)) return new Point2D.Double(x3 += iy1, y -= ix1);
        x3 = -x3;
        y = -y;
        return new Point2D.Double(x3 += iy1, y -= ix1);
    }

    public boolean curvedArcGridOutline(ImmutableArcInst a, long gridWidth, long gridRadius) {
        int angle;
        int i;
        int pieces;
        double gridLength;
        long pureGridRadius = Math.abs(gridRadius);
        if ((double)(pureGridRadius * 2L) < (gridLength = a.getGridLength())) {
            return false;
        }
        Point2D[] centers = DBMath.findCenters(pureGridRadius, a.headLocation.gridMutable(), a.tailLocation.gridMutable());
        if (centers == null) {
            return false;
        }
        Point2D centerPt = centers[1];
        if (gridRadius < 0L) {
            centerPt = centers[0];
        }
        double centerX = centerPt.getX();
        double centerY = centerPt.getY();
        int angleBase = DBMath.figureAngle((double)a.headLocation.getGridX() - centerX, (double)a.headLocation.getGridY() - centerY);
        int angleRange = DBMath.figureAngle((double)a.tailLocation.getGridX() - centerX, (double)a.tailLocation.getGridY() - centerY);
        if ((angleRange -= angleBase) < 0) {
            angleRange += 3600;
        }
        if (angleRange > 1800) {
            if ((angleBase += angleRange) < 0) {
                angleBase += 3600;
            }
            angleRange = 3600 - angleRange;
        }
        for (pieces = angleRange; pieces > 16; pieces /= 2) {
        }
        if (pieces == 0) {
            return false;
        }
        double outerRadius = pureGridRadius + gridWidth / 2L;
        double innerRadius = outerRadius - (double)gridWidth;
        for (i = 0; i <= pieces; ++i) {
            angle = (angleBase + i * angleRange / pieces) % 3600;
            this.pushPoint(DBMath.cos(angle) * innerRadius + centerX, DBMath.sin(angle) * innerRadius + centerY);
        }
        for (i = pieces; i >= 0; --i) {
            angle = (angleBase + i * angleRange / pieces) % 3600;
            this.pushPoint(DBMath.cos(angle) * outerRadius + centerX, DBMath.sin(angle) * outerRadius + centerY);
        }
        return true;
    }

    public boolean genShapeEasy(ImmutableArcInst a) {
        if (this.m.isHardArc(a.arcId)) {
            return false;
        }
        ArcProto protoType = this.techPool.getArcProto(a.protoId);
        int gridExtendOverMin = (int)a.getGridExtendOverMin();
        int minLayerExtend = gridExtendOverMin + protoType.getMinLayerGridExtend();
        if (minLayerExtend == 0) {
            assert (protoType.getNumArcLayers() == 1);
            Technology.ArcLayer primLayer = protoType.getArcLayer(0);
            Layer layer = primLayer.getLayer();
            if (this.skipLayer(layer)) {
                return true;
            }
            Poly.Type style = primLayer.getStyle();
            if (style == Poly.Type.FILLED) {
                style = Poly.Type.OPENED;
            }
            this.intCoords[0] = (int)a.tailLocation.getGridX();
            this.intCoords[1] = (int)a.tailLocation.getGridY();
            this.intCoords[2] = (int)a.headLocation.getGridX();
            this.intCoords[3] = (int)a.headLocation.getGridY();
            this.pushIntLine(style, primLayer.getLayer());
            return true;
        }
        boolean tailExtended = false;
        if (a.isTailExtended()) {
            short shrinkT = this.shrinkage.get(a.tailNodeId);
            if (shrinkT == 0) {
                tailExtended = true;
            } else if (shrinkT != 1) {
                return false;
            }
        }
        boolean headExtended = false;
        if (a.isHeadExtended()) {
            short shrinkH = this.shrinkage.get(a.headNodeId);
            if (shrinkH == 0) {
                headExtended = true;
            } else if (shrinkH != 1) {
                return false;
            }
        }
        int n = protoType.getNumArcLayers();
        for (int i = 0; i < n; ++i) {
            Technology.ArcLayer primLayer = protoType.getArcLayer(i);
            Layer layer = primLayer.getLayer();
            assert (primLayer.getStyle() == Poly.Type.FILLED);
            if (this.skipLayer(layer)) continue;
            a.makeGridBoxInt(this.intCoords, tailExtended, headExtended, gridExtendOverMin + protoType.getLayerGridExtend(i));
            this.pushIntBox(layer);
        }
        return true;
    }

    public void pushPoint(EPoint p, double gridX, double gridY) {
        this.pushPointLow((double)p.getGridX() + DBMath.roundShapeCoord(gridX), (double)p.getGridY() + DBMath.roundShapeCoord(gridY));
    }

    public void pushPoint(double gridX, double gridY) {
        this.pushPointLow(DBMath.roundShapeCoord(gridX), DBMath.roundShapeCoord(gridY));
    }

    public void pushPoint(EPoint p) {
        this.pushPointLow(p.getGridX(), p.getGridY());
    }

    private void pushPointLow(double gridX, double gridY) {
        if (this.pointCount * 2 >= this.doubleCoords.length) {
            this.resize();
        }
        this.doubleCoords[this.pointCount * 2] = gridX;
        this.doubleCoords[this.pointCount * 2 + 1] = gridY;
        ++this.pointCount;
    }

    private void resize() {
        double[] newDoubleCoords = new double[this.doubleCoords.length * 2];
        System.arraycopy(this.doubleCoords, 0, newDoubleCoords, 0, this.doubleCoords.length);
        this.doubleCoords = newDoubleCoords;
    }

    public void pushPoly(Poly.Type style, Layer layer, EGraphics graphicsOverride, PrimitivePort pp) {
        if (!this.electrical) {
            pp = null;
        }
        this.transformDoubleCoords(style);
        if (style == Poly.Type.FILLED && this.pointCount == 4 && graphicsOverride == null && pp == null && (this.doubleCoords[0] == this.doubleCoords[2] && this.doubleCoords[4] == this.doubleCoords[6] && this.doubleCoords[1] == this.doubleCoords[7] && this.doubleCoords[3] == this.doubleCoords[5] || this.doubleCoords[0] == this.doubleCoords[6] && this.doubleCoords[2] == this.doubleCoords[4] && this.doubleCoords[1] == this.doubleCoords[3] && this.doubleCoords[5] == this.doubleCoords[7])) {
            double dlx = Math.min(this.doubleCoords[0], this.doubleCoords[4]);
            double dhx = Math.max(this.doubleCoords[0], this.doubleCoords[4]);
            double dly = Math.min(this.doubleCoords[1], this.doubleCoords[5]);
            double dhy = Math.max(this.doubleCoords[1], this.doubleCoords[5]);
            long lx = (long)dlx;
            long hx = (long)dhx;
            long ly = (long)dly;
            long hy = (long)dhy;
            if (dlx == (double)lx && dhx == (double)hx && dly == (double)ly && dhy == (double)hy) {
                this.pointCount = 0;
                this.intCoords[0] = (int)lx;
                this.intCoords[1] = (int)ly;
                this.intCoords[2] = (int)hx;
                this.intCoords[3] = (int)hy;
                this.addIntBox(this.intCoords, layer);
                return;
            }
        }
        this.addDoublePoly(this.pointCount, style, layer, graphicsOverride, pp);
        this.pointCount = 0;
    }

    public void pushTextPoly(Poly.Type style, Layer layer, PrimitivePort pp, String message, TextDescriptor descriptor) {
        if (!this.electrical) {
            pp = null;
        }
        this.transformDoubleCoords(style);
        this.addDoubleTextPoly(this.pointCount, style, layer, pp, message, descriptor);
        this.pointCount = 0;
    }

    private void transformDoubleCoords(Poly.Type style) {
        if (this.curNode != null) {
            if (this.rotateNodes && this.curNode.orient.canonic() != Orientation.IDENT) {
                if ((style == Poly.Type.CIRCLEARC || style == Poly.Type.THICKCIRCLEARC) && this.curNode.orient.canonic().isCTranspose()) {
                    double t = this.doubleCoords[2];
                    this.doubleCoords[2] = this.doubleCoords[4];
                    this.doubleCoords[4] = t;
                    t = this.doubleCoords[3];
                    this.doubleCoords[3] = this.doubleCoords[5];
                    this.doubleCoords[5] = t;
                }
                this.curNode.orient.pureRotate().transform(this.doubleCoords, 0, this.doubleCoords, 0, this.pointCount);
                if (!this.curNode.orient.isManhattan()) {
                    for (int i = 0; i < this.pointCount * 2; ++i) {
                        this.doubleCoords[i] = DBMath.roundShapeCoord(this.doubleCoords[i]);
                    }
                }
            }
            double anchorX = this.curNode.anchor.getGridX();
            double anchorY = this.curNode.anchor.getGridY();
            for (int i = 0; i < this.pointCount; ++i) {
                int n = i * 2 + 0;
                this.doubleCoords[n] = this.doubleCoords[n] + anchorX;
                int n2 = i * 2 + 1;
                this.doubleCoords[n2] = this.doubleCoords[n2] + anchorY;
            }
        }
        if (this.pureRotate != null) {
            if ((style == Poly.Type.CIRCLEARC || style == Poly.Type.THICKCIRCLEARC) && this.orient.canonic().isCTranspose()) {
                double t = this.doubleCoords[2];
                this.doubleCoords[2] = this.doubleCoords[4];
                this.doubleCoords[4] = t;
                t = this.doubleCoords[3];
                this.doubleCoords[3] = this.doubleCoords[5];
                this.doubleCoords[5] = t;
            }
            this.pureRotate.transform(this.doubleCoords, 0, this.doubleCoords, 0, this.pointCount);
            if (!this.orient.isManhattan()) {
                for (int i = 0; i < this.pointCount * 2; ++i) {
                    this.doubleCoords[i] = DBMath.roundShapeCoord(this.doubleCoords[i]);
                }
            }
        }
    }

    public void pushIntBox(Layer layer) {
        if (this.curNode != null && !this.curNode.orient.isManhattan() || this.orient != null && !this.orient.isManhattan()) {
            this.pushPointLow(this.intCoords[0], this.intCoords[1]);
            this.pushPointLow(this.intCoords[2], this.intCoords[1]);
            this.pushPointLow(this.intCoords[2], this.intCoords[3]);
            this.pushPointLow(this.intCoords[0], this.intCoords[3]);
            this.pushPoly(Poly.Type.FILLED, layer, null, null);
            return;
        }
        if (this.curNode != null) {
            if (this.rotateNodes && this.curNode.orient.canonic() != Orientation.IDENT) {
                this.curNode.orient.rectangleBounds(this.intCoords);
            }
            int anchorX = (int)this.curNode.anchor.getGridX();
            int anchorY = (int)this.curNode.anchor.getGridY();
            this.intCoords[0] = this.intCoords[0] + anchorX;
            this.intCoords[1] = this.intCoords[1] + anchorY;
            this.intCoords[2] = this.intCoords[2] + anchorX;
            this.intCoords[3] = this.intCoords[3] + anchorY;
        }
        if (this.orient != null) {
            this.orient.rectangleBounds(this.intCoords);
        }
        this.addIntBox(this.intCoords, layer);
    }

    public void pushIntLine(Poly.Type style, Layer layer) {
        if (this.orient != null) {
            if (!this.orient.isManhattan()) {
                this.pushPointLow(this.intCoords[0], this.intCoords[1]);
                this.pushPointLow(this.intCoords[2], this.intCoords[3]);
                this.pushPoly(style, layer, null, null);
                return;
            }
            this.orient.transformPoints(2, this.intCoords);
        }
        this.addIntPoly(2, style, layer, null, null);
    }

    public abstract void addDoublePoly(int var1, Poly.Type var2, Layer var3, EGraphics var4, PrimitivePort var5);

    public void addDoubleTextPoly(int numPoints, Poly.Type style, Layer layer, PrimitivePort pp, String message, TextDescriptor descriptor) {
        this.addDoublePoly(numPoints, style, layer, null, pp);
    }

    public abstract void addIntPoly(int var1, Poly.Type var2, Layer var3, EGraphics var4, PrimitivePort var5);

    public abstract void addIntBox(int[] var1, Layer var2);

    private class SerpentineTrans {
        private static final int LEFTANGLE = 900;
        private static final int RIGHTANGLE = 2700;
        private ImmutableNodeInst theNode;
        private PrimitiveNode theProto;
        private int layersTotal;
        private int numSegments;
        private double extraScale;
        private Technology.NodeLayer[] primLayers;
        private Point2D[] points;
        private double[] specialValues;
        private boolean fieldPolyOnEndsOnly;
        private int fillBox;

        private SerpentineTrans(ImmutableNodeInst niD, PrimitiveNode protoType, Technology.NodeLayer[] pLayers) {
            this.theNode = niD;
            this.layersTotal = 0;
            this.points = niD.getTrace();
            if (this.points != null && this.points.length < 2) {
                this.points = null;
            }
            if (this.points != null) {
                this.theProto = protoType;
                this.specialValues = this.theProto.getSpecialValues();
                this.primLayers = pLayers;
                int count2 = this.primLayers.length;
                this.numSegments = this.points.length - 1;
                this.layersTotal = count2;
                this.extraScale = 0.0;
                double length = niD.getSerpentineTransistorLength();
                if (length > 0.0) {
                    this.extraScale = (length - this.specialValues[3]) / 2.0;
                }
                this.fieldPolyOnEndsOnly = false;
                int numFieldPoly = 0;
                int numGatePoly = 0;
                for (int i = 0; i < count2; ++i) {
                    if (!this.primLayers[i].getLayer().getFunction().isPoly()) continue;
                    if (this.primLayers[i].getLayer().getFunction() == Layer.Function.GATE) {
                        ++numGatePoly;
                        continue;
                    }
                    ++numFieldPoly;
                }
                if (numFieldPoly > 0 && numGatePoly > 0) {
                    this.fieldPolyOnEndsOnly = true;
                }
            }
        }

        private boolean hasValidData() {
            return this.points != null;
        }

        private void initTransPolyFilling() {
            this.fillBox = 0;
        }

        private void fillTransPoly() {
            int element;
            Technology.NodeLayer primLayer;
            Layer layer;
            if (AbstractShapeBuilder.this.skipLayer(layer = (primLayer = this.primLayers[element = this.fillBox++]).getLayer())) {
                return;
            }
            double extendt = primLayer.getSerpentineExtentT();
            double extendb = primLayer.getSerpentineExtentB();
            boolean extendEnds = true;
            if (this.fieldPolyOnEndsOnly && layer.getFunction().isPoly()) {
                if (layer.getFunction() == Layer.Function.GATE) {
                    extendEnds = false;
                } else {
                    if (extendt != 0.0) {
                        int thissg = 0;
                        int nextsg = 1;
                        Point2D thisPt = this.points[thissg];
                        Point2D nextPt = this.points[nextsg];
                        int angle = DBMath.figureAngle(thisPt, nextPt);
                        nextPt = thisPt;
                        int ang = angle + 1800;
                        thisPt = DBMath.addPoints(thisPt, DBMath.cos(ang) * extendt, DBMath.sin(ang) * extendt);
                        this.buildSerpentinePoly(element, 0, this.numSegments, thisPt, nextPt, angle);
                        return;
                    }
                    if (extendb != 0.0) {
                        int thissg = this.numSegments - 1;
                        int nextsg = this.numSegments;
                        Point2D thisPt = this.points[thissg];
                        Point2D nextPt = this.points[nextsg];
                        int angle = DBMath.figureAngle(thisPt, nextPt);
                        thisPt = nextPt;
                        nextPt = DBMath.addPoints(nextPt, DBMath.cos(angle) * extendb, DBMath.sin(angle) * extendb);
                        this.buildSerpentinePoly(element, 0, this.numSegments, thisPt, nextPt, angle);
                        return;
                    }
                }
            }
            Point2D.Double[] outPoints = new Point2D.Double[(this.numSegments + 1) * 2];
            for (int segment = 0; segment < this.numSegments; ++segment) {
                Point2D otherPt;
                int otherang;
                int thissg = segment;
                int nextsg = segment + 1;
                Point2D thisPt = this.points[thissg];
                Point2D nextPt = this.points[nextsg];
                int angle = DBMath.figureAngle(thisPt, nextPt);
                if (extendEnds) {
                    if (thissg == 0) {
                        int ang = angle + 1800;
                        thisPt = DBMath.addPoints(thisPt, DBMath.cos(ang) * extendt, DBMath.sin(ang) * extendt);
                    }
                    if (nextsg == this.numSegments) {
                        nextPt = DBMath.addPoints(nextPt, DBMath.cos(angle) * extendb, DBMath.sin(angle) * extendb);
                    }
                }
                double lwid = primLayer.getSerpentineLWidth();
                double rwid = primLayer.getSerpentineRWidth();
                rwid += this.extraScale;
                int ang = angle + 900;
                double sin = DBMath.sin(ang) * (lwid += this.extraScale);
                double cos = DBMath.cos(ang) * lwid;
                Point2D thisL = DBMath.addPoints(thisPt, cos, sin);
                Point2D nextL = DBMath.addPoints(nextPt, cos, sin);
                ang = angle + 2700;
                sin = DBMath.sin(ang) * rwid;
                cos = DBMath.cos(ang) * rwid;
                Point2D thisR = DBMath.addPoints(thisPt, cos, sin);
                Point2D nextR = DBMath.addPoints(nextPt, cos, sin);
                if (thissg != 0 && (otherang = DBMath.figureAngle(otherPt = this.points[thissg - 1], thisPt)) != angle) {
                    ang = otherang + 900;
                    thisL = DBMath.intersect(DBMath.addPoints(thisPt, DBMath.cos(ang) * lwid, DBMath.sin(ang) * lwid), otherang, thisL, angle);
                    ang = otherang + 2700;
                    thisR = DBMath.intersect(DBMath.addPoints(thisPt, DBMath.cos(ang) * rwid, DBMath.sin(ang) * rwid), otherang, thisR, angle);
                }
                if (nextsg != this.numSegments && (otherang = DBMath.figureAngle(nextPt, otherPt = this.points[nextsg + 1])) != angle) {
                    ang = otherang + 900;
                    Point2D newPtL = DBMath.addPoints(nextPt, DBMath.cos(ang) * lwid, DBMath.sin(ang) * lwid);
                    nextL = DBMath.intersect(newPtL, otherang, nextL, angle);
                    ang = otherang + 2700;
                    Point2D newPtR = DBMath.addPoints(nextPt, DBMath.cos(ang) * rwid, DBMath.sin(ang) * rwid);
                    nextR = DBMath.intersect(newPtR, otherang, nextR, angle);
                }
                if (segment == 0) {
                    outPoints[0] = thisL;
                    outPoints[1] = nextL;
                    outPoints[(this.numSegments + 1) * 2 - 2] = nextR;
                    outPoints[(this.numSegments + 1) * 2 - 1] = thisR;
                    continue;
                }
                outPoints[segment + 1] = nextL;
                outPoints[(this.numSegments + 1) * 2 - 2 - segment] = nextR;
            }
            for (Point2D.Double point : outPoints) {
                AbstractShapeBuilder.this.pushPoint(((Point2D)point).getX() * 400.0, ((Point2D)point).getY() * 400.0);
            }
            AbstractShapeBuilder.this.pushPoly(primLayer.getStyle(), layer, null, primLayer.getPort(this.theProto));
        }

        private void buildSerpentinePoly(int element, int thissg, int nextsg, Point2D thisPt, Point2D nextPt, int angle) {
            Point2D otherPt;
            int otherang;
            Technology.NodeLayer primLayer = this.primLayers[element];
            double lwid = primLayer.getSerpentineLWidth();
            double rwid = primLayer.getSerpentineRWidth();
            rwid += this.extraScale;
            int ang = angle + 900;
            double sin = DBMath.sin(ang) * (lwid += this.extraScale);
            double cos = DBMath.cos(ang) * lwid;
            Point2D thisL = DBMath.addPoints(thisPt, cos, sin);
            Point2D nextL = DBMath.addPoints(nextPt, cos, sin);
            ang = angle + 2700;
            sin = DBMath.sin(ang) * rwid;
            cos = DBMath.cos(ang) * rwid;
            Point2D thisR = DBMath.addPoints(thisPt, cos, sin);
            Point2D nextR = DBMath.addPoints(nextPt, cos, sin);
            if (thissg != 0 && (otherang = DBMath.figureAngle(otherPt = this.points[thissg - 1], thisPt)) != angle) {
                ang = otherang + 900;
                thisL = DBMath.intersect(DBMath.addPoints(thisPt, DBMath.cos(ang) * lwid, DBMath.sin(ang) * lwid), otherang, thisL, angle);
                ang = otherang + 2700;
                thisR = DBMath.intersect(DBMath.addPoints(thisPt, DBMath.cos(ang) * rwid, DBMath.sin(ang) * rwid), otherang, thisR, angle);
            }
            if (nextsg != this.numSegments && (otherang = DBMath.figureAngle(nextPt, otherPt = this.points[nextsg + 1])) != angle) {
                ang = otherang + 900;
                Point2D newPtL = DBMath.addPoints(nextPt, DBMath.cos(ang) * lwid, DBMath.sin(ang) * lwid);
                nextL = DBMath.intersect(newPtL, otherang, nextL, angle);
                ang = otherang + 2700;
                Point2D newPtR = DBMath.addPoints(nextPt, DBMath.cos(ang) * rwid, DBMath.sin(ang) * rwid);
                nextR = DBMath.intersect(newPtR, otherang, nextR, angle);
            }
            AbstractShapeBuilder.this.pushPoint(thisL.getX() * 400.0, thisL.getY() * 400.0);
            AbstractShapeBuilder.this.pushPoint(thisR.getX() * 400.0, thisR.getY() * 400.0);
            AbstractShapeBuilder.this.pushPoint(nextR.getX() * 400.0, nextR.getY() * 400.0);
            AbstractShapeBuilder.this.pushPoint(nextL.getX() * 400.0, nextL.getY() * 400.0);
            AbstractShapeBuilder.this.pushPoly(primLayer.getStyle(), primLayer.getLayer(), null, primLayer.getPort(this.theProto));
        }

        private void fillTransPort(PortProto pp) {
            Point2D.Double nextPt;
            Point2D.Double thisPt;
            PortProto lpp;
            double diffInset = this.specialValues[1];
            double diffExtend = this.specialValues[2];
            double defWid = this.specialValues[3] + this.extraScale;
            double polyInset = this.specialValues[4];
            double polyExtend = this.specialValues[5];
            int total = this.points.length;
            int which = 0;
            Iterator<PortProto> it = this.theProto.getPorts();
            while (it.hasNext() && (lpp = it.next()) != pp) {
                ++which;
            }
            assert (which == pp.getPortIndex());
            if (which == 0) {
                thisPt = new Point2D.Double(this.points[0].getX(), this.points[0].getY());
                nextPt = new Point2D.Double(this.points[1].getX(), this.points[1].getY());
                int angle = DBMath.figureAngle(thisPt, nextPt);
                int ang = (angle + 1800) % 3600;
                ((Point2D)thisPt).setLocation(((Point2D)thisPt).getX() + DBMath.cos(ang) * polyExtend, ((Point2D)thisPt).getY() + DBMath.sin(ang) * polyExtend);
                ang = (angle + 900) % 3600;
                Point2D.Double end1 = new Point2D.Double(((Point2D)thisPt).getX() + DBMath.cos(ang) * (defWid / 2.0 - polyInset), ((Point2D)thisPt).getY() + DBMath.sin(ang) * (defWid / 2.0 - polyInset));
                ang = (angle + 2700) % 3600;
                Point2D.Double end2 = new Point2D.Double(((Point2D)thisPt).getX() + DBMath.cos(ang) * (defWid / 2.0 - polyInset), ((Point2D)thisPt).getY() + DBMath.sin(ang) * (defWid / 2.0 - polyInset));
                AbstractShapeBuilder.this.pushPoint(((Point2D)end1).getX() * 400.0, ((Point2D)end1).getY() * 400.0);
                AbstractShapeBuilder.this.pushPoint(((Point2D)end2).getX() * 400.0, ((Point2D)end2).getY() * 400.0);
                AbstractShapeBuilder.this.pushPoly(Poly.Type.OPENED, null, null, null);
                return;
            }
            if (which == 2) {
                thisPt = new Point2D.Double(this.points[total - 1].getX(), this.points[total - 1].getY());
                nextPt = new Point2D.Double(this.points[total - 2].getX(), this.points[total - 2].getY());
                int angle = DBMath.figureAngle(thisPt, nextPt);
                int ang = (angle + 1800) % 3600;
                ((Point2D)thisPt).setLocation(((Point2D)thisPt).getX() + DBMath.cos(ang) * polyExtend, ((Point2D)thisPt).getY() + DBMath.sin(ang) * polyExtend);
                ang = (angle + 900) % 3600;
                Point2D.Double end1 = new Point2D.Double(((Point2D)thisPt).getX() + DBMath.cos(ang) * (defWid / 2.0 - polyInset), ((Point2D)thisPt).getY() + DBMath.sin(ang) * (defWid / 2.0 - polyInset));
                ang = (angle + 2700) % 3600;
                Point2D.Double end2 = new Point2D.Double(((Point2D)thisPt).getX() + DBMath.cos(ang) * (defWid / 2.0 - polyInset), ((Point2D)thisPt).getY() + DBMath.sin(ang) * (defWid / 2.0 - polyInset));
                AbstractShapeBuilder.this.pushPoint(((Point2D)end1).getX() * 400.0, ((Point2D)end1).getY() * 400.0);
                AbstractShapeBuilder.this.pushPoint(((Point2D)end2).getX() * 400.0, ((Point2D)end2).getY() * 400.0);
                AbstractShapeBuilder.this.pushPoly(Poly.Type.OPENED, null, null, null);
                return;
            }
            if (which == 3) {
                diffExtend = -diffExtend;
                defWid = -defWid;
            }
            if (which == 4) {
                defWid = 0.0;
                diffExtend = 0.0;
            }
            Point2D.Double[] portPoints = new Point2D.Double[total];
            Point2D.Double lastPoint = null;
            int lastAngle = 0;
            for (int nextIndex = 1; nextIndex < total; ++nextIndex) {
                int thisIndex = nextIndex - 1;
                Point2D thisPt2 = new Point2D.Double(this.points[thisIndex].getX(), this.points[thisIndex].getY());
                Point2D.Double nextPt2 = new Point2D.Double(this.points[nextIndex].getX(), this.points[nextIndex].getY());
                int angle = DBMath.figureAngle(thisPt2, nextPt2);
                if (thisIndex == 0) {
                    ((Point2D)thisPt2).setLocation(((Point2D)thisPt2).getX() + DBMath.cos(angle) * diffInset, ((Point2D)thisPt2).getY() + DBMath.sin(angle) * diffInset);
                }
                if (nextIndex == total - 1) {
                    int backAng = (angle + 1800) % 3600;
                    ((Point2D)nextPt2).setLocation(((Point2D)nextPt2).getX() + DBMath.cos(backAng) * diffInset, ((Point2D)nextPt2).getY() + DBMath.sin(backAng) * diffInset);
                }
                int ang = (angle + 900) % 3600;
                double sine = DBMath.sin(ang);
                double cosine = DBMath.cos(ang);
                ((Point2D)thisPt2).setLocation(((Point2D)thisPt2).getX() + cosine * (defWid / 2.0 + diffExtend), ((Point2D)thisPt2).getY() + sine * (defWid / 2.0 + diffExtend));
                ((Point2D)nextPt2).setLocation(((Point2D)nextPt2).getX() + cosine * (defWid / 2.0 + diffExtend), ((Point2D)nextPt2).getY() + sine * (defWid / 2.0 + diffExtend));
                if (thisIndex != 0) {
                    thisPt2 = DBMath.intersect(lastPoint, lastAngle, thisPt2, angle);
                }
                portPoints[thisIndex] = thisPt2;
                lastPoint = thisPt2;
                lastAngle = angle;
                if (nextIndex != total - 1) continue;
                portPoints[nextIndex] = nextPt2;
            }
            for (Point2D.Double point : portPoints) {
                AbstractShapeBuilder.this.pushPoint(((Point2D)point).getX() * 400.0, ((Point2D)point).getY() * 400.0);
            }
            AbstractShapeBuilder.this.pushPoly(Poly.Type.OPENED, null, null, null);
        }
    }

    private class MultiCutData {
        private long cutSizeX;
        private long cutSizeY;
        private long cutSep;
        private long cutSep1D;
        private long cutSep2D;
        private int cutsX;
        private int cutsY;
        private int cutsTotal;
        private int cutsReasonable;
        private long cutBaseX;
        private long cutBaseY;
        private long cutShiftLeftXPos;
        private long cutShiftRightXPos;
        private long cutShiftNoneXPos;
        private long cutShiftDownYPos;
        private long cutShiftUpYPos;
        private long cutShiftNoneYPos;
        private long cutShiftLeftXAmt;
        private long cutShiftRightXAmt;
        private long cutShiftDownYAmt;
        private long cutShiftUpYAmt;
        private double cutTopEdge;
        private double cutLeftEdge;
        private double cutRightEdge;

        private MultiCutData(ImmutableNodeInst niD, Technology.NodeLayer cutLayer) {
            this.calculateInternalData(niD, cutLayer);
        }

        private MultiCutData(ImmutableNodeInst niD, TechPool techPool) {
            this.calculateInternalData(niD, techPool.getPrimitiveNode((PrimitiveNodeId)niD.protoId).findMulticut());
        }

        private void calculateInternalData(ImmutableNodeInst niD, Technology.NodeLayer cutLayer) {
            Integer cutAlignment;
            double spacingD;
            Variable var;
            EPoint size2 = niD.size;
            assert (cutLayer.getRepresentation() == 3);
            long gridWidth = size2.getGridX();
            long gridHeight = size2.getGridY();
            Technology.TechPoint[] techPoints = cutLayer.getPoints();
            long lx = techPoints[0].getX().getGridAdder() + (long)((double)gridWidth * techPoints[0].getX().getMultiplier());
            long hx = techPoints[1].getX().getGridAdder() + (long)((double)gridWidth * techPoints[1].getX().getMultiplier());
            long ly = techPoints[0].getY().getGridAdder() + (long)((double)gridHeight * techPoints[0].getY().getMultiplier());
            long hy = techPoints[1].getY().getGridAdder() + (long)((double)gridHeight * techPoints[1].getY().getMultiplier());
            this.cutSizeX = cutLayer.getGridMulticutSizeX();
            this.cutSizeY = cutLayer.getGridMulticutSizeX();
            this.cutSep1D = cutLayer.getGridMulticutSep1D();
            this.cutSep2D = cutLayer.getGridMulticutSep2D();
            if (!niD.isEasyShape() && (var = niD.getVar(Technology.NodeLayer.CUT_SPACING)) != null && (spacingD = VarContext.objectToDouble(var.getObject(), -1.0)) != -1.0) {
                this.cutSep1D = this.cutSep2D = DBMath.lambdaToGrid(spacingD);
            }
            this.cutBaseX = lx + hx >> 1;
            this.cutBaseY = ly + hy >> 1;
            long cutAreaWidth = hx - lx;
            long cutAreaHeight = hy - ly;
            int oneDcutsX = 1 + (int)(cutAreaWidth / (this.cutSizeX + this.cutSep1D));
            int oneDcutsY = 1 + (int)(cutAreaHeight / (this.cutSizeY + this.cutSep1D));
            this.cutSep = this.cutSep1D;
            this.cutsX = oneDcutsX;
            this.cutsY = oneDcutsY;
            if (this.cutsX > 1 && this.cutsY > 1) {
                int twoDcutsX = 1 + (int)(cutAreaWidth / (this.cutSizeX + this.cutSep2D));
                int twoDcutsY = 1 + (int)(cutAreaHeight / (this.cutSizeY + this.cutSep2D));
                this.cutSep = this.cutSep2D;
                this.cutsX = twoDcutsX;
                this.cutsY = twoDcutsY;
                if (this.cutsX == 1 || this.cutsY == 1) {
                    this.cutSep = this.cutSep1D;
                    if (cutAreaWidth > cutAreaHeight) {
                        this.cutsX = oneDcutsX;
                    } else {
                        this.cutsY = oneDcutsY;
                    }
                }
            }
            if (this.cutsX <= 0) {
                this.cutsX = 1;
            }
            if (this.cutsY <= 0) {
                this.cutsY = 1;
            }
            this.cutShiftLeftXPos = this.cutsX;
            this.cutShiftRightXPos = this.cutsX;
            this.cutShiftDownYPos = this.cutsY;
            this.cutShiftUpYPos = this.cutsY;
            this.cutShiftNoneXPos = -1L;
            this.cutShiftNoneYPos = -1L;
            if (!niD.isEasyShape() && (cutAlignment = (Integer)niD.getVarValue(Technology.NodeLayer.CUT_ALIGNMENT, Integer.class)) != null) {
                if (cutAlignment == 1) {
                    this.cutShiftLeftXPos = 0L;
                    this.cutShiftDownYPos = 0L;
                    this.cutShiftLeftXAmt = (long)(1 - this.cutsX) * (this.cutSizeX + this.cutSep) / 2L - lx;
                    this.cutShiftDownYAmt = (long)(1 - this.cutsY) * (this.cutSizeY + this.cutSep) / 2L - ly;
                    this.cutShiftRightXPos = this.cutsX / 2;
                    this.cutShiftUpYPos = this.cutsY / 2;
                    this.cutShiftRightXAmt = hx - (long)(this.cutsX - 1) * (this.cutSizeX + this.cutSep) / 2L;
                    this.cutShiftUpYAmt = hy - (long)(this.cutsY - 1) * (this.cutSizeY + this.cutSep) / 2L;
                    if ((this.cutsX & 1) != 0) {
                        this.cutShiftNoneXPos = this.cutsX / 2;
                    }
                    if ((this.cutsY & 1) != 0) {
                        this.cutShiftNoneYPos = this.cutsY / 2;
                    }
                } else if (cutAlignment == 2) {
                    this.cutShiftLeftXPos = 0L;
                    this.cutShiftDownYPos = 0L;
                    this.cutShiftLeftXAmt = (long)(1 - this.cutsX) * (this.cutSizeX + this.cutSep) / 2L - lx;
                    this.cutShiftDownYAmt = (long)(1 - this.cutsY) * (this.cutSizeY + this.cutSep) / 2L - ly;
                }
            }
            this.cutsReasonable = this.cutsTotal = this.cutsX * this.cutsY;
            if (this.cutsTotal != 1 && this.cutsX > 2 && this.cutsY > 2) {
                this.cutsReasonable = this.cutsX * 2 + (this.cutsY - 2) * 2;
                this.cutTopEdge = this.cutsX * 2;
                this.cutLeftEdge = this.cutsX * 2 + this.cutsY - 2;
                this.cutRightEdge = this.cutsX * 2 + (this.cutsY - 2) * 2;
            }
        }

        private int numCuts() {
            return this.cutsTotal;
        }

        private int numCutsX() {
            return this.cutsX;
        }

        private int numCutsY() {
            return this.cutsY;
        }

        private double getCutSizeX() {
            return this.cutSizeX;
        }

        private double getCutSizeY() {
            return this.cutSizeY;
        }

        private void fillCutPoly(int cut, Poly.Type style, Layer layer, PrimitivePort pp) {
            long cX = this.cutBaseX;
            long cY = this.cutBaseY;
            if (this.cutsX > 1 || this.cutsY > 1) {
                int cutNum;
                if (this.cutsX > 2 && this.cutsY > 2 && cut >= this.cutsX) {
                    if ((double)cut < this.cutTopEdge) {
                        cut += this.cutsX * (this.cutsY - 2);
                    } else if ((double)cut < this.cutLeftEdge) {
                        cut = (int)(((double)cut - this.cutTopEdge) * (double)this.cutsX + (double)this.cutsX);
                    } else if ((double)cut < this.cutRightEdge) {
                        cut = (int)(((double)cut - this.cutLeftEdge) * (double)this.cutsX + (double)(this.cutsX * 2) - 1.0);
                    } else {
                        int cutx = (cut -= (int)this.cutRightEdge) % (this.cutsX - 2);
                        int cuty = cut / (this.cutsX - 2);
                        cut = cuty * this.cutsX + cutx + this.cutsX + 1;
                    }
                }
                if (this.cutsX != 1) {
                    cutNum = cut % this.cutsX;
                    cX = (long)((double)cX + (double)((long)(cutNum * 2 - (this.cutsX - 1)) * (this.cutSizeX + this.cutSep)) * 0.5);
                    if ((long)cutNum != this.cutShiftNoneXPos) {
                        if ((long)cutNum >= this.cutShiftRightXPos) {
                            cX += this.cutShiftRightXAmt;
                        } else if ((long)cutNum >= this.cutShiftLeftXPos) {
                            cX -= this.cutShiftLeftXAmt;
                        }
                    }
                }
                if (this.cutsY != 1) {
                    cutNum = cut / this.cutsX;
                    cY = (long)((double)cY + (double)((long)(cutNum * 2 - (this.cutsY - 1)) * (this.cutSizeY + this.cutSep)) * 0.5);
                    if ((long)cutNum != this.cutShiftNoneYPos) {
                        if ((long)cutNum >= this.cutShiftUpYPos) {
                            cY += this.cutShiftUpYAmt;
                        } else if ((long)cutNum >= this.cutShiftDownYPos) {
                            cY -= this.cutShiftDownYAmt;
                        }
                    }
                }
            }
            double lX = cX - (this.cutSizeX >> 1);
            double hX = cX + (this.cutSizeX >> 1);
            double lY = cY - (this.cutSizeY >> 1);
            double hY = cY + (this.cutSizeY >> 1);
            AbstractShapeBuilder.this.pushPoint(lX, lY);
            AbstractShapeBuilder.this.pushPoint(hX, lY);
            AbstractShapeBuilder.this.pushPoint(hX, hY);
            AbstractShapeBuilder.this.pushPoint(lX, hY);
            AbstractShapeBuilder.this.pushPoly(style, layer, null, pp);
        }
    }

    private class CarbonNanotube {
        private ImmutableNodeInst niD;
        private Technology.NodeLayer tubeLayer;
        private int numTubes;
        private long tubeSpacing;

        private CarbonNanotube(ImmutableNodeInst niD, Technology.NodeLayer tubeLayer) {
            this.niD = niD;
            this.tubeLayer = tubeLayer;
            this.numTubes = 10;
            Variable var = niD.getVar(Technology.NodeLayer.CARBON_NANOTUBE_COUNT);
            if (var != null) {
                this.numTubes = (Integer)var.getObject();
            }
            this.tubeSpacing = -1L;
            var = niD.getVar(Technology.NodeLayer.CARBON_NANOTUBE_PITCH);
            if (var != null) {
                this.tubeSpacing = DBMath.lambdaToGrid((Double)var.getObject());
            }
        }

        private void fillCutPoly(int r, Poly.Type style, Layer layer, PrimitivePort pp) {
            EPoint size2 = this.niD.size;
            long gridWidth = size2.getGridX();
            long gridHeight = size2.getGridY();
            Technology.TechPoint[] techPoints = this.tubeLayer.getPoints();
            long lx = techPoints[0].getX().getGridAdder() + (long)((double)gridWidth * techPoints[0].getX().getMultiplier());
            long hx = techPoints[1].getX().getGridAdder() + (long)((double)gridWidth * techPoints[1].getX().getMultiplier());
            long ly = techPoints[0].getY().getGridAdder() + (long)((double)gridHeight * techPoints[0].getY().getMultiplier());
            long hy = techPoints[1].getY().getGridAdder() + (long)((double)gridHeight * techPoints[1].getY().getMultiplier());
            if (this.tubeSpacing < 0L) {
                this.tubeSpacing = (hx - lx) / (long)(this.numTubes * 2 - 1);
            }
            long tubeDia = (hx - lx - (long)(this.numTubes - 1) * this.tubeSpacing) / (long)this.numTubes;
            long tubeHalfHeight = (hy - ly) / 2L;
            long cX = lx + (tubeDia >> 1) + (tubeDia + this.tubeSpacing) * (long)r;
            long cY = 0L;
            double lX = cX - (tubeDia >> 1);
            double hX = cX + (tubeDia >> 1);
            double lY = cY - tubeHalfHeight;
            double hY = cY + tubeHalfHeight;
            AbstractShapeBuilder.this.pushPoint(lX, lY);
            AbstractShapeBuilder.this.pushPoint(hX, lY);
            AbstractShapeBuilder.this.pushPoint(hX, hY);
            AbstractShapeBuilder.this.pushPoint(lX, hY);
            AbstractShapeBuilder.this.pushPoly(style, layer, null, pp);
        }
    }

    public static class Shrinkage {
        public static final short EXTEND_90 = 0;
        public static final short EXTEND_0 = 1;
        private static final short EXTEND_ANY = 2;
        private static final int ANGLE_SHIFT = 12;
        private static final int ANGLE_MASK = 4095;
        private static final int ANGLE_DIAGONAL_MASK = 0x1000000;
        private static final int ANGLE_COUNT_SHIFT = 25;
        private final short[] shrink;

        public Shrinkage() {
            this.shrink = new short[0];
        }

        public Shrinkage(CellBackup cellBackup) {
            CellRevision cellRevision = cellBackup.cellRevision;
            TechPool techPool = cellBackup.techPool;
            int maxNodeId = -1;
            for (int nodeIndex = 0; nodeIndex < cellRevision.nodes.size(); ++nodeIndex) {
                maxNodeId = Math.max(maxNodeId, ((ImmutableNodeInst)cellRevision.nodes.get((int)nodeIndex)).nodeId);
            }
            int[] angles = new int[maxNodeId + 1];
            for (ImmutableArcInst a : cellRevision.arcs) {
                ArcProto ap = techPool.getArcProto(a.protoId);
                if (a.getGridExtendOverMin() + (long)ap.getMaxLayerGridExtend() == 0L) continue;
                if (a.tailNodeId == a.headNodeId && a.tailPortId == a.headPortId) {
                    this.registerArcEnd(angles, a.tailNodeId, 0, false, false);
                    continue;
                }
                boolean is90 = a.isManhattan();
                this.registerArcEnd(angles, a.tailNodeId, a.getOppositeAngle(), is90, a.isTailExtended());
                this.registerArcEnd(angles, a.headNodeId, a.getAngle(), is90, a.isHeadExtended());
            }
            short[] shrink = new short[maxNodeId + 1];
            for (int nodeIndex = 0; nodeIndex < cellRevision.nodes.size(); ++nodeIndex) {
                ImmutableNodeInst n = (ImmutableNodeInst)cellRevision.nodes.get(nodeIndex);
                NodeProtoId np = n.protoId;
                if (!(np instanceof PrimitiveNodeId) || !techPool.getPrimitiveNode((PrimitiveNodeId)np).isArcsShrink()) continue;
                shrink[n.nodeId] = Shrinkage.computeShrink(angles[n.nodeId]);
            }
            this.shrink = shrink;
        }

        public short get(int nodeId) {
            return nodeId < this.shrink.length ? this.shrink[nodeId] : (short)0;
        }

        private void registerArcEnd(int[] angles, int nodeId, int angle, boolean is90, boolean extended) {
            if (angle == -1) {
                angle = 0;
            }
            assert (angle >= 0 && angle < 3600);
            int ang = angles[nodeId];
            if (extended) {
                int count2 = ang >>> 25;
                switch (count2) {
                    case 0: {
                        ang |= angle;
                        ang += 0x2000000;
                        break;
                    }
                    case 1: {
                        ang |= angle << 12;
                        ang += 0x2000000;
                        break;
                    }
                    case 2: {
                        ang += 0x2000000;
                    }
                }
                if (!is90) {
                    ang |= 0x1000000;
                }
            } else {
                ang |= 0x6000000;
            }
            angles[nodeId] = ang;
        }

        static short computeShrink(int angs) {
            boolean hasAny = (angs & 0x1000000) != 0;
            int count2 = angs >>> 25;
            if (hasAny && count2 == 2) {
                int da;
                int ang0 = angs & 0xFFF;
                int ang1 = angs >> 12 & 0xFFF;
                int n = da = ang0 > ang1 ? ang0 - ang1 : ang1 - ang0;
                if (da == 900 || da == 2700) {
                    return 0;
                }
                if (da == 1800) {
                    return 1;
                }
                if (900 < da && da < 2700) {
                    int a = ang0 + ang1;
                    if (a >= 3600) {
                        a -= 3600;
                    }
                    return (short)(2 + a);
                }
            }
            return 0;
        }
    }
}

