/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool;

import com.sun.electric.database.network.NetworkTool;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.Setting;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.Listener;
import com.sun.electric.tool.ToolSettings;
import com.sun.electric.tool.compaction.Compaction;
import com.sun.electric.tool.cvspm.CVS;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.erc.ERC;
import com.sun.electric.tool.extract.Extract;
import com.sun.electric.tool.extract.LayerCoverageTool;
import com.sun.electric.tool.extract.ParasiticTool;
import com.sun.electric.tool.generator.layout.GateLayGenSettings;
import com.sun.electric.tool.generator.layout.fill.FillGeneratorTool;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.logicaleffort.LETool;
import com.sun.electric.tool.placement.Placement;
import com.sun.electric.tool.project.Project;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.sc.SilComp;
import com.sun.electric.tool.simulation.SimulationTool;
import com.sun.electric.tool.user.User;
import com.sun.electric.util.TextUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

public class Tool
implements Comparable {
    private String toolName;
    private int toolState;
    private int toolIndex;
    private static LinkedHashMap<String, Tool> tools = new LinkedHashMap();
    private static List<Listener> listeners = new ArrayList<Listener>();
    private static int toolNumber = 0;
    private final Setting.Group settings;
    public Pref.Group prefs;
    private static final int TOOLON = 1;
    private static final int TOOLBG = 2;
    private static final int TOOLFIX = 4;
    private static final int TOOLINCREMENTAL = 16;
    private static final int TOOLANALYSIS = 32;
    private static final int TOOLSYNTHESIS = 64;

    protected Tool(String toolName) {
        this(toolName, toolName + "Tool");
    }

    protected Tool(String toolName, String settingGroupName) {
        this.toolName = toolName;
        this.toolState = 0;
        this.toolIndex = toolNumber++;
        assert (Tool.findTool(toolName) == null);
        tools.put(toolName, this);
        this.settings = ToolSettings.getToolSettings(settingGroupName);
        this.prefs = Pref.groupForPackage(this.getClass());
        for (Setting setting : this.settings.getSettings()) {
            assert (setting.getPrefPath().equals(this.prefs.relativePath() + "/" + setting.getPrefName()));
        }
    }

    private void updateListeners() {
        listeners.clear();
        for (Tool t : tools.values()) {
            if (!(t instanceof Listener) || !((Listener)t).isOn()) continue;
            listeners.add((Listener)t);
        }
    }

    public static void initAllTools() {
        User.getUserTool().init();
        Compaction.getCompactionTool().init();
        DRC.getDRCTool().init();
        ERC.getERCTool().init();
        Extract.getExtractTool().init();
        IOTool.getIOTool().init();
        LETool.getLETool().init();
        NetworkTool.getNetworkTool().init();
        ParasiticTool.getParasiticTool().init();
        Placement.getPlacementTool().init();
        Project.getProjectTool().init();
        Routing.getRoutingTool().init();
        SilComp.getSilCompTool().init();
        SimulationTool.getSimulationTool().init();
        LayerCoverageTool.getLayerCoverageTool().init();
        GateLayGenSettings.tool.init();
        FillGeneratorTool.getTool().init();
        CVS.getCVSTool().init();
        try {
            Class<?> staClass = Class.forName("com.sun.electric.plugins.sctiming.RunSTA");
            if (staClass != null) {
                Method staInit = staClass.getMethod("staticinit", new Class[0]);
                staInit.invoke(Tool.class, new Object[0]);
            }
        }
        catch (Exception e) {
            TextUtils.recordMissingPrivateComponent("Static Timing Analyzer");
        }
    }

    public static Tool findTool(String name) {
        return tools.get(name);
    }

    public static Iterator<Tool> getTools() {
        return tools.values().iterator();
    }

    public static int getNumTools() {
        return tools.size();
    }

    public static Iterator<Listener> getListeners() {
        return listeners.iterator();
    }

    public String getName() {
        return this.toolName;
    }

    public int getIndex() {
        return this.toolIndex;
    }

    public void setOn() {
        this.toolState |= 1;
        this.updateListeners();
    }

    public void clearOn() {
        this.toolState &= 0xFFFFFFFE;
        this.updateListeners();
    }

    public boolean isOn() {
        return (this.toolState & 1) != 0;
    }

    public void setBackground() {
        this.toolState |= 2;
    }

    public void clearBackground() {
        this.toolState &= 0xFFFFFFFD;
    }

    public boolean isBackground() {
        return (this.toolState & 2) != 0;
    }

    public void setFixErrors() {
        this.toolState |= 4;
    }

    public void clearFixErrors() {
        this.toolState &= 0xFFFFFFFB;
    }

    public boolean isFixErrors() {
        return (this.toolState & 4) != 0;
    }

    public void setIncremental() {
        this.toolState |= 0x10;
    }

    public void clearIncremental() {
        this.toolState &= 0xFFFFFFEF;
    }

    public boolean isIncremental() {
        return (this.toolState & 0x10) != 0;
    }

    public void setAnalysis() {
        this.toolState |= 0x20;
    }

    public void clearAnalysis() {
        this.toolState &= 0xFFFFFFDF;
    }

    public boolean isAnalysis() {
        return (this.toolState & 0x20) != 0;
    }

    public void setSynthesis() {
        this.toolState |= 0x40;
    }

    public void clearSynthesis() {
        this.toolState &= 0xFFFFFFBF;
    }

    public boolean isSynthesis() {
        return (this.toolState & 0x40) != 0;
    }

    public Setting.Group getProjectSettings() {
        return this.settings;
    }

    public int compareTo(Object obj) {
        Tool that = (Tool)obj;
        return this.toolIndex - that.toolIndex;
    }

    public String toString() {
        return "Tool '" + this.toolName + "'";
    }

    public void setVarInJob(ElectricObject obj, Variable.Key key, Object newVal) {
        new SetVarJob(this, obj, key, newVal);
    }

    public void init() {
    }

    public static boolean testAll() {
        return true;
    }

    private static class SetVarJob
    extends Job {
        private ElectricObject obj;
        private Variable.Key key;
        private Object newVal;

        protected SetVarJob(Tool tool, ElectricObject obj, Variable.Key key, Object newVal) {
            super("Add Variable", tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.obj = obj;
            this.key = key;
            this.newVal = newVal;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            this.obj.newVar(this.key, this.newVal);
            return true;
        }
    }
}

