/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.gates;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.generator.layout.TrackRouterH;

public class WellTie {
    private static final double DEF_SIZE = Double.POSITIVE_INFINITY;
    private static final double WELL_CONT_PITCH = 11.0;

    private static void error(boolean pred, String msg) {
        Job.error(pred, msg);
    }

    public static double edgeToContDist() {
        return 16.5;
    }

    public static Cell makePart(boolean nmos, boolean pmos, double wid, StdCellParams stdCell) {
        TechType tech = stdCell.getTechType();
        if (wid == 0.0) {
            wid = 11.0;
        }
        String nm = (nmos ? "Nmos" : "") + (pmos ? "Pmos" : "") + "WellTie";
        Cell tie = stdCell.findPart(nm = stdCell.parameterizedName(nm) + "_W" + wid + "{lay}");
        if (tie != null) {
            return tie;
        }
        tie = stdCell.newPart(nm);
        double leftWellContX = 5.5;
        double rightWellContX = wid - 5.5;
        double wellMinX = leftWellContX - 6.5;
        double wellMaxX = Math.max(leftWellContX, rightWellContX) + 6.5;
        if (!(wid < 11.0)) {
            PortInst right;
            Export e;
            String portNm;
            if (nmos) {
                portNm = stdCell.getNmosWellTieName();
                e = LayoutLib.newExport(tie, portNm, stdCell.getNmosWellTieRole(), tech.m2(), 4.0, leftWellContX, stdCell.getNmosWellTieY());
                PortInst left = LayoutLib.newNodeInst(tech.pwm1(), leftWellContX, stdCell.getNmosWellTieY(), Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, tie).getOnlyPortInst();
                TrackRouterH tr = new TrackRouterH(tech.m2(), stdCell.getNmosWellTieWidth(), stdCell.getNmosWellTieY(), tech, tie);
                tr.connect(e);
                tr.connect(left);
                if (wid >= 22.0) {
                    right = LayoutLib.newNodeInst(tech.pwm1(), rightWellContX, stdCell.getNmosWellTieY(), Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, tie).getOnlyPortInst();
                    tr.connect(right);
                }
            }
            if (pmos) {
                portNm = stdCell.getPmosWellTieName();
                e = LayoutLib.newExport(tie, portNm, stdCell.getPmosWellTieRole(), tech.m2(), 4.0, leftWellContX, stdCell.getPmosWellTieY());
                TrackRouterH tr = new TrackRouterH(tech.m2(), stdCell.getPmosWellTieWidth(), stdCell.getPmosWellTieY(), tech, tie);
                PortInst left = LayoutLib.newNodeInst(tech.nwm1(), leftWellContX, stdCell.getPmosWellTieY(), Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, tie).getOnlyPortInst();
                tr.connect(e);
                tr.connect(left);
                if (wid >= 22.0) {
                    right = LayoutLib.newNodeInst(tech.nwm1(), rightWellContX, stdCell.getPmosWellTieY(), Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, tie).getOnlyPortInst();
                    tr.connect(right);
                }
            }
        }
        if (nmos) {
            stdCell.addNmosWell(wellMinX, wellMaxX, tie);
        }
        if (pmos) {
            stdCell.addPmosWell(wellMinX, wellMaxX, tie);
        }
        if (nmos) {
            if (pmos) {
                stdCell.addEssentialBounds(0.0, wid, tie);
            } else {
                stdCell.addNstackEssentialBounds(0.0, wid, tie);
            }
        } else {
            WellTie.error(!pmos, "WellTie must be for at least one well");
            stdCell.addPstackEssentialBounds(0.0, wid, tie);
        }
        return tie;
    }
}

