/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input.verilog;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.placement.Placement;
import com.sun.electric.tool.simulation.SimulationTool;
import com.sun.electric.tool.user.CompileVerilogStruct;
import com.sun.electric.tool.user.IconParameters;
import com.sun.electric.util.TextUtils;
import java.awt.geom.Point2D;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VerilogReader
extends Input<Object> {
    List<NodeInst> transistors = new ArrayList<NodeInst>();
    double maxWidth = 100.0;
    double nodeWidth = 10.0;
    double primitiveHeight = 0.5;
    double primitiveWidth = 0.5;
    Map<Cell, Point2D.Double> locationMap = new HashMap<Cell, Point2D.Double>();
    PrimitiveNode essentialBounds = Generic.tech().findNodeProto("Essential-Bounds");
    Cell topCell = null;
    Map<String, NodeInst> pinsMap = new HashMap<String, NodeInst>();
    private VerilogPreferences localPrefs;

    public VerilogReader(VerilogPreferences ap) {
        this.localPrefs = ap;
    }

    public static class VerilogPreferences
    extends Input.InputPreferences {
        public boolean runPlacement = SimulationTool.getFactoryVerilogRunPlacementTool();
        Placement.PlacementPreferences placementPrefs;
        IconParameters iconParameters = IconParameters.makeInstance(true);
        public boolean makeLayoutCells = IOTool.isFactoryVerilogMakeLayoutCells();

        public VerilogPreferences(boolean factory) {
            super(factory);
            if (!factory) {
                this.runPlacement = SimulationTool.getVerilogRunPlacementTool();
                this.makeLayoutCells = IOTool.isVerilogMakeLayoutCells();
            }
            this.placementPrefs = new Placement.PlacementPreferences(factory);
        }

        @Override
        public Library doInput(URL fileURL, Library lib, Technology tech, Map<Library, Cell> currentCells, Map<CellId, BitSet> nodesToExpand, Job job) {
            VerilogReader in = new VerilogReader(this);
            File f2 = TextUtils.getFile(fileURL);
            CompileVerilogStruct cvs = new CompileVerilogStruct(f2, false);
            Cell cell = cvs.genCell(lib, !this.makeLayoutCells, this.iconParameters);
            if (lib != null && this.runPlacement) {
                Placement.placeCellNoJob(cell, this.placementPrefs, true, job);
            }
            in.closeInput();
            return lib;
        }
    }
}

