/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar1;

import com.sun.electric.tool.routing.RoutingFrame;
import com.sun.electric.tool.routing.experimentalAStar1.AStarRoutingFrame;
import com.sun.electric.tool.routing.experimentalAStar1.Map;
import java.awt.geom.Rectangle2D;
import java.util.concurrent.CountDownLatch;

public class AStarBlockageWorker
implements Runnable {
    private boolean DEBUG = false;
    private CountDownLatch latch;
    private RoutingFrame.RoutingGeometry blockage;
    private Map map;

    public AStarBlockageWorker(Map map2, RoutingFrame.RoutingGeometry blockage, CountDownLatch latch) {
        this.blockage = blockage;
        this.latch = latch;
        this.map = map2;
        this.DEBUG &= AStarRoutingFrame.getInstance().isOutputEnabled();
    }

    @Override
    public void run() {
        Rectangle2D rec = this.blockage.getBounds();
        double scalingFactor = this.map.getScalingFactor();
        int minX = (int)Math.floor((rec.getMinX() + (double)this.map.getDispX()) / scalingFactor + 0.5);
        int maxX = (int)Math.ceil((rec.getMaxX() + (double)this.map.getDispX()) / scalingFactor - 0.5);
        int minY = (int)Math.floor((rec.getMinY() + (double)this.map.getDispY()) / scalingFactor + 0.5);
        int maxY = (int)Math.ceil((rec.getMaxY() + (double)this.map.getDispY()) / scalingFactor - 0.5);
        if (this.DEBUG) {
            System.out.printf("AStarBlockageWorker: block: minx: %f, miny: %f, maxx: %f, maxy: %f\n", minX, minY, maxX, maxY);
        }
        int layer = this.blockage.getLayer().getMetalNumber() - 1;
        for (int x2 = minX; x2 < maxX; ++x2) {
            for (int y = minY; y < maxY; ++y) {
                this.map.setStatus(x2, y, layer, -3);
            }
        }
        this.latch.countDown();
    }
}

