/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.seaOfGates;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.Environment;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesEngine;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;

public class SeaOfGatesEngineOld
extends SeaOfGatesEngine {
    @Override
    protected void doRoutingParallel(int numberOfThreads, List<SeaOfGatesEngine.NeededRoute> allRoutes, SeaOfGatesEngine.RouteBatches[] routeBatches, Environment env, EditingPreferences ep, Job job) {
        if (Job.getDebug()) {
            System.out.println("Do routing parallel with raw threads");
        }
        RouteInThread[] threads = new RouteInThread[numberOfThreads];
        for (int i = 0; i < numberOfThreads; ++i) {
            threads[i] = new RouteInThread("Route #" + (i + 1), env, ep, job);
        }
        SeaOfGatesEngine.NeededRoute[] routesToDo = new SeaOfGatesEngine.NeededRoute[numberOfThreads];
        int[] routeIndices = new int[numberOfThreads];
        Semaphore outSem = new Semaphore(0);
        ArrayList<SeaOfGatesEngine.NeededRoute> myList = new ArrayList<SeaOfGatesEngine.NeededRoute>();
        for (SeaOfGatesEngine.NeededRoute nr : allRoutes) {
            myList.add(nr);
        }
        ArrayList<Rectangle2D> blocked = new ArrayList<Rectangle2D>();
        int totalRoutes = allRoutes.size();
        int routesDone = 0;
        while (myList.size() > 0) {
            int i;
            if (job != null && job.checkAbort()) {
                System.out.println("Sea-of-gates routing aborted");
                break;
            }
            int threadAssign = 0;
            blocked.clear();
            for (int i2 = 0; i2 < myList.size(); ++i2) {
                SeaOfGatesEngine.NeededRoute nr = (SeaOfGatesEngine.NeededRoute)myList.get(i2);
                boolean isBlocked = false;
                for (Rectangle2D block : blocked) {
                    if (!block.intersects(nr.routeBounds)) continue;
                    isBlocked = true;
                    break;
                }
                if (isBlocked) continue;
                blocked.add(nr.routeBounds);
                routesToDo[threadAssign] = nr;
                routeIndices[threadAssign] = i2;
                threads[threadAssign].startRoute(nr, outSem);
                if (++threadAssign >= numberOfThreads) break;
            }
            String routes = "";
            for (i = 0; i < threadAssign; ++i) {
                String routeName = routesToDo[i].routeName;
                if (routeBatches[routesToDo[i].batchNumber].segsInBatch > 1) {
                    routeName = routeName + "(" + routesToDo[i].routeInBatch + "/" + routeBatches[routesToDo[i].batchNumber].segsInBatch + ")";
                }
                if (routes.length() > 0) {
                    routes = routes + ", ";
                }
                routes = routes + routeName + " [from " + routesToDo[i].fromPi.getNodeInst().describe(false) + " port " + routesToDo[i].fromPi.getPortProto().getName() + " to " + routesToDo[i].toPi.getNodeInst().describe(false) + " port " + routesToDo[i].toPi.getPortProto().getName() + "]";
            }
            System.out.println((threadAssign > 1 ? "Parallel " : "") + "Routing " + routes + "...");
            Job.getUserInterface().setProgressNote(routes);
            outSem.acquireUninterruptibly(threadAssign);
            for (i = 0; i < threadAssign; ++i) {
                if (routesToDo[i].winningWF == null || routesToDo[i].winningWF.vertices == null) continue;
                routesToDo[i].createRoute();
            }
            for (i = threadAssign - 1; i >= 0; --i) {
                myList.remove(routeIndices[i]);
            }
            Job.getUserInterface().setProgressValue((routesDone += threadAssign) * 100 / totalRoutes);
        }
        for (int i = 0; i < numberOfThreads; ++i) {
            threads[i].startRoute(null, null);
        }
    }

    private class RouteInThread
    extends Thread {
        private Semaphore inSem;
        private SeaOfGatesEngine.NeededRoute nr;
        private Semaphore whenDone;
        private Environment env;
        private EditingPreferences ep;
        private Job job;

        public RouteInThread(String name, Environment env, EditingPreferences ep, Job job) {
            super(name);
            this.inSem = new Semaphore(0);
            this.env = env;
            this.ep = ep;
            this.job = job;
            this.start();
        }

        public void startRoute(SeaOfGatesEngine.NeededRoute nr, Semaphore whenDone) {
            this.nr = nr;
            this.whenDone = whenDone;
            this.inSem.release();
        }

        @Override
        public void run() {
            Environment.setThreadEnvironment(this.env);
            EditingPreferences.setThreadEditingPreferences(this.ep);
            while (true) {
                this.inSem.acquireUninterruptibly();
                if (this.nr == null) {
                    return;
                }
                SeaOfGatesEngineOld.this.findPath(this.nr, this.env, this.ep, this.job);
                this.whenDone.release();
            }
        }
    }
}

